/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.annotations.internal;

import java.lang.annotation.Annotation;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.SQLInsert;
import org.hibernate.annotations.SQLUpdate;
import org.hibernate.annotations.Table;
import org.hibernate.boot.models.HibernateAnnotations;
import org.hibernate.boot.models.annotations.internal.ForeignKeyAnnotation;
import org.hibernate.boot.models.annotations.internal.SQLDeleteAnnotation;
import org.hibernate.boot.models.annotations.internal.SQLInsertAnnotation;
import org.hibernate.boot.models.annotations.internal.SQLUpdateAnnotation;
import org.hibernate.boot.models.internal.OrmAnnotationHelper;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.jboss.jandex.AnnotationInstance;

public class TableAnnotation
implements Table {
    private String appliesTo;
    private FetchMode fetch;
    private boolean inverse;
    private boolean optional;
    private String checkConstraint;
    private String comment;
    private SQLInsert sqlInsert;
    private SQLUpdate sqlUpdate;
    private SQLDelete sqlDelete;
    private ForeignKey foreignKey;
    private Index[] indexes;

    public TableAnnotation(SourceModelBuildingContext modelContext) {
        this.appliesTo = "";
        this.fetch = FetchMode.JOIN;
        this.inverse = false;
        this.optional = true;
        this.checkConstraint = "";
        this.comment = "";
        this.sqlInsert = new SQLInsertAnnotation(modelContext);
        this.sqlUpdate = new SQLUpdateAnnotation(modelContext);
        this.sqlDelete = new SQLDeleteAnnotation(modelContext);
        this.foreignKey = new ForeignKeyAnnotation(modelContext);
        this.indexes = new Index[0];
    }

    public TableAnnotation(Table annotation, SourceModelBuildingContext modelContext) {
        this.appliesTo = annotation.appliesTo();
        this.fetch = annotation.fetch();
        this.inverse = annotation.inverse();
        this.optional = annotation.optional();
        this.indexes = (Index[])OrmAnnotationHelper.extractJdkValue(annotation, HibernateAnnotations.TABLE, "indexes", modelContext);
        this.checkConstraint = annotation.checkConstraint();
        this.comment = annotation.comment();
        this.sqlInsert = (SQLInsert)OrmAnnotationHelper.extractJdkValue(annotation, HibernateAnnotations.TABLE, "sqlInsert", modelContext);
        this.sqlUpdate = (SQLUpdate)OrmAnnotationHelper.extractJdkValue(annotation, HibernateAnnotations.TABLE, "sqlUpdate", modelContext);
        this.sqlDelete = (SQLDelete)OrmAnnotationHelper.extractJdkValue(annotation, HibernateAnnotations.TABLE, "sqlDelete", modelContext);
        this.foreignKey = (ForeignKey)OrmAnnotationHelper.extractJdkValue(annotation, HibernateAnnotations.TABLE, "foreignKey", modelContext);
        this.indexes = (Index[])OrmAnnotationHelper.extractJdkValue(annotation, HibernateAnnotations.TABLE, "indexes", modelContext);
    }

    public TableAnnotation(AnnotationInstance annotation, SourceModelBuildingContext modelContext) {
        this.appliesTo = (String)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.TABLE, "appliesTo", modelContext);
        this.fetch = (FetchMode)((Object)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.TABLE, "fetch", modelContext));
        this.inverse = (Boolean)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.TABLE, "inverse", modelContext);
        this.optional = (Boolean)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.TABLE, "optional", modelContext);
        this.indexes = (Index[])OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.TABLE, "indexes", modelContext);
        this.checkConstraint = (String)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.TABLE, "checkConstraint", modelContext);
        this.comment = (String)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.TABLE, "comment", modelContext);
        this.sqlInsert = (SQLInsert)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.TABLE, "sqlInsert", modelContext);
        this.sqlUpdate = (SQLUpdate)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.TABLE, "sqlUpdate", modelContext);
        this.sqlDelete = (SQLDelete)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.TABLE, "sqlDelete", modelContext);
        this.foreignKey = (ForeignKey)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.TABLE, "foreignKey", modelContext);
        this.indexes = (Index[])OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.TABLE, "indexes", modelContext);
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return Table.class;
    }

    @Override
    public String appliesTo() {
        return this.appliesTo;
    }

    public void appliesTo(String value) {
        this.appliesTo = value;
    }

    @Override
    public FetchMode fetch() {
        return this.fetch;
    }

    public void fetch(FetchMode value) {
        this.fetch = value;
    }

    @Override
    public boolean inverse() {
        return this.inverse;
    }

    public void inverse(boolean value) {
        this.inverse = value;
    }

    @Override
    public boolean optional() {
        return this.optional;
    }

    public void optional(boolean value) {
        this.optional = value;
    }

    @Override
    public String checkConstraint() {
        return this.checkConstraint;
    }

    public void checkConstraint(String value) {
        this.checkConstraint = value;
    }

    @Override
    public String comment() {
        return this.comment;
    }

    public void comment(String value) {
        this.comment = value;
    }

    @Override
    public ForeignKey foreignKey() {
        return this.foreignKey;
    }

    public void foreignKey(ForeignKey value) {
        this.foreignKey = value;
    }

    @Override
    public SQLInsert sqlInsert() {
        return this.sqlInsert;
    }

    public void sqlInsert(SQLInsert value) {
        this.sqlInsert = value;
    }

    @Override
    public SQLUpdate sqlUpdate() {
        return this.sqlUpdate;
    }

    public void sqlUpdate(SQLUpdate value) {
        this.sqlUpdate = value;
    }

    @Override
    public SQLDelete sqlDelete() {
        return this.sqlDelete;
    }

    public void sqlDelete(SQLDelete value) {
        this.sqlDelete = value;
    }

    @Override
    public Index[] indexes() {
        return this.indexes;
    }

    public void indexes(Index[] value) {
        this.indexes = value;
    }
}

