/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.annotations.internal;

import java.lang.annotation.Annotation;
import org.hibernate.annotations.TimeZoneColumn;
import org.hibernate.boot.models.HibernateAnnotations;
import org.hibernate.boot.models.internal.OrmAnnotationHelper;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.jboss.jandex.AnnotationInstance;

public class TimeZoneColumnAnnotation
implements TimeZoneColumn {
    private String name;
    private boolean insertable;
    private boolean updatable;
    private String columnDefinition;
    private String table;

    public TimeZoneColumnAnnotation(SourceModelBuildingContext modelContext) {
        this.name = "";
        this.insertable = true;
        this.updatable = true;
        this.columnDefinition = "";
        this.table = "";
    }

    public TimeZoneColumnAnnotation(TimeZoneColumn annotation, SourceModelBuildingContext modelContext) {
        this.name = annotation.name();
        this.insertable = annotation.insertable();
        this.updatable = annotation.updatable();
        this.columnDefinition = annotation.columnDefinition();
        this.table = annotation.table();
    }

    public TimeZoneColumnAnnotation(AnnotationInstance annotation, SourceModelBuildingContext modelContext) {
        this.name = (String)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.TIME_ZONE_COLUMN, "name", modelContext);
        this.insertable = (Boolean)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.TIME_ZONE_COLUMN, "insertable", modelContext);
        this.updatable = (Boolean)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.TIME_ZONE_COLUMN, "updatable", modelContext);
        this.columnDefinition = (String)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.TIME_ZONE_COLUMN, "columnDefinition", modelContext);
        this.table = (String)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.TIME_ZONE_COLUMN, "table", modelContext);
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return TimeZoneColumn.class;
    }

    @Override
    public String name() {
        return this.name;
    }

    public void name(String value) {
        this.name = value;
    }

    @Override
    public boolean insertable() {
        return this.insertable;
    }

    public void insertable(boolean value) {
        this.insertable = value;
    }

    @Override
    public boolean updatable() {
        return this.updatable;
    }

    public void updatable(boolean value) {
        this.updatable = value;
    }

    @Override
    public String columnDefinition() {
        return this.columnDefinition;
    }

    public void columnDefinition(String value) {
        this.columnDefinition = value;
    }

    @Override
    public String table() {
        return this.table;
    }

    public void table(String value) {
        this.table = value;
    }
}

