/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.categorize.spi;

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.boot.CacheRegionDefinition;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.models.ModelsException;

public class CacheRegion {
    private String regionName;
    private AccessType accessType;
    private boolean cacheLazyProperties;

    public CacheRegion(Cache cacheAnnotation, AccessType implicitCacheAccessType, String implicitRegionName) {
        if (cacheAnnotation == null) {
            this.regionName = implicitRegionName;
            this.accessType = implicitCacheAccessType;
            this.cacheLazyProperties = true;
        } else {
            String explicitRegionName = cacheAnnotation.region();
            this.regionName = StringHelper.isEmpty(explicitRegionName) ? implicitRegionName : explicitRegionName;
            this.accessType = this.interpretAccessStrategy(cacheAnnotation.usage());
            boolean includeLazy = cacheAnnotation.includeLazy();
            String include = cacheAnnotation.include();
            assert ("all".equals(include) || "non-lazy".equals(include));
            this.cacheLazyProperties = includeLazy && include.equals("all");
        }
    }

    private AccessType interpretAccessStrategy(CacheConcurrencyStrategy usage) {
        if (usage == null) {
            return null;
        }
        switch (usage) {
            case NONE: {
                return null;
            }
            case READ_ONLY: {
                return AccessType.READ_ONLY;
            }
            case READ_WRITE: {
                return AccessType.READ_WRITE;
            }
            case NONSTRICT_READ_WRITE: {
                return AccessType.NONSTRICT_READ_WRITE;
            }
            case TRANSACTIONAL: {
                return AccessType.TRANSACTIONAL;
            }
        }
        throw new ModelsException("Unexpected cache concurrency strategy specified - " + usage);
    }

    public String getRegionName() {
        return this.regionName;
    }

    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    public AccessType getAccessType() {
        return this.accessType;
    }

    public void setAccessType(AccessType accessType) {
        this.accessType = accessType;
    }

    public boolean isCacheLazyProperties() {
        return this.cacheLazyProperties;
    }

    public void setCacheLazyProperties(boolean cacheLazyProperties) {
        this.cacheLazyProperties = cacheLazyProperties;
    }

    public void overlay(CacheRegionDefinition overrides) {
        if (overrides == null) {
            return;
        }
        this.accessType = AccessType.fromExternalName(overrides.getUsage());
        if (StringHelper.isEmpty(overrides.getRegion())) {
            this.regionName = overrides.getRegion();
        }
        this.cacheLazyProperties = overrides.isCacheLazy();
    }

    public void overlay(CacheRegion overrides) {
        if (overrides == null) {
            return;
        }
        this.accessType = overrides.accessType;
        this.regionName = overrides.regionName;
        this.cacheLazyProperties = overrides.cacheLazyProperties;
    }

    public String toString() {
        return "Caching{region='" + this.regionName + "', accessType=" + this.accessType + ", cacheLazyProperties=" + this.cacheLazyProperties + "}";
    }
}

