/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.internal;

import org.hibernate.annotations.TenantId;
import org.hibernate.boot.models.internal.OrmAnnotationHelper;
import org.hibernate.models.internal.jandex.JandexClassDetails;
import org.hibernate.models.internal.jdk.JdkBuilders;
import org.hibernate.models.spi.AnnotationDescriptorRegistry;
import org.hibernate.models.spi.ClassDetailsRegistry;
import org.hibernate.models.spi.RegistryPrimer;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.IndexView;

public class ModelsHelper {
    public static void preFillRegistries(RegistryPrimer.Contributions contributions, SourceModelBuildingContext buildingContext) {
        OrmAnnotationHelper.forEachOrmAnnotation(arg_0 -> ((RegistryPrimer.Contributions)contributions).registerAnnotation(arg_0));
        buildingContext.getAnnotationDescriptorRegistry().getDescriptor(TenantId.class);
        IndexView jandexIndex = buildingContext.getJandexIndex();
        if (jandexIndex == null) {
            return;
        }
        ClassDetailsRegistry classDetailsRegistry = buildingContext.getClassDetailsRegistry();
        AnnotationDescriptorRegistry annotationDescriptorRegistry = buildingContext.getAnnotationDescriptorRegistry();
        for (ClassInfo knownClass : jandexIndex.getKnownClasses()) {
            String className = knownClass.name().toString();
            if (knownClass.isAnnotation()) {
                Class annotationClass = buildingContext.getClassLoading().classForName(className);
                annotationDescriptorRegistry.resolveDescriptor(annotationClass, t -> JdkBuilders.buildAnnotationDescriptor((Class)annotationClass, (SourceModelBuildingContext)buildingContext));
            }
            classDetailsRegistry.resolveClassDetails(className, name -> new JandexClassDetails(knownClass, buildingContext));
        }
    }
}

