/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.xml.internal;

import jakarta.persistence.AccessType;
import java.util.List;
import org.hibernate.boot.jaxb.mapping.spi.JaxbAnyMappingImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbAssociationOverrideImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbAttributeOverrideImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbAttributesContainer;
import org.hibernate.boot.jaxb.mapping.spi.JaxbBaseAttributesContainer;
import org.hibernate.boot.jaxb.mapping.spi.JaxbBasicImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbElementCollectionImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEmbeddedImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbManyToManyImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbManyToOneImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbNaturalId;
import org.hibernate.boot.jaxb.mapping.spi.JaxbOneToManyImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbOneToOneImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbPersistentAttribute;
import org.hibernate.boot.jaxb.mapping.spi.JaxbPluralAnyMappingImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbTransientImpl;
import org.hibernate.boot.models.xml.internal.XmlAnnotationHelper;
import org.hibernate.boot.models.xml.internal.attr.AnyMappingAttributeProcessing;
import org.hibernate.boot.models.xml.internal.attr.BasicAttributeProcessing;
import org.hibernate.boot.models.xml.internal.attr.CommonAttributeProcessing;
import org.hibernate.boot.models.xml.internal.attr.ElementCollectionAttributeProcessing;
import org.hibernate.boot.models.xml.internal.attr.EmbeddedAttributeProcessing;
import org.hibernate.boot.models.xml.internal.attr.ManyToManyAttributeProcessing;
import org.hibernate.boot.models.xml.internal.attr.ManyToOneAttributeProcessing;
import org.hibernate.boot.models.xml.internal.attr.OneToManyAttributeProcessing;
import org.hibernate.boot.models.xml.internal.attr.OneToOneAttributeProcessing;
import org.hibernate.boot.models.xml.internal.attr.PluralAnyMappingAttributeProcessing;
import org.hibernate.boot.models.xml.spi.XmlDocumentContext;
import org.hibernate.models.spi.MutableAnnotationTarget;
import org.hibernate.models.spi.MutableClassDetails;
import org.hibernate.models.spi.MutableMemberDetails;

public class AttributeProcessor {
    public static void processNaturalId(JaxbNaturalId jaxbNaturalId, MutableClassDetails mutableClassDetails, AccessType classAccessType, XmlDocumentContext xmlDocumentContext) {
        AttributeProcessor.processNaturalId(jaxbNaturalId, mutableClassDetails, classAccessType, null, xmlDocumentContext);
    }

    public static void processNaturalId(JaxbNaturalId jaxbNaturalId, MutableClassDetails mutableClassDetails, AccessType classAccessType, MemberAdjuster memberAdjuster, XmlDocumentContext xmlDocumentContext) {
        if (jaxbNaturalId == null) {
            return;
        }
        XmlAnnotationHelper.applyNaturalIdCache(jaxbNaturalId, mutableClassDetails, xmlDocumentContext);
        AttributeProcessor.processBaseAttributes(jaxbNaturalId, mutableClassDetails, classAccessType, memberAdjuster, xmlDocumentContext);
    }

    public static void processBaseAttributes(JaxbBaseAttributesContainer attributesContainer, MutableClassDetails mutableClassDetails, AccessType classAccessType, MemberAdjuster memberAdjuster, XmlDocumentContext xmlDocumentContext) {
        MutableMemberDetails memberDetails;
        int i;
        for (i = 0; i < attributesContainer.getBasicAttributes().size(); ++i) {
            JaxbBasicImpl jaxbBasic = attributesContainer.getBasicAttributes().get(i);
            memberDetails = BasicAttributeProcessing.processBasicAttribute(jaxbBasic, mutableClassDetails, classAccessType, xmlDocumentContext);
            if (memberAdjuster == null) continue;
            memberAdjuster.adjust(memberDetails, jaxbBasic, xmlDocumentContext);
        }
        for (i = 0; i < attributesContainer.getEmbeddedAttributes().size(); ++i) {
            JaxbEmbeddedImpl jaxbEmbedded = attributesContainer.getEmbeddedAttributes().get(i);
            memberDetails = EmbeddedAttributeProcessing.processEmbeddedAttribute(jaxbEmbedded, mutableClassDetails, classAccessType, xmlDocumentContext);
            if (memberAdjuster == null) continue;
            memberAdjuster.adjust(memberDetails, jaxbEmbedded, xmlDocumentContext);
        }
        for (i = 0; i < attributesContainer.getManyToOneAttributes().size(); ++i) {
            JaxbManyToOneImpl jaxbManyToOne = attributesContainer.getManyToOneAttributes().get(i);
            memberDetails = ManyToOneAttributeProcessing.processManyToOneAttribute(jaxbManyToOne, mutableClassDetails, classAccessType, xmlDocumentContext);
            if (memberAdjuster == null) continue;
            memberAdjuster.adjust(memberDetails, jaxbManyToOne, xmlDocumentContext);
        }
        for (i = 0; i < attributesContainer.getAnyMappingAttributes().size(); ++i) {
            JaxbAnyMappingImpl jaxbAnyMapping = attributesContainer.getAnyMappingAttributes().get(i);
            memberDetails = AnyMappingAttributeProcessing.processAnyMappingAttribute(jaxbAnyMapping, mutableClassDetails, classAccessType, xmlDocumentContext);
            if (memberAdjuster == null) continue;
            memberAdjuster.adjust(memberDetails, jaxbAnyMapping, xmlDocumentContext);
        }
    }

    public static void processAttributes(JaxbAttributesContainer attributesContainer, MutableClassDetails mutableClassDetails, AccessType classAccessType, XmlDocumentContext xmlDocumentContext) {
        AttributeProcessor.processAttributes(attributesContainer, mutableClassDetails, classAccessType, null, xmlDocumentContext);
    }

    public static void processAttributes(JaxbAttributesContainer attributesContainer, MutableClassDetails mutableClassDetails, AccessType classAccessType, MemberAdjuster memberAdjuster, XmlDocumentContext xmlDocumentContext) {
        MutableMemberDetails memberDetails;
        int i;
        AttributeProcessor.processBaseAttributes(attributesContainer, mutableClassDetails, classAccessType, memberAdjuster, xmlDocumentContext);
        for (i = 0; i < attributesContainer.getOneToOneAttributes().size(); ++i) {
            JaxbOneToOneImpl jaxbOneToOne = attributesContainer.getOneToOneAttributes().get(i);
            memberDetails = OneToOneAttributeProcessing.processOneToOneAttribute(jaxbOneToOne, mutableClassDetails, classAccessType, xmlDocumentContext);
            if (memberAdjuster == null) continue;
            memberAdjuster.adjust(memberDetails, jaxbOneToOne, xmlDocumentContext);
        }
        for (i = 0; i < attributesContainer.getElementCollectionAttributes().size(); ++i) {
            JaxbElementCollectionImpl jaxbElementCollection = attributesContainer.getElementCollectionAttributes().get(i);
            memberDetails = ElementCollectionAttributeProcessing.processElementCollectionAttribute(jaxbElementCollection, mutableClassDetails, classAccessType, xmlDocumentContext);
            if (memberAdjuster == null) continue;
            memberAdjuster.adjust(memberDetails, jaxbElementCollection, xmlDocumentContext);
        }
        for (i = 0; i < attributesContainer.getOneToManyAttributes().size(); ++i) {
            JaxbOneToManyImpl jaxbOneToMany = attributesContainer.getOneToManyAttributes().get(i);
            memberDetails = OneToManyAttributeProcessing.processOneToManyAttribute(jaxbOneToMany, mutableClassDetails, classAccessType, xmlDocumentContext);
            if (memberAdjuster == null) continue;
            memberAdjuster.adjust(memberDetails, jaxbOneToMany, xmlDocumentContext);
        }
        for (i = 0; i < attributesContainer.getManyToManyAttributes().size(); ++i) {
            JaxbManyToManyImpl jaxbManyToMany = attributesContainer.getManyToManyAttributes().get(i);
            memberDetails = ManyToManyAttributeProcessing.processManyToManyAttribute(jaxbManyToMany, mutableClassDetails, classAccessType, xmlDocumentContext);
            if (memberAdjuster == null) continue;
            memberAdjuster.adjust(memberDetails, jaxbManyToMany, xmlDocumentContext);
        }
        for (i = 0; i < attributesContainer.getPluralAnyMappingAttributes().size(); ++i) {
            JaxbPluralAnyMappingImpl jaxbPluralAnyMapping = attributesContainer.getPluralAnyMappingAttributes().get(i);
            memberDetails = PluralAnyMappingAttributeProcessing.processPluralAnyMappingAttributes(jaxbPluralAnyMapping, mutableClassDetails, classAccessType, xmlDocumentContext);
            if (memberAdjuster == null) continue;
            memberAdjuster.adjust(memberDetails, jaxbPluralAnyMapping, xmlDocumentContext);
        }
        for (i = 0; i < attributesContainer.getTransients().size(); ++i) {
            JaxbTransientImpl jaxbTransient = attributesContainer.getTransients().get(i);
            CommonAttributeProcessing.applyTransient(jaxbTransient, mutableClassDetails, classAccessType, xmlDocumentContext);
        }
    }

    public static void processAttributeOverrides(List<JaxbAttributeOverrideImpl> attributeOverrides, MutableClassDetails mutableClassDetails, XmlDocumentContext xmlDocumentContext) {
        XmlAnnotationHelper.applyAttributeOverrides(attributeOverrides, (MutableAnnotationTarget)mutableClassDetails, null, xmlDocumentContext);
    }

    public static void processAssociationOverrides(List<JaxbAssociationOverrideImpl> associationOverrides, MutableClassDetails mutableClassDetails, XmlDocumentContext xmlDocumentContext) {
        XmlAnnotationHelper.applyAssociationOverrides(associationOverrides, (MutableAnnotationTarget)mutableClassDetails, xmlDocumentContext);
    }

    @FunctionalInterface
    public static interface MemberAdjuster {
        public <M extends MutableMemberDetails> void adjust(M var1, JaxbPersistentAttribute var2, XmlDocumentContext var3);
    }
}

