/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.xml.internal;

import jakarta.persistence.AssociationOverride;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.CheckConstraint;
import jakarta.persistence.Convert;
import jakarta.persistence.EnumType;
import jakarta.persistence.Index;
import jakarta.persistence.PrimaryKeyJoinColumn;
import jakarta.persistence.SecondaryTable;
import jakarta.persistence.TemporalType;
import jakarta.persistence.UniqueConstraint;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.URL;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Currency;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.UUID;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.AnnotationException;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Filter;
import org.hibernate.annotations.FilterJoinTable;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.ResultCheckStyle;
import org.hibernate.annotations.SecondaryRow;
import org.hibernate.boot.internal.LimitedCollectionClassification;
import org.hibernate.boot.jaxb.mapping.spi.JaxbAssociationOverrideImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbAttributeOverrideImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbBasicMapping;
import org.hibernate.boot.jaxb.mapping.spi.JaxbCachingImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbCascadeTypeImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbCheckConstraintImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbCollectionIdImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbCollectionUserTypeImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbColumnImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbConfigurationParameterImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbConvertImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbCustomSqlImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbDiscriminatorColumnImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbDiscriminatorFormulaImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbElementCollectionImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEntity;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEntityImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEntityListenerContainerImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEntityListenerImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEntityOrMappedSuperclass;
import org.hibernate.boot.jaxb.mapping.spi.JaxbGeneratedValueImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbGenericIdGeneratorImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbHbmFilterImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbIdClassImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbIndexImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbJoinColumnImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbLifecycleCallback;
import org.hibernate.boot.jaxb.mapping.spi.JaxbLifecycleCallbackContainer;
import org.hibernate.boot.jaxb.mapping.spi.JaxbLobImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbNationalizedImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbNaturalId;
import org.hibernate.boot.jaxb.mapping.spi.JaxbNotFoundCapable;
import org.hibernate.boot.jaxb.mapping.spi.JaxbPluralAttribute;
import org.hibernate.boot.jaxb.mapping.spi.JaxbPrimaryKeyJoinColumnImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbSchemaAware;
import org.hibernate.boot.jaxb.mapping.spi.JaxbSecondaryTableImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbSequenceGeneratorImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbTableGeneratorImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbTableImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbUniqueConstraintImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbUserTypeImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbUuidGeneratorImpl;
import org.hibernate.boot.models.HibernateAnnotations;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.XmlAnnotations;
import org.hibernate.boot.models.annotations.internal.AssociationOverrideJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.AssociationOverridesJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.AttributeOverrideJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.AttributeOverridesJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.CascadeAnnotation;
import org.hibernate.boot.models.annotations.internal.CheckConstraintJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.CollectionClassificationXmlAnnotation;
import org.hibernate.boot.models.annotations.internal.CollectionIdAnnotation;
import org.hibernate.boot.models.annotations.internal.CollectionTypeAnnotation;
import org.hibernate.boot.models.annotations.internal.ColumnJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.ColumnTransformerAnnotation;
import org.hibernate.boot.models.annotations.internal.ConvertJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.ConvertsJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.DiscriminatorColumnJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.DiscriminatorFormulaAnnotation;
import org.hibernate.boot.models.annotations.internal.DiscriminatorOptionsAnnotation;
import org.hibernate.boot.models.annotations.internal.DiscriminatorValueJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.EntityJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.EntityListenersJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.EnumeratedJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.FilterAnnotation;
import org.hibernate.boot.models.annotations.internal.FilterJoinTableAnnotation;
import org.hibernate.boot.models.annotations.internal.FilterJoinTablesAnnotation;
import org.hibernate.boot.models.annotations.internal.FiltersAnnotation;
import org.hibernate.boot.models.annotations.internal.GeneratedValueJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.GenericGeneratorAnnotation;
import org.hibernate.boot.models.annotations.internal.IdClassJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.IndexJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.InheritanceJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.JavaTypeAnnotation;
import org.hibernate.boot.models.annotations.internal.JdbcTypeAnnotation;
import org.hibernate.boot.models.annotations.internal.JdbcTypeCodeAnnotation;
import org.hibernate.boot.models.annotations.internal.NaturalIdCacheAnnotation;
import org.hibernate.boot.models.annotations.internal.NotFoundAnnotation;
import org.hibernate.boot.models.annotations.internal.ParameterAnnotation;
import org.hibernate.boot.models.annotations.internal.PrimaryKeyJoinColumnJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.PrimaryKeyJoinColumnsJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.RowIdAnnotation;
import org.hibernate.boot.models.annotations.internal.SQLJoinTableRestrictionAnnotation;
import org.hibernate.boot.models.annotations.internal.SQLRestrictionAnnotation;
import org.hibernate.boot.models.annotations.internal.SecondaryRowAnnotation;
import org.hibernate.boot.models.annotations.internal.SecondaryRowsAnnotation;
import org.hibernate.boot.models.annotations.internal.SecondaryTableJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.SecondaryTablesJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.SequenceGeneratorJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.TableGeneratorJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.TableJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.TargetXmlAnnotation;
import org.hibernate.boot.models.annotations.internal.TemporalJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.UniqueConstraintJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.UuidGeneratorAnnotation;
import org.hibernate.boot.models.annotations.spi.CustomSqlDetails;
import org.hibernate.boot.models.annotations.spi.DatabaseObjectDetails;
import org.hibernate.boot.models.categorize.spi.JpaEventListenerStyle;
import org.hibernate.boot.models.spi.JpaEventListener;
import org.hibernate.boot.models.xml.internal.UserTypeCases;
import org.hibernate.boot.models.xml.internal.UserTypeCasesMapKey;
import org.hibernate.boot.models.xml.internal.UserTypeCasesStandard;
import org.hibernate.boot.models.xml.internal.db.ForeignKeyProcessing;
import org.hibernate.boot.models.xml.internal.db.JoinColumnProcessing;
import org.hibernate.boot.models.xml.internal.db.TableProcessing;
import org.hibernate.boot.models.xml.spi.XmlDocument;
import org.hibernate.boot.models.xml.spi.XmlDocumentContext;
import org.hibernate.engine.spi.ExecuteUpdateResultCheckStyle;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.models.ModelsException;
import org.hibernate.models.spi.AnnotationDescriptor;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.ClassDetailsRegistry;
import org.hibernate.models.spi.MethodDetails;
import org.hibernate.models.spi.MutableAnnotationTarget;
import org.hibernate.models.spi.MutableClassDetails;
import org.hibernate.models.spi.MutableMemberDetails;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.hibernate.type.SqlTypes;

public class XmlAnnotationHelper {
    private static final Parameter[] NO_PARAMETERS = new Parameter[0];
    private static final CheckConstraint[] NO_CHECK_CONSTRAINTS = new CheckConstraint[0];
    private static final UniqueConstraint[] NO_UNIQUE_CONSTRAINTS = new UniqueConstraint[0];
    private static final Index[] NO_INDICES = new Index[0];

    public static void applyEntity(JaxbEntity jaxbEntity, MutableClassDetails classDetails, XmlDocumentContext xmlDocumentContext) {
        EntityJpaAnnotation entityAnn = (EntityJpaAnnotation)((Object)classDetails.applyAnnotationUsage(JpaAnnotations.ENTITY, xmlDocumentContext.getModelBuildingContext()));
        if (StringHelper.isNotEmpty(jaxbEntity.getName())) {
            entityAnn.name(jaxbEntity.getName());
        }
    }

    public static void applyColumn(JaxbColumnImpl jaxbColumn, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        if (jaxbColumn == null) {
            return;
        }
        ColumnJpaAnnotation columnAnnotationUsage = (ColumnJpaAnnotation)memberDetails.applyAnnotationUsage(JpaAnnotations.COLUMN, xmlDocumentContext.getModelBuildingContext());
        columnAnnotationUsage.apply(jaxbColumn, xmlDocumentContext);
    }

    private static ColumnJpaAnnotation createColumnAnnotation(JaxbColumnImpl jaxbColumn, MutableAnnotationTarget target, XmlDocumentContext xmlDocumentContext) {
        ColumnJpaAnnotation usage = (ColumnJpaAnnotation)JpaAnnotations.COLUMN.createUsage(xmlDocumentContext.getModelBuildingContext());
        usage.apply(jaxbColumn, xmlDocumentContext);
        return usage;
    }

    public static void applyColumnTransformation(JaxbColumnImpl jaxbColumn, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        if (StringHelper.isEmpty(jaxbColumn.getRead()) && StringHelper.isEmpty(jaxbColumn.getWrite())) {
            return;
        }
        ColumnTransformerAnnotation annotationUsage = (ColumnTransformerAnnotation)memberDetails.applyAnnotationUsage(HibernateAnnotations.COLUMN_TRANSFORMER, xmlDocumentContext.getModelBuildingContext());
        annotationUsage.forColumn(jaxbColumn.getName());
        if (StringHelper.isNotEmpty(jaxbColumn.getRead())) {
            annotationUsage.read(jaxbColumn.getRead());
        }
        if (StringHelper.isNotEmpty(jaxbColumn.getWrite())) {
            annotationUsage.write(jaxbColumn.getWrite());
        }
    }

    public static void applyUserType(JaxbUserTypeImpl jaxbType, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        XmlAnnotationHelper.applyUserType(jaxbType, memberDetails, UserTypeCasesStandard.STANDARD_USER_TYPE_CASES, xmlDocumentContext);
    }

    public static void applyMapKeyUserType(JaxbUserTypeImpl jaxbType, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        XmlAnnotationHelper.applyUserType(jaxbType, memberDetails, UserTypeCasesMapKey.MAP_KEY_USER_TYPE_CASES, xmlDocumentContext);
    }

    public static void applyUserType(JaxbUserTypeImpl jaxbType, MutableMemberDetails memberDetails, UserTypeCases cases, XmlDocumentContext xmlDocumentContext) {
        if (jaxbType == null || StringHelper.isEmpty(jaxbType.getValue())) {
            cases.handleNone(jaxbType, memberDetails, xmlDocumentContext);
        } else if (jaxbType.getValue().equalsIgnoreCase("char") || jaxbType.getValue().equalsIgnoreCase("character") || Character.class.getName().equalsIgnoreCase(jaxbType.getValue())) {
            cases.handleCharacter(jaxbType, memberDetails, xmlDocumentContext);
        } else if (jaxbType.getValue().equalsIgnoreCase("string") || String.class.getName().equalsIgnoreCase(jaxbType.getValue())) {
            cases.handleString(jaxbType, memberDetails, xmlDocumentContext);
        } else if (jaxbType.getValue().equalsIgnoreCase("byte") || Byte.class.getName().equals(jaxbType.getValue())) {
            cases.handleByte(jaxbType, memberDetails, xmlDocumentContext);
        } else if (jaxbType.getValue().equalsIgnoreCase("boolean") || Boolean.class.getName().equals(jaxbType.getValue())) {
            cases.handleBoolean(jaxbType, memberDetails, xmlDocumentContext);
        } else if (jaxbType.getValue().equalsIgnoreCase("short") || Short.class.getName().equals(jaxbType.getValue())) {
            cases.handleShort(jaxbType, memberDetails, xmlDocumentContext);
        } else if (jaxbType.getValue().equalsIgnoreCase("int") || jaxbType.getValue().equalsIgnoreCase("integer") || Integer.class.getName().equals(jaxbType.getValue())) {
            cases.handleInteger(jaxbType, memberDetails, xmlDocumentContext);
        } else if (jaxbType.getValue().equalsIgnoreCase("long") || Long.class.getName().equals(jaxbType.getValue())) {
            cases.handleLong(jaxbType, memberDetails, xmlDocumentContext);
        } else if (jaxbType.getValue().equalsIgnoreCase("double") || Double.class.getName().equals(jaxbType.getValue())) {
            cases.handleDouble(jaxbType, memberDetails, xmlDocumentContext);
        } else if (jaxbType.getValue().equalsIgnoreCase("float") || Float.class.getName().equals(jaxbType.getValue())) {
            cases.handleFloat(jaxbType, memberDetails, xmlDocumentContext);
        } else if (jaxbType.getValue().equalsIgnoreCase("biginteger") || jaxbType.getValue().equalsIgnoreCase("big_integer") || BigInteger.class.getName().equals(jaxbType.getValue())) {
            cases.handleBigInteger(jaxbType, memberDetails, xmlDocumentContext);
        } else if (jaxbType.getValue().equalsIgnoreCase("bigdecimal") || jaxbType.getValue().equalsIgnoreCase("big_decimal") || BigDecimal.class.getName().equals(jaxbType.getValue())) {
            cases.handleBigDecimal(jaxbType, memberDetails, xmlDocumentContext);
        } else if (jaxbType.getValue().equalsIgnoreCase("uuid") || UUID.class.getName().equals(jaxbType.getValue())) {
            cases.handleUuid(jaxbType, memberDetails, xmlDocumentContext);
        } else if (jaxbType.getValue().equalsIgnoreCase("url") || URL.class.getName().equals(jaxbType.getValue())) {
            cases.handleUrl(jaxbType, memberDetails, xmlDocumentContext);
        } else if (jaxbType.getValue().equalsIgnoreCase("inet") || jaxbType.getValue().equalsIgnoreCase("inetaddress") || jaxbType.getValue().equalsIgnoreCase("inet_address") || InetAddress.class.getName().equals(jaxbType.getValue())) {
            cases.handleInetAddress(jaxbType, memberDetails, xmlDocumentContext);
        } else if (jaxbType.getValue().equalsIgnoreCase("currency") || Currency.class.getName().equals(jaxbType.getValue())) {
            cases.handleCurrency(jaxbType, memberDetails, xmlDocumentContext);
        } else if (jaxbType.getValue().equalsIgnoreCase("locale") || Locale.class.getName().equals(jaxbType.getValue())) {
            cases.handleLocale(jaxbType, memberDetails, xmlDocumentContext);
        } else if (jaxbType.getValue().equalsIgnoreCase("class") || Class.class.getName().equals(jaxbType.getValue())) {
            cases.handleClass(jaxbType, memberDetails, xmlDocumentContext);
        } else if (jaxbType.getValue().equalsIgnoreCase("blob") || Blob.class.getName().equals(jaxbType.getValue())) {
            cases.handleBlob(jaxbType, memberDetails, xmlDocumentContext);
        } else if (jaxbType.getValue().equalsIgnoreCase("clob") || Clob.class.getName().equals(jaxbType.getValue())) {
            cases.handleClob(jaxbType, memberDetails, xmlDocumentContext);
        } else if (jaxbType.getValue().equalsIgnoreCase("nclob") || NClob.class.getName().equals(jaxbType.getValue())) {
            cases.handleNClob(jaxbType, memberDetails, xmlDocumentContext);
        } else if (jaxbType.getValue().equalsIgnoreCase("instant") || Instant.class.getName().equals(jaxbType.getValue())) {
            cases.handleInstant(jaxbType, memberDetails, xmlDocumentContext);
        } else if (jaxbType.getValue().equalsIgnoreCase("duration") || Duration.class.getName().equals(jaxbType.getValue())) {
            cases.handleDuration(jaxbType, memberDetails, xmlDocumentContext);
        } else if (jaxbType.getValue().equalsIgnoreCase("year") || Year.class.getName().equals(jaxbType.getValue())) {
            cases.handleYear(jaxbType, memberDetails, xmlDocumentContext);
        } else if (jaxbType.getValue().equalsIgnoreCase("localdatetime") || jaxbType.getValue().equalsIgnoreCase("local_date_time") || LocalDateTime.class.getName().equals(jaxbType.getValue())) {
            cases.handleLocalDateTime(jaxbType, memberDetails, xmlDocumentContext);
        } else if (jaxbType.getValue().equalsIgnoreCase("localdate") || jaxbType.getValue().equalsIgnoreCase("local_date") || LocalDate.class.getName().equals(jaxbType.getValue())) {
            cases.handleLocalDate(jaxbType, memberDetails, xmlDocumentContext);
        } else if (jaxbType.getValue().equalsIgnoreCase("localtime") || jaxbType.getValue().equalsIgnoreCase("local_time") || LocalTime.class.getName().equals(jaxbType.getValue())) {
            cases.handleLocalTime(jaxbType, memberDetails, xmlDocumentContext);
        } else if (jaxbType.getValue().equalsIgnoreCase("zoneddatetime") || jaxbType.getValue().equalsIgnoreCase("zoned_date_time") || ZonedDateTime.class.getName().equals(jaxbType.getValue())) {
            cases.handleZonedDateTime(jaxbType, memberDetails, xmlDocumentContext);
        } else if (jaxbType.getValue().equalsIgnoreCase("offsetdatetime") || jaxbType.getValue().equalsIgnoreCase("offset_date_time") || OffsetDateTime.class.getName().equals(jaxbType.getValue())) {
            cases.handleOffsetDateTime(jaxbType, memberDetails, xmlDocumentContext);
        } else if (jaxbType.getValue().equalsIgnoreCase("offsettime") || jaxbType.getValue().equalsIgnoreCase("offset_time") || OffsetTime.class.getName().equals(jaxbType.getValue())) {
            cases.handleOffsetTime(jaxbType, memberDetails, xmlDocumentContext);
        } else if (jaxbType.getValue().equalsIgnoreCase("zoneid") || jaxbType.getValue().equalsIgnoreCase("zone_id") || ZoneId.class.getName().equals(jaxbType.getValue())) {
            cases.handleZoneId(jaxbType, memberDetails, xmlDocumentContext);
        } else if (jaxbType.getValue().equalsIgnoreCase("zoneoffset") || jaxbType.getValue().equalsIgnoreCase("zone_offset") || ZoneOffset.class.getName().equals(jaxbType.getValue())) {
            cases.handleZoneOffset(jaxbType, memberDetails, xmlDocumentContext);
        } else if (jaxbType.getValue().equalsIgnoreCase("timestamp") || jaxbType.getValue().equalsIgnoreCase("time_stamp") || Date.class.getName().equals(jaxbType.getValue()) || Timestamp.class.getName().equals(jaxbType.getValue())) {
            cases.handleTimestamp(jaxbType, memberDetails, xmlDocumentContext);
        } else if (jaxbType.getValue().equalsIgnoreCase("date") || java.sql.Date.class.getName().equals(jaxbType.getValue())) {
            cases.handleDate(jaxbType, memberDetails, xmlDocumentContext);
        } else if (jaxbType.getValue().equalsIgnoreCase("time") || Time.class.getName().equals(jaxbType.getValue())) {
            cases.handleTime(jaxbType, memberDetails, xmlDocumentContext);
        } else if (jaxbType.getValue().equalsIgnoreCase("calendar") || jaxbType.getValue().equalsIgnoreCase("gregoriancalendar") || jaxbType.getValue().equalsIgnoreCase("gregorian_calendar") || Calendar.class.getName().equals(jaxbType.getValue()) || GregorianCalendar.class.getName().equals(jaxbType.getValue())) {
            cases.handleCalendar(jaxbType, memberDetails, xmlDocumentContext);
        } else if (jaxbType.getValue().equalsIgnoreCase("timezone") || jaxbType.getValue().equalsIgnoreCase("time_zone") || TimeZone.class.getName().equals(jaxbType.getValue())) {
            cases.handleTimeZone(jaxbType, memberDetails, xmlDocumentContext);
        } else {
            cases.handleGeneral(jaxbType, memberDetails, xmlDocumentContext);
        }
    }

    public static Parameter[] collectParameters(List<JaxbConfigurationParameterImpl> jaxbParameters, XmlDocumentContext xmlDocumentContext) {
        return XmlAnnotationHelper.collectParameters(jaxbParameters, xmlDocumentContext.getModelBuildingContext());
    }

    public static Parameter[] collectParameters(List<JaxbConfigurationParameterImpl> jaxbParameters, SourceModelBuildingContext sourceModelContext) {
        if (CollectionHelper.isEmpty(jaxbParameters)) {
            return NO_PARAMETERS;
        }
        Parameter[] parameters = new Parameter[jaxbParameters.size()];
        for (int i = 0; i < jaxbParameters.size(); ++i) {
            JaxbConfigurationParameterImpl jaxbParameter = jaxbParameters.get(i);
            ParameterAnnotation usage = (ParameterAnnotation)HibernateAnnotations.PARAMETER.createUsage(sourceModelContext);
            parameters[i] = usage;
            usage.name(jaxbParameter.getName());
            usage.value(jaxbParameter.getValue());
        }
        return parameters;
    }

    public static void applyCollectionUserType(JaxbCollectionUserTypeImpl jaxbType, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        if (jaxbType == null) {
            return;
        }
        CollectionTypeAnnotation typeAnn = (CollectionTypeAnnotation)memberDetails.applyAnnotationUsage(HibernateAnnotations.COLLECTION_TYPE, xmlDocumentContext.getModelBuildingContext());
        ClassDetails userTypeImpl = XmlAnnotationHelper.resolveJavaType(jaxbType.getType(), xmlDocumentContext);
        typeAnn.type(userTypeImpl.toJavaClass());
        typeAnn.parameters(XmlAnnotationHelper.collectParameters(jaxbType.getParameters(), xmlDocumentContext));
    }

    public static void applyCollectionId(JaxbCollectionIdImpl jaxbCollectionId, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        JaxbGeneratedValueImpl generator;
        if (jaxbCollectionId == null) {
            return;
        }
        CollectionIdAnnotation collectionIdAnn = (CollectionIdAnnotation)memberDetails.applyAnnotationUsage(HibernateAnnotations.COLLECTION_ID, xmlDocumentContext.getModelBuildingContext());
        JaxbColumnImpl jaxbColumn = jaxbCollectionId.getColumn();
        if (jaxbColumn != null) {
            collectionIdAnn.column(XmlAnnotationHelper.createColumnAnnotation(jaxbColumn, (MutableAnnotationTarget)memberDetails, xmlDocumentContext));
        }
        if ((generator = jaxbCollectionId.getGenerator()) != null && StringHelper.isNotEmpty(generator.getGenerator())) {
            collectionIdAnn.generator(generator.getGenerator());
        }
    }

    public static void applyCascading(JaxbCascadeTypeImpl jaxbCascadeType, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        if (jaxbCascadeType == null) {
            return;
        }
        ArrayList<CascadeType> cascadeTypes = new ArrayList<CascadeType>(xmlDocumentContext.getEffectiveDefaults().getDefaultCascadeTypes());
        if (jaxbCascadeType.getCascadeAll() != null) {
            cascadeTypes.add(CascadeType.ALL);
        }
        if (jaxbCascadeType.getCascadePersist() != null) {
            cascadeTypes.add(CascadeType.PERSIST);
        }
        if (jaxbCascadeType.getCascadeMerge() != null) {
            cascadeTypes.add(CascadeType.MERGE);
        }
        if (jaxbCascadeType.getCascadeRemove() != null) {
            cascadeTypes.add(CascadeType.REMOVE);
        }
        if (jaxbCascadeType.getCascadeRefresh() != null) {
            cascadeTypes.add(CascadeType.REFRESH);
        }
        if (jaxbCascadeType.getCascadeDetach() != null) {
            cascadeTypes.add(CascadeType.DETACH);
        }
        if (jaxbCascadeType.getCascadeReplicate() != null) {
            cascadeTypes.add(CascadeType.REPLICATE);
        }
        if (jaxbCascadeType.getCascadeLock() != null) {
            cascadeTypes.add(CascadeType.LOCK);
        }
        if (!cascadeTypes.isEmpty()) {
            CascadeAnnotation cascadeAnn = (CascadeAnnotation)memberDetails.applyAnnotationUsage(HibernateAnnotations.CASCADE, xmlDocumentContext.getModelBuildingContext());
            cascadeAnn.value((CascadeType[])cascadeTypes.toArray(CascadeType[]::new));
        }
    }

    public static void applyTargetClass(String name, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        TargetXmlAnnotation targetAnn = (TargetXmlAnnotation)memberDetails.applyAnnotationUsage(XmlAnnotations.TARGET, xmlDocumentContext.getModelBuildingContext());
        targetAnn.value(name);
    }

    public static void applyTemporal(TemporalType temporalType, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        if (temporalType == null) {
            return;
        }
        TemporalJpaAnnotation temporalAnn = (TemporalJpaAnnotation)((Object)memberDetails.applyAnnotationUsage(JpaAnnotations.TEMPORAL, xmlDocumentContext.getModelBuildingContext()));
        temporalAnn.value(temporalType);
    }

    public static void applyLob(JaxbLobImpl jaxbLob, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        if (jaxbLob == null) {
            return;
        }
        memberDetails.applyAnnotationUsage(JpaAnnotations.LOB, xmlDocumentContext.getModelBuildingContext());
    }

    public static void applyEnumerated(EnumType enumType, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        if (enumType == null) {
            return;
        }
        EnumeratedJpaAnnotation annotationUsage = (EnumeratedJpaAnnotation)((Object)memberDetails.applyAnnotationUsage(JpaAnnotations.ENUMERATED, xmlDocumentContext.getModelBuildingContext()));
        annotationUsage.value(enumType);
    }

    public static void applyNationalized(JaxbNationalizedImpl jaxbNationalized, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        if (jaxbNationalized == null) {
            return;
        }
        memberDetails.applyAnnotationUsage(HibernateAnnotations.NATIONALIZED, xmlDocumentContext.getModelBuildingContext());
    }

    public static void applyGeneratedValue(JaxbGeneratedValueImpl jaxbGeneratedValue, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        if (jaxbGeneratedValue == null) {
            return;
        }
        GeneratedValueJpaAnnotation generatedValueAnn = (GeneratedValueJpaAnnotation)((Object)memberDetails.applyAnnotationUsage(JpaAnnotations.GENERATED_VALUE, xmlDocumentContext.getModelBuildingContext()));
        if (jaxbGeneratedValue.getStrategy() != null) {
            generatedValueAnn.strategy(jaxbGeneratedValue.getStrategy());
        }
        if (StringHelper.isNotEmpty(jaxbGeneratedValue.getGenerator())) {
            generatedValueAnn.generator(jaxbGeneratedValue.getGenerator());
        }
    }

    public static void applySequenceGenerator(JaxbSequenceGeneratorImpl jaxbGenerator, MutableAnnotationTarget generatorTarget, XmlDocumentContext xmlDocumentContext) {
        if (jaxbGenerator == null) {
            return;
        }
        SequenceGeneratorJpaAnnotation sequenceAnn = (SequenceGeneratorJpaAnnotation)((Object)generatorTarget.applyAnnotationUsage(JpaAnnotations.SEQUENCE_GENERATOR, xmlDocumentContext.getModelBuildingContext()));
        if (StringHelper.isNotEmpty(jaxbGenerator.getName())) {
            sequenceAnn.name(jaxbGenerator.getName());
        }
        if (jaxbGenerator.getSequenceName() != null) {
            sequenceAnn.sequenceName(jaxbGenerator.getSequenceName());
        }
        if (StringHelper.isNotEmpty(jaxbGenerator.getCatalog())) {
            sequenceAnn.catalog(jaxbGenerator.getCatalog());
        }
        if (StringHelper.isNotEmpty(jaxbGenerator.getSchema())) {
            sequenceAnn.schema(jaxbGenerator.getSchema());
        }
        if (jaxbGenerator.getInitialValue() != null) {
            sequenceAnn.initialValue(jaxbGenerator.getInitialValue());
        }
        if (jaxbGenerator.getAllocationSize() != null) {
            sequenceAnn.allocationSize(jaxbGenerator.getAllocationSize());
        }
        if (StringHelper.isNotEmpty(jaxbGenerator.getOptions())) {
            sequenceAnn.options(jaxbGenerator.getOptions());
        }
    }

    public static void applyTableGenerator(JaxbTableGeneratorImpl jaxbGenerator, MutableAnnotationTarget generatorTarget, XmlDocumentContext xmlDocumentContext) {
        if (jaxbGenerator == null) {
            return;
        }
        TableGeneratorJpaAnnotation tableAnn = (TableGeneratorJpaAnnotation)generatorTarget.applyAnnotationUsage(JpaAnnotations.TABLE_GENERATOR, xmlDocumentContext.getModelBuildingContext());
        tableAnn.apply(jaxbGenerator, xmlDocumentContext);
    }

    public static void applyUuidGenerator(JaxbUuidGeneratorImpl jaxbGenerator, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        if (jaxbGenerator == null) {
            return;
        }
        UuidGeneratorAnnotation uuidGenAnn = (UuidGeneratorAnnotation)memberDetails.applyAnnotationUsage(HibernateAnnotations.UUID_GENERATOR, xmlDocumentContext.getModelBuildingContext());
        uuidGenAnn.style(jaxbGenerator.getStyle());
    }

    public static void applyGenericGenerator(JaxbGenericIdGeneratorImpl jaxbGenerator, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        if (jaxbGenerator == null) {
            return;
        }
        GenericGeneratorAnnotation generatorAnn = (GenericGeneratorAnnotation)memberDetails.applyAnnotationUsage(HibernateAnnotations.GENERIC_GENERATOR, xmlDocumentContext.getModelBuildingContext());
        generatorAnn.name("");
        generatorAnn.strategy(jaxbGenerator.getClazz());
        List<JaxbConfigurationParameterImpl> jaxbParameters = jaxbGenerator.getParameters();
        if (CollectionHelper.isEmpty(jaxbParameters)) {
            generatorAnn.parameters(NO_PARAMETERS);
        } else {
            Parameter[] parameters = new Parameter[jaxbParameters.size()];
            for (int i = 0; i < jaxbParameters.size(); ++i) {
                ParameterAnnotation parameterUsage = (ParameterAnnotation)HibernateAnnotations.PARAMETER.createUsage(xmlDocumentContext.getModelBuildingContext());
                parameterUsage.name(jaxbParameters.get(i).getName());
                parameterUsage.value(jaxbParameters.get(i).getValue());
                parameters[i] = parameterUsage;
            }
            generatorAnn.parameters(parameters);
        }
    }

    public static void applyAttributeOverrides(JaxbPluralAttribute pluralAttribute, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        List<JaxbAttributeOverrideImpl> jaxbElementOverrides;
        List<JaxbAttributeOverrideImpl> jaxbMapKeyOverrides = pluralAttribute.getMapKeyAttributeOverrides();
        List<JaxbAttributeOverrideImpl> list = jaxbElementOverrides = pluralAttribute instanceof JaxbElementCollectionImpl ? ((JaxbElementCollectionImpl)pluralAttribute).getAttributeOverrides() : Collections.emptyList();
        if (CollectionHelper.isEmpty(jaxbMapKeyOverrides) && CollectionHelper.isEmpty(jaxbElementOverrides)) {
            return;
        }
        AttributeOverridesJpaAnnotation overridesUsage = (AttributeOverridesJpaAnnotation)((Object)memberDetails.applyAnnotationUsage(JpaAnnotations.ATTRIBUTE_OVERRIDES, xmlDocumentContext.getModelBuildingContext()));
        int numberOfOverrides = jaxbMapKeyOverrides.size() + jaxbElementOverrides.size();
        AttributeOverride[] overrideUsages = new AttributeOverride[numberOfOverrides];
        overridesUsage.value(overrideUsages);
        if (memberDetails.getMapKeyType() != null) {
            int position = 0;
            for (JaxbAttributeOverrideImpl jaxbOverride : jaxbMapKeyOverrides) {
                overrideUsages[position++] = XmlAnnotationHelper.createAttributeOverrideUsage(jaxbOverride, "key", (MutableAnnotationTarget)memberDetails, xmlDocumentContext);
            }
            for (JaxbAttributeOverrideImpl jaxbOverride : jaxbElementOverrides) {
                overrideUsages[position++] = XmlAnnotationHelper.createAttributeOverrideUsage(jaxbOverride, "value", (MutableAnnotationTarget)memberDetails, xmlDocumentContext);
            }
        } else {
            assert (CollectionHelper.isEmpty(jaxbMapKeyOverrides));
            for (int i = 0; i < jaxbElementOverrides.size(); ++i) {
                overrideUsages[i] = XmlAnnotationHelper.createAttributeOverrideUsage(jaxbElementOverrides.get(i), "value", (MutableAnnotationTarget)memberDetails, xmlDocumentContext);
            }
        }
    }

    private static AttributeOverrideJpaAnnotation createAttributeOverrideUsage(JaxbAttributeOverrideImpl jaxbOverride, String namePrefix, MutableAnnotationTarget target, XmlDocumentContext xmlDocumentContext) {
        SourceModelBuildingContext modelBuildingContext = xmlDocumentContext.getModelBuildingContext();
        AttributeOverrideJpaAnnotation overrideUsage = (AttributeOverrideJpaAnnotation)((Object)JpaAnnotations.ATTRIBUTE_OVERRIDE.createUsage(modelBuildingContext));
        String name = StringHelper.qualifyConditionally(namePrefix, jaxbOverride.getName());
        overrideUsage.name(name);
        ColumnJpaAnnotation columnAnn = (ColumnJpaAnnotation)JpaAnnotations.COLUMN.createUsage(modelBuildingContext);
        overrideUsage.column(columnAnn);
        columnAnn.apply(jaxbOverride.getColumn(), xmlDocumentContext);
        return overrideUsage;
    }

    public static void applyAttributeOverrides(List<JaxbAttributeOverrideImpl> jaxbOverrides, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        XmlAnnotationHelper.applyAttributeOverrides(jaxbOverrides, (MutableAnnotationTarget)memberDetails, null, xmlDocumentContext);
    }

    public static void applyAttributeOverrides(List<JaxbAttributeOverrideImpl> jaxbOverrides, MutableAnnotationTarget target, String namePrefix, XmlDocumentContext xmlDocumentContext) {
        if (CollectionHelper.isEmpty(jaxbOverrides)) {
            return;
        }
        AttributeOverridesJpaAnnotation overridesUsage = (AttributeOverridesJpaAnnotation)((Object)target.replaceAnnotationUsage(JpaAnnotations.ATTRIBUTE_OVERRIDE, JpaAnnotations.ATTRIBUTE_OVERRIDES, xmlDocumentContext.getModelBuildingContext()));
        AttributeOverride[] overrideUsages = new AttributeOverride[jaxbOverrides.size()];
        overridesUsage.value(overrideUsages);
        for (int i = 0; i < jaxbOverrides.size(); ++i) {
            overrideUsages[i] = XmlAnnotationHelper.createAttributeOverrideUsage(jaxbOverrides.get(i), namePrefix, target, xmlDocumentContext);
        }
    }

    public static void applyAssociationOverrides(List<JaxbAssociationOverrideImpl> jaxbOverrides, MutableAnnotationTarget target, XmlDocumentContext xmlDocumentContext) {
        if (CollectionHelper.isEmpty(jaxbOverrides)) {
            return;
        }
        AssociationOverridesJpaAnnotation overridesUsage = (AssociationOverridesJpaAnnotation)((Object)target.replaceAnnotationUsage(JpaAnnotations.ASSOCIATION_OVERRIDE, JpaAnnotations.ASSOCIATION_OVERRIDES, xmlDocumentContext.getModelBuildingContext()));
        AssociationOverride[] overrideUsages = new AssociationOverride[jaxbOverrides.size()];
        overridesUsage.value(overrideUsages);
        for (int i = 0; i < jaxbOverrides.size(); ++i) {
            AssociationOverrideJpaAnnotation override = (AssociationOverrideJpaAnnotation)((Object)JpaAnnotations.ASSOCIATION_OVERRIDE.createUsage(xmlDocumentContext.getModelBuildingContext()));
            overrideUsages[i] = override;
            XmlAnnotationHelper.transferAssociationOverride(jaxbOverrides.get(i), override, target, xmlDocumentContext);
        }
    }

    private static void transferAssociationOverride(JaxbAssociationOverrideImpl jaxbOverride, AssociationOverrideJpaAnnotation overrideUsage, MutableAnnotationTarget target, XmlDocumentContext xmlDocumentContext) {
        overrideUsage.name(jaxbOverride.getName());
        List<JaxbJoinColumnImpl> joinColumns = jaxbOverride.getJoinColumns();
        if (CollectionHelper.isNotEmpty(joinColumns)) {
            overrideUsage.joinColumns(JoinColumnProcessing.transformJoinColumnList(joinColumns, xmlDocumentContext));
        }
        if (jaxbOverride.getJoinTable() != null) {
            overrideUsage.joinTable(TableProcessing.transformJoinTable(jaxbOverride.getJoinTable(), target, xmlDocumentContext));
        }
        if (jaxbOverride.getForeignKeys() != null) {
            overrideUsage.foreignKey(ForeignKeyProcessing.createNestedForeignKeyAnnotation(jaxbOverride.getForeignKeys(), xmlDocumentContext));
        }
    }

    public static void applyConvert(JaxbConvertImpl jaxbConvert, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        if (jaxbConvert == null) {
            return;
        }
        ConvertJpaAnnotation annotation = (ConvertJpaAnnotation)((Object)memberDetails.replaceAnnotationUsage(JpaAnnotations.CONVERT, xmlDocumentContext.getModelBuildingContext()));
        XmlAnnotationHelper.transferConvertDetails(jaxbConvert, annotation, null, xmlDocumentContext);
    }

    public static void applyConverts(List<JaxbConvertImpl> jaxbConverts, String namePrefix, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        if (CollectionHelper.isEmpty(jaxbConverts)) {
            return;
        }
        ConvertsJpaAnnotation convertsUsage = (ConvertsJpaAnnotation)memberDetails.replaceAnnotationUsage(JpaAnnotations.CONVERT, JpaAnnotations.CONVERTS, xmlDocumentContext.getModelBuildingContext());
        Convert[] convertUsages = new Convert[jaxbConverts.size()];
        convertsUsage.value(convertUsages);
        for (int i = 0; i < jaxbConverts.size(); ++i) {
            convertUsages[i] = XmlAnnotationHelper.transformConvert(jaxbConverts.get(i), namePrefix, xmlDocumentContext);
        }
    }

    public static Convert transformConvert(JaxbConvertImpl jaxbConvert, String namePrefix, XmlDocumentContext xmlDocumentContext) {
        if (jaxbConvert == null) {
            return null;
        }
        ConvertJpaAnnotation convert = (ConvertJpaAnnotation)((Object)JpaAnnotations.CONVERT.createUsage(xmlDocumentContext.getModelBuildingContext()));
        XmlAnnotationHelper.transferConvertDetails(jaxbConvert, convert, namePrefix, xmlDocumentContext);
        return convert;
    }

    private static void transferConvertDetails(JaxbConvertImpl jaxbConvert, ConvertJpaAnnotation convert, String namePrefix, XmlDocumentContext xmlDocumentContext) {
        if (StringHelper.isNotEmpty(jaxbConvert.getConverter())) {
            convert.converter(xmlDocumentContext.resolveJavaType(jaxbConvert.getConverter()).toJavaClass());
        }
        if (StringHelper.isNotEmpty(jaxbConvert.getAttributeName())) {
            convert.attributeName(XmlAnnotationHelper.prefixIfNotAlready(jaxbConvert.getAttributeName(), namePrefix));
        }
        if (jaxbConvert.isDisableConversion() != null) {
            convert.disableConversion(jaxbConvert.isDisableConversion());
        }
    }

    public static void applyTable(JaxbTableImpl jaxbTable, MutableAnnotationTarget target, XmlDocumentContext xmlDocumentContext) {
        if (jaxbTable == null) {
            XmlDocument.Defaults defaults = xmlDocumentContext.getXmlDocument().getDefaults();
            String catalog = defaults.getCatalog();
            String schema = defaults.getSchema();
            if (StringHelper.isNotEmpty(catalog) || StringHelper.isNotEmpty(schema)) {
                TableJpaAnnotation tableAnn = (TableJpaAnnotation)target.applyAnnotationUsage(JpaAnnotations.TABLE, xmlDocumentContext.getModelBuildingContext());
                if (StringHelper.isNotEmpty(catalog)) {
                    tableAnn.catalog(catalog);
                }
                if (StringHelper.isNotEmpty(schema)) {
                    tableAnn.schema(schema);
                }
            }
        } else {
            TableJpaAnnotation tableAnn = (TableJpaAnnotation)target.applyAnnotationUsage(JpaAnnotations.TABLE, xmlDocumentContext.getModelBuildingContext());
            tableAnn.apply(jaxbTable, xmlDocumentContext);
        }
    }

    public static void applyOptionalString(String value, Consumer<String> target) {
        if (StringHelper.isNotEmpty(value)) {
            target.accept(value);
        }
    }

    public static void applyNaturalIdCache(JaxbNaturalId jaxbNaturalId, MutableClassDetails classDetails, XmlDocumentContext xmlDocumentContext) {
        if (jaxbNaturalId == null || jaxbNaturalId.getCaching() == null) {
            return;
        }
        NaturalIdCacheAnnotation naturalIdCacheUsage = (NaturalIdCacheAnnotation)classDetails.applyAnnotationUsage(HibernateAnnotations.NATURAL_ID_CACHE, xmlDocumentContext.getModelBuildingContext());
        JaxbCachingImpl jaxbCaching = jaxbNaturalId.getCaching();
        if (StringHelper.isNotEmpty(jaxbCaching.getRegion())) {
            naturalIdCacheUsage.region(jaxbCaching.getRegion());
        }
    }

    static void applyInheritance(JaxbEntity jaxbEntity, MutableClassDetails classDetails, XmlDocumentContext xmlDocumentContext) {
        if (jaxbEntity.getInheritance() == null) {
            return;
        }
        InheritanceJpaAnnotation inheritanceUsage = (InheritanceJpaAnnotation)((Object)classDetails.applyAnnotationUsage(JpaAnnotations.INHERITANCE, xmlDocumentContext.getModelBuildingContext()));
        if (jaxbEntity.getInheritance().getStrategy() != null) {
            inheritanceUsage.strategy(jaxbEntity.getInheritance().getStrategy());
        }
    }

    public static ClassDetails resolveJavaType(String value, XmlDocumentContext xmlDocumentContext) {
        return XmlAnnotationHelper.resolveJavaType(xmlDocumentContext.getXmlDocument().getDefaults().getPackage(), value, xmlDocumentContext.getModelBuildingContext().getClassDetailsRegistry());
    }

    public static ClassDetails resolveJavaType(String value, ClassDetailsRegistry classDetailsRegistry) {
        return XmlAnnotationHelper.resolveJavaType(null, value, classDetailsRegistry);
    }

    public static ClassDetails resolveJavaType(String packageName, String name, ClassDetailsRegistry classDetailsRegistry) {
        if (StringHelper.isEmpty(name)) {
            name = Object.class.getName();
        } else if (!(Byte.TYPE.getName().equals(name) || Boolean.TYPE.getName().equals(name) || Short.TYPE.getName().equals(name) || Integer.TYPE.getName().equals(name) || Long.TYPE.getName().equals(name) || Double.TYPE.getName().equals(name) || Float.TYPE.getName().equals(name))) {
            name = Byte.class.getSimpleName().equalsIgnoreCase(name) ? Byte.class.getName() : (Boolean.class.getSimpleName().equalsIgnoreCase(name) ? Boolean.class.getName() : (Short.class.getSimpleName().equalsIgnoreCase(name) ? Short.class.getName() : (Integer.class.getSimpleName().equalsIgnoreCase(name) ? Integer.class.getName() : (Long.class.getSimpleName().equalsIgnoreCase(name) ? Long.class.getName() : (Double.class.getSimpleName().equalsIgnoreCase(name) ? Double.class.getName() : (Float.class.getSimpleName().equalsIgnoreCase(name) ? Float.class.getName() : (BigInteger.class.getSimpleName().equalsIgnoreCase(name) ? BigInteger.class.getName() : (BigDecimal.class.getSimpleName().equalsIgnoreCase(name) ? BigDecimal.class.getName() : (String.class.getSimpleName().equalsIgnoreCase(name) ? String.class.getName() : (Character.class.getSimpleName().equalsIgnoreCase(name) ? Character.class.getName() : (UUID.class.getSimpleName().equalsIgnoreCase(name) ? Character.class.getName() : StringHelper.qualifyConditionallyIfNot(packageName, name))))))))))));
        }
        return classDetailsRegistry.resolveClassDetails(name);
    }

    public static void applyBasicTypeComposition(JaxbBasicMapping jaxbBasicMapping, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        if (jaxbBasicMapping.getType() != null) {
            XmlAnnotationHelper.applyUserType(jaxbBasicMapping.getType(), memberDetails, xmlDocumentContext);
        } else if (jaxbBasicMapping.getJavaType() != null) {
            XmlAnnotationHelper.applyJavaTypeDescriptor(jaxbBasicMapping.getJavaType(), memberDetails, xmlDocumentContext);
        } else if (StringHelper.isNotEmpty(jaxbBasicMapping.getTarget())) {
            XmlAnnotationHelper.applyTargetClass(jaxbBasicMapping.getTarget(), memberDetails, xmlDocumentContext);
        }
        if (StringHelper.isNotEmpty(jaxbBasicMapping.getJdbcType())) {
            XmlAnnotationHelper.applyJdbcTypeDescriptor(jaxbBasicMapping.getJdbcType(), memberDetails, xmlDocumentContext);
        } else if (jaxbBasicMapping.getJdbcTypeCode() != null) {
            XmlAnnotationHelper.applyJdbcTypeCode(jaxbBasicMapping.getJdbcTypeCode(), memberDetails, xmlDocumentContext);
        } else if (StringHelper.isNotEmpty(jaxbBasicMapping.getJdbcTypeName())) {
            XmlAnnotationHelper.applyJdbcTypeCode(XmlAnnotationHelper.resolveJdbcTypeName(jaxbBasicMapping.getJdbcTypeName()), memberDetails, xmlDocumentContext);
        }
    }

    private static int resolveJdbcTypeName(String name) {
        try {
            Field matchingField = SqlTypes.class.getDeclaredField(name);
            return matchingField.getInt(null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ModelsException("Could not resolve <jdbc-type-name>" + name + "</jdbc-type-name>", (Throwable)e);
        }
    }

    public static void applyJavaTypeDescriptor(String descriptorClassName, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        JavaTypeAnnotation typeAnn = (JavaTypeAnnotation)memberDetails.applyAnnotationUsage(HibernateAnnotations.JAVA_TYPE, xmlDocumentContext.getModelBuildingContext());
        ClassDetails descriptorClass = xmlDocumentContext.getModelBuildingContext().getClassDetailsRegistry().resolveClassDetails(descriptorClassName);
        typeAnn.value(descriptorClass.toJavaClass());
    }

    private static void applyJdbcTypeDescriptor(String descriptorClassName, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        ClassDetails descriptorClassDetails = xmlDocumentContext.getModelBuildingContext().getClassDetailsRegistry().resolveClassDetails(descriptorClassName);
        JdbcTypeAnnotation jdbcTypeAnn = (JdbcTypeAnnotation)memberDetails.applyAnnotationUsage(HibernateAnnotations.JDBC_TYPE, xmlDocumentContext.getModelBuildingContext());
        jdbcTypeAnn.value(descriptorClassDetails.toJavaClass());
    }

    public static void applyJdbcTypeCode(Integer jdbcTypeCode, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        if (jdbcTypeCode == null) {
            return;
        }
        JdbcTypeCodeAnnotation typeCodeAnn = (JdbcTypeCodeAnnotation)memberDetails.applyAnnotationUsage(HibernateAnnotations.JDBC_TYPE_CODE, xmlDocumentContext.getModelBuildingContext());
        typeCodeAnn.value(jdbcTypeCode);
    }

    public static void applyFilters(List<JaxbHbmFilterImpl> jaxbFilters, MutableAnnotationTarget target, XmlDocumentContext xmlDocumentContext) {
        if (CollectionHelper.isEmpty(jaxbFilters)) {
            return;
        }
        FiltersAnnotation filters = (FiltersAnnotation)target.replaceAnnotationUsage(HibernateAnnotations.FILTER, HibernateAnnotations.FILTERS, xmlDocumentContext.getModelBuildingContext());
        Filter[] filterUsages = new FilterAnnotation[jaxbFilters.size()];
        filters.value(filterUsages);
        for (int i = 0; i < jaxbFilters.size(); ++i) {
            FilterAnnotation filterUsage = (FilterAnnotation)HibernateAnnotations.FILTER.createUsage(xmlDocumentContext.getModelBuildingContext());
            filterUsages[i] = filterUsage;
            filterUsage.apply(jaxbFilters.get(i), xmlDocumentContext);
        }
    }

    public static void applyJoinTableFilters(List<JaxbHbmFilterImpl> jaxbFilters, MutableAnnotationTarget target, XmlDocumentContext xmlDocumentContext) {
        if (CollectionHelper.isEmpty(jaxbFilters)) {
            return;
        }
        FilterJoinTablesAnnotation filters = (FilterJoinTablesAnnotation)target.replaceAnnotationUsage(HibernateAnnotations.FILTER_JOIN_TABLE, HibernateAnnotations.FILTER_JOIN_TABLES, xmlDocumentContext.getModelBuildingContext());
        FilterJoinTable[] filterUsages = new FilterJoinTableAnnotation[jaxbFilters.size()];
        filters.value(filterUsages);
        for (int i = 0; i < jaxbFilters.size(); ++i) {
            FilterJoinTableAnnotation filterUsage = (FilterJoinTableAnnotation)HibernateAnnotations.FILTER_JOIN_TABLE.createUsage(xmlDocumentContext.getModelBuildingContext());
            filterUsages[i] = filterUsage;
            filterUsage.apply(jaxbFilters.get(i), xmlDocumentContext);
        }
    }

    public static void applySqlRestriction(String sqlRestriction, MutableAnnotationTarget target, XmlDocumentContext xmlDocumentContext) {
        if (StringHelper.isEmpty(sqlRestriction)) {
            return;
        }
        SQLRestrictionAnnotation sqlRestrictionAnn = (SQLRestrictionAnnotation)target.applyAnnotationUsage(HibernateAnnotations.SQL_RESTRICTION, xmlDocumentContext.getModelBuildingContext());
        sqlRestrictionAnn.value(sqlRestriction);
    }

    public static void applySqlJoinTableRestriction(String sqlRestriction, MutableAnnotationTarget target, XmlDocumentContext xmlDocumentContext) {
        if (StringHelper.isEmpty(sqlRestriction)) {
            return;
        }
        SQLJoinTableRestrictionAnnotation sqlRestrictionAnn = (SQLJoinTableRestrictionAnnotation)target.applyAnnotationUsage(HibernateAnnotations.SQL_JOIN_TABLE_RESTRICTION, xmlDocumentContext.getModelBuildingContext());
        sqlRestrictionAnn.value(sqlRestriction);
    }

    public static void applyCustomSql(JaxbCustomSqlImpl jaxbCustomSql, MutableAnnotationTarget target, AnnotationDescriptor descriptor, XmlDocumentContext xmlDocumentContext) {
        if (jaxbCustomSql == null) {
            return;
        }
        CustomSqlDetails annotation = (CustomSqlDetails)target.applyAnnotationUsage(descriptor, xmlDocumentContext.getModelBuildingContext());
        XmlAnnotationHelper.applyCustomSql(jaxbCustomSql, annotation);
    }

    public static void applyCustomSql(JaxbCustomSqlImpl jaxbCustomSql, CustomSqlDetails annotation) {
        if (jaxbCustomSql == null) {
            return;
        }
        annotation.sql(jaxbCustomSql.getValue());
        annotation.callable(jaxbCustomSql.isCallable());
        if (StringHelper.isNotEmpty(jaxbCustomSql.getTable())) {
            annotation.table(jaxbCustomSql.getTable());
        }
        if (jaxbCustomSql.getResultCheck() != null) {
            annotation.check(XmlAnnotationHelper.interpretResultCheckStyle(jaxbCustomSql.getResultCheck()));
        }
    }

    private static ResultCheckStyle interpretResultCheckStyle(ExecuteUpdateResultCheckStyle style) {
        return switch (style) {
            default -> throw new IncompatibleClassChangeError();
            case ExecuteUpdateResultCheckStyle.NONE -> ResultCheckStyle.NONE;
            case ExecuteUpdateResultCheckStyle.COUNT -> ResultCheckStyle.COUNT;
            case ExecuteUpdateResultCheckStyle.PARAM -> ResultCheckStyle.PARAM;
        };
    }

    static void applyIdClass(JaxbIdClassImpl jaxbIdClass, MutableClassDetails target, XmlDocumentContext xmlDocumentContext) {
        if (jaxbIdClass == null || StringHelper.isEmpty(jaxbIdClass.getClazz())) {
            return;
        }
        IdClassJpaAnnotation idClassAnn = (IdClassJpaAnnotation)((Object)target.applyAnnotationUsage(JpaAnnotations.ID_CLASS, xmlDocumentContext.getModelBuildingContext()));
        ClassDetails idClassImpl = xmlDocumentContext.getModelBuildingContext().getClassDetailsRegistry().resolveClassDetails(jaxbIdClass.getClazz());
        idClassAnn.value(idClassImpl.toJavaClass());
    }

    public static void applyLifecycleCallbacks(JaxbEntityOrMappedSuperclass jaxbClass, MutableClassDetails classDetails, XmlDocumentContext xmlDocumentContext) {
        SourceModelBuildingContext modelBuildingContext = xmlDocumentContext.getModelBuildingContext();
        if (jaxbClass.getExcludeDefaultListeners() != null) {
            classDetails.applyAnnotationUsage(JpaAnnotations.EXCLUDE_DEFAULT_LISTENERS, modelBuildingContext);
        }
        if (jaxbClass.getExcludeSuperclassListeners() != null) {
            classDetails.applyAnnotationUsage(JpaAnnotations.EXCLUDE_SUPERCLASS_LISTENERS, modelBuildingContext);
        }
        XmlAnnotationHelper.applyLifecycleCallbacks(jaxbClass, JpaEventListenerStyle.CALLBACK, classDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyEntityListeners(jaxbClass.getEntityListenerContainer(), classDetails, xmlDocumentContext);
    }

    public static void applyEntityListeners(JaxbEntityListenerContainerImpl entityListenerContainer, MutableClassDetails classDetails, XmlDocumentContext xmlDocumentContext) {
        if (entityListenerContainer == null || entityListenerContainer.getEntityListeners().isEmpty()) {
            return;
        }
        EntityListenersJpaAnnotation listenersUsage = (EntityListenersJpaAnnotation)((Object)classDetails.replaceAnnotationUsage(JpaAnnotations.ENTITY_LISTENERS, xmlDocumentContext.getModelBuildingContext()));
        Class[] listeners = new Class[entityListenerContainer.getEntityListeners().size()];
        listenersUsage.value(listeners);
        for (int i = 0; i < entityListenerContainer.getEntityListeners().size(); ++i) {
            JaxbEntityListenerImpl jaxbEntityListener = entityListenerContainer.getEntityListeners().get(i);
            MutableClassDetails entityListenerClass = xmlDocumentContext.resolveJavaType(jaxbEntityListener.getClazz());
            XmlAnnotationHelper.applyLifecycleCallbacks(jaxbEntityListener, JpaEventListenerStyle.LISTENER, entityListenerClass, xmlDocumentContext);
            listeners[i] = entityListenerClass.toJavaClass();
        }
    }

    static void applyLifecycleCallbacks(JaxbLifecycleCallbackContainer lifecycleCallbackContainer, JpaEventListenerStyle callbackType, MutableClassDetails classDetails, XmlDocumentContext xmlDocumentContext) {
        XmlAnnotationHelper.applyLifecycleCallback(lifecycleCallbackContainer.getPrePersist(), callbackType, JpaAnnotations.PRE_PERSIST, classDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyLifecycleCallback(lifecycleCallbackContainer.getPostPersist(), callbackType, JpaAnnotations.POST_PERSIST, classDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyLifecycleCallback(lifecycleCallbackContainer.getPreRemove(), callbackType, JpaAnnotations.PRE_REMOVE, classDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyLifecycleCallback(lifecycleCallbackContainer.getPostRemove(), callbackType, JpaAnnotations.POST_REMOVE, classDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyLifecycleCallback(lifecycleCallbackContainer.getPreUpdate(), callbackType, JpaAnnotations.PRE_UPDATE, classDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyLifecycleCallback(lifecycleCallbackContainer.getPostUpdate(), callbackType, JpaAnnotations.POST_UPDATE, classDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyLifecycleCallback(lifecycleCallbackContainer.getPostLoad(), callbackType, JpaAnnotations.POST_LOAD, classDetails, xmlDocumentContext);
    }

    private static <A extends Annotation> void applyLifecycleCallback(JaxbLifecycleCallback lifecycleCallback, JpaEventListenerStyle callbackType, AnnotationDescriptor<A> annotationDescriptor, MutableClassDetails classDetails, XmlDocumentContext xmlDocumentContext) {
        if (lifecycleCallback != null) {
            MutableMemberDetails methodDetails = XmlAnnotationHelper.getCallbackMethodDetails(lifecycleCallback.getMethodName(), callbackType, (ClassDetails)classDetails);
            if (methodDetails == null) {
                throw new AnnotationException(String.format("Lifecycle callback method not found - %s (%s)", lifecycleCallback.getMethodName(), classDetails.getName()));
            }
            methodDetails.applyAnnotationUsage(annotationDescriptor, xmlDocumentContext.getModelBuildingContext());
        }
    }

    private static MutableMemberDetails getCallbackMethodDetails(String name, JpaEventListenerStyle callbackType, ClassDetails classDetails) {
        for (MethodDetails method : classDetails.getMethods()) {
            if (!method.getName().equals(name) || !JpaEventListener.matchesSignature(callbackType, method)) continue;
            return (MutableMemberDetails)method;
        }
        return null;
    }

    static void applyRowId(String rowId, MutableClassDetails target, XmlDocumentContext xmlDocumentContext) {
        if (rowId == null) {
            return;
        }
        RowIdAnnotation rowIdAnn = (RowIdAnnotation)target.applyAnnotationUsage(HibernateAnnotations.ROW_ID, xmlDocumentContext.getModelBuildingContext());
        if (StringHelper.isNotEmpty(rowId)) {
            rowIdAnn.value(rowId);
        }
    }

    private static String prefixIfNotAlready(String value, String prefix) {
        String previous;
        if (StringHelper.isNotEmpty(prefix) && !(previous = StringHelper.unqualify(value)).equalsIgnoreCase(prefix)) {
            return StringHelper.qualify(prefix, value);
        }
        return value;
    }

    static void applyDiscriminatorValue(String discriminatorValue, MutableClassDetails target, XmlDocumentContext xmlDocumentContext) {
        if (StringHelper.isEmpty(discriminatorValue)) {
            return;
        }
        DiscriminatorValueJpaAnnotation valueAnn = (DiscriminatorValueJpaAnnotation)((Object)target.applyAnnotationUsage(JpaAnnotations.DISCRIMINATOR_VALUE, xmlDocumentContext.getModelBuildingContext()));
        valueAnn.value(discriminatorValue);
    }

    static void applyDiscriminatorColumn(JaxbDiscriminatorColumnImpl jaxbDiscriminatorColumn, MutableClassDetails target, XmlDocumentContext xmlDocumentContext) {
        if (jaxbDiscriminatorColumn == null) {
            return;
        }
        DiscriminatorColumnJpaAnnotation discriminatorColumnAnn = (DiscriminatorColumnJpaAnnotation)((Object)target.applyAnnotationUsage(JpaAnnotations.DISCRIMINATOR_COLUMN, xmlDocumentContext.getModelBuildingContext()));
        discriminatorColumnAnn.apply(jaxbDiscriminatorColumn, xmlDocumentContext);
        if (jaxbDiscriminatorColumn.isForceSelection() || jaxbDiscriminatorColumn.isInsertable() == Boolean.FALSE) {
            DiscriminatorOptionsAnnotation optionsAnn = (DiscriminatorOptionsAnnotation)target.applyAnnotationUsage(HibernateAnnotations.DISCRIMINATOR_OPTIONS, xmlDocumentContext.getModelBuildingContext());
            optionsAnn.force(true);
            if (jaxbDiscriminatorColumn.isInsertable() != null) {
                optionsAnn.insert(jaxbDiscriminatorColumn.isInsertable());
            }
        }
    }

    public static void applyDiscriminatorFormula(@Nullable JaxbDiscriminatorFormulaImpl jaxbDiscriminatorFormula, MutableClassDetails target, XmlDocumentContext xmlDocumentContext) {
        if (jaxbDiscriminatorFormula == null) {
            return;
        }
        if (StringHelper.isEmpty(jaxbDiscriminatorFormula.getFragment())) {
            return;
        }
        DiscriminatorFormulaAnnotation discriminatorFormulaAnn = (DiscriminatorFormulaAnnotation)target.applyAnnotationUsage(HibernateAnnotations.DISCRIMINATOR_FORMULA, xmlDocumentContext.getModelBuildingContext());
        discriminatorFormulaAnn.value(jaxbDiscriminatorFormula.getFragment());
        if (jaxbDiscriminatorFormula.getDiscriminatorType() != null) {
            discriminatorFormulaAnn.discriminatorType(jaxbDiscriminatorFormula.getDiscriminatorType());
        }
        if (jaxbDiscriminatorFormula.isForceSelection()) {
            DiscriminatorOptionsAnnotation optionsAnn = (DiscriminatorOptionsAnnotation)target.applyAnnotationUsage(HibernateAnnotations.DISCRIMINATOR_OPTIONS, xmlDocumentContext.getModelBuildingContext());
            optionsAnn.force(true);
        }
    }

    public static String determineTargetName(String explicitName, XmlDocumentContext xmlDocumentContext) {
        String qualifiedName = StringHelper.qualifyConditionallyIfNot(xmlDocumentContext.getXmlDocument().getDefaults().getPackage(), explicitName);
        ClassDetails classDetails = xmlDocumentContext.getModelBuildingContext().getClassDetailsRegistry().resolveClassDetails(qualifiedName);
        if (classDetails != null) {
            return classDetails.getName();
        }
        return explicitName;
    }

    public static void applySchema(JaxbSchemaAware jaxbNode, DatabaseObjectDetails annotationUsage, XmlDocumentContext xmlDocumentContext) {
        if (jaxbNode == null) {
            return;
        }
        if (StringHelper.isNotEmpty(jaxbNode.getSchema())) {
            annotationUsage.schema(jaxbNode.getSchema());
        } else if (StringHelper.isNotEmpty(XmlAnnotationHelper.documentSchema(xmlDocumentContext))) {
            annotationUsage.schema(XmlAnnotationHelper.documentSchema(xmlDocumentContext));
        }
    }

    private static String documentSchema(XmlDocumentContext xmlDocumentContext) {
        return xmlDocumentContext.getXmlDocument().getDefaults().getSchema();
    }

    public static void applyCatalog(JaxbSchemaAware jaxbNode, DatabaseObjectDetails annotationUsage, XmlDocumentContext xmlDocumentContext) {
        if (jaxbNode == null) {
            return;
        }
        if (StringHelper.isNotEmpty(jaxbNode.getCatalog())) {
            annotationUsage.catalog(jaxbNode.getCatalog());
        } else if (StringHelper.isNotEmpty(XmlAnnotationHelper.documentCatalog(xmlDocumentContext))) {
            annotationUsage.catalog(XmlAnnotationHelper.documentCatalog(xmlDocumentContext));
        }
    }

    private static String documentCatalog(XmlDocumentContext xmlDocumentContext) {
        return xmlDocumentContext.getXmlDocument().getDefaults().getCatalog();
    }

    public static void applyNotFound(JaxbNotFoundCapable jaxbNode, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        assert (jaxbNode != null);
        NotFoundAction notFoundAction = jaxbNode.getNotFound();
        if (notFoundAction == null || notFoundAction == NotFoundAction.EXCEPTION) {
            return;
        }
        NotFoundAnnotation notFoundAnn = (NotFoundAnnotation)memberDetails.applyAnnotationUsage(HibernateAnnotations.NOT_FOUND, xmlDocumentContext.getModelBuildingContext());
        notFoundAnn.action(notFoundAction);
    }

    public static void applySecondaryTables(List<JaxbSecondaryTableImpl> jaxbSecondaryTables, MutableAnnotationTarget target, XmlDocumentContext xmlDocumentContext) {
        if (jaxbSecondaryTables == null || jaxbSecondaryTables.isEmpty()) {
            return;
        }
        SecondaryTablesJpaAnnotation tablesUsage = (SecondaryTablesJpaAnnotation)target.replaceAnnotationUsage(JpaAnnotations.SECONDARY_TABLE, JpaAnnotations.SECONDARY_TABLES, xmlDocumentContext.getModelBuildingContext());
        SecondaryTable[] tableUsages = new SecondaryTable[jaxbSecondaryTables.size()];
        tablesUsage.value(tableUsages);
        SecondaryRowsAnnotation rowsUsage = (SecondaryRowsAnnotation)target.replaceAnnotationUsage(HibernateAnnotations.SECONDARY_ROW, HibernateAnnotations.SECONDARY_ROWS, xmlDocumentContext.getModelBuildingContext());
        SecondaryRow[] rowUsages = new SecondaryRow[jaxbSecondaryTables.size()];
        rowsUsage.value(rowUsages);
        for (int i = 0; i < jaxbSecondaryTables.size(); ++i) {
            SecondaryTableJpaAnnotation tableUsage = (SecondaryTableJpaAnnotation)JpaAnnotations.SECONDARY_TABLE.createUsage(xmlDocumentContext.getModelBuildingContext());
            tableUsages[i] = tableUsage;
            JaxbSecondaryTableImpl jaxbSecondaryTable = jaxbSecondaryTables.get(i);
            tableUsage.apply(jaxbSecondaryTable, xmlDocumentContext);
            SecondaryRowAnnotation rowUsage = (SecondaryRowAnnotation)HibernateAnnotations.SECONDARY_ROW.createUsage(xmlDocumentContext.getModelBuildingContext());
            rowUsages[i] = rowUsage;
            rowUsage.table(tableUsage.name());
            rowUsage.optional(jaxbSecondaryTable.isOptional() == Boolean.TRUE);
            rowUsage.owned(jaxbSecondaryTable.isOwned() == Boolean.TRUE);
        }
    }

    public static CheckConstraint[] collectCheckConstraints(List<JaxbCheckConstraintImpl> jaxbChecks, XmlDocumentContext xmlDocumentContext) {
        if (CollectionHelper.isEmpty(jaxbChecks)) {
            return NO_CHECK_CONSTRAINTS;
        }
        CheckConstraint[] checks = new CheckConstraint[jaxbChecks.size()];
        for (int i = 0; i < jaxbChecks.size(); ++i) {
            JaxbCheckConstraintImpl jaxbCheck = jaxbChecks.get(i);
            CheckConstraintJpaAnnotation annotation = (CheckConstraintJpaAnnotation)((Object)JpaAnnotations.CHECK_CONSTRAINT.createUsage(xmlDocumentContext.getModelBuildingContext()));
            checks[i] = annotation;
            annotation.constraint(jaxbCheck.getConstraint());
            XmlAnnotationHelper.applyOptionalString(jaxbCheck.getName(), annotation::name);
            XmlAnnotationHelper.applyOptionalString(jaxbCheck.getOptions(), annotation::options);
        }
        return checks;
    }

    public static UniqueConstraint[] collectUniqueConstraints(List<JaxbUniqueConstraintImpl> jaxbUniqueConstraints, XmlDocumentContext xmlDocumentContext) {
        return XmlAnnotationHelper.collectUniqueConstraints(jaxbUniqueConstraints, xmlDocumentContext.getModelBuildingContext());
    }

    public static UniqueConstraint[] collectUniqueConstraints(List<JaxbUniqueConstraintImpl> jaxbUniqueConstraints, SourceModelBuildingContext modelContext) {
        if (CollectionHelper.isEmpty(jaxbUniqueConstraints)) {
            return NO_UNIQUE_CONSTRAINTS;
        }
        UniqueConstraint[] constraints = new UniqueConstraint[jaxbUniqueConstraints.size()];
        for (int i = 0; i < jaxbUniqueConstraints.size(); ++i) {
            UniqueConstraintJpaAnnotation uniqueConstraint = (UniqueConstraintJpaAnnotation)((Object)JpaAnnotations.UNIQUE_CONSTRAINT.createUsage(modelContext));
            constraints[i] = uniqueConstraint;
            JaxbUniqueConstraintImpl jaxbUniqueConstraint = jaxbUniqueConstraints.get(i);
            uniqueConstraint.columnNames((String[])jaxbUniqueConstraint.getColumnName().toArray(String[]::new));
            XmlAnnotationHelper.applyOptionalString(jaxbUniqueConstraint.getName(), uniqueConstraint::name);
            XmlAnnotationHelper.applyOptionalString(jaxbUniqueConstraint.getOptions(), uniqueConstraint::options);
        }
        return constraints;
    }

    public static Index[] collectIndexes(List<JaxbIndexImpl> jaxbIndexes, XmlDocumentContext xmlDocumentContext) {
        return XmlAnnotationHelper.collectIndexes(jaxbIndexes, xmlDocumentContext.getModelBuildingContext());
    }

    public static Index[] collectIndexes(List<JaxbIndexImpl> jaxbIndexes, SourceModelBuildingContext sourceModelContext) {
        if (CollectionHelper.isEmpty(jaxbIndexes)) {
            return NO_INDICES;
        }
        Index[] indexes = new Index[jaxbIndexes.size()];
        for (int i = 0; i < jaxbIndexes.size(); ++i) {
            IndexJpaAnnotation index = (IndexJpaAnnotation)((Object)JpaAnnotations.INDEX.createUsage(sourceModelContext));
            indexes[i] = index;
            JaxbIndexImpl jaxbIndex = jaxbIndexes.get(i);
            index.columnList(jaxbIndex.getColumnList());
            XmlAnnotationHelper.applyOptionalString(jaxbIndex.getName(), index::name);
            if (jaxbIndex.isUnique() == null) continue;
            index.unique(jaxbIndex.isUnique());
        }
        return indexes;
    }

    public static void applyPrimaryKeyJoinColumns(JaxbEntityImpl jaxbEntity, MutableClassDetails classDetails, XmlDocumentContext xmlDocumentContext) {
        List<JaxbPrimaryKeyJoinColumnImpl> jaxbColumns = jaxbEntity.getPrimaryKeyJoinColumns();
        if (CollectionHelper.isEmpty(jaxbColumns)) {
            return;
        }
        SourceModelBuildingContext modelBuildingContext = xmlDocumentContext.getModelBuildingContext();
        PrimaryKeyJoinColumnsJpaAnnotation columnsAnn = (PrimaryKeyJoinColumnsJpaAnnotation)classDetails.replaceAnnotationUsage(JpaAnnotations.PRIMARY_KEY_JOIN_COLUMN, JpaAnnotations.PRIMARY_KEY_JOIN_COLUMNS, modelBuildingContext);
        PrimaryKeyJoinColumn[] columns = new PrimaryKeyJoinColumn[jaxbColumns.size()];
        for (int i = 0; i < jaxbColumns.size(); ++i) {
            PrimaryKeyJoinColumnJpaAnnotation column = (PrimaryKeyJoinColumnJpaAnnotation)((Object)JpaAnnotations.PRIMARY_KEY_JOIN_COLUMN.createUsage(modelBuildingContext));
            JaxbPrimaryKeyJoinColumnImpl jaxbColumn = jaxbColumns.get(i);
            column.apply(jaxbColumn, xmlDocumentContext);
            columns[i] = column;
        }
        columnsAnn.value(columns);
    }

    public static void applyCollectionClassification(LimitedCollectionClassification classification, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        CollectionClassificationXmlAnnotation collectionClassification = (CollectionClassificationXmlAnnotation)memberDetails.applyAnnotationUsage(HibernateAnnotations.COLLECTION_CLASSIFICATION, xmlDocumentContext.getModelBuildingContext());
        collectionClassification.value(classification);
    }
}

