/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.xml.internal.attr;

import jakarta.persistence.AccessType;
import org.hibernate.boot.jaxb.mapping.spi.JaxbOneToManyImpl;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.XmlAnnotations;
import org.hibernate.boot.models.annotations.internal.OneToManyJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.TargetXmlAnnotation;
import org.hibernate.boot.models.xml.internal.XmlAnnotationHelper;
import org.hibernate.boot.models.xml.internal.XmlProcessingHelper;
import org.hibernate.boot.models.xml.internal.attr.CommonAttributeProcessing;
import org.hibernate.boot.models.xml.internal.attr.CommonPluralAttributeProcessing;
import org.hibernate.boot.models.xml.internal.db.JoinColumnProcessing;
import org.hibernate.boot.models.xml.internal.db.TableProcessing;
import org.hibernate.boot.models.xml.spi.XmlDocumentContext;
import org.hibernate.internal.util.NullnessHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.models.spi.MutableAnnotationTarget;
import org.hibernate.models.spi.MutableClassDetails;
import org.hibernate.models.spi.MutableMemberDetails;

public class OneToManyAttributeProcessing {
    public static MutableMemberDetails processOneToManyAttribute(JaxbOneToManyImpl jaxbOneToMany, MutableClassDetails declarer, AccessType classAccessType, XmlDocumentContext xmlDocumentContext) {
        AccessType accessType = NullnessHelper.coalesce(jaxbOneToMany.getAccess(), classAccessType);
        MutableMemberDetails memberDetails = XmlProcessingHelper.getAttributeMember(jaxbOneToMany.getName(), accessType, declarer);
        OneToManyJpaAnnotation oneToManyAnn = OneToManyAttributeProcessing.applyOneToMany(jaxbOneToMany, memberDetails, accessType, xmlDocumentContext);
        OneToManyAttributeProcessing.applyTargetEntity(jaxbOneToMany, (MutableAnnotationTarget)memberDetails, xmlDocumentContext);
        CommonPluralAttributeProcessing.applyPluralAttributeStructure(jaxbOneToMany, memberDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyCascading(jaxbOneToMany.getCascade(), memberDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyAttributeOverrides(jaxbOneToMany.getMapKeyAttributeOverrides(), (MutableAnnotationTarget)memberDetails, "key", xmlDocumentContext);
        TableProcessing.transformJoinTable(jaxbOneToMany.getJoinTable(), (MutableAnnotationTarget)memberDetails, xmlDocumentContext);
        XmlAnnotationHelper.applySqlJoinTableRestriction(jaxbOneToMany.getSqlJoinTableRestriction(), (MutableAnnotationTarget)memberDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyJoinTableFilters(jaxbOneToMany.getJoinTableFilters(), (MutableAnnotationTarget)memberDetails, xmlDocumentContext);
        JoinColumnProcessing.applyJoinColumns(jaxbOneToMany.getJoinColumn(), memberDetails, xmlDocumentContext);
        CommonAttributeProcessing.applyOnDelete(jaxbOneToMany.getOnDelete(), memberDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyNotFound(jaxbOneToMany, memberDetails, xmlDocumentContext);
        return memberDetails;
    }

    private static OneToManyJpaAnnotation applyOneToMany(JaxbOneToManyImpl jaxbOneToMany, MutableMemberDetails memberDetails, AccessType accessType, XmlDocumentContext xmlDocumentContext) {
        OneToManyJpaAnnotation oneToManyAnn = (OneToManyJpaAnnotation)memberDetails.applyAnnotationUsage(JpaAnnotations.ONE_TO_MANY, xmlDocumentContext.getModelBuildingContext());
        if (jaxbOneToMany != null) {
            CommonAttributeProcessing.applyAccess(accessType, memberDetails, xmlDocumentContext);
            CommonAttributeProcessing.applyAttributeAccessor(jaxbOneToMany, memberDetails, xmlDocumentContext);
            CommonAttributeProcessing.applyFetching(jaxbOneToMany, memberDetails, oneToManyAnn, xmlDocumentContext);
            CommonAttributeProcessing.applyOptimisticLock(jaxbOneToMany, memberDetails, xmlDocumentContext);
            if (StringHelper.isNotEmpty(jaxbOneToMany.getMappedBy())) {
                oneToManyAnn.mappedBy(jaxbOneToMany.getMappedBy());
            }
            if (jaxbOneToMany.isOrphanRemoval() != null) {
                oneToManyAnn.orphanRemoval(jaxbOneToMany.isOrphanRemoval());
            }
        }
        return oneToManyAnn;
    }

    private static void applyTargetEntity(JaxbOneToManyImpl jaxbOneToMany, MutableAnnotationTarget target, XmlDocumentContext xmlDocumentContext) {
        String targetEntityName = jaxbOneToMany.getTargetEntity();
        if (StringHelper.isEmpty(targetEntityName)) {
            return;
        }
        TargetXmlAnnotation annotation = (TargetXmlAnnotation)target.applyAnnotationUsage(XmlAnnotations.TARGET, xmlDocumentContext.getModelBuildingContext());
        annotation.value(xmlDocumentContext.resolveClassName(targetEntityName));
    }
}

