/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.xml.internal.db;

import jakarta.persistence.JoinColumn;
import jakarta.persistence.MapKeyJoinColumn;
import jakarta.persistence.PrimaryKeyJoinColumn;
import java.util.List;
import org.hibernate.annotations.JoinColumnOrFormula;
import org.hibernate.boot.jaxb.mapping.spi.JaxbJoinColumnImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbMapKeyJoinColumnImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbPrimaryKeyJoinColumnImpl;
import org.hibernate.boot.models.HibernateAnnotations;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.annotations.internal.JoinColumnJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.JoinColumnOrFormulaAnnotation;
import org.hibernate.boot.models.annotations.internal.JoinColumnsJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.JoinColumnsOrFormulasAnnotation;
import org.hibernate.boot.models.annotations.internal.JoinFormulaAnnotation;
import org.hibernate.boot.models.annotations.internal.MapKeyJoinColumnJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.MapKeyJoinColumnsJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.PrimaryKeyJoinColumnJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.PrimaryKeyJoinColumnsJpaAnnotation;
import org.hibernate.boot.models.xml.spi.XmlDocumentContext;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.models.spi.MutableMemberDetails;

public class JoinColumnProcessing {
    private static final JoinColumn[] NO_JOIN_COLUMNS = new JoinColumn[0];
    private static final PrimaryKeyJoinColumn[] NO_PRIMARY_KEY_JOIN_COLUMNS = new PrimaryKeyJoinColumn[0];
    private static final MapKeyJoinColumn[] NO_KEY_JOIN_COLUMNS = new MapKeyJoinColumn[0];

    public static void applyJoinColumns(List<JaxbJoinColumnImpl> jaxbJoinColumns, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        if (CollectionHelper.isEmpty(jaxbJoinColumns)) {
            return;
        }
        JoinColumnsJpaAnnotation columnsAnn = (JoinColumnsJpaAnnotation)memberDetails.replaceAnnotationUsage(JpaAnnotations.JOIN_COLUMN, JpaAnnotations.JOIN_COLUMNS, xmlDocumentContext.getModelBuildingContext());
        columnsAnn.value(JoinColumnProcessing.transformJoinColumnList(jaxbJoinColumns, xmlDocumentContext));
    }

    public static JoinColumn[] transformJoinColumnList(List<JaxbJoinColumnImpl> jaxbJoinColumns, XmlDocumentContext xmlDocumentContext) {
        if (CollectionHelper.isEmpty(jaxbJoinColumns)) {
            return NO_JOIN_COLUMNS;
        }
        JoinColumn[] joinColumns = new JoinColumn[jaxbJoinColumns.size()];
        for (int i = 0; i < jaxbJoinColumns.size(); ++i) {
            JoinColumnJpaAnnotation joinColumn = (JoinColumnJpaAnnotation)((Object)JpaAnnotations.JOIN_COLUMN.createUsage(xmlDocumentContext.getModelBuildingContext()));
            joinColumns[i] = joinColumn;
            joinColumn.apply(jaxbJoinColumns.get(i), xmlDocumentContext);
        }
        return joinColumns;
    }

    public static void applyJoinColumnsOrFormula(List<JaxbJoinColumnImpl> jaxbJoinColumns, List<String> jaxbJoinFormulas, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        if (CollectionHelper.isEmpty(jaxbJoinFormulas)) {
            JoinColumnProcessing.applyJoinColumns(jaxbJoinColumns, memberDetails, xmlDocumentContext);
        } else {
            int i;
            JoinColumnsOrFormulasAnnotation joinColumnsOrFormulasUsage = (JoinColumnsOrFormulasAnnotation)memberDetails.replaceAnnotationUsage(HibernateAnnotations.JOIN_COLUMN_OR_FORMULA, HibernateAnnotations.JOIN_COLUMNS_OR_FORMULAS, xmlDocumentContext.getModelBuildingContext());
            JoinColumn[] joinColumns = JoinColumnProcessing.transformJoinColumnList(jaxbJoinColumns, xmlDocumentContext);
            JoinColumnOrFormula[] values = new JoinColumnOrFormula[jaxbJoinColumns.size() + jaxbJoinFormulas.size()];
            joinColumnsOrFormulasUsage.value(values);
            for (i = 0; i < joinColumns.length; ++i) {
                JoinColumnOrFormulaAnnotation joinColumnOrFormula = (JoinColumnOrFormulaAnnotation)HibernateAnnotations.JOIN_COLUMN_OR_FORMULA.createUsage(xmlDocumentContext.getModelBuildingContext());
                joinColumnOrFormula.column(joinColumns[i]);
            }
            for (i = 0; i < jaxbJoinFormulas.size(); ++i) {
                JoinFormulaAnnotation joinFormula = (JoinFormulaAnnotation)HibernateAnnotations.JOIN_FORMULA.createUsage(xmlDocumentContext.getModelBuildingContext());
                joinFormula.value(jaxbJoinFormulas.get(i));
                JoinColumnOrFormulaAnnotation joinColumnOrFormula = (JoinColumnOrFormulaAnnotation)HibernateAnnotations.JOIN_COLUMN_OR_FORMULA.createUsage(xmlDocumentContext.getModelBuildingContext());
                joinColumnOrFormula.formula(joinFormula);
                values[joinColumns.length + i] = joinColumnOrFormula;
            }
        }
    }

    public static void applyPrimaryKeyJoinColumns(List<JaxbPrimaryKeyJoinColumnImpl> jaxbJoinColumns, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        if (CollectionHelper.isEmpty(jaxbJoinColumns)) {
            return;
        }
        PrimaryKeyJoinColumnsJpaAnnotation columnsUsage = (PrimaryKeyJoinColumnsJpaAnnotation)memberDetails.replaceAnnotationUsage(JpaAnnotations.PRIMARY_KEY_JOIN_COLUMN, JpaAnnotations.PRIMARY_KEY_JOIN_COLUMNS, xmlDocumentContext.getModelBuildingContext());
        columnsUsage.value(JoinColumnProcessing.transformPrimaryKeyJoinColumns(jaxbJoinColumns, xmlDocumentContext));
    }

    public static PrimaryKeyJoinColumn[] transformPrimaryKeyJoinColumns(List<JaxbPrimaryKeyJoinColumnImpl> jaxbJoinColumns, XmlDocumentContext xmlDocumentContext) {
        if (CollectionHelper.isEmpty(jaxbJoinColumns)) {
            return NO_PRIMARY_KEY_JOIN_COLUMNS;
        }
        PrimaryKeyJoinColumn[] result = new PrimaryKeyJoinColumn[jaxbJoinColumns.size()];
        for (int i = 0; i < jaxbJoinColumns.size(); ++i) {
            PrimaryKeyJoinColumnJpaAnnotation joinColumn = (PrimaryKeyJoinColumnJpaAnnotation)((Object)JpaAnnotations.PRIMARY_KEY_JOIN_COLUMN.createUsage(xmlDocumentContext.getModelBuildingContext()));
            result[i] = joinColumn;
            joinColumn.apply(jaxbJoinColumns.get(i), xmlDocumentContext);
        }
        return result;
    }

    public static void applyMapKeyJoinColumns(List<JaxbMapKeyJoinColumnImpl> jaxbJoinColumns, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        if (CollectionHelper.isEmpty(jaxbJoinColumns)) {
            return;
        }
        MapKeyJoinColumnsJpaAnnotation joinColumnsUsage = (MapKeyJoinColumnsJpaAnnotation)memberDetails.replaceAnnotationUsage(JpaAnnotations.MAP_KEY_JOIN_COLUMN, JpaAnnotations.MAP_KEY_JOIN_COLUMNS, xmlDocumentContext.getModelBuildingContext());
        joinColumnsUsage.value(JoinColumnProcessing.transformMapKeyJoinColumns(jaxbJoinColumns, xmlDocumentContext));
    }

    private static MapKeyJoinColumn[] transformMapKeyJoinColumns(List<JaxbMapKeyJoinColumnImpl> jaxbJoinColumns, XmlDocumentContext xmlDocumentContext) {
        if (CollectionHelper.isEmpty(jaxbJoinColumns)) {
            return NO_KEY_JOIN_COLUMNS;
        }
        MapKeyJoinColumn[] joinColumns = new MapKeyJoinColumn[jaxbJoinColumns.size()];
        for (int i = 0; i < jaxbJoinColumns.size(); ++i) {
            MapKeyJoinColumnJpaAnnotation annotation = (MapKeyJoinColumnJpaAnnotation)((Object)JpaAnnotations.MAP_KEY_JOIN_COLUMN.createUsage(xmlDocumentContext.getModelBuildingContext()));
            joinColumns[i] = annotation;
            annotation.apply(jaxbJoinColumns.get(i), xmlDocumentContext);
        }
        return joinColumns;
    }
}

