/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.internal;

import java.util.function.Supplier;
import org.hibernate.MappingException;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.IdentifierValue;
import org.hibernate.engine.spi.SharedSessionDelegatorBaseImpl;
import org.hibernate.engine.spi.VersionValue;
import org.hibernate.mapping.KeyValue;
import org.hibernate.property.access.spi.Getter;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.VersionJavaType;
import org.hibernate.type.descriptor.java.spi.PrimitiveJavaType;

public class UnsavedValueFactory {
    public static IdentifierValue getUnsavedIdentifierValue(KeyValue bootIdMapping, JavaType<?> idJtd, Getter getter, Supplier<?> templateInstanceAccess) {
        String unsavedValue = bootIdMapping.getNullValue();
        if (unsavedValue == null) {
            if (getter != null && templateInstanceAccess != null) {
                Object templateInstance = templateInstanceAccess.get();
                Object defaultValue = getter.get(templateInstance);
                return new IdentifierValue(defaultValue);
            }
            if (idJtd instanceof PrimitiveJavaType) {
                return new IdentifierValue(((PrimitiveJavaType)idJtd).getDefaultValue());
            }
            return IdentifierValue.NULL;
        }
        switch (unsavedValue) {
            case "null": {
                return IdentifierValue.NULL;
            }
            case "undefined": {
                return IdentifierValue.UNDEFINED;
            }
            case "none": {
                return IdentifierValue.NONE;
            }
            case "any": {
                return IdentifierValue.ANY;
            }
        }
        return new IdentifierValue(idJtd.fromString(unsavedValue));
    }

    public static <T> VersionValue getUnsavedVersionValue(KeyValue bootVersionMapping, VersionJavaType<T> jtd, Long length, Integer precision, Integer scale, Getter getter, Supplier<?> templateInstanceAccess) {
        String unsavedValue = bootVersionMapping.getNullValue();
        if (unsavedValue == null) {
            if (getter != null && templateInstanceAccess != null) {
                Object templateInstance = templateInstanceAccess.get();
                Object defaultValue = getter.get(templateInstance);
                T seedValue = jtd.seed(length, precision, scale, UnsavedValueFactory.mockSession(bootVersionMapping.getBuildingContext()));
                return jtd.areEqual(seedValue, defaultValue) ? VersionValue.UNDEFINED : new VersionValue(defaultValue);
            }
            return VersionValue.UNDEFINED;
        }
        switch (unsavedValue) {
            case "undefined": {
                return VersionValue.UNDEFINED;
            }
            case "null": {
                return VersionValue.NULL;
            }
            case "negative": {
                return VersionValue.NEGATIVE;
            }
        }
        throw new MappingException("Could not parse version unsaved-value: " + unsavedValue);
    }

    private static SharedSessionDelegatorBaseImpl mockSession(final MetadataBuildingContext context) {
        return new SharedSessionDelegatorBaseImpl(null){

            @Override
            public JdbcServices getJdbcServices() {
                return context.getBootstrapContext().getServiceRegistry().requireService(JdbcServices.class);
            }
        };
    }

    private UnsavedValueFactory() {
    }
}

