/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.spi;

import jakarta.persistence.CacheRetrieveMode;
import jakarta.persistence.CacheStoreMode;
import jakarta.persistence.EntityGraph;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.FindOption;
import jakarta.persistence.FlushModeType;
import jakarta.persistence.LockModeType;
import jakarta.persistence.LockOption;
import jakarta.persistence.RefreshOption;
import jakarta.persistence.TypedQueryReference;
import jakarta.persistence.criteria.CriteriaDelete;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.CriteriaSelect;
import jakarta.persistence.criteria.CriteriaUpdate;
import jakarta.persistence.metamodel.Metamodel;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.CacheMode;
import org.hibernate.Filter;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.IdentifierLoadAccess;
import org.hibernate.Interceptor;
import org.hibernate.LobHelper;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.MultiIdentifierLoadAccess;
import org.hibernate.NaturalIdLoadAccess;
import org.hibernate.NaturalIdMultiLoadAccess;
import org.hibernate.ReplicationMode;
import org.hibernate.Session;
import org.hibernate.SessionEventListener;
import org.hibernate.SharedSessionBuilder;
import org.hibernate.SimpleNaturalIdLoadAccess;
import org.hibernate.Transaction;
import org.hibernate.UnknownProfileException;
import org.hibernate.cache.spi.CacheTransactionSynchronization;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.jdbc.LobCreationContext;
import org.hibernate.engine.jdbc.LobCreator;
import org.hibernate.engine.jdbc.connections.spi.JdbcConnectionAccess;
import org.hibernate.engine.jdbc.spi.JdbcCoordinator;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.ActionQueue;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.ExceptionConverter;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionEventListenerManager;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.event.spi.DeleteContext;
import org.hibernate.event.spi.EventManager;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.MergeContext;
import org.hibernate.event.spi.PersistContext;
import org.hibernate.event.spi.RefreshContext;
import org.hibernate.graph.RootGraph;
import org.hibernate.graph.spi.RootGraphImplementor;
import org.hibernate.jdbc.ReturningWork;
import org.hibernate.jdbc.Work;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.procedure.ProcedureCall;
import org.hibernate.query.MutationQuery;
import org.hibernate.query.SelectionQuery;
import org.hibernate.query.criteria.HibernateCriteriaBuilder;
import org.hibernate.query.criteria.JpaCriteriaInsert;
import org.hibernate.query.criteria.JpaCriteriaInsertSelect;
import org.hibernate.query.spi.QueryImplementor;
import org.hibernate.query.spi.QueryProducerImplementor;
import org.hibernate.query.sql.spi.NativeQueryImplementor;
import org.hibernate.resource.jdbc.spi.JdbcSessionContext;
import org.hibernate.resource.transaction.spi.TransactionCoordinator;
import org.hibernate.stat.SessionStatistics;

public class SessionDelegatorBaseImpl
implements SessionImplementor {
    protected final @UnknownKeyFor @NonNull @Initialized SessionImplementor delegate;

    public SessionDelegatorBaseImpl(@UnknownKeyFor @NonNull @Initialized SessionImplementor delegate) {
        this.delegate = delegate;
    }

    protected @UnknownKeyFor @NonNull @Initialized SessionImplementor delegate() {
        return this.delegate;
    }

    @Override
    public <T> T execute(@UnknownKeyFor @NonNull @Initialized LobCreationContext.Callback<T> callback) {
        return (T)this.delegate.execute(callback);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getTenantIdentifier() {
        return this.delegate.getTenantIdentifier();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Object getTenantIdentifierValue() {
        return this.delegate.getTenantIdentifierValue();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized UUID getSessionIdentifier() {
        return this.delegate.getSessionIdentifier();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized JdbcConnectionAccess getJdbcConnectionAccess() {
        return this.delegate.getJdbcConnectionAccess();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized EntityKey generateEntityKey(@UnknownKeyFor @NonNull @Initialized Object id, @UnknownKeyFor @NonNull @Initialized EntityPersister persister) {
        return this.delegate.generateEntityKey(id, persister);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Interceptor getInterceptor() {
        return this.delegate.getInterceptor();
    }

    @Override
    public void setAutoClear(@UnknownKeyFor @NonNull @Initialized boolean enabled) {
        this.delegate.setAutoClear(enabled);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean isTransactionInProgress() {
        return this.delegate.isTransactionInProgress();
    }

    @Override
    public void checkTransactionNeededForUpdateOperation(@UnknownKeyFor @NonNull @Initialized String exceptionMessage) {
        this.delegate.checkTransactionNeededForUpdateOperation(exceptionMessage);
    }

    @Override
    public void initializeCollection(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PersistentCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> collection, @UnknownKeyFor @NonNull @Initialized boolean writing) throws @UnknownKeyFor @NonNull @Initialized HibernateException {
        this.delegate.initializeCollection(collection, writing);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Object internalLoad(@UnknownKeyFor @NonNull @Initialized String entityName, @UnknownKeyFor @NonNull @Initialized Object id, @UnknownKeyFor @NonNull @Initialized boolean eager, @UnknownKeyFor @NonNull @Initialized boolean nullable) throws @UnknownKeyFor @NonNull @Initialized HibernateException {
        return this.delegate.internalLoad(entityName, id, eager, nullable);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Object immediateLoad(@UnknownKeyFor @NonNull @Initialized String entityName, @UnknownKeyFor @NonNull @Initialized Object id) throws @UnknownKeyFor @NonNull @Initialized HibernateException {
        return this.delegate.immediateLoad(entityName, id);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized SessionFactoryImplementor getFactory() {
        return this.delegate.getFactory();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized EntityPersister getEntityPersister(@Nullable @UnknownKeyFor @Initialized String entityName, @UnknownKeyFor @NonNull @Initialized Object object) throws @UnknownKeyFor @NonNull @Initialized HibernateException {
        return this.delegate.getEntityPersister(entityName, object);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Object getEntityUsingInterceptor(@UnknownKeyFor @NonNull @Initialized EntityKey key) throws @UnknownKeyFor @NonNull @Initialized HibernateException {
        return this.delegate.getEntityUsingInterceptor(key);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Object getContextEntityIdentifier(@UnknownKeyFor @NonNull @Initialized Object object) {
        return this.delegate.getContextEntityIdentifier(object);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String bestGuessEntityName(@UnknownKeyFor @NonNull @Initialized Object object) {
        return this.delegate.bestGuessEntityName(object);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String guessEntityName(@UnknownKeyFor @NonNull @Initialized Object entity) throws @UnknownKeyFor @NonNull @Initialized HibernateException {
        return this.delegate.guessEntityName(entity);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Object instantiate(@UnknownKeyFor @NonNull @Initialized String entityName, @UnknownKeyFor @NonNull @Initialized Object id) throws @UnknownKeyFor @NonNull @Initialized HibernateException {
        return this.delegate.instantiate(entityName, id);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized PersistenceContext getPersistenceContext() {
        return this.delegate.getPersistenceContext();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized CacheMode getCacheMode() {
        return this.delegate.getCacheMode();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized CacheRetrieveMode getCacheRetrieveMode() {
        return this.delegate.getCacheRetrieveMode();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized CacheStoreMode getCacheStoreMode() {
        return this.delegate.getCacheStoreMode();
    }

    @Override
    public void setCacheMode(@UnknownKeyFor @NonNull @Initialized CacheMode cm) {
        this.delegate.setCacheMode(cm);
    }

    @Override
    public void setCacheStoreMode(@UnknownKeyFor @NonNull @Initialized CacheStoreMode cacheStoreMode) {
        this.delegate.setCacheStoreMode(cacheStoreMode);
    }

    @Override
    public void setCacheRetrieveMode(@UnknownKeyFor @NonNull @Initialized CacheRetrieveMode cacheRetrieveMode) {
        this.delegate.setCacheRetrieveMode(cacheRetrieveMode);
    }

    @Override
    public void setCriteriaCopyTreeEnabled(@UnknownKeyFor @NonNull @Initialized boolean jpaCriteriaCopyComplianceEnabled) {
        this.delegate.setCriteriaCopyTreeEnabled(jpaCriteriaCopyComplianceEnabled);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean isCriteriaCopyTreeEnabled() {
        return this.delegate.isCriteriaCopyTreeEnabled();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean getNativeJdbcParametersIgnored() {
        return this.delegate.getNativeJdbcParametersIgnored();
    }

    @Override
    public void setNativeJdbcParametersIgnored(@UnknownKeyFor @NonNull @Initialized boolean nativeJdbcParametersIgnored) {
        this.delegate.setNativeJdbcParametersIgnored(nativeJdbcParametersIgnored);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean isOpen() {
        return this.delegate.isOpen();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean isConnected() {
        return this.delegate.isConnected();
    }

    @Override
    public void checkOpen(@UnknownKeyFor @NonNull @Initialized boolean markForRollbackIfClosed) {
        this.delegate.checkOpen(markForRollbackIfClosed);
    }

    @Override
    public void markForRollbackOnly() {
        this.delegate.markForRollbackOnly();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized FlushModeType getFlushMode() {
        return this.delegate.getFlushMode();
    }

    @Override
    public void setFlushMode(@UnknownKeyFor @NonNull @Initialized FlushModeType flushModeType) {
        this.delegate.setFlushMode(flushModeType);
    }

    @Override
    public void setHibernateFlushMode(@UnknownKeyFor @NonNull @Initialized FlushMode flushMode) {
        this.delegate.setHibernateFlushMode(flushMode);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized FlushMode getHibernateFlushMode() {
        return this.delegate.getHibernateFlushMode();
    }

    public void lock(@UnknownKeyFor @NonNull @Initialized Object entity, @UnknownKeyFor @NonNull @Initialized LockModeType lockMode) {
        this.delegate.lock(entity, lockMode);
    }

    public void lock(@UnknownKeyFor @NonNull @Initialized Object entity, @UnknownKeyFor @NonNull @Initialized LockModeType lockMode, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> properties) {
        this.delegate.lock(entity, lockMode, properties);
    }

    public void lock(@UnknownKeyFor @NonNull @Initialized Object entity, @UnknownKeyFor @NonNull @Initialized LockModeType lockMode, LockOption ... options) {
        this.delegate.lock(entity, lockMode, options);
    }

    @Override
    public void flush() {
        this.delegate.flush();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean isEventSource() {
        return this.delegate.isEventSource();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized EventSource asEventSource() {
        return this.delegate.asEventSource();
    }

    @Override
    public void afterScrollOperation() {
        this.delegate.afterScrollOperation();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized TransactionCoordinator getTransactionCoordinator() {
        return this.delegate.getTransactionCoordinator();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized JdbcCoordinator getJdbcCoordinator() {
        return this.delegate.getJdbcCoordinator();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized JdbcServices getJdbcServices() {
        return this.delegate.getJdbcServices();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized JdbcSessionContext getJdbcSessionContext() {
        return this.delegate.getJdbcSessionContext();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean isClosed() {
        return this.delegate.isClosed();
    }

    @Override
    public void checkOpen() {
        this.delegate.checkOpen();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean isOpenOrWaitingForAutoClose() {
        return this.delegate.isOpenOrWaitingForAutoClose();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean shouldAutoClose() {
        return this.delegate.shouldAutoClose();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean isAutoCloseSessionEnabled() {
        return this.delegate.isAutoCloseSessionEnabled();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean shouldAutoJoinTransaction() {
        return this.delegate.shouldAutoJoinTransaction();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized LoadQueryInfluencers getLoadQueryInfluencers() {
        return this.delegate.getLoadQueryInfluencers();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized ExceptionConverter getExceptionConverter() {
        return this.delegate.getExceptionConverter();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized PersistenceContext getPersistenceContextInternal() {
        return this.delegate.getPersistenceContextInternal();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean autoFlushIfRequired(@UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> querySpaces) throws @UnknownKeyFor @NonNull @Initialized HibernateException {
        return this.delegate.autoFlushIfRequired(querySpaces);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean autoFlushIfRequired(@UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> querySpaces, @UnknownKeyFor @NonNull @Initialized boolean skipPreFlush) throws @UnknownKeyFor @NonNull @Initialized HibernateException {
        return this.delegate.autoFlushIfRequired(querySpaces, skipPreFlush);
    }

    @Override
    public void autoPreFlush() {
        this.delegate.autoPreFlush();
    }

    @Override
    public void afterOperation(@UnknownKeyFor @NonNull @Initialized boolean success) {
        this.delegate.afterOperation(success);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized SessionEventListenerManager getEventListenerManager() {
        return this.delegate.getEventListenerManager();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Transaction accessTransaction() {
        return this.delegate.accessTransaction();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Transaction beginTransaction() {
        return this.delegate.beginTransaction();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Transaction getTransaction() {
        return this.delegate.getTransaction();
    }

    @Override
    public void startTransactionBoundary() {
        this.delegate.startTransactionBoundary();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized CacheTransactionSynchronization getCacheTransactionSynchronization() {
        return this.delegate.getCacheTransactionSynchronization();
    }

    @Override
    public void afterTransactionBegin() {
        this.delegate.afterTransactionBegin();
    }

    @Override
    public void beforeTransactionCompletion() {
        this.delegate.beforeTransactionCompletion();
    }

    @Override
    public void afterTransactionCompletion(@UnknownKeyFor @NonNull @Initialized boolean successful, @UnknownKeyFor @NonNull @Initialized boolean delayed) {
        this.delegate.afterTransactionCompletion(successful, delayed);
    }

    @Override
    public void flushBeforeTransactionCompletion() {
        this.delegate.flushBeforeTransactionCompletion();
    }

    public @UnknownKeyFor @NonNull @Initialized EntityManagerFactory getEntityManagerFactory() {
        return this.delegate.getFactory();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized HibernateCriteriaBuilder getCriteriaBuilder() {
        return this.delegate.getCriteriaBuilder();
    }

    public @UnknownKeyFor @NonNull @Initialized Metamodel getMetamodel() {
        return this.delegate.getMetamodel();
    }

    @Override
    public <T> @UnknownKeyFor @NonNull @Initialized RootGraphImplementor<T> createEntityGraph(@UnknownKeyFor @NonNull @Initialized Class<T> rootType) {
        return this.delegate.createEntityGraph((Class)rootType);
    }

    @Override
    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized RootGraphImplementor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> createEntityGraph(@UnknownKeyFor @NonNull @Initialized String graphName) {
        return this.delegate.createEntityGraph(graphName);
    }

    @Override
    public <T> @UnknownKeyFor @NonNull @Initialized RootGraph<T> createEntityGraph(@UnknownKeyFor @NonNull @Initialized Class<T> rootType, @UnknownKeyFor @NonNull @Initialized String graphName) {
        return this.delegate.createEntityGraph(rootType, graphName);
    }

    @Override
    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized RootGraphImplementor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> getEntityGraph(@UnknownKeyFor @NonNull @Initialized String graphName) {
        return this.delegate.getEntityGraph(graphName);
    }

    @Override
    public <T> @UnknownKeyFor @NonNull @Initialized QueryImplementor<T> createQuery(@UnknownKeyFor @NonNull @Initialized CriteriaSelect<T> selectQuery) {
        return this.delegate.createQuery((CriteriaSelect)selectQuery);
    }

    @Override
    public <T> @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized EntityGraph<@UnknownKeyFor @Nullable @Initialized ? super T>> getEntityGraphs(@UnknownKeyFor @NonNull @Initialized Class<T> entityClass) {
        return this.delegate.getEntityGraphs(entityClass);
    }

    private @UnknownKeyFor @NonNull @Initialized QueryProducerImplementor queryDelegate() {
        return this.delegate;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized MutationQuery createMutationQuery(@UnknownKeyFor @NonNull @Initialized CriteriaUpdate updateQuery) {
        return this.delegate().createMutationQuery(updateQuery);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized MutationQuery createMutationQuery(@UnknownKeyFor @NonNull @Initialized CriteriaDelete deleteQuery) {
        return this.delegate().createMutationQuery(deleteQuery);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized MutationQuery createMutationQuery(@UnknownKeyFor @NonNull @Initialized JpaCriteriaInsertSelect insertSelect) {
        return this.delegate().createMutationQuery(insertSelect);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized MutationQuery createMutationQuery(@UnknownKeyFor @NonNull @Initialized JpaCriteriaInsert insertSelect) {
        return this.delegate().createMutationQuery(insertSelect);
    }

    public <T> @UnknownKeyFor @NonNull @Initialized QueryImplementor<T> createQuery(@UnknownKeyFor @NonNull @Initialized CriteriaQuery<T> criteriaQuery) {
        return this.queryDelegate().createQuery((CriteriaQuery)criteriaQuery);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized QueryImplementor createQuery(@UnknownKeyFor @NonNull @Initialized CriteriaUpdate updateQuery) {
        return this.queryDelegate().createQuery(updateQuery);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized QueryImplementor createQuery(@UnknownKeyFor @NonNull @Initialized CriteriaDelete deleteQuery) {
        return this.queryDelegate().createQuery(deleteQuery);
    }

    public <T> @UnknownKeyFor @NonNull @Initialized QueryImplementor<T> createQuery(@UnknownKeyFor @NonNull @Initialized TypedQueryReference<T> typedQueryReference) {
        return this.queryDelegate().createQuery((TypedQueryReference)typedQueryReference);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized QueryImplementor getNamedQuery(@UnknownKeyFor @NonNull @Initialized String name) {
        return this.queryDelegate().getNamedQuery(name);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized NativeQueryImplementor getNamedNativeQuery(@UnknownKeyFor @NonNull @Initialized String name) {
        return this.queryDelegate().getNamedNativeQuery(name);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized NativeQueryImplementor getNamedNativeQuery(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized String resultSetMapping) {
        return this.queryDelegate().getNamedNativeQuery(name, resultSetMapping);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized QueryImplementor createQuery(@UnknownKeyFor @NonNull @Initialized String queryString) {
        return this.queryDelegate().createQuery(queryString);
    }

    @Override
    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized SelectionQuery<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> createSelectionQuery(@UnknownKeyFor @NonNull @Initialized String hqlString) {
        return this.queryDelegate().createSelectionQuery(hqlString);
    }

    @Override
    public <R> @UnknownKeyFor @NonNull @Initialized SelectionQuery<R> createSelectionQuery(@UnknownKeyFor @NonNull @Initialized String hqlString, @UnknownKeyFor @NonNull @Initialized Class<R> resultType) {
        return this.queryDelegate().createSelectionQuery(hqlString, resultType);
    }

    @Override
    public <R> @UnknownKeyFor @NonNull @Initialized SelectionQuery<R> createSelectionQuery(@UnknownKeyFor @NonNull @Initialized CriteriaQuery<R> criteria) {
        return this.queryDelegate().createSelectionQuery(criteria);
    }

    public <T> @UnknownKeyFor @NonNull @Initialized QueryImplementor<T> createQuery(@UnknownKeyFor @NonNull @Initialized String queryString, @UnknownKeyFor @NonNull @Initialized Class<T> resultType) {
        return this.queryDelegate().createQuery(queryString, resultType);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized QueryImplementor createNamedQuery(@UnknownKeyFor @NonNull @Initialized String name) {
        return this.queryDelegate().createNamedQuery(name);
    }

    public <T> @UnknownKeyFor @NonNull @Initialized QueryImplementor<T> createNamedQuery(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized Class<T> resultClass) {
        return this.queryDelegate().createNamedQuery(name, resultClass);
    }

    @Override
    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized SelectionQuery<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> createNamedSelectionQuery(@UnknownKeyFor @NonNull @Initialized String name) {
        return this.delegate().createNamedSelectionQuery(name);
    }

    @Override
    public <R> @UnknownKeyFor @NonNull @Initialized SelectionQuery<R> createNamedSelectionQuery(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized Class<R> resultType) {
        return this.delegate().createNamedSelectionQuery(name, resultType);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized NativeQueryImplementor createNativeQuery(@UnknownKeyFor @NonNull @Initialized String sqlString) {
        return this.queryDelegate().createNativeQuery(sqlString);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized NativeQueryImplementor createNativeQuery(@UnknownKeyFor @NonNull @Initialized String sqlString, @UnknownKeyFor @NonNull @Initialized Class resultClass) {
        return this.queryDelegate().createNativeQuery(sqlString, resultClass);
    }

    public <T> @UnknownKeyFor @NonNull @Initialized NativeQueryImplementor<T> createNativeQuery(@UnknownKeyFor @NonNull @Initialized String sqlString, @UnknownKeyFor @NonNull @Initialized Class<T> resultClass, @UnknownKeyFor @NonNull @Initialized String tableAlias) {
        return this.queryDelegate().createNativeQuery(sqlString, resultClass, tableAlias);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized NativeQueryImplementor createNativeQuery(@UnknownKeyFor @NonNull @Initialized String sqlString, @UnknownKeyFor @NonNull @Initialized String resultSetMappingName) {
        return this.queryDelegate().createNativeQuery(sqlString, resultSetMappingName);
    }

    public <T> @UnknownKeyFor @NonNull @Initialized NativeQueryImplementor<T> createNativeQuery(@UnknownKeyFor @NonNull @Initialized String sqlString, @UnknownKeyFor @NonNull @Initialized String resultSetMappingName, @UnknownKeyFor @NonNull @Initialized Class<T> resultClass) {
        return this.queryDelegate().createNativeQuery(sqlString, resultSetMappingName, resultClass);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized MutationQuery createMutationQuery(@UnknownKeyFor @NonNull @Initialized String statementString) {
        return this.delegate.createMutationQuery(statementString);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized MutationQuery createNamedMutationQuery(@UnknownKeyFor @NonNull @Initialized String name) {
        return this.delegate.createNamedMutationQuery(name);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized MutationQuery createNativeMutationQuery(@UnknownKeyFor @NonNull @Initialized String sqlString) {
        return this.delegate.createNativeMutationQuery(sqlString);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized ProcedureCall createNamedStoredProcedureQuery(@UnknownKeyFor @NonNull @Initialized String name) {
        return this.delegate.createNamedStoredProcedureQuery(name);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized ProcedureCall createStoredProcedureQuery(@UnknownKeyFor @NonNull @Initialized String procedureName) {
        return this.delegate.createStoredProcedureQuery(procedureName);
    }

    public @UnknownKeyFor @NonNull @Initialized ProcedureCall createStoredProcedureQuery(@UnknownKeyFor @NonNull @Initialized String procedureName, Class ... resultClasses) {
        return this.delegate.createStoredProcedureQuery(procedureName, resultClasses);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized ProcedureCall createStoredProcedureQuery(@UnknownKeyFor @NonNull @Initialized String procedureName, String ... resultSetMappings) {
        return this.delegate.createStoredProcedureQuery(procedureName, resultSetMappings);
    }

    @Override
    public void prepareForQueryExecution(@UnknownKeyFor @NonNull @Initialized boolean requiresTxn) {
        this.delegate.prepareForQueryExecution(requiresTxn);
    }

    @Override
    public void joinTransaction() {
        this.delegate.joinTransaction();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean isJoinedToTransaction() {
        return this.delegate.isJoinedToTransaction();
    }

    public <T> T unwrap(@UnknownKeyFor @NonNull @Initialized Class<T> cls) {
        return (T)this.delegate.unwrap(cls);
    }

    public @UnknownKeyFor @NonNull @Initialized Object getDelegate() {
        return this;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized ProcedureCall getNamedProcedureCall(@UnknownKeyFor @NonNull @Initialized String name) {
        return this.delegate.getNamedProcedureCall(name);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized ProcedureCall createStoredProcedureCall(@UnknownKeyFor @NonNull @Initialized String procedureName) {
        return this.delegate.createStoredProcedureCall(procedureName);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized ProcedureCall createStoredProcedureCall(@UnknownKeyFor @NonNull @Initialized String procedureName, Class<?> ... resultClasses) {
        return this.delegate.createStoredProcedureCall(procedureName, resultClasses);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized ProcedureCall createStoredProcedureCall(@UnknownKeyFor @NonNull @Initialized String procedureName, String ... resultSetMappings) {
        return this.delegate.createStoredProcedureCall(procedureName, resultSetMappings);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized SharedSessionBuilder sessionWithOptions() {
        return this.delegate.sessionWithOptions();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized SessionFactoryImplementor getSessionFactory() {
        return this.delegate.getSessionFactory();
    }

    @Override
    public void close() throws @UnknownKeyFor @NonNull @Initialized HibernateException {
        this.delegate.close();
    }

    @Override
    public void cancelQuery() throws @UnknownKeyFor @NonNull @Initialized HibernateException {
        this.delegate.cancelQuery();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean isDirty() throws @UnknownKeyFor @NonNull @Initialized HibernateException {
        return this.delegate.isDirty();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean isDefaultReadOnly() {
        return this.delegate.isDefaultReadOnly();
    }

    @Override
    public void setDefaultReadOnly(@UnknownKeyFor @NonNull @Initialized boolean readOnly) {
        this.delegate.setDefaultReadOnly(readOnly);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Object getIdentifier(@UnknownKeyFor @NonNull @Initialized Object object) {
        return this.delegate.getIdentifier(object);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean contains(@UnknownKeyFor @NonNull @Initialized String entityName, @UnknownKeyFor @NonNull @Initialized Object object) {
        return this.delegate.contains(entityName, object);
    }

    public @UnknownKeyFor @NonNull @Initialized boolean contains(@UnknownKeyFor @NonNull @Initialized Object object) {
        return this.delegate.contains(object);
    }

    public @UnknownKeyFor @NonNull @Initialized LockModeType getLockMode(@UnknownKeyFor @NonNull @Initialized Object entity) {
        return this.delegate.getLockMode(entity);
    }

    public void setProperty(@UnknownKeyFor @NonNull @Initialized String propertyName, @UnknownKeyFor @NonNull @Initialized Object value) {
        this.delegate.setProperty(propertyName, value);
    }

    public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> getProperties() {
        return this.delegate.getProperties();
    }

    @Override
    public void evict(@UnknownKeyFor @NonNull @Initialized Object object) {
        this.delegate.evict(object);
    }

    @Override
    public <T> T load(@UnknownKeyFor @NonNull @Initialized Class<T> theClass, @UnknownKeyFor @NonNull @Initialized Object id, @UnknownKeyFor @NonNull @Initialized LockMode lockMode) {
        return this.delegate.load(theClass, id, lockMode);
    }

    @Override
    public <T> T load(@UnknownKeyFor @NonNull @Initialized Class<T> theClass, @UnknownKeyFor @NonNull @Initialized Object id, @UnknownKeyFor @NonNull @Initialized LockOptions lockOptions) {
        return this.delegate.load(theClass, id, lockOptions);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Object load(@UnknownKeyFor @NonNull @Initialized String entityName, @UnknownKeyFor @NonNull @Initialized Object id, @UnknownKeyFor @NonNull @Initialized LockMode lockMode) {
        return this.delegate.load(entityName, id, lockMode);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Object load(@UnknownKeyFor @NonNull @Initialized String entityName, @UnknownKeyFor @NonNull @Initialized Object id, @UnknownKeyFor @NonNull @Initialized LockOptions lockOptions) {
        return this.delegate.load(entityName, id, lockOptions);
    }

    @Override
    public <T> T load(@UnknownKeyFor @NonNull @Initialized Class<T> theClass, @UnknownKeyFor @NonNull @Initialized Object id) {
        return this.delegate.load(theClass, id);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Object load(@UnknownKeyFor @NonNull @Initialized String entityName, @UnknownKeyFor @NonNull @Initialized Object id) {
        return this.delegate.load(entityName, id);
    }

    @Override
    public void load(@UnknownKeyFor @NonNull @Initialized Object object, @UnknownKeyFor @NonNull @Initialized Object id) {
        this.delegate.load(object, id);
    }

    @Override
    public void replicate(@UnknownKeyFor @NonNull @Initialized Object object, @UnknownKeyFor @NonNull @Initialized ReplicationMode replicationMode) {
        this.delegate.replicate(object, replicationMode);
    }

    @Override
    public void replicate(@UnknownKeyFor @NonNull @Initialized String entityName, @UnknownKeyFor @NonNull @Initialized Object object, @UnknownKeyFor @NonNull @Initialized ReplicationMode replicationMode) {
        this.delegate.replicate(entityName, object, replicationMode);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Object save(@UnknownKeyFor @NonNull @Initialized Object object) {
        return this.delegate.save(object);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Object save(@UnknownKeyFor @NonNull @Initialized String entityName, @UnknownKeyFor @NonNull @Initialized Object object) {
        return this.delegate.save(entityName, object);
    }

    @Override
    public void saveOrUpdate(@UnknownKeyFor @NonNull @Initialized Object object) {
        this.delegate.saveOrUpdate(object);
    }

    @Override
    public void saveOrUpdate(@UnknownKeyFor @NonNull @Initialized String entityName, @UnknownKeyFor @NonNull @Initialized Object object) {
        this.delegate.saveOrUpdate(entityName, object);
    }

    @Override
    public void update(@UnknownKeyFor @NonNull @Initialized Object object) {
        this.delegate.update(object);
    }

    @Override
    public void update(@UnknownKeyFor @NonNull @Initialized String entityName, @UnknownKeyFor @NonNull @Initialized Object object) {
        this.delegate.update(entityName, object);
    }

    @Override
    public <T> T merge(T object) {
        return this.delegate.merge(object);
    }

    @Override
    public <T> T merge(@UnknownKeyFor @NonNull @Initialized String entityName, T object) {
        return this.delegate.merge(entityName, object);
    }

    @Override
    public void persist(@UnknownKeyFor @NonNull @Initialized Object object) {
        this.delegate.persist(object);
    }

    @Override
    public void remove(@UnknownKeyFor @NonNull @Initialized Object entity) {
        this.delegate.remove(entity);
    }

    public <T> @Nullable T find(@UnknownKeyFor @NonNull @Initialized Class<T> entityClass, @UnknownKeyFor @NonNull @Initialized Object primaryKey) {
        return (T)this.delegate.find(entityClass, primaryKey);
    }

    public <T> @Nullable T find(@UnknownKeyFor @NonNull @Initialized Class<T> entityClass, @UnknownKeyFor @NonNull @Initialized Object primaryKey, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> properties) {
        return (T)this.delegate.find(entityClass, primaryKey, properties);
    }

    public <T> @Nullable T find(@UnknownKeyFor @NonNull @Initialized Class<T> entityClass, @UnknownKeyFor @NonNull @Initialized Object primaryKey, @UnknownKeyFor @NonNull @Initialized LockModeType lockMode) {
        return (T)this.delegate.find(entityClass, primaryKey, lockMode);
    }

    public <T> @Nullable T find(@UnknownKeyFor @NonNull @Initialized Class<T> entityClass, @UnknownKeyFor @NonNull @Initialized Object primaryKey, @UnknownKeyFor @NonNull @Initialized LockModeType lockMode, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> properties) {
        return (T)this.delegate.find(entityClass, primaryKey, lockMode, properties);
    }

    public <T> T find(@UnknownKeyFor @NonNull @Initialized Class<T> entityClass, @UnknownKeyFor @NonNull @Initialized Object primaryKey, FindOption ... options) {
        return (T)this.delegate.find(entityClass, primaryKey, options);
    }

    public <T> T find(@UnknownKeyFor @NonNull @Initialized EntityGraph<T> entityGraph, @UnknownKeyFor @NonNull @Initialized Object primaryKey, FindOption ... options) {
        return (T)this.delegate.find(entityGraph, primaryKey, options);
    }

    @Override
    public <T> T getReference(@UnknownKeyFor @NonNull @Initialized Class<T> entityClass, @UnknownKeyFor @NonNull @Initialized Object id) {
        return this.delegate.getReference(entityClass, id);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Object getReference(@UnknownKeyFor @NonNull @Initialized String entityName, @UnknownKeyFor @NonNull @Initialized Object id) {
        return this.delegate.getReference(entityName, id);
    }

    @Override
    public void persist(@UnknownKeyFor @NonNull @Initialized String entityName, @UnknownKeyFor @NonNull @Initialized Object object) {
        this.delegate.persist(entityName, object);
    }

    @Override
    public void delete(@UnknownKeyFor @NonNull @Initialized Object object) {
        this.delegate.delete(object);
    }

    @Override
    public void delete(@UnknownKeyFor @NonNull @Initialized String entityName, @UnknownKeyFor @NonNull @Initialized Object object) {
        this.delegate.delete(entityName, object);
    }

    @Override
    public void lock(@UnknownKeyFor @NonNull @Initialized Object object, @UnknownKeyFor @NonNull @Initialized LockMode lockMode) {
        this.delegate.lock(object, lockMode);
    }

    @Override
    public void lock(@UnknownKeyFor @NonNull @Initialized String entityName, @UnknownKeyFor @NonNull @Initialized Object object, @UnknownKeyFor @NonNull @Initialized LockMode lockMode) {
        this.delegate.lock(entityName, object, lockMode);
    }

    @Override
    public void lock(@UnknownKeyFor @NonNull @Initialized String entityName, @UnknownKeyFor @NonNull @Initialized Object object, @UnknownKeyFor @NonNull @Initialized LockOptions lockOptions) {
        this.delegate.lock(entityName, object, lockOptions);
    }

    @Override
    public void lock(@UnknownKeyFor @NonNull @Initialized Object object, @UnknownKeyFor @NonNull @Initialized LockOptions lockOptions) {
        this.delegate.lock(object, lockOptions);
    }

    @Override
    @Deprecated
    public @UnknownKeyFor @NonNull @Initialized Session.LockRequest buildLockRequest(@UnknownKeyFor @NonNull @Initialized LockOptions lockOptions) {
        return this.delegate.buildLockRequest(lockOptions);
    }

    @Override
    public void refresh(@UnknownKeyFor @NonNull @Initialized Object object) {
        this.delegate.refresh(object);
    }

    public void refresh(@UnknownKeyFor @NonNull @Initialized Object entity, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> properties) {
        this.delegate.refresh(entity, properties);
    }

    public void refresh(@UnknownKeyFor @NonNull @Initialized Object entity, @UnknownKeyFor @NonNull @Initialized LockModeType lockMode) {
        this.delegate.refresh(entity, lockMode);
    }

    public void refresh(@UnknownKeyFor @NonNull @Initialized Object entity, @UnknownKeyFor @NonNull @Initialized LockModeType lockMode, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> properties) {
        this.delegate.refresh(entity, lockMode, properties);
    }

    public void refresh(@UnknownKeyFor @NonNull @Initialized Object entity, RefreshOption ... options) {
        this.delegate.refresh(entity, options);
    }

    @Override
    public void refresh(@UnknownKeyFor @NonNull @Initialized String entityName, @UnknownKeyFor @NonNull @Initialized Object object) {
        this.delegate.refresh(entityName, object);
    }

    @Override
    public void refresh(@UnknownKeyFor @NonNull @Initialized Object object, @UnknownKeyFor @NonNull @Initialized LockMode lockMode) {
        this.delegate.refresh(object, lockMode);
    }

    @Override
    public void refresh(@UnknownKeyFor @NonNull @Initialized Object object, @UnknownKeyFor @NonNull @Initialized LockOptions lockOptions) {
        this.delegate.refresh(object, lockOptions);
    }

    @Override
    public void refresh(@UnknownKeyFor @NonNull @Initialized String entityName, @UnknownKeyFor @NonNull @Initialized Object object, @UnknownKeyFor @NonNull @Initialized LockOptions lockOptions) {
        this.delegate.refresh(entityName, object, lockOptions);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized LockMode getCurrentLockMode(@UnknownKeyFor @NonNull @Initialized Object object) {
        return this.delegate.getCurrentLockMode(object);
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public void detach(@UnknownKeyFor @NonNull @Initialized Object entity) {
        this.delegate.detach(entity);
    }

    @Override
    public <T> T get(@UnknownKeyFor @NonNull @Initialized Class<T> theClass, @UnknownKeyFor @NonNull @Initialized Object id) {
        return this.delegate.get(theClass, id);
    }

    @Override
    public <T> T get(@UnknownKeyFor @NonNull @Initialized Class<T> theClass, @UnknownKeyFor @NonNull @Initialized Object id, @UnknownKeyFor @NonNull @Initialized LockMode lockMode) {
        return this.delegate.get(theClass, id, lockMode);
    }

    @Override
    public <T> T get(@UnknownKeyFor @NonNull @Initialized Class<T> theClass, @UnknownKeyFor @NonNull @Initialized Object id, @UnknownKeyFor @NonNull @Initialized LockOptions lockOptions) {
        return this.delegate.get(theClass, id, lockOptions);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Object get(@UnknownKeyFor @NonNull @Initialized String entityName, @UnknownKeyFor @NonNull @Initialized Object id) {
        return this.delegate.get(entityName, id);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Object get(@UnknownKeyFor @NonNull @Initialized String entityName, @UnknownKeyFor @NonNull @Initialized Object id, @UnknownKeyFor @NonNull @Initialized LockMode lockMode) {
        return this.delegate.get(entityName, id, lockMode);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Object get(@UnknownKeyFor @NonNull @Initialized String entityName, @UnknownKeyFor @NonNull @Initialized Object id, @UnknownKeyFor @NonNull @Initialized LockOptions lockOptions) {
        return this.delegate.get(entityName, id, lockOptions);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getEntityName(@UnknownKeyFor @NonNull @Initialized Object object) {
        return this.delegate.getEntityName(object);
    }

    @Override
    public <T> T getReference(T object) {
        return this.delegate.getReference(object);
    }

    @Override
    public <T> @UnknownKeyFor @NonNull @Initialized IdentifierLoadAccess<T> byId(@UnknownKeyFor @NonNull @Initialized String entityName) {
        return this.delegate.byId(entityName);
    }

    @Override
    public <T> @UnknownKeyFor @NonNull @Initialized MultiIdentifierLoadAccess<T> byMultipleIds(@UnknownKeyFor @NonNull @Initialized Class<T> entityClass) {
        return this.delegate.byMultipleIds(entityClass);
    }

    @Override
    public <T> @UnknownKeyFor @NonNull @Initialized MultiIdentifierLoadAccess<T> byMultipleIds(@UnknownKeyFor @NonNull @Initialized String entityName) {
        return this.delegate.byMultipleIds(entityName);
    }

    @Override
    public <T> @UnknownKeyFor @NonNull @Initialized IdentifierLoadAccess<T> byId(@UnknownKeyFor @NonNull @Initialized Class<T> entityClass) {
        return this.delegate.byId(entityClass);
    }

    @Override
    public <T> @UnknownKeyFor @NonNull @Initialized NaturalIdLoadAccess<T> byNaturalId(@UnknownKeyFor @NonNull @Initialized String entityName) {
        return this.delegate.byNaturalId(entityName);
    }

    @Override
    public <T> @UnknownKeyFor @NonNull @Initialized NaturalIdLoadAccess<T> byNaturalId(@UnknownKeyFor @NonNull @Initialized Class<T> entityClass) {
        return this.delegate.byNaturalId(entityClass);
    }

    @Override
    public <T> @UnknownKeyFor @NonNull @Initialized SimpleNaturalIdLoadAccess<T> bySimpleNaturalId(@UnknownKeyFor @NonNull @Initialized String entityName) {
        return this.delegate.bySimpleNaturalId(entityName);
    }

    @Override
    public <T> @UnknownKeyFor @NonNull @Initialized SimpleNaturalIdLoadAccess<T> bySimpleNaturalId(@UnknownKeyFor @NonNull @Initialized Class<T> entityClass) {
        return this.delegate.bySimpleNaturalId(entityClass);
    }

    @Override
    public <T> @UnknownKeyFor @NonNull @Initialized NaturalIdMultiLoadAccess<T> byMultipleNaturalId(@UnknownKeyFor @NonNull @Initialized Class<T> entityClass) {
        return this.delegate.byMultipleNaturalId(entityClass);
    }

    @Override
    public <T> @UnknownKeyFor @NonNull @Initialized NaturalIdMultiLoadAccess<T> byMultipleNaturalId(@UnknownKeyFor @NonNull @Initialized String entityName) {
        return this.delegate.byMultipleNaturalId(entityName);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Filter enableFilter(@UnknownKeyFor @NonNull @Initialized String filterName) {
        return this.delegate.enableFilter(filterName);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Filter getEnabledFilter(@UnknownKeyFor @NonNull @Initialized String filterName) {
        return this.delegate.getEnabledFilter(filterName);
    }

    @Override
    public void disableFilter(@UnknownKeyFor @NonNull @Initialized String filterName) {
        this.delegate.disableFilter(filterName);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized SessionStatistics getStatistics() {
        return this.delegate.getStatistics();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean isReadOnly(@UnknownKeyFor @NonNull @Initialized Object entityOrProxy) {
        return this.delegate.isReadOnly(entityOrProxy);
    }

    @Override
    public void setReadOnly(@UnknownKeyFor @NonNull @Initialized Object entityOrProxy, @UnknownKeyFor @NonNull @Initialized boolean readOnly) {
        this.delegate.setReadOnly(entityOrProxy, readOnly);
    }

    @Override
    public void doWork(@UnknownKeyFor @NonNull @Initialized Work work) throws @UnknownKeyFor @NonNull @Initialized HibernateException {
        this.delegate.doWork(work);
    }

    @Override
    public <T> T doReturningWork(@UnknownKeyFor @NonNull @Initialized ReturningWork<T> work) throws @UnknownKeyFor @NonNull @Initialized HibernateException {
        return this.delegate.doReturningWork(work);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean isFetchProfileEnabled(@UnknownKeyFor @NonNull @Initialized String name) throws @UnknownKeyFor @NonNull @Initialized UnknownProfileException {
        return this.delegate.isFetchProfileEnabled(name);
    }

    @Override
    public void enableFetchProfile(@UnknownKeyFor @NonNull @Initialized String name) throws @UnknownKeyFor @NonNull @Initialized UnknownProfileException {
        this.delegate.enableFetchProfile(name);
    }

    @Override
    public void disableFetchProfile(@UnknownKeyFor @NonNull @Initialized String name) throws @UnknownKeyFor @NonNull @Initialized UnknownProfileException {
        this.delegate.disableFetchProfile(name);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized LobHelper getLobHelper() {
        return this.delegate.getLobHelper();
    }

    @Override
    public void addEventListeners(SessionEventListener ... listeners) {
        this.delegate.addEventListeners(listeners);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized ActionQueue getActionQueue() {
        return this.delegate.getActionQueue();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Object instantiate(@UnknownKeyFor @NonNull @Initialized EntityPersister persister, @UnknownKeyFor @NonNull @Initialized Object id) throws @UnknownKeyFor @NonNull @Initialized HibernateException {
        return this.delegate.instantiate(persister, id);
    }

    @Override
    public void forceFlush(@UnknownKeyFor @NonNull @Initialized EntityEntry e) throws @UnknownKeyFor @NonNull @Initialized HibernateException {
        this.delegate.forceFlush(e);
    }

    @Override
    public void forceFlush(@UnknownKeyFor @NonNull @Initialized EntityKey e) throws @UnknownKeyFor @NonNull @Initialized HibernateException {
        this.delegate.forceFlush(e);
    }

    @Override
    public void merge(@UnknownKeyFor @NonNull @Initialized String entityName, @UnknownKeyFor @NonNull @Initialized Object object, @UnknownKeyFor @NonNull @Initialized MergeContext copiedAlready) throws @UnknownKeyFor @NonNull @Initialized HibernateException {
        this.delegate.merge(entityName, object, copiedAlready);
    }

    @Override
    public void persist(@UnknownKeyFor @NonNull @Initialized String entityName, @UnknownKeyFor @NonNull @Initialized Object object, @UnknownKeyFor @NonNull @Initialized PersistContext createdAlready) throws @UnknownKeyFor @NonNull @Initialized HibernateException {
        this.delegate.persist(entityName, object, createdAlready);
    }

    @Override
    public void persistOnFlush(@UnknownKeyFor @NonNull @Initialized String entityName, @UnknownKeyFor @NonNull @Initialized Object object, @UnknownKeyFor @NonNull @Initialized PersistContext copiedAlready) {
        this.delegate.persistOnFlush(entityName, object, copiedAlready);
    }

    @Override
    public void refresh(@UnknownKeyFor @NonNull @Initialized String entityName, @UnknownKeyFor @NonNull @Initialized Object object, @UnknownKeyFor @NonNull @Initialized RefreshContext refreshedAlready) throws @UnknownKeyFor @NonNull @Initialized HibernateException {
        this.delegate.refresh(entityName, object, refreshedAlready);
    }

    @Override
    public void delete(@UnknownKeyFor @NonNull @Initialized String entityName, @UnknownKeyFor @NonNull @Initialized Object child, @UnknownKeyFor @NonNull @Initialized boolean isCascadeDeleteEnabled, @UnknownKeyFor @NonNull @Initialized DeleteContext transientEntities) {
        this.delegate.delete(entityName, child, isCascadeDeleteEnabled, transientEntities);
    }

    @Override
    public void removeOrphanBeforeUpdates(@UnknownKeyFor @NonNull @Initialized String entityName, @UnknownKeyFor @NonNull @Initialized Object child) {
        this.delegate.removeOrphanBeforeUpdates(entityName, child);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized SessionImplementor getSession() {
        return this;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean useStreamForLobBinding() {
        return this.delegate.useStreamForLobBinding();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized int getPreferredSqlTypeCodeForBoolean() {
        return this.delegate.getPreferredSqlTypeCodeForBoolean();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized LobCreator getLobCreator() {
        return this.delegate.getLobCreator();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Integer getJdbcBatchSize() {
        return this.delegate.getJdbcBatchSize();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized EventManager getEventManager() {
        return this.delegate.getEventManager();
    }

    @Override
    public void setJdbcBatchSize(@UnknownKeyFor @NonNull @Initialized Integer jdbcBatchSize) {
        this.delegate.setJdbcBatchSize(jdbcBatchSize);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean isSubselectFetchingEnabled() {
        return this.delegate.isSubselectFetchingEnabled();
    }

    @Override
    public void setSubselectFetchingEnabled(@UnknownKeyFor @NonNull @Initialized boolean enabled) {
        this.delegate.setSubselectFetchingEnabled(enabled);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized int getFetchBatchSize() {
        return this.delegate.getFetchBatchSize();
    }

    @Override
    public void setFetchBatchSize(@UnknownKeyFor @NonNull @Initialized int batchSize) {
        this.delegate.setFetchBatchSize(batchSize);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized TimeZone getJdbcTimeZone() {
        return this.delegate.getJdbcTimeZone();
    }
}

