/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.boot.spi;

import jakarta.persistence.PersistenceConfiguration;
import jakarta.persistence.SharedCacheMode;
import jakarta.persistence.ValidationMode;
import jakarta.persistence.spi.PersistenceUnitTransactionType;
import java.net.URL;
import java.util.List;
import java.util.Properties;
import org.hibernate.bytecode.enhance.spi.EnhancementContext;
import org.hibernate.bytecode.spi.ClassTransformer;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.jpa.HibernatePersistenceProvider;
import org.hibernate.jpa.boot.spi.PersistenceUnitDescriptor;

public class PersistenceConfigurationDescriptor
implements PersistenceUnitDescriptor {
    private final PersistenceConfiguration persistenceConfiguration;
    private final Properties properties;
    private final List<String> managedClassNames;

    public PersistenceConfigurationDescriptor(PersistenceConfiguration persistenceConfiguration) {
        this.persistenceConfiguration = persistenceConfiguration;
        this.properties = CollectionHelper.asProperties(persistenceConfiguration.properties());
        this.managedClassNames = persistenceConfiguration.managedClasses().stream().map(Class::getName).toList();
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public String getName() {
        return this.persistenceConfiguration.name();
    }

    @Override
    public String getProviderClassName() {
        return this.persistenceConfiguration.provider();
    }

    @Override
    public boolean isUseQuotedIdentifiers() {
        return this.properties.get("hibernate.globally_quoted_identifiers") == Boolean.TRUE;
    }

    @Override
    public boolean isExcludeUnlistedClasses() {
        return true;
    }

    @Override
    public PersistenceUnitTransactionType getTransactionType() {
        return switch (this.persistenceConfiguration.transactionType()) {
            default -> throw new IncompatibleClassChangeError();
            case jakarta.persistence.PersistenceUnitTransactionType.JTA -> PersistenceUnitTransactionType.JTA;
            case jakarta.persistence.PersistenceUnitTransactionType.RESOURCE_LOCAL -> PersistenceUnitTransactionType.RESOURCE_LOCAL;
        };
    }

    @Override
    public ValidationMode getValidationMode() {
        return this.persistenceConfiguration.validationMode();
    }

    @Override
    public SharedCacheMode getSharedCacheMode() {
        return this.persistenceConfiguration.sharedCacheMode();
    }

    @Override
    public List<String> getManagedClassNames() {
        return this.managedClassNames;
    }

    @Override
    public List<String> getMappingFileNames() {
        return this.persistenceConfiguration.mappingFiles();
    }

    @Override
    public Object getNonJtaDataSource() {
        return this.persistenceConfiguration.nonJtaDataSource();
    }

    @Override
    public Object getJtaDataSource() {
        return this.persistenceConfiguration.jtaDataSource();
    }

    @Override
    public ClassLoader getClassLoader() {
        return HibernatePersistenceProvider.class.getClassLoader();
    }

    @Override
    public ClassLoader getTempClassLoader() {
        return null;
    }

    @Override
    public void pushClassTransformer(EnhancementContext enhancementContext) {
    }

    @Override
    public ClassTransformer getClassTransformer() {
        return null;
    }

    @Override
    public URL getPersistenceUnitRootUrl() {
        return null;
    }

    @Override
    public List<URL> getJarFileUrls() {
        return null;
    }
}

