/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.util.List;
import java.util.Objects;
import org.hibernate.MappingException;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.MappingHelper;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.ToOne;
import org.hibernate.mapping.ValueVisitor;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.type.Type;

public class OneToOne
extends ToOne {
    private boolean constrained;
    private ForeignKeyDirection foreignKeyType;
    private KeyValue identifier;
    private String propertyName;
    private final String entityName;
    private String mappedByProperty;

    public OneToOne(MetadataBuildingContext buildingContext, Table table, PersistentClass owner) throws MappingException {
        super(buildingContext, table);
        this.identifier = owner.getKey();
        this.entityName = owner.getEntityName();
    }

    private OneToOne(OneToOne original) {
        super(original);
        this.constrained = original.constrained;
        this.foreignKeyType = original.foreignKeyType;
        this.identifier = original.identifier == null ? null : (KeyValue)original.identifier.copy();
        this.propertyName = original.propertyName;
        this.entityName = original.entityName;
        this.mappedByProperty = original.mappedByProperty;
    }

    @Override
    public OneToOne copy() {
        return new OneToOne(this);
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName == null ? null : propertyName.intern();
    }

    public String getEntityName() {
        return this.entityName;
    }

    @Override
    public Type getType() throws MappingException {
        if (this.getColumnSpan() > 0) {
            return MappingHelper.specialOneToOne(this.getReferencedEntityName(), this.getForeignKeyType(), this.isReferenceToPrimaryKey(), this.getReferencedPropertyName(), this.isLazy(), this.isUnwrapProxy(), this.getEntityName(), this.getPropertyName(), this.isConstrained(), this.getBuildingContext());
        }
        return MappingHelper.oneToOne(this.getReferencedEntityName(), this.getForeignKeyType(), this.isReferenceToPrimaryKey(), this.getReferencedPropertyName(), this.isLazy(), this.isUnwrapProxy(), this.entityName, this.propertyName, this.isConstrained(), this.getBuildingContext());
    }

    @Override
    public void createUniqueKey(MetadataBuildingContext context) {
        if (!this.hasFormula() && this.getColumnSpan() > 0) {
            this.getTable().createUniqueKey(this.getConstraintColumns(), context);
        }
    }

    @Override
    public List<Selectable> getVirtualSelectables() {
        List<Selectable> selectables = super.getVirtualSelectables();
        if (selectables.isEmpty()) {
            selectables = this.identifier.getSelectables();
        }
        return selectables;
    }

    @Override
    public List<Column> getConstraintColumns() {
        List<Column> columns = super.getColumns();
        if (columns.isEmpty()) {
            columns = this.identifier.getColumns();
        }
        return columns;
    }

    @Override
    public boolean isConstrained() {
        return this.constrained;
    }

    public ForeignKeyDirection getForeignKeyType() {
        return this.foreignKeyType;
    }

    public KeyValue getIdentifier() {
        return this.identifier;
    }

    public void setConstrained(boolean constrained) {
        this.constrained = constrained;
    }

    public void setForeignKeyType(ForeignKeyDirection foreignKeyType) {
        this.foreignKeyType = foreignKeyType;
    }

    public void setIdentifier(KeyValue identifier) {
        this.identifier = identifier;
    }

    @Override
    public boolean isNullable() {
        return !this.constrained;
    }

    @Override
    public Object accept(ValueVisitor visitor) {
        return visitor.accept(this);
    }

    @Override
    public boolean isSame(ToOne other) {
        return other instanceof OneToOne && this.isSame((OneToOne)other);
    }

    public boolean isSame(OneToOne other) {
        return super.isSame(other) && Objects.equals((Object)this.foreignKeyType, (Object)other.foreignKeyType) && OneToOne.isSame(this.identifier, other.identifier) && Objects.equals(this.propertyName, other.propertyName) && Objects.equals(this.entityName, other.entityName) && this.constrained == other.constrained;
    }

    public String getMappedByProperty() {
        return this.mappedByProperty;
    }

    public void setMappedByProperty(String mappedByProperty) {
        this.mappedByProperty = mappedByProperty;
    }
}

