/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.hibernate.cache.MutableCacheKeyBuilder;
import org.hibernate.engine.FetchStyle;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.internal.UnsavedValueFactory;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.VersionValue;
import org.hibernate.internal.util.IndexedConsumer;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.RootClass;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.EntityVersionMapping;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.internal.BasicAttributeMapping;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationProcess;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchOptions;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.basic.BasicFetch;
import org.hibernate.sql.results.graph.basic.BasicResult;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.java.VersionJavaType;

public class EntityVersionMappingImpl
implements EntityVersionMapping,
FetchOptions {
    private final String attributeName;
    private final EntityMappingType declaringType;
    private final String columnTableExpression;
    private final String columnExpression;
    private final String columnDefinition;
    private final Long length;
    private final Integer precision;
    private final Integer scale;
    private final Integer temporalPrecision;
    private final BasicType versionBasicType;
    private final VersionValue unsavedValueStrategy;
    private BasicAttributeMapping attributeMapping;

    public EntityVersionMappingImpl(RootClass bootEntityDescriptor, Supplier<?> templateInstanceAccess, String attributeName, String columnTableExpression, String columnExpression, String columnDefinition, Long length, Integer precision, Integer scale, Integer temporalPrecision, BasicType<?> versionBasicType, EntityMappingType declaringType, MappingModelCreationProcess creationProcess) {
        this.attributeName = attributeName;
        this.columnDefinition = columnDefinition;
        this.length = length;
        this.precision = precision;
        this.scale = scale;
        this.temporalPrecision = temporalPrecision;
        this.declaringType = declaringType;
        this.columnTableExpression = columnTableExpression;
        this.columnExpression = columnExpression;
        this.versionBasicType = versionBasicType;
        this.unsavedValueStrategy = UnsavedValueFactory.getUnsavedVersionValue((KeyValue)bootEntityDescriptor.getVersion().getValue(), (VersionJavaType)versionBasicType.getJavaTypeDescriptor(), length, precision, scale, declaringType.getRepresentationStrategy().resolvePropertyAccess(bootEntityDescriptor.getVersion()).getGetter(), templateInstanceAccess);
    }

    @Override
    public BasicAttributeMapping getVersionAttribute() {
        return (BasicAttributeMapping)this.declaringType.findAttributeMapping(this.attributeName);
    }

    @Override
    public VersionValue getUnsavedStrategy() {
        return this.unsavedValueStrategy;
    }

    @Override
    public String getContainingTableExpression() {
        return this.columnTableExpression;
    }

    @Override
    public String getSelectionExpression() {
        return this.columnExpression;
    }

    @Override
    public boolean isFormula() {
        return false;
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    @Override
    public boolean isInsertable() {
        return true;
    }

    @Override
    public boolean isUpdateable() {
        return true;
    }

    @Override
    public boolean isPartitioned() {
        return false;
    }

    @Override
    public boolean hasPartitionedSelectionMapping() {
        return false;
    }

    @Override
    public String getCustomReadExpression() {
        return null;
    }

    @Override
    public String getCustomWriteExpression() {
        return null;
    }

    @Override
    public String getColumnDefinition() {
        return this.columnDefinition;
    }

    @Override
    public Long getLength() {
        return this.length;
    }

    @Override
    public Integer getPrecision() {
        return this.precision;
    }

    @Override
    public Integer getScale() {
        return this.scale;
    }

    @Override
    public Integer getTemporalPrecision() {
        return this.temporalPrecision;
    }

    @Override
    public MappingType getPartMappingType() {
        return this.versionBasicType;
    }

    @Override
    public MappingType getMappedType() {
        return this.versionBasicType;
    }

    @Override
    public JdbcMapping getJdbcMapping() {
        return this.versionBasicType.getJdbcMapping();
    }

    @Override
    public VersionJavaType<?> getJavaType() {
        return (VersionJavaType)this.versionBasicType.getJavaTypeDescriptor();
    }

    @Override
    public String getPartName() {
        return this.attributeName;
    }

    @Override
    public NavigableRole getNavigableRole() {
        return this.getVersionAttribute().getNavigableRole();
    }

    @Override
    public EntityMappingType findContainingEntityMapping() {
        return this.declaringType;
    }

    @Override
    public String getFetchableName() {
        return this.attributeName;
    }

    @Override
    public int getFetchableKey() {
        return this.getVersionAttribute().getFetchableKey();
    }

    @Override
    public FetchOptions getMappedFetchOptions() {
        return this;
    }

    @Override
    public Fetch generateFetch(FetchParent fetchParent, NavigablePath fetchablePath, FetchTiming fetchTiming, boolean selected, String resultVariable, DomainResultCreationState creationState) {
        SqlAstCreationState sqlAstCreationState = creationState.getSqlAstCreationState();
        TableGroup tableGroup = sqlAstCreationState.getFromClauseAccess().findTableGroup(fetchParent.getNavigablePath());
        SqlExpressionResolver sqlExpressionResolver = sqlAstCreationState.getSqlExpressionResolver();
        TableReference columnTableReference = tableGroup.resolveTableReference(fetchablePath, this.columnTableExpression);
        SqlSelection sqlSelection = sqlExpressionResolver.resolveSqlSelection(sqlExpressionResolver.resolveSqlExpression(columnTableReference, this), this.versionBasicType.getJdbcJavaType(), fetchParent, sqlAstCreationState.getCreationContext().getSessionFactory().getTypeConfiguration());
        return new BasicFetch(sqlSelection.getValuesArrayPosition(), fetchParent, fetchablePath, this, fetchTiming, creationState, !sqlSelection.isVirtual());
    }

    @Override
    public <T> DomainResult<T> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, DomainResultCreationState creationState) {
        SqlSelection sqlSelection = this.resolveSqlSelection(tableGroup, creationState);
        return new BasicResult(sqlSelection.getValuesArrayPosition(), resultVariable, this.versionBasicType, navigablePath, false, !sqlSelection.isVirtual());
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState) {
        this.resolveSqlSelection(tableGroup, creationState);
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState, BiConsumer<SqlSelection, JdbcMapping> selectionConsumer) {
        selectionConsumer.accept(this.resolveSqlSelection(tableGroup, creationState), this.getJdbcMapping());
    }

    @Override
    public <X, Y> int breakDownJdbcValues(Object domainValue, int offset, X x, Y y, ModelPart.JdbcValueBiConsumer<X, Y> valueConsumer, SharedSessionContractImplementor session) {
        valueConsumer.consume(offset, x, y, domainValue, this);
        return this.getJdbcTypeCount();
    }

    private SqlSelection resolveSqlSelection(TableGroup tableGroup, DomainResultCreationState creationState) {
        SqlAstCreationState sqlAstCreationState = creationState.getSqlAstCreationState();
        SqlExpressionResolver sqlExpressionResolver = sqlAstCreationState.getSqlExpressionResolver();
        TableReference columnTableReference = tableGroup.resolveTableReference(tableGroup.getNavigablePath().append(this.getNavigableRole().getNavigableName()), this.columnTableExpression);
        return sqlExpressionResolver.resolveSqlSelection(sqlExpressionResolver.resolveSqlExpression(columnTableReference, this), this.versionBasicType.getJdbcJavaType(), null, sqlAstCreationState.getCreationContext().getSessionFactory().getTypeConfiguration());
    }

    @Override
    public FetchStyle getStyle() {
        return FetchStyle.JOIN;
    }

    @Override
    public FetchTiming getTiming() {
        return FetchTiming.IMMEDIATE;
    }

    @Override
    public Object disassemble(Object value, SharedSessionContractImplementor session) {
        return this.versionBasicType.disassemble(value, session);
    }

    @Override
    public void addToCacheKey(MutableCacheKeyBuilder cacheKey, Object value, SharedSessionContractImplementor session) {
        this.versionBasicType.addToCacheKey(cacheKey, value, session);
    }

    @Override
    public <X, Y> int forEachDisassembledJdbcValue(Object value, int offset, X x, Y y, Bindable.JdbcValuesBiConsumer<X, Y> valuesConsumer, SharedSessionContractImplementor session) {
        return this.versionBasicType.forEachDisassembledJdbcValue(value, offset, x, y, valuesConsumer, session);
    }

    @Override
    public int forEachJdbcType(int offset, IndexedConsumer<JdbcMapping> action) {
        action.accept(offset, this.getJdbcMapping());
        return this.getJdbcTypeCount();
    }
}

