/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.hibernate.AssertionFailure;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.boot.model.internal.SoftDeleteHelper;
import org.hibernate.cache.MutableCacheKeyBuilder;
import org.hibernate.engine.FetchStyle;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.IndexedConsumer;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.OneToOne;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.ToOne;
import org.hibernate.mapping.Value;
import org.hibernate.metamodel.UnsupportedMappingException;
import org.hibernate.metamodel.mapping.AssociationKey;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.AttributeMetadata;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.EntityAssociationMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.EntityValuedModelPart;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.ManagedMappingType;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.ModelPartContainer;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.SelectableConsumer;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.SelectablePath;
import org.hibernate.metamodel.mapping.SoftDeleteMapping;
import org.hibernate.metamodel.mapping.ValuedModelPart;
import org.hibernate.metamodel.mapping.VirtualModelPart;
import org.hibernate.metamodel.mapping.internal.AbstractSingularAttributeMapping;
import org.hibernate.metamodel.mapping.internal.EmbeddedCollectionPart;
import org.hibernate.metamodel.mapping.internal.EmbeddedIdentifierMappingImpl;
import org.hibernate.metamodel.mapping.internal.EntityCollectionPart;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationHelper;
import org.hibernate.metamodel.mapping.internal.SingleAttributeIdentifierMapping;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.persister.collection.AbstractCollectionPersister;
import org.hibernate.persister.entity.EntityNameUse;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.JoinedSubclassEntityPersister;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.spi.EntityIdentifierNavigablePath;
import org.hibernate.spi.NavigablePath;
import org.hibernate.spi.TreatedNavigablePath;
import org.hibernate.sql.ast.SqlAstJoinType;
import org.hibernate.sql.ast.spi.FromClauseAccess;
import org.hibernate.sql.ast.spi.SqlAliasBase;
import org.hibernate.sql.ast.spi.SqlAliasStemHelper;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.from.CorrelatedTableGroup;
import org.hibernate.sql.ast.tree.from.LazyTableGroup;
import org.hibernate.sql.ast.tree.from.MappedByTableGroup;
import org.hibernate.sql.ast.tree.from.PluralTableGroup;
import org.hibernate.sql.ast.tree.from.StandardTableGroup;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableGroupJoinProducer;
import org.hibernate.sql.ast.tree.from.TableGroupProducer;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.TableReferenceJoin;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchOptions;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.sql.results.graph.FetchableContainer;
import org.hibernate.sql.results.graph.InitializerParent;
import org.hibernate.sql.results.graph.embeddable.EmbeddableValuedFetchable;
import org.hibernate.sql.results.graph.entity.EntityFetch;
import org.hibernate.sql.results.graph.entity.EntityValuedFetchable;
import org.hibernate.sql.results.graph.entity.internal.EntityDelayedFetchImpl;
import org.hibernate.sql.results.graph.entity.internal.EntityFetchJoinedImpl;
import org.hibernate.sql.results.graph.entity.internal.EntityFetchSelectImpl;
import org.hibernate.sql.results.internal.NullValueAssembler;
import org.hibernate.sql.results.internal.domain.CircularBiDirectionalFetchImpl;
import org.hibernate.sql.results.internal.domain.CircularFetchImpl;
import org.hibernate.type.CompositeType;
import org.hibernate.type.EmbeddedComponentType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.java.JavaType;

public class ToOneAttributeMapping
extends AbstractSingularAttributeMapping
implements EntityValuedFetchable,
EntityAssociationMapping,
TableGroupJoinProducer,
LazyTableGroup.ParentTableGroupUseChecker {
    private final NavigableRole navigableRole;
    private final String sqlAliasStem;
    private final boolean isNullable;
    private final boolean isLazy;
    private final boolean isKeyTableNullable;
    private final boolean isInternalLoadNullable;
    private final NotFoundAction notFoundAction;
    private final boolean unwrapProxy;
    private final boolean isOptional;
    private final EntityMappingType entityMappingType;
    private final String referencedPropertyName;
    private final String targetKeyPropertyName;
    private final Set<String> targetKeyPropertyNames;
    private final Cardinality cardinality;
    private final boolean hasJoinTable;
    private final SelectablePath bidirectionalAttributePath;
    private final TableGroupProducer declaringTableGroupProducer;
    private ForeignKeyDescriptor foreignKeyDescriptor;
    private ForeignKeyDescriptor.Nature sideNature;
    private String identifyingColumnsTableExpression;
    private boolean canUseParentTableGroup;

    protected ToOneAttributeMapping(ToOneAttributeMapping original) {
        super(original);
        this.navigableRole = original.navigableRole;
        this.isInternalLoadNullable = original.isInternalLoadNullable;
        this.notFoundAction = original.notFoundAction;
        this.unwrapProxy = original.unwrapProxy;
        this.isOptional = original.isOptional;
        this.entityMappingType = original.entityMappingType;
        this.referencedPropertyName = original.referencedPropertyName;
        this.targetKeyPropertyName = original.targetKeyPropertyName;
        this.cardinality = original.cardinality;
        this.hasJoinTable = original.hasJoinTable;
        this.bidirectionalAttributePath = original.bidirectionalAttributePath;
        this.declaringTableGroupProducer = original.declaringTableGroupProducer;
        this.isKeyTableNullable = original.isKeyTableNullable;
        this.sqlAliasStem = original.sqlAliasStem;
        this.targetKeyPropertyNames = original.targetKeyPropertyNames;
        this.isNullable = original.isNullable;
        this.isLazy = original.isLazy;
        this.foreignKeyDescriptor = original.foreignKeyDescriptor;
        this.sideNature = original.sideNature;
        this.identifyingColumnsTableExpression = original.identifyingColumnsTableExpression;
        this.canUseParentTableGroup = original.canUseParentTableGroup;
    }

    public ToOneAttributeMapping(String name, NavigableRole navigableRole, int stateArrayPosition, int fetchableIndex, ToOne bootValue, AttributeMetadata attributeMetadata, FetchOptions mappedFetchOptions, EntityMappingType entityMappingType, ManagedMappingType declaringType, EntityPersister declaringEntityPersister, PropertyAccess propertyAccess) {
        this(name, navigableRole, stateArrayPosition, fetchableIndex, bootValue, attributeMetadata, mappedFetchOptions.getTiming(), mappedFetchOptions.getStyle(), entityMappingType, declaringType, declaringEntityPersister, propertyAccess);
    }

    public ToOneAttributeMapping(String name, NavigableRole navigableRole, int stateArrayPosition, int fetchableIndex, ToOne bootValue, AttributeMetadata attributeMetadata, FetchTiming mappedFetchTiming, FetchStyle mappedFetchStyle, EntityMappingType entityMappingType, ManagedMappingType declaringType, EntityPersister declaringEntityPersister, PropertyAccess propertyAccess) {
        super(name, stateArrayPosition, fetchableIndex, attributeMetadata, ToOneAttributeMapping.adjustFetchTiming(mappedFetchTiming, bootValue, entityMappingType), mappedFetchStyle, declaringType, propertyAccess);
        PersistentClass entityBinding;
        this.sqlAliasStem = SqlAliasStemHelper.INSTANCE.generateStemFromAttributeName(name);
        this.isNullable = bootValue.isNullable();
        this.isLazy = navigableRole.getParent().getParent() == null && declaringEntityPersister.getBytecodeEnhancementMetadata().getLazyAttributesMetadata().isLazyAttribute(name);
        this.referencedPropertyName = bootValue.getReferencedPropertyName();
        this.unwrapProxy = bootValue.isUnwrapProxy();
        this.entityMappingType = entityMappingType;
        this.navigableRole = navigableRole;
        this.declaringTableGroupProducer = ToOneAttributeMapping.resolveDeclaringTableGroupProducer(declaringEntityPersister, navigableRole);
        if (bootValue instanceof ManyToOne) {
            ManyToOne manyToOne = (ManyToOne)bootValue;
            this.notFoundAction = ((ManyToOne)bootValue).getNotFoundAction();
            this.cardinality = manyToOne.isLogicalOneToOne() ? Cardinality.LOGICAL_ONE_TO_ONE : Cardinality.MANY_TO_ONE;
            entityBinding = manyToOne.getMetadata().getEntityBinding(manyToOne.getReferencedEntityName());
            if (this.referencedPropertyName == null) {
                String propertyPath;
                SelectablePath bidirectionalAttributeName = null;
                String string = propertyPath = bootValue.getPropertyName() == null ? name : bootValue.getPropertyName();
                if (this.cardinality == Cardinality.LOGICAL_ONE_TO_ONE) {
                    boolean hasJoinTable = false;
                    for (Join join : entityBinding.getJoinClosure()) {
                        if (!join.getPersistentClass().getEntityName().equals(entityBinding.getEntityName()) || join.getPropertySpan() != 1 || join.getTable() != manyToOne.getTable() || !ToOneAttributeMapping.equal(join.getKey(), manyToOne)) continue;
                        bidirectionalAttributeName = SelectablePath.parse(join.getProperties().get(0).getName());
                        hasJoinTable = true;
                        break;
                    }
                    if (bidirectionalAttributeName == null) {
                        bidirectionalAttributeName = this.findBidirectionalOneToOneAttributeName(propertyPath, declaringType, null, entityBinding.getPropertyClosure());
                    }
                    this.hasJoinTable = hasJoinTable;
                } else {
                    this.hasJoinTable = false;
                    bidirectionalAttributeName = ToOneAttributeMapping.findBidirectionalOneToManyAttributeName(propertyPath, declaringType, null, entityBinding.getPropertyClosure());
                }
                this.bidirectionalAttributePath = bidirectionalAttributeName;
            } else {
                Property property = entityBinding.getProperty(this.referencedPropertyName);
                this.hasJoinTable = this.cardinality == Cardinality.LOGICAL_ONE_TO_ONE && property != null && property.getValue() instanceof ManyToOne && ((ManyToOne)property.getValue()).isLogicalOneToOne();
                SelectablePath selectablePath = this.bidirectionalAttributePath = property != null && property.getValue().getType() instanceof EntityType ? SelectablePath.parse(this.referencedPropertyName) : null;
            }
            if (bootValue.isNullable()) {
                this.isKeyTableNullable = true;
            } else {
                String targetTableName = MappingModelCreationHelper.getTableIdentifierExpression(manyToOne.getTable(), declaringEntityPersister.getFactory());
                if (CollectionPart.Nature.fromNameExact(navigableRole.getParent().getLocalName()) != null) {
                    PluralAttributeMapping pluralAttribute = (PluralAttributeMapping)declaringEntityPersister.findByPath(navigableRole.getParent().getParent().getFullPath().substring(declaringEntityPersister.getNavigableRole().getFullPath().length() + 1));
                    assert (pluralAttribute != null);
                    AbstractCollectionPersister persister = (AbstractCollectionPersister)pluralAttribute.getCollectionDescriptor();
                    this.isKeyTableNullable = !persister.getTableName().equals(targetTableName);
                } else {
                    int tableIndex = ArrayHelper.indexOf(declaringEntityPersister.getTableNames(), targetTableName);
                    this.isKeyTableNullable = declaringEntityPersister.isNullableTable(tableIndex);
                }
            }
            this.isOptional = ((ManyToOne)bootValue).isIgnoreNotFound();
            this.isInternalLoadNullable = this.isNullable && bootValue.isForeignKeyEnabled() || this.hasNotFoundAction();
        } else {
            assert (bootValue instanceof OneToOne);
            this.cardinality = Cardinality.ONE_TO_ONE;
            this.hasJoinTable = false;
            OneToOne oneToOne = (OneToOne)bootValue;
            this.bidirectionalAttributePath = oneToOne.getMappedByProperty() == null ? SelectablePath.parse(this.referencedPropertyName) : SelectablePath.parse(oneToOne.getMappedByProperty());
            this.notFoundAction = null;
            this.isKeyTableNullable = this.isNullable();
            this.isOptional = !bootValue.isConstrained();
            this.isInternalLoadNullable = this.isNullable();
        }
        if (entityMappingType.getSoftDeleteMapping() != null && this.getTiming() == FetchTiming.DELAYED) {
            throw new UnsupportedMappingException(String.format(Locale.ROOT, "To-one attribute (%s.%s) cannot be mapped as LAZY as its associated entity is defined with @SoftDelete", declaringType.getPartName(), this.getAttributeName()));
        }
        if (this.referencedPropertyName == null) {
            HashSet<String> targetKeyPropertyNames = new HashSet<String>(2);
            targetKeyPropertyNames.add("{id}");
            entityBinding = bootValue.getBuildingContext().getMetadataCollector().getEntityBinding(entityMappingType.getEntityName());
            Type propertyType = entityBinding.getIdentifierMapper() == null ? entityBinding.getIdentifier().getType() : entityBinding.getIdentifierMapper().getType();
            if (entityBinding.getIdentifierProperty() == null) {
                CompositeType compositeType;
                if (propertyType.isComponentType() && (compositeType = (CompositeType)propertyType).isEmbedded() && compositeType.getPropertyNames().length == 1) {
                    this.targetKeyPropertyName = compositeType.getPropertyNames()[0];
                    ToOneAttributeMapping.addPrefixedPropertyPaths(targetKeyPropertyNames, this.targetKeyPropertyName, compositeType.getSubtypes()[0], declaringEntityPersister.getFactory());
                    ToOneAttributeMapping.addPrefixedPropertyNames(targetKeyPropertyNames, "{id}", propertyType, declaringEntityPersister.getFactory());
                } else {
                    this.targetKeyPropertyName = "{id}";
                    ToOneAttributeMapping.addPrefixedPropertyPaths(targetKeyPropertyNames, null, propertyType, declaringEntityPersister.getFactory());
                }
            } else {
                this.targetKeyPropertyName = entityBinding.getIdentifierProperty().getName();
                ToOneAttributeMapping.addPrefixedPropertyPaths(targetKeyPropertyNames, this.targetKeyPropertyName, propertyType, declaringEntityPersister.getFactory());
            }
            this.targetKeyPropertyNames = targetKeyPropertyNames;
        } else {
            CompositeType compositeType;
            PersistentClass entityBinding2 = bootValue.getBuildingContext().getMetadataCollector().getEntityBinding(entityMappingType.getEntityName());
            Type propertyType = entityBinding2.getRecursiveProperty(this.referencedPropertyName).getType();
            if (bootValue.isReferenceToPrimaryKey()) {
                this.targetKeyPropertyName = this.referencedPropertyName;
                HashSet<String> targetKeyPropertyNames = new HashSet<String>(3);
                ToOneAttributeMapping.addPrefixedPropertyNames(targetKeyPropertyNames, this.targetKeyPropertyName, propertyType, declaringEntityPersister.getFactory());
                ToOneAttributeMapping.addPrefixedPropertyNames(targetKeyPropertyNames, null, bootValue.getType(), declaringEntityPersister.getFactory());
                this.targetKeyPropertyNames = targetKeyPropertyNames;
            } else if (propertyType.isComponentType() && (compositeType = (CompositeType)propertyType).isEmbedded() && compositeType.getPropertyNames().length == 1) {
                HashSet<String> targetKeyPropertyNames = new HashSet<String>(2);
                this.targetKeyPropertyName = compositeType.getPropertyNames()[0];
                ToOneAttributeMapping.addPrefixedPropertyPaths(targetKeyPropertyNames, this.targetKeyPropertyName, compositeType.getSubtypes()[0], declaringEntityPersister.getFactory());
                ToOneAttributeMapping.addPrefixedPropertyNames(targetKeyPropertyNames, "{id}", propertyType, declaringEntityPersister.getFactory());
                this.targetKeyPropertyNames = targetKeyPropertyNames;
            } else {
                HashSet<String> targetKeyPropertyNames = new HashSet<String>(2);
                this.targetKeyPropertyName = this.referencedPropertyName;
                String mapsIdAttributeName = ToOneAttributeMapping.findMapsIdPropertyName(entityMappingType, this.referencedPropertyName);
                if (mapsIdAttributeName != null) {
                    ToOneAttributeMapping.addPrefixedPropertyPaths(targetKeyPropertyNames, mapsIdAttributeName, entityMappingType.getEntityPersister().getIdentifierType(), declaringEntityPersister.getFactory());
                }
                ToOneAttributeMapping.addPrefixedPropertyNames(targetKeyPropertyNames, this.targetKeyPropertyName, propertyType, declaringEntityPersister.getFactory());
                ToOneAttributeMapping.addPrefixedPropertyNames(targetKeyPropertyNames, "{fk}", propertyType, declaringEntityPersister.getFactory());
                this.targetKeyPropertyNames = targetKeyPropertyNames;
            }
        }
    }

    private static SelectablePath findBidirectionalOneToManyAttributeName(String propertyPath, ManagedMappingType declaringType, SelectablePath parentSelectablePath, Collection<Property> properties) {
        for (Property property : properties) {
            org.hibernate.mapping.Collection collection;
            SelectablePath bidirectionalAttributeName;
            Value value = property.getValue();
            if (value instanceof Component && (bidirectionalAttributeName = ToOneAttributeMapping.findBidirectionalOneToManyAttributeName(propertyPath, declaringType, parentSelectablePath == null ? SelectablePath.parse(property.getName()) : parentSelectablePath.append(property.getName()), ((Component)value).getProperties())) != null) {
                return bidirectionalAttributeName;
            }
            if (!(value instanceof org.hibernate.mapping.Collection) || !propertyPath.equals((collection = (org.hibernate.mapping.Collection)value).getMappedByProperty()) || !collection.getElement().getType().getName().equals(declaringType.getJavaType().getTypeName())) continue;
            return parentSelectablePath == null ? SelectablePath.parse(property.getName()) : parentSelectablePath.append(property.getName());
        }
        return null;
    }

    private SelectablePath findBidirectionalOneToOneAttributeName(String propertyPath, ManagedMappingType declaringType, SelectablePath parentSelectablePath, Collection<Property> properties) {
        for (Property property : properties) {
            Value value = property.getValue();
            if (value instanceof Component) {
                SelectablePath bidirectionalAttributeName = this.findBidirectionalOneToOneAttributeName(propertyPath, declaringType, parentSelectablePath == null ? SelectablePath.parse(property.getName()) : parentSelectablePath.append(property.getName()), ((Component)value).getProperties());
                if (bidirectionalAttributeName == null) continue;
                return bidirectionalAttributeName;
            }
            if (!(value instanceof OneToOne)) continue;
            OneToOne oneToOne = (OneToOne)value;
            if (!this.declaringTableGroupProducer.getNavigableRole().getLocalName().equals(oneToOne.getReferencedEntityName()) || !propertyPath.equals(oneToOne.getMappedByProperty()) || !oneToOne.getReferencedEntityName().equals(declaringType.getJavaType().getTypeName())) continue;
            return parentSelectablePath == null ? SelectablePath.parse(property.getName()) : parentSelectablePath.append(property.getName());
        }
        return null;
    }

    private static FetchTiming adjustFetchTiming(FetchTiming mappedFetchTiming, ToOne bootValue, EntityMappingType entityMappingType) {
        if (bootValue instanceof ManyToOne && ((ManyToOne)bootValue).getNotFoundAction() != null) {
            return FetchTiming.IMMEDIATE;
        }
        return mappedFetchTiming;
    }

    private static TableGroupProducer resolveDeclaringTableGroupProducer(EntityPersister declaringEntityPersister, NavigableRole navigableRole) {
        NavigableRole parentRole = navigableRole.getParent();
        String collectionRole = null;
        do {
            CollectionPart.Nature nature;
            if ((nature = CollectionPart.Nature.fromNameExact(parentRole.getLocalName())) == null) continue;
            collectionRole = parentRole.getParent().getFullPath();
            break;
        } while ((parentRole = parentRole.getParent()) != null);
        if (collectionRole != null) {
            return declaringEntityPersister.getFactory().getMappingMetamodel().findCollectionDescriptor(collectionRole).getAttributeMapping();
        }
        return declaringEntityPersister;
    }

    private ToOneAttributeMapping(ToOneAttributeMapping original, ManagedMappingType declaringType, TableGroupProducer declaringTableGroupProducer) {
        super(original.getAttributeName(), original.getStateArrayPosition(), original.getFetchableKey(), original.getAttributeMetadata(), original, declaringType, original.getPropertyAccess());
        this.navigableRole = original.navigableRole;
        this.sqlAliasStem = original.sqlAliasStem;
        this.isNullable = original.isNullable;
        this.isLazy = original.isLazy;
        this.isKeyTableNullable = original.isKeyTableNullable;
        this.isOptional = original.isOptional;
        this.notFoundAction = original.notFoundAction;
        this.unwrapProxy = original.unwrapProxy;
        this.entityMappingType = original.entityMappingType;
        this.referencedPropertyName = original.referencedPropertyName;
        this.targetKeyPropertyName = original.targetKeyPropertyName;
        this.targetKeyPropertyNames = original.targetKeyPropertyNames;
        this.cardinality = original.cardinality;
        this.hasJoinTable = original.hasJoinTable;
        this.bidirectionalAttributePath = original.bidirectionalAttributePath;
        this.declaringTableGroupProducer = declaringTableGroupProducer;
        this.isInternalLoadNullable = original.isInternalLoadNullable;
    }

    private static boolean equal(Value lhsValue, Value rhsValue) {
        List<Selectable> lhsColumns = lhsValue.getSelectables();
        List<Selectable> rhsColumns = rhsValue.getSelectables();
        if (lhsColumns.size() != rhsColumns.size()) {
            return false;
        }
        for (int i = 0; i < lhsColumns.size(); ++i) {
            Selectable lhs = lhsColumns.get(i);
            Selectable rhs = rhsColumns.get(i);
            if (lhs.getText().equals(rhs.getText())) continue;
            return false;
        }
        return true;
    }

    static String findMapsIdPropertyName(EntityMappingType entityMappingType, String referencedPropertyName) {
        EntityPersister persister = entityMappingType.getEntityPersister();
        if (Arrays.equals(persister.getIdentifierColumnNames(), persister.getPropertyColumnNames(referencedPropertyName))) {
            return persister.getIdentifierPropertyName();
        }
        return null;
    }

    public static void addPrefixedPropertyPaths(Set<String> targetKeyPropertyNames, String prefix, Type type, SessionFactoryImplementor factory) {
        ToOneAttributeMapping.addPrefixedPropertyNames(targetKeyPropertyNames, prefix, type, factory);
        ToOneAttributeMapping.addPrefixedPropertyNames(targetKeyPropertyNames, "{fk}", type, factory);
        ToOneAttributeMapping.addPrefixedPropertyNames(targetKeyPropertyNames, "{id}", type, factory);
    }

    public static void addPrefixedPropertyNames(Set<String> targetKeyPropertyNames, String prefix, Type type, SessionFactoryImplementor factory) {
        if (prefix != null) {
            targetKeyPropertyNames.add(prefix);
        }
        if (type.isComponentType()) {
            CompositeType componentType = (CompositeType)type;
            String[] propertyNames = componentType.getPropertyNames();
            Type[] componentTypeSubtypes = componentType.getSubtypes();
            int propertyNamesLength = propertyNames.length;
            for (int i = 0; i < propertyNamesLength; ++i) {
                Object newPrefix = prefix == null ? propertyNames[i] : prefix + "." + propertyNames[i];
                ToOneAttributeMapping.addPrefixedPropertyNames(targetKeyPropertyNames, (String)newPrefix, componentTypeSubtypes[i], factory);
            }
        } else if (type.isEntityType()) {
            Object newFkPrefix;
            Object newPkPrefix;
            Object newPrefix;
            EntityType entityType = (EntityType)type;
            Type identifierOrUniqueKeyType = entityType.getIdentifierOrUniqueKeyType(factory);
            Object propertyName = entityType.isReferenceToPrimaryKey() ? entityType.getAssociatedEntityPersister(factory).getIdentifierPropertyName() : (identifierOrUniqueKeyType instanceof EmbeddedComponentType ? null : entityType.getRHSUniqueKeyPropertyName());
            if (prefix == null) {
                newPrefix = propertyName;
                newPkPrefix = "{id}";
                newFkPrefix = "{fk}";
            } else if (propertyName == null) {
                newPrefix = prefix;
                newPkPrefix = prefix + ".{id}";
                newFkPrefix = prefix + ".{fk}";
            } else {
                newPrefix = prefix + "." + (String)propertyName;
                newPkPrefix = prefix + ".{id}";
                newFkPrefix = prefix + ".{fk}";
            }
            ToOneAttributeMapping.addPrefixedPropertyNames(targetKeyPropertyNames, (String)newPrefix, identifierOrUniqueKeyType, factory);
            ToOneAttributeMapping.addPrefixedPropertyNames(targetKeyPropertyNames, (String)newPkPrefix, identifierOrUniqueKeyType, factory);
            ToOneAttributeMapping.addPrefixedPropertyNames(targetKeyPropertyNames, (String)newFkPrefix, identifierOrUniqueKeyType, factory);
            if (identifierOrUniqueKeyType instanceof EmbeddedComponentType) {
                Object newEmbeddedFkPrefix;
                Object newEmbeddedPkPrefix;
                if (prefix == null) {
                    newEmbeddedPkPrefix = "{id}";
                    newEmbeddedFkPrefix = "{fk}";
                } else {
                    newEmbeddedPkPrefix = prefix + ".{id}";
                    newEmbeddedFkPrefix = prefix + ".{fk}";
                }
                ToOneAttributeMapping.addPrefixedPropertyNames(targetKeyPropertyNames, (String)newEmbeddedPkPrefix, identifierOrUniqueKeyType, factory);
                ToOneAttributeMapping.addPrefixedPropertyNames(targetKeyPropertyNames, (String)newEmbeddedFkPrefix, identifierOrUniqueKeyType, factory);
            }
        }
    }

    public ToOneAttributeMapping copy(ManagedMappingType declaringType, TableGroupProducer declaringTableGroupProducer) {
        return new ToOneAttributeMapping(this, declaringType, declaringTableGroupProducer);
    }

    @Override
    public void setForeignKeyDescriptor(ForeignKeyDescriptor foreignKeyDescriptor) {
        assert (this.identifyingColumnsTableExpression != null);
        this.foreignKeyDescriptor = foreignKeyDescriptor;
        this.sideNature = this.cardinality == Cardinality.ONE_TO_ONE && this.bidirectionalAttributePath != null ? ForeignKeyDescriptor.Nature.TARGET : (foreignKeyDescriptor.getAssociationKey().getTable().equals(this.identifyingColumnsTableExpression) ? ForeignKeyDescriptor.Nature.KEY : ForeignKeyDescriptor.Nature.TARGET);
        boolean forceJoin = this.hasNotFoundAction() || this.cardinality == Cardinality.ONE_TO_ONE && this.isNullable();
        this.canUseParentTableGroup = !forceJoin && this.sideNature == ForeignKeyDescriptor.Nature.KEY && this.declaringTableGroupProducer.containsTableReference(this.identifyingColumnsTableExpression);
    }

    public String getIdentifyingColumnsTableExpression() {
        return this.identifyingColumnsTableExpression;
    }

    public void setIdentifyingColumnsTableExpression(String tableExpression) {
        this.identifyingColumnsTableExpression = tableExpression;
    }

    @Override
    public ForeignKeyDescriptor getForeignKeyDescriptor() {
        return this.foreignKeyDescriptor;
    }

    @Override
    public ForeignKeyDescriptor.Nature getSideNature() {
        return this.sideNature;
    }

    @Override
    public boolean isReferenceToPrimaryKey() {
        return this.foreignKeyDescriptor.getSide(this.sideNature.inverse()).getModelPart().isEntityIdentifierMapping();
    }

    @Override
    public boolean isFkOptimizationAllowed() {
        return this.canUseParentTableGroup;
    }

    @Override
    public boolean hasPartitionedSelectionMapping() {
        return this.foreignKeyDescriptor.hasPartitionedSelectionMapping();
    }

    public String getReferencedPropertyName() {
        return this.referencedPropertyName;
    }

    public String getTargetKeyPropertyName() {
        return this.targetKeyPropertyName;
    }

    @Override
    public Set<String> getTargetKeyPropertyNames() {
        return this.targetKeyPropertyNames;
    }

    public Cardinality getCardinality() {
        return this.cardinality;
    }

    @Override
    public EntityMappingType getMappedType() {
        return this.getEntityMappingType();
    }

    @Override
    public EntityMappingType getEntityMappingType() {
        return this.entityMappingType;
    }

    @Override
    public NavigableRole getNavigableRole() {
        return this.navigableRole;
    }

    @Override
    public ModelPart findSubPart(String name) {
        return this.findSubPart(name, null);
    }

    @Override
    public ModelPart findSubPart(String name, EntityMappingType targetType) {
        if (this.canUseParentTableGroup && this.targetKeyPropertyNames.contains(name)) {
            ValuedModelPart fkPart = this.sideNature == ForeignKeyDescriptor.Nature.KEY ? this.foreignKeyDescriptor.getKeyPart() : this.foreignKeyDescriptor.getTargetPart();
            if (fkPart instanceof EmbeddableValuedModelPart && fkPart instanceof VirtualModelPart && !"{id}".equals(name) && !"{fk}".equals(name) && !"{fk-target}".equals(name) && !fkPart.getPartName().equals(name)) {
                return ((ModelPartContainer)((Object)fkPart)).findSubPart(name, targetType);
            }
            return fkPart;
        }
        return EntityValuedFetchable.super.findSubPart(name, targetType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Fetch resolveCircularFetch(NavigablePath fetchablePath, FetchParent fetchParent, FetchTiming fetchTiming, DomainResultCreationState creationState) {
        AssociationKey associationKey = this.foreignKeyDescriptor.getAssociationKey();
        boolean associationKeyVisited = creationState.isAssociationKeyVisited(associationKey);
        if (associationKeyVisited || this.bidirectionalAttributePath != null) {
            DomainResult<?> foreignKeyDomainResult;
            if (!associationKeyVisited && creationState.isRegisteringVisitedAssociationKeys()) {
                return null;
            }
            NavigablePath parentNavigablePath = fetchablePath.getParent();
            assert (parentNavigablePath.equals(fetchParent.getNavigablePath()));
            if (parentNavigablePath.getLocalName().equals("{fk}") || parentNavigablePath.getLocalName().equals("{fk-target}")) {
                return null;
            }
            ModelPart parentModelPart = creationState.resolveModelPart(parentNavigablePath);
            if (parentModelPart instanceof EmbeddedIdentifierMappingImpl) {
                while (parentNavigablePath instanceof EntityIdentifierNavigablePath) {
                    parentNavigablePath = parentNavigablePath.getParent();
                    assert (parentNavigablePath != null);
                    parentModelPart = creationState.resolveModelPart(parentNavigablePath);
                }
            }
            while (parentModelPart instanceof EmbeddableValuedFetchable) {
                parentNavigablePath = parentNavigablePath.getParent();
                assert (parentNavigablePath != null);
                parentModelPart = creationState.resolveModelPart(parentNavigablePath);
            }
            if (this.isBidirectionalAttributeName(parentNavigablePath, parentModelPart, fetchablePath, creationState)) {
                return this.createCircularBiDirectionalFetch(fetchablePath, fetchParent, parentNavigablePath, fetchTiming, creationState);
            }
            TableGroup parentTableGroup = creationState.getSqlAstCreationState().getFromClauseAccess().getTableGroup(fetchParent.getNavigablePath());
            assert (!creationState.isResolvingCircularFetch());
            try {
                creationState.setResolvingCircularFetch(true);
                foreignKeyDomainResult = this.sideNature == ForeignKeyDescriptor.Nature.KEY ? this.foreignKeyDescriptor.createKeyDomainResult(fetchablePath, this.createTableGroupForDelayedFetch(fetchablePath, parentTableGroup, null, creationState), fetchParent, creationState) : this.foreignKeyDescriptor.createTargetDomainResult(fetchablePath, parentTableGroup, fetchParent, creationState);
            }
            finally {
                creationState.setResolvingCircularFetch(false);
            }
            return new CircularFetchImpl(this, fetchTiming, fetchablePath, fetchParent, this.isSelectByUniqueKey(this.sideNature), parentNavigablePath, foreignKeyDomainResult, creationState);
        }
        return null;
    }

    protected boolean isBidirectionalAttributeName(NavigablePath parentNavigablePath, ModelPart parentModelPart, NavigablePath fetchablePath, DomainResultCreationState creationState) {
        if (this.bidirectionalAttributePath == null) {
            if (parentModelPart instanceof ToOneAttributeMapping) {
                ToOneAttributeMapping toOneAttributeMapping = (ToOneAttributeMapping)parentModelPart;
                if (toOneAttributeMapping.bidirectionalAttributePath != null) {
                    return toOneAttributeMapping.isBidirectionalAttributeName(fetchablePath, this, parentNavigablePath, creationState);
                }
            } else {
                if (parentModelPart instanceof PluralAttributeMapping) {
                    return parentNavigablePath.getParent() != null && ((PluralAttributeMapping)parentModelPart).isBidirectionalAttributeName(fetchablePath, this);
                }
                if (parentModelPart instanceof EntityCollectionPart) {
                    NavigablePath parentOfParent = parentNavigablePath.getParent();
                    if (parentOfParent instanceof EntityIdentifierNavigablePath) {
                        parentOfParent = parentOfParent.getParent();
                    }
                    return parentOfParent.getParent() != null && ((PluralAttributeMapping)creationState.resolveModelPart(parentOfParent)).isBidirectionalAttributeName(fetchablePath, this);
                }
            }
            return false;
        }
        if (this.isParentEmbeddedCollectionPart(creationState, parentNavigablePath.getParent())) {
            return false;
        }
        if (this.cardinality == Cardinality.MANY_TO_ONE) {
            NavigablePath grandparentNavigablePath = parentNavigablePath.getParent();
            if (parentNavigablePath.getLocalName().equals(CollectionPart.Nature.ELEMENT.getName()) && grandparentNavigablePath != null && grandparentNavigablePath.isSuffix(this.bidirectionalAttributePath)) {
                NavigablePath parentPath = grandparentNavigablePath.getParent();
                if (parentPath == null) {
                    return grandparentNavigablePath.getFullPath().equals(this.entityMappingType.findByPath(this.bidirectionalAttributePath).getNavigableRole().getFullPath());
                }
                if (parentPath.getParent() == null) {
                    String entityName = this.entityMappingType.getPartName();
                    return parentPath.getFullPath().startsWith(entityName) && (parentPath.getFullPath().length() == entityName.length() || parentPath.getFullPath().charAt(entityName.length()) == '(');
                }
                return parentPath.getLocalName().equals(this.navigableRole.getLocalName());
            }
            return false;
        }
        NavigablePath navigablePath = parentNavigablePath.trimSuffix(this.bidirectionalAttributePath);
        if (navigablePath != null) {
            String localName = navigablePath.getLocalName();
            if (localName.equals("{id}") || localName.equals("{fk}") || localName.equals("{fk-target}")) {
                navigablePath = navigablePath.getParent();
            }
            return creationState.resolveModelPart(navigablePath).getPartMappingType() == this.entityMappingType;
        }
        return false;
    }

    private boolean isParentEmbeddedCollectionPart(DomainResultCreationState creationState, NavigablePath parentNavigablePath) {
        while (parentNavigablePath != null) {
            ModelPart parentModelPart = creationState.resolveModelPart(parentNavigablePath);
            if (parentModelPart instanceof EmbeddedCollectionPart) {
                return true;
            }
            if (parentModelPart instanceof EmbeddableValuedModelPart) {
                parentNavigablePath = parentNavigablePath.getParent();
                continue;
            }
            return false;
        }
        return false;
    }

    private Fetch createCircularBiDirectionalFetch(NavigablePath fetchablePath, FetchParent fetchParent, NavigablePath parentNavigablePath, FetchTiming fetchTiming, DomainResultCreationState creationState) {
        boolean hasBidirectionalFetchParent;
        NavigablePath referencedNavigablePath;
        FetchParent realFetchParent = fetchParent;
        while (realFetchParent.getNavigablePath() != parentNavigablePath) {
            realFetchParent = ((Fetch)((Object)fetchParent)).getFetchParent();
        }
        if (parentNavigablePath.getParent() == null) {
            referencedNavigablePath = parentNavigablePath;
            hasBidirectionalFetchParent = true;
        } else if (CollectionPart.Nature.fromNameExact(parentNavigablePath.getLocalName()) != null) {
            referencedNavigablePath = this.getReferencedNavigablePath(creationState, parentNavigablePath.getParent());
            hasBidirectionalFetchParent = fetchParent instanceof Fetch && ((Fetch)((Object)fetchParent)).getFetchParent() instanceof Fetch;
        } else {
            referencedNavigablePath = this.getReferencedNavigablePath(creationState, parentNavigablePath);
            hasBidirectionalFetchParent = fetchParent instanceof Fetch;
        }
        if (referencedNavigablePath != null) {
            DomainResult<?> keyDomainResult = this.sideNature == ForeignKeyDescriptor.Nature.KEY && !this.isKeyTableNullable ? this.foreignKeyDescriptor.createKeyDomainResult(fetchablePath, this.createTableGroupForDelayedFetch(fetchablePath, creationState.getSqlAstCreationState().getFromClauseAccess().findTableGroup(realFetchParent.getNavigablePath()), null, creationState), fetchParent, creationState) : null;
            if (hasBidirectionalFetchParent) {
                return new CircularBiDirectionalFetchImpl(FetchTiming.IMMEDIATE, fetchablePath, fetchParent, this, referencedNavigablePath, keyDomainResult);
            }
            FromClauseAccess fromClauseAccess = creationState.getSqlAstCreationState().getFromClauseAccess();
            TableGroup tableGroup = fromClauseAccess.getTableGroup(referencedNavigablePath);
            fromClauseAccess.registerTableGroup(fetchablePath, tableGroup);
            creationState.getSqlAstCreationState().registerEntityNameUsage(tableGroup, EntityNameUse.PROJECTION, this.entityMappingType.getEntityName());
            return this.buildEntityFetchJoined(fetchParent, this, tableGroup, keyDomainResult, false, fetchablePath, creationState);
        }
        FromClauseAccess fromClauseAccess = creationState.getSqlAstCreationState().getFromClauseAccess();
        NavigablePath realParent = CollectionPart.Nature.fromNameExact(parentNavigablePath.getLocalName()) != null ? parentNavigablePath.getParent() : parentNavigablePath;
        TableGroup parentTableGroup = fromClauseAccess.getTableGroup(realParent);
        DomainResult<?> domainResult = this.sideNature == ForeignKeyDescriptor.Nature.KEY ? this.foreignKeyDescriptor.createKeyDomainResult(fetchablePath, this.createTableGroupForDelayedFetch(fetchablePath, parentTableGroup, null, creationState), fetchParent, creationState) : this.foreignKeyDescriptor.createTargetDomainResult(fetchablePath, parentTableGroup, fetchParent, creationState);
        if (fetchTiming == FetchTiming.IMMEDIATE) {
            return this.buildEntityFetchSelect(fetchParent, this, fetchablePath, domainResult, this.isSelectByUniqueKey(this.sideNature), false, creationState);
        }
        if (this.entityMappingType.isConcreteProxy() && this.sideNature == ForeignKeyDescriptor.Nature.TARGET) {
            this.createTableGroupForDelayedFetch(fetchablePath, parentTableGroup, null, creationState);
        }
        return this.buildEntityDelayedFetch(fetchParent, this, fetchablePath, domainResult, this.isSelectByUniqueKey(this.sideNature), creationState);
    }

    protected EntityFetch buildEntityDelayedFetch(FetchParent fetchParent, ToOneAttributeMapping fetchedAttribute, NavigablePath navigablePath, DomainResult<?> keyResult, boolean selectByUniqueKey, DomainResultCreationState creationState) {
        return new EntityDelayedFetchImpl(fetchParent, fetchedAttribute, navigablePath, keyResult, selectByUniqueKey, creationState);
    }

    protected EntityFetch buildEntityFetchSelect(FetchParent fetchParent, ToOneAttributeMapping fetchedAttribute, NavigablePath navigablePath, DomainResult<?> keyResult, boolean selectByUniqueKey, boolean isAffectedByFilter, DomainResultCreationState creationState) {
        return new EntityFetchSelectImpl(fetchParent, fetchedAttribute, navigablePath, keyResult, selectByUniqueKey, isAffectedByFilter, creationState);
    }

    protected EntityFetch buildEntityFetchJoined(FetchParent fetchParent, ToOneAttributeMapping toOneMapping, TableGroup tableGroup, DomainResult<?> keyResult, boolean isAffectedByFilter, NavigablePath navigablePath, DomainResultCreationState creationState) {
        return new EntityFetchJoinedImpl(fetchParent, toOneMapping, tableGroup, keyResult, isAffectedByFilter, navigablePath, creationState);
    }

    private NavigablePath getReferencedNavigablePath(DomainResultCreationState creationState, NavigablePath parentNavigablePath) {
        NavigablePath referencedNavigablePath = parentNavigablePath.getParent();
        MappingType partMappingType = creationState.resolveModelPart(referencedNavigablePath).getPartMappingType();
        while (!(partMappingType instanceof EntityMappingType) || partMappingType != this.entityMappingType && !this.entityMappingType.getEntityPersister().isSubclassEntityName(partMappingType.getMappedJavaType().getTypeName()) && !((EntityMappingType)partMappingType).getEntityPersister().isSubclassEntityName(this.entityMappingType.getEntityName())) {
            if ((referencedNavigablePath = referencedNavigablePath.getParent()) == null) {
                return null;
            }
            partMappingType = creationState.resolveModelPart(referencedNavigablePath).getPartMappingType();
        }
        return referencedNavigablePath;
    }

    @Override
    public EntityFetch generateFetch(FetchParent fetchParent, NavigablePath fetchablePath, FetchTiming fetchTiming, boolean selected, String resultVariable, DomainResultCreationState creationState) {
        DomainResult<?> keyResult;
        SqlAstCreationState sqlAstCreationState = creationState.getSqlAstCreationState();
        FromClauseAccess fromClauseAccess = sqlAstCreationState.getFromClauseAccess();
        TableGroup parentTableGroup = fromClauseAccess.getTableGroup(fetchParent.getNavigablePath());
        NavigablePath parentNavigablePath = fetchablePath.getParent();
        assert (parentNavigablePath.equals(fetchParent.getNavigablePath()) || fetchParent.getNavigablePath() instanceof TreatedNavigablePath && parentNavigablePath.equals(fetchParent.getNavigablePath().getRealParent()));
        if (fetchTiming == FetchTiming.IMMEDIATE && selected) {
            TableGroup tableGroup = this.determineTableGroupForFetch(fetchablePath, fetchParent, parentTableGroup, resultVariable, fromClauseAccess, creationState);
            return this.withRegisteredAssociationKeys(() -> {
                boolean affectedByEnabledFilters = this.isAffectedByEnabledFilters(creationState);
                DomainResult<?> keyResult = null;
                if (this.sideNature == ForeignKeyDescriptor.Nature.KEY) {
                    if (this.hasNotFoundAction() || !this.isInternalLoadNullable || affectedByEnabledFilters) {
                        keyResult = this.foreignKeyDescriptor.createKeyDomainResult(fetchablePath, tableGroup, fetchParent, creationState);
                    }
                } else if (this.hasNotFoundAction() || this.getAssociatedEntityMappingType().getSoftDeleteMapping() != null || affectedByEnabledFilters) {
                    keyResult = this.foreignKeyDescriptor.createTargetDomainResult(fetchablePath, parentTableGroup, fetchParent, creationState);
                }
                return this.buildEntityFetchJoined(fetchParent, this, tableGroup, keyResult, affectedByEnabledFilters, fetchablePath, creationState);
            }, creationState);
        }
        ForeignKeyDescriptor.Nature resolvingKeySideOfForeignKey = creationState.getCurrentlyResolvingForeignKeyPart();
        ForeignKeyDescriptor.Nature side = resolvingKeySideOfForeignKey == ForeignKeyDescriptor.Nature.KEY && this.sideNature == ForeignKeyDescriptor.Nature.TARGET ? ForeignKeyDescriptor.Nature.KEY : this.sideNature;
        if (side == ForeignKeyDescriptor.Nature.KEY) {
            tableGroup = this.sideNature == ForeignKeyDescriptor.Nature.KEY ? this.createTableGroupForDelayedFetch(fetchablePath, parentTableGroup, null, creationState) : parentTableGroup;
            keyResult = this.foreignKeyDescriptor.createKeyDomainResult(fetchablePath, tableGroup, fetchParent, creationState);
        } else {
            tableGroup = this.sideNature == ForeignKeyDescriptor.Nature.TARGET ? parentTableGroup : this.createTableGroupForDelayedFetch(fetchablePath, parentTableGroup, null, creationState);
            keyResult = this.foreignKeyDescriptor.createTargetDomainResult(fetchablePath, tableGroup, fetchParent, creationState);
        }
        boolean selectByUniqueKey = this.isSelectByUniqueKey(side);
        if (this.needsImmediateFetch(fetchTiming)) {
            return this.buildEntityFetchSelect(fetchParent, this, fetchablePath, keyResult, selectByUniqueKey, this.isAffectedByEnabledFilters(creationState), creationState);
        }
        if (this.entityMappingType.isConcreteProxy() && this.sideNature == ForeignKeyDescriptor.Nature.TARGET) {
            this.createTableGroupForDelayedFetch(fetchablePath, parentTableGroup, null, creationState);
        }
        return this.buildEntityDelayedFetch(fetchParent, this, fetchablePath, keyResult, selectByUniqueKey, creationState);
    }

    private boolean isAffectedByEnabledFilters(DomainResultCreationState creationState) {
        LoadQueryInfluencers loadQueryInfluencers = creationState.getSqlAstCreationState().getLoadQueryInfluencers();
        return this.entityMappingType.isAffectedByEnabledFilters(loadQueryInfluencers, true);
    }

    private boolean needsImmediateFetch(FetchTiming fetchTiming) {
        if (fetchTiming == FetchTiming.IMMEDIATE) {
            return true;
        }
        if (!this.entityMappingType.isConcreteProxy()) {
            return this.hasNotFoundAction() || this.entityMappingType.getSoftDeleteMapping() != null || !this.entityMappingType.getEntityPersister().isInstrumented() && this.cardinality == Cardinality.ONE_TO_ONE && this.isOptional;
        }
        return false;
    }

    private TableGroup determineTableGroupForFetch(NavigablePath fetchablePath, FetchParent fetchParent, TableGroup parentTableGroup, String resultVariable, FromClauseAccess fromClauseAccess, DomainResultCreationState creationState) {
        FetchableContainer parentEntityType = fetchParent.getReferencedMappingType();
        SqlAstJoinType joinType = parentEntityType instanceof JoinedSubclassEntityPersister && ((JoinedSubclassEntityPersister)parentEntityType).findDeclaredAttributeMapping(this.getPartName()) == null ? this.getJoinTypeForFetch(fetchablePath, parentTableGroup) : null;
        return fromClauseAccess.resolveTableGroup(fetchablePath, np -> {
            TableGroup leftJoined = null;
            for (TableGroupJoin tableGroupJoin : parentTableGroup.getTableGroupJoins()) {
                switch (tableGroupJoin.getJoinType()) {
                    case INNER: {
                        if (!tableGroupJoin.getNavigablePath().pathsMatch((NavigablePath)np)) break;
                        return tableGroupJoin.getJoinedGroup();
                    }
                    case LEFT: {
                        if (!tableGroupJoin.getNavigablePath().pathsMatch((NavigablePath)np) || !this.isSimpleJoinPredicate(tableGroupJoin.getPredicate())) break;
                        leftJoined = tableGroupJoin.getJoinedGroup();
                    }
                }
            }
            if (leftJoined != null) {
                return leftJoined;
            }
            TableGroupJoin tableGroupJoin = this.createTableGroupJoin(fetchablePath, parentTableGroup, resultVariable, null, joinType, true, false, creationState.getSqlAstCreationState());
            parentTableGroup.addTableGroupJoin(tableGroupJoin);
            return tableGroupJoin.getJoinedGroup();
        });
    }

    private TableGroup createTableGroupForDelayedFetch(NavigablePath fetchablePath, TableGroup parentTableGroup, String resultVariable, DomainResultCreationState creationState) {
        TableGroup compatibleTableGroup = parentTableGroup.findCompatibleJoinedGroup(this, SqlAstJoinType.LEFT);
        if (compatibleTableGroup != null) {
            return compatibleTableGroup;
        }
        TableGroupJoin tableGroupJoin = this.createTableGroupJoin(fetchablePath, parentTableGroup, resultVariable, null, SqlAstJoinType.LEFT, false, false, creationState.getSqlAstCreationState());
        parentTableGroup.addTableGroupJoin(tableGroupJoin);
        creationState.getSqlAstCreationState().getFromClauseAccess().registerTableGroup(fetchablePath, tableGroupJoin.getJoinedGroup());
        return tableGroupJoin.getJoinedGroup();
    }

    private boolean isSelectByUniqueKey(ForeignKeyDescriptor.Nature side) {
        if (this.referencedPropertyName == null) {
            return false;
        }
        if (side == ForeignKeyDescriptor.Nature.KEY) {
            return !this.foreignKeyDescriptor.getNavigableRole().equals(this.entityMappingType.getIdentifierMapping().getNavigableRole());
        }
        return this.bidirectionalAttributePath != null && (!(this.entityMappingType.getIdentifierMapping() instanceof SingleAttributeIdentifierMapping) || !this.targetKeyPropertyNames.contains(this.entityMappingType.getIdentifierMapping().getAttributeName()));
    }

    @Override
    public <T> DomainResult<T> createSnapshotDomainResult(NavigablePath navigablePath, TableGroup parentTableGroup, String resultVariable, DomainResultCreationState creationState) {
        if (this.sideNature == ForeignKeyDescriptor.Nature.KEY) {
            return this.foreignKeyDescriptor.getKeyPart().createDomainResult(navigablePath, parentTableGroup, resultVariable, creationState);
        }
        return new NullDomainResult(this.foreignKeyDescriptor.getKeyPart().getJavaType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EntityFetch withRegisteredAssociationKeys(Supplier<EntityFetch> fetchCreator, DomainResultCreationState creationState) {
        ModelPart bidirectionalModelPart;
        boolean added = creationState.registerVisitedAssociationKey(this.foreignKeyDescriptor.getAssociationKey());
        AssociationKey additionalAssociationKey = null;
        if (this.cardinality == Cardinality.LOGICAL_ONE_TO_ONE && this.bidirectionalAttributePath != null && (bidirectionalModelPart = this.entityMappingType.findByPath(this.bidirectionalAttributePath)) instanceof ToOneAttributeMapping) {
            assert (bidirectionalModelPart.getPartMappingType() == this.declaringTableGroupProducer);
            ToOneAttributeMapping bidirectionalAttribute = (ToOneAttributeMapping)bidirectionalModelPart;
            AssociationKey secondKey = bidirectionalAttribute.getForeignKeyDescriptor().getAssociationKey();
            if (creationState.registerVisitedAssociationKey(secondKey)) {
                additionalAssociationKey = secondKey;
            }
        }
        try {
            EntityFetch entityFetch = fetchCreator.get();
            return entityFetch;
        }
        finally {
            if (added) {
                creationState.removeVisitedAssociationKey(this.foreignKeyDescriptor.getAssociationKey());
            }
            if (additionalAssociationKey != null) {
                creationState.removeVisitedAssociationKey(additionalAssociationKey);
            }
        }
    }

    @Override
    public SqlAstJoinType getDefaultSqlAstJoinType(TableGroup parentTableGroup) {
        Class<?> parentTableGroupType;
        Class<?> attributeDeclaringType;
        if (this.isKeyTableNullable || this.isNullable) {
            return SqlAstJoinType.LEFT;
        }
        if (parentTableGroup.getModelPart() instanceof CollectionPart) {
            return SqlAstJoinType.LEFT;
        }
        if (parentTableGroup.canUseInnerJoins() && (attributeDeclaringType = this.declaringTableGroupProducer.getJavaType().getJavaTypeClass()).isAssignableFrom(parentTableGroupType = parentTableGroup.getModelPart().getJavaType().getJavaTypeClass())) {
            return SqlAstJoinType.INNER;
        }
        return SqlAstJoinType.LEFT;
    }

    @Override
    public boolean isSimpleJoinPredicate(Predicate predicate) {
        return predicate == null || this.foreignKeyDescriptor.isSimpleJoinPredicate(predicate);
    }

    @Override
    public boolean containsTableReference(String tableExpression) {
        return this.getEntityMappingType().containsTableReference(tableExpression);
    }

    @Override
    public int getNumberOfFetchables() {
        return this.getEntityMappingType().getNumberOfFetchables();
    }

    @Override
    public Fetchable getFetchable(int position) {
        return this.getEntityMappingType().getFetchable(position);
    }

    @Override
    public TableGroupJoin createTableGroupJoin(NavigablePath navigablePath, TableGroup lhs, String explicitSourceAlias, SqlAliasBase explicitSqlAliasBase, SqlAstJoinType requestedJoinType, boolean fetched, boolean addsPredicate, SqlAstCreationState creationState) {
        assert (!(lhs instanceof PluralTableGroup));
        FromClauseAccess fromClauseAccess = creationState.getFromClauseAccess();
        SqlAstJoinType joinType = this.determineSqlJoinType(lhs, requestedJoinType, fetched);
        if (!(addsPredicate || joinType != SqlAstJoinType.INNER && joinType != SqlAstJoinType.LEFT)) {
            String indexPropertyName;
            String pathName;
            NavigablePath parentParentPath;
            PluralTableGroup pluralTableGroup;
            TableGroup parentTableGroup = lhs;
            ModelPartContainer parentContainer = lhs.getModelPart();
            StringBuilder embeddablePathSb = null;
            while (!(parentContainer instanceof CollectionPart) && parentContainer instanceof EmbeddableValuedModelPart) {
                if (embeddablePathSb == null) {
                    embeddablePathSb = new StringBuilder();
                }
                embeddablePathSb.insert(0, parentContainer.getPartName() + ".");
                NavigablePath parentNavigablePath = parentTableGroup.getNavigablePath();
                TableGroup tableGroup = fromClauseAccess.findTableGroup(parentNavigablePath.getParent());
                if (tableGroup == null) {
                    assert (parentNavigablePath.getLocalName().equals("{fk}") || parentNavigablePath.getLocalName().equals("{fk-target}"));
                    break;
                }
                parentTableGroup = tableGroup;
                parentContainer = tableGroup.getModelPart();
            }
            if (CollectionPart.Nature.ELEMENT.getName().equals(parentTableGroup.getNavigablePath().getLocalName()) && (pluralTableGroup = (PluralTableGroup)fromClauseAccess.findTableGroup(parentParentPath = parentTableGroup.getNavigablePath().getParent())) != null && (pathName = embeddablePathSb != null ? embeddablePathSb.append(this.getAttributeName()).toString() : this.getAttributeName()).equals(indexPropertyName = pluralTableGroup.getModelPart().getIndexMetadata().getIndexPropertyName())) {
                TableGroup indexTableGroup = pluralTableGroup.getIndexTableGroup();
                this.initializeIfNeeded(lhs, requestedJoinType, indexTableGroup);
                return new TableGroupJoin(navigablePath, joinType, new MappedByTableGroup(navigablePath, this, indexTableGroup, fetched, pluralTableGroup, this), null);
            }
        }
        TableGroup lazyTableGroup = this.createRootTableGroupJoin(navigablePath, lhs, explicitSourceAlias, explicitSqlAliasBase, requestedJoinType, fetched, (Consumer)null, creationState);
        TableGroupJoin join = new TableGroupJoin(navigablePath, joinType, lazyTableGroup, null);
        TableReference lhsTableReference = lhs.resolveTableReference(navigablePath, this, this.identifyingColumnsTableExpression);
        ((LazyTableGroup)lazyTableGroup).setTableGroupInitializerCallback(arg_0 -> this.lambda$createTableGroupJoin$2(lhsTableReference, join, creationState, (LazyTableGroup)lazyTableGroup, navigablePath, arg_0));
        return join;
    }

    @Override
    public SqlAstJoinType determineSqlJoinType(TableGroup lhs, SqlAstJoinType requestedJoinType, boolean fetched) {
        if (requestedJoinType != null) {
            return requestedJoinType;
        }
        if (fetched) {
            return this.getDefaultSqlAstJoinType(lhs);
        }
        return SqlAstJoinType.INNER;
    }

    @Override
    public LazyTableGroup createRootTableGroupJoin(NavigablePath navigablePath, TableGroup lhs, String explicitSourceAlias, SqlAliasBase explicitSqlAliasBase, SqlAstJoinType requestedJoinType, boolean fetched, Consumer<Predicate> predicateConsumer, SqlAstCreationState creationState) {
        SqlAliasBase sqlAliasBase = SqlAliasBase.from(explicitSqlAliasBase, explicitSourceAlias, this, creationState.getSqlAliasBaseGenerator());
        SoftDeleteMapping softDeleteMapping = this.getAssociatedEntityMappingType().getSoftDeleteMapping();
        boolean canUseInnerJoin = !lhs.canUseInnerJoins() ? false : (this.isNullable || this.hasNotFoundAction() || softDeleteMapping != null ? false : requestedJoinType == SqlAstJoinType.INNER);
        TableGroup realParentTableGroup = lhs;
        FromClauseAccess fromClauseAccess = creationState.getFromClauseAccess();
        while (realParentTableGroup.getModelPart() instanceof EmbeddableValuedModelPart) {
            NavigablePath parentNavigablePath = realParentTableGroup.getNavigablePath();
            TableGroup tableGroup2 = fromClauseAccess.findTableGroup(parentNavigablePath.getParent());
            if (tableGroup2 == null) {
                assert (parentNavigablePath.getLocalName().equals("{fk}") || parentNavigablePath.getLocalName().equals("{fk-target}"));
                realParentTableGroup = null;
                break;
            }
            realParentTableGroup = tableGroup2;
        }
        EntityValuedModelPart tableGroupProducer = requestedJoinType != null && realParentTableGroup instanceof CorrelatedTableGroup ? this.entityMappingType : this;
        LazyTableGroup lazyTableGroup = new LazyTableGroup(canUseInnerJoin, navigablePath, fetched, () -> this.createTableGroupInternal(canUseInnerJoin, navigablePath, fetched, null, sqlAliasBase, creationState), this, (TableGroupProducer)((Object)tableGroupProducer), explicitSourceAlias, sqlAliasBase, creationState.getCreationContext().getSessionFactory(), lhs);
        if (predicateConsumer != null) {
            TableReference lhsTableReference = lhs.resolveTableReference(navigablePath, this.identifyingColumnsTableExpression);
            lazyTableGroup.setTableGroupInitializerCallback(tableGroup -> predicateConsumer.accept(this.foreignKeyDescriptor.generateJoinPredicate(this.sideNature == ForeignKeyDescriptor.Nature.TARGET ? lhsTableReference : tableGroup.getPrimaryTableReference(), this.sideNature == ForeignKeyDescriptor.Nature.TARGET ? tableGroup.getPrimaryTableReference() : lhsTableReference, creationState)));
            if (fetched && softDeleteMapping != null) {
                TableReference tableReference = lazyTableGroup.resolveTableReference(navigablePath, this.getAssociatedEntityMappingType().getSoftDeleteTableDetails().getTableName());
                predicateConsumer.accept(SoftDeleteHelper.createNonSoftDeletedRestriction(tableReference, softDeleteMapping, creationState.getSqlExpressionResolver()));
            }
        }
        if (requestedJoinType != null && realParentTableGroup instanceof CorrelatedTableGroup) {
            lazyTableGroup.getPrimaryTableReference();
        } else {
            this.initializeIfNeeded(lhs, requestedJoinType, lazyTableGroup);
        }
        return lazyTableGroup;
    }

    @Override
    public boolean canUseParentTableGroup(TableGroupProducer producer, NavigablePath navigablePath, ValuedModelPart valuedModelPart) {
        return producer == this && this.sideNature == ForeignKeyDescriptor.Nature.KEY && this.foreignKeyDescriptor.isKeyPart(valuedModelPart);
    }

    private void initializeIfNeeded(TableGroup lhs, SqlAstJoinType sqlAstJoinType, TableGroup tableGroup) {
        if (sqlAstJoinType == SqlAstJoinType.INNER && (this.isNullable || !lhs.canUseInnerJoins())) {
            if (this.hasJoinTable) {
                TableReference lhsTableReference = lhs.resolveTableReference(tableGroup.getNavigablePath(), this.identifyingColumnsTableExpression);
                List<TableReferenceJoin> tableReferenceJoins = lhs.getTableReferenceJoins();
                for (int i = 0; i < tableReferenceJoins.size(); ++i) {
                    TableReferenceJoin tableReferenceJoin = tableReferenceJoins.get(i);
                    if (tableReferenceJoin.getJoinType() == SqlAstJoinType.INNER || tableReferenceJoin.getJoinedTableReference() != lhsTableReference) continue;
                    tableReferenceJoins.set(i, new TableReferenceJoin(true, tableReferenceJoin.getJoinedTableReference(), tableReferenceJoin.getPredicate()));
                    return;
                }
                throw new AssertionFailure("Couldn't find table reference join for join table: " + lhsTableReference);
            }
            tableGroup.getPrimaryTableReference();
        }
    }

    private SqlAstJoinType getJoinTypeForFetch(NavigablePath navigablePath, TableGroup tableGroup) {
        for (TableGroupJoin tableGroupJoin : tableGroup.getTableGroupJoins()) {
            if (!tableGroupJoin.getNavigablePath().equals(navigablePath)) continue;
            return tableGroupJoin.getJoinType();
        }
        return null;
    }

    public TableGroup createTableGroupInternal(boolean canUseInnerJoins, NavigablePath navigablePath, boolean fetched, String sourceAlias, SqlAliasBase sqlAliasBase, SqlAstCreationState creationState) {
        TableReference primaryTableReference = this.getEntityMappingType().createPrimaryTableReference(sqlAliasBase, creationState);
        return new StandardTableGroup(canUseInnerJoins, navigablePath, this, fetched, sourceAlias, primaryTableReference, true, sqlAliasBase, this.getEntityMappingType().getRootEntityDescriptor()::containsTableReference, (tableExpression, tg) -> this.getEntityMappingType().createTableReferenceJoin((String)tableExpression, sqlAliasBase, primaryTableReference, creationState), creationState.getCreationContext().getSessionFactory());
    }

    @Override
    public String getSqlAliasStem() {
        return this.sqlAliasStem;
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    public boolean isLazy() {
        return this.isLazy;
    }

    @Override
    public boolean isOptional() {
        return this.isOptional;
    }

    public boolean isInternalLoadNullable() {
        return this.isInternalLoadNullable;
    }

    public NotFoundAction getNotFoundAction() {
        return this.notFoundAction;
    }

    public boolean isIgnoreNotFound() {
        return this.notFoundAction == NotFoundAction.IGNORE;
    }

    public boolean hasNotFoundAction() {
        return this.notFoundAction != null;
    }

    @Override
    public boolean isUnwrapProxy() {
        return this.unwrapProxy;
    }

    @Override
    public EntityMappingType getAssociatedEntityMappingType() {
        return this.getEntityMappingType();
    }

    @Override
    public ModelPart getKeyTargetMatchPart() {
        return this.foreignKeyDescriptor.getPart(this.sideNature);
    }

    public String toString() {
        return "ToOneAttributeMapping(" + this.navigableRole + ")@" + System.identityHashCode(this);
    }

    @Override
    public <X, Y> int breakDownJdbcValues(Object domainValue, int offset, X x, Y y, ModelPart.JdbcValueBiConsumer<X, Y> valueConsumer, SharedSessionContractImplementor session) {
        if (this.cardinality == Cardinality.ONE_TO_ONE && this.sideNature == ForeignKeyDescriptor.Nature.TARGET) {
            return 0;
        }
        Object value = this.extractValue(domainValue, session);
        return this.foreignKeyDescriptor.breakDownJdbcValues(value, offset, x, y, valueConsumer, session);
    }

    private Object extractValue(Object domainValue, SharedSessionContractImplementor session) {
        if (domainValue == null) {
            return null;
        }
        if (this.referencedPropertyName != null) {
            LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(domainValue);
            if (lazyInitializer != null) {
                domainValue = lazyInitializer.getImplementation();
            }
            assert (this.getAssociatedEntityMappingType().getRepresentationStrategy().getInstantiator().isInstance(domainValue, session.getSessionFactory()));
            return ToOneAttributeMapping.extractAttributePathValue(domainValue, this.getAssociatedEntityMappingType(), this.referencedPropertyName);
        }
        return this.foreignKeyDescriptor.getAssociationKeyFromSide(domainValue, this.sideNature.inverse(), session);
    }

    private static Object extractAttributePathValue(Object domainValue, EntityMappingType entityType, String attributePath) {
        if (!attributePath.contains(".")) {
            return entityType.findAttributeMapping(attributePath).getValue(domainValue);
        }
        Object value = domainValue;
        ManagedMappingType managedType = entityType;
        String[] pathParts = attributePath.split("\\.");
        for (int i = 0; i < pathParts.length; ++i) {
            assert (managedType != null);
            String pathPart = pathParts[i];
            AttributeMapping attributeMapping = managedType.findAttributeMapping(pathPart);
            value = attributeMapping.getValue(value);
            managedType = attributeMapping.getMappedType() instanceof ManagedMappingType ? (ManagedMappingType)attributeMapping.getMappedType() : null;
        }
        return value;
    }

    @Override
    public int forEachSelectable(int offset, SelectableConsumer consumer) {
        if (this.sideNature == ForeignKeyDescriptor.Nature.KEY) {
            return this.foreignKeyDescriptor.visitKeySelectables(offset, consumer);
        }
        return 0;
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState) {
        if (this.sideNature == ForeignKeyDescriptor.Nature.KEY) {
            this.foreignKeyDescriptor.getKeyPart().applySqlSelections(navigablePath, tableGroup, creationState);
        }
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState, BiConsumer<SqlSelection, JdbcMapping> selectionConsumer) {
        if (this.sideNature == ForeignKeyDescriptor.Nature.KEY) {
            this.foreignKeyDescriptor.getKeyPart().applySqlSelections(navigablePath, tableGroup, creationState, selectionConsumer);
        }
    }

    @Override
    public String getContainingTableExpression() {
        if (this.sideNature == ForeignKeyDescriptor.Nature.KEY) {
            return this.foreignKeyDescriptor.getKeyTable();
        }
        return this.foreignKeyDescriptor.getTargetTable();
    }

    @Override
    public int getJdbcTypeCount() {
        if (this.sideNature == ForeignKeyDescriptor.Nature.KEY) {
            return this.foreignKeyDescriptor.getJdbcTypeCount();
        }
        return 0;
    }

    @Override
    public JdbcMapping getJdbcMapping(int index) {
        return this.foreignKeyDescriptor.getJdbcMapping(index);
    }

    @Override
    public SelectableMapping getSelectable(int columnIndex) {
        if (this.sideNature == ForeignKeyDescriptor.Nature.KEY) {
            return this.foreignKeyDescriptor.getSelectable(columnIndex);
        }
        return null;
    }

    @Override
    public int forEachJdbcType(int offset, IndexedConsumer<JdbcMapping> action) {
        return this.foreignKeyDescriptor.forEachJdbcType(offset, action);
    }

    @Override
    public Object disassemble(Object value, SharedSessionContractImplementor session) {
        return this.foreignKeyDescriptor.disassemble(this.foreignKeyDescriptor.getAssociationKeyFromSide(value, this.sideNature.inverse(), session), session);
    }

    @Override
    public void addToCacheKey(MutableCacheKeyBuilder cacheKey, Object value, SharedSessionContractImplementor session) {
        Object cacheValue = value != null && this.foreignKeyDescriptor.getJavaType().getJavaTypeClass() == value.getClass() ? value : this.foreignKeyDescriptor.getAssociationKeyFromSide(value, this.sideNature.inverse(), session);
        this.foreignKeyDescriptor.addToCacheKey(cacheKey, cacheValue, session);
    }

    @Override
    public <X, Y> int forEachDisassembledJdbcValue(Object value, int offset, X x, Y y, Bindable.JdbcValuesBiConsumer<X, Y> valuesConsumer, SharedSessionContractImplementor session) {
        return this.foreignKeyDescriptor.forEachDisassembledJdbcValue(value, offset, x, y, valuesConsumer, session);
    }

    @Override
    public <X, Y> int forEachJdbcValue(Object value, int offset, X x, Y y, Bindable.JdbcValuesBiConsumer<X, Y> consumer, SharedSessionContractImplementor session) {
        return this.foreignKeyDescriptor.forEachDisassembledJdbcValue(this.foreignKeyDescriptor.disassemble(this.foreignKeyDescriptor.getAssociationKeyFromSide(value, this.sideNature.inverse(), session), session), offset, x, y, consumer, session);
    }

    private /* synthetic */ void lambda$createTableGroupJoin$2(TableReference lhsTableReference, TableGroupJoin join, SqlAstCreationState creationState, LazyTableGroup lazyTableGroup, NavigablePath navigablePath, TableGroup tableGroup) {
        SoftDeleteMapping softDeleteMapping;
        TableReference keyTableReference;
        TableReference targetTableReference;
        if (this.sideNature == ForeignKeyDescriptor.Nature.TARGET) {
            targetTableReference = lhsTableReference;
            keyTableReference = tableGroup.resolveTableReference(this.foreignKeyDescriptor.getKeyTable());
        } else {
            targetTableReference = tableGroup.resolveTableReference(this.foreignKeyDescriptor.getTargetTable());
            keyTableReference = lhsTableReference;
        }
        join.applyPredicate(this.foreignKeyDescriptor.generateJoinPredicate(targetTableReference, keyTableReference, creationState));
        if (this.getAssociatedEntityMappingType().getEntityPersister().hasFilterForLoadByKey()) {
            this.getAssociatedEntityMappingType().applyBaseRestrictions(join::applyPredicate, tableGroup, true, creationState.getLoadQueryInfluencers().getEnabledFilters(), creationState.applyOnlyLoadByKeyFilters(), null, creationState);
        }
        this.getAssociatedEntityMappingType().applyWhereRestrictions(join::applyPredicate, tableGroup, true, creationState);
        if (this.getAssociatedEntityMappingType().getSuperMappingType() != null && !creationState.supportsEntityNameUsage()) {
            this.getAssociatedEntityMappingType().applyDiscriminator(null, null, tableGroup, creationState);
        }
        if ((softDeleteMapping = this.getAssociatedEntityMappingType().getSoftDeleteMapping()) != null) {
            TableReference tableReference = lazyTableGroup.resolveTableReference(navigablePath, this.getAssociatedEntityMappingType().getSoftDeleteTableDetails().getTableName());
            join.applyPredicate(SoftDeleteHelper.createNonSoftDeletedRestriction(tableReference, softDeleteMapping, creationState.getSqlExpressionResolver()));
        }
    }

    public static enum Cardinality {
        ONE_TO_ONE,
        MANY_TO_ONE,
        LOGICAL_ONE_TO_ONE;

    }

    public static class NullDomainResult
    implements DomainResult {
        private final DomainResultAssembler resultAssembler;
        private final JavaType<?> resultJavaType;

        public NullDomainResult(JavaType<?> javaType) {
            this.resultAssembler = new NullValueAssembler(javaType);
            this.resultJavaType = javaType;
        }

        @Override
        public String getResultVariable() {
            return null;
        }

        public DomainResultAssembler createResultAssembler(InitializerParent parent, AssemblerCreationState creationState) {
            return this.resultAssembler;
        }

        @Override
        public JavaType<?> getResultJavaType() {
            return this.resultJavaType;
        }

        @Override
        public void collectValueIndexesToCache(BitSet valueIndexes) {
        }
    }
}

