/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.mapping.Component;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.AttributeMappingsList;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.NonAggregatedIdentifierMapping;
import org.hibernate.metamodel.mapping.SelectableMappings;
import org.hibernate.metamodel.mapping.internal.AbstractEmbeddableMapping;
import org.hibernate.metamodel.mapping.internal.EmbeddedAttributeMapping;
import org.hibernate.metamodel.mapping.internal.IdClassEmbeddable;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationHelper;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationProcess;
import org.hibernate.metamodel.mapping.internal.MutableAttributeMappingList;
import org.hibernate.metamodel.mapping.internal.VirtualIdRepresentationStrategy;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.property.access.spi.Getter;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupProducer;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.type.AnyType;
import org.hibernate.type.CollectionType;
import org.hibernate.type.CompositeType;
import org.hibernate.type.spi.CompositeTypeImplementor;

public class VirtualIdEmbeddable
extends AbstractEmbeddableMapping
implements NonAggregatedIdentifierMapping.IdentifierValueMapper {
    private final NavigableRole navigableRole;
    private final NonAggregatedIdentifierMapping idMapping;
    private final VirtualIdRepresentationStrategy representationStrategy;

    public VirtualIdEmbeddable(Component virtualIdSource, NonAggregatedIdentifierMapping idMapping, EntityPersister identifiedEntityMapping, String rootTableExpression, String[] rootTableKeyColumnNames, MappingModelCreationProcess creationProcess) {
        super(new MutableAttributeMappingList(virtualIdSource.getType().getPropertyNames().length));
        this.navigableRole = idMapping.getNavigableRole();
        this.idMapping = idMapping;
        this.representationStrategy = new VirtualIdRepresentationStrategy(this, identifiedEntityMapping, virtualIdSource, creationProcess.getCreationContext());
        CompositeType compositeType = virtualIdSource.getType();
        ((CompositeTypeImplementor)compositeType).injectMappingModelPart(idMapping, creationProcess);
        creationProcess.registerInitializationCallback("VirtualIdEmbeddable(" + this.navigableRole.getFullPath() + ")#finishInitialization", () -> this.finishInitialization(virtualIdSource, compositeType, rootTableExpression, rootTableKeyColumnNames, creationProcess));
    }

    public VirtualIdEmbeddable(EmbeddedAttributeMapping valueMapping, TableGroupProducer declaringTableGroupProducer, SelectableMappings selectableMappings, VirtualIdEmbeddable inverseMappingType, MappingModelCreationProcess creationProcess) {
        super(new MutableAttributeMappingList(inverseMappingType.attributeMappings.size()));
        this.navigableRole = inverseMappingType.getNavigableRole();
        this.idMapping = (NonAggregatedIdentifierMapping)((Object)valueMapping);
        this.representationStrategy = inverseMappingType.representationStrategy;
        this.selectableMappings = selectableMappings;
        creationProcess.registerInitializationCallback("VirtualIdEmbeddable(" + inverseMappingType.getNavigableRole().getFullPath() + ".{inverse})#finishInitialization", () -> this.inverseInitializeCallback(declaringTableGroupProducer, selectableMappings, inverseMappingType, creationProcess, this, this.attributeMappings));
    }

    @Override
    public EmbeddableValuedModelPart getEmbeddedPart() {
        return this.idMapping;
    }

    @Override
    public Object getIdentifier(Object entity, SharedSessionContractImplementor session) {
        return this.representationStrategy.getInstantiator().instantiate(() -> this.getValues(entity), session.getSessionFactory());
    }

    @Override
    public void setIdentifier(Object entity, Object id, SharedSessionContractImplementor session) {
        if (entity != id) {
            this.setValues(entity, this.getValues(id));
        }
    }

    @Override
    public NavigableRole getNavigableRole() {
        return this.navigableRole;
    }

    @Override
    public String getPartName() {
        return this.idMapping.getPartName();
    }

    @Override
    public EmbeddableValuedModelPart getEmbeddedValueMapping() {
        return this.getEmbeddedPart();
    }

    @Override
    public VirtualIdRepresentationStrategy getRepresentationStrategy() {
        return this.representationStrategy;
    }

    @Override
    public EntityMappingType findContainingEntityMapping() {
        return this.idMapping.findContainingEntityMapping();
    }

    @Override
    public <T> DomainResult<T> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, DomainResultCreationState creationState) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <X, Y> int decompose(Object domainValue, int offset, X x, Y y, ModelPart.JdbcValueBiConsumer<X, Y> valueConsumer, SharedSessionContractImplementor session) {
        if (this.idMapping.getIdClassEmbeddable() != null) {
            return this.idMapping.getIdClassEmbeddable().decompose(domainValue, offset, x, y, valueConsumer, session);
        }
        int span = 0;
        for (int i = 0; i < this.attributeMappings.size(); ++i) {
            AttributeMapping attributeMapping = this.attributeMappings.get(i);
            span += attributeMapping.decompose(attributeMapping.getValue(domainValue), offset + span, x, y, valueConsumer, session);
        }
        return span;
    }

    @Override
    public EmbeddableMappingType createInverseMappingType(EmbeddedAttributeMapping valueMapping, TableGroupProducer declaringTableGroupProducer, SelectableMappings selectableMappings, MappingModelCreationProcess creationProcess) {
        return new VirtualIdEmbeddable(valueMapping, declaringTableGroupProducer, selectableMappings, this, creationProcess);
    }

    private boolean finishInitialization(Component bootDescriptor, CompositeType compositeType, String rootTableExpression, String[] rootTableKeyColumnNames, MappingModelCreationProcess creationProcess) {
        this.attributeMappings.clear();
        return this.finishInitialization(this.navigableRole, bootDescriptor, compositeType, rootTableExpression, rootTableKeyColumnNames, this, this.representationStrategy, (attributeName, attributeType) -> {
            if (attributeType instanceof CollectionType) {
                throw new AbstractEmbeddableMapping.IllegalAttributeType("A \"virtual id\" cannot define collection attributes : " + attributeName);
            }
            if (attributeType instanceof AnyType) {
                throw new AbstractEmbeddableMapping.IllegalAttributeType("A \"virtual id\" cannot define <any/> attributes : " + attributeName);
            }
        }, (column, jdbcEnvironment) -> MappingModelCreationHelper.getTableIdentifierExpression(column.getValue().getTable(), creationProcess), this::addAttribute, () -> creationProcess.registerInitializationCallback("VirtualIdEmbeddable(" + this.navigableRole + ")#initColumnMappings", this::initColumnMappings), creationProcess);
    }

    @Override
    public boolean areEqual(@Nullable Object one, @Nullable Object other, SharedSessionContractImplementor session) {
        IdClassEmbeddable idClassEmbeddable = this.idMapping.getIdClassEmbeddable();
        if (idClassEmbeddable != null) {
            return idClassEmbeddable.areEqual(one, other, session);
        }
        AttributeMappingsList attributeMappings = this.getAttributeMappings();
        for (int i = 0; i < attributeMappings.size(); ++i) {
            Getter getter;
            AttributeMapping attributeMapping = attributeMappings.get(i);
            if (attributeMapping.areEqual((getter = attributeMapping.getPropertyAccess().getGetter()).get(one), getter.get(other), session)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compare(Object value1, Object value2) {
        IdClassEmbeddable idClassEmbeddable = this.idMapping.getIdClassEmbeddable();
        if (idClassEmbeddable != null) {
            AttributeMappingsList attributeMappings = idClassEmbeddable.getAttributeMappings();
            for (int i = 0; i < attributeMappings.size(); ++i) {
                Getter getter;
                AttributeMapping attributeMapping = attributeMappings.get(i);
                int comparison = attributeMapping.compare((getter = attributeMapping.getPropertyAccess().getGetter()).get(value1), getter.get(value2));
                if (comparison == 0) continue;
                return comparison;
            }
            return 0;
        }
        return super.compare(value1, value2);
    }
}

