/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.entity.mutation;

import org.hibernate.engine.OptimisticLockStyle;
import org.hibernate.engine.jdbc.batch.internal.BasicBatchKey;
import org.hibernate.engine.jdbc.mutation.JdbcValueBindings;
import org.hibernate.engine.jdbc.mutation.MutationExecutor;
import org.hibernate.engine.jdbc.mutation.ParameterUsage;
import org.hibernate.engine.jdbc.mutation.group.PreparedStatementDetails;
import org.hibernate.engine.jdbc.mutation.internal.ModelMutationHelper;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.EntityVersionMapping;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.mutation.AbstractMutationCoordinator;
import org.hibernate.persister.entity.mutation.DeleteCoordinator;
import org.hibernate.persister.entity.mutation.EntityTableMapping;
import org.hibernate.sql.model.MutationOperation;
import org.hibernate.sql.model.MutationOperationGroup;

public abstract class AbstractDeleteCoordinator
extends AbstractMutationCoordinator
implements DeleteCoordinator {
    private final BasicBatchKey batchKey;
    private final MutationOperationGroup staticOperationGroup;
    private MutationOperationGroup noVersionDeleteGroup;

    public AbstractDeleteCoordinator(EntityPersister entityPersister, SessionFactoryImplementor factory) {
        super(entityPersister, factory);
        this.batchKey = new BasicBatchKey(entityPersister.getEntityName() + "#DELETE");
        this.staticOperationGroup = this.generateOperationGroup("", null, true, null);
        if (!entityPersister.isVersioned()) {
            this.noVersionDeleteGroup = this.staticOperationGroup;
        }
    }

    @Override
    public MutationOperationGroup getStaticMutationOperationGroup() {
        return this.staticOperationGroup;
    }

    @Override
    public BasicBatchKey getBatchKey() {
        return this.batchKey;
    }

    protected abstract MutationOperationGroup generateOperationGroup(Object var1, Object[] var2, boolean var3, SharedSessionContractImplementor var4);

    @Override
    public void delete(Object entity, Object id, Object version, SharedSessionContractImplementor session) {
        Object rowId;
        boolean isImpliedOptimisticLocking = this.entityPersister().optimisticLockStyle().isAllOrDirty();
        PersistenceContext persistenceContext = session.getPersistenceContextInternal();
        EntityEntry entry = persistenceContext.getEntry(entity);
        Object[] loadedState = entry != null && isImpliedOptimisticLocking ? entry.getLoadedState() : null;
        Object object = rowId = entry != null ? entry.getRowId() : null;
        if (isImpliedOptimisticLocking && loadedState != null || rowId == null && this.entityPersister().hasRowId()) {
            this.doDynamicDelete(entity, id, rowId, loadedState, session);
        } else {
            this.doStaticDelete(entity, id, rowId, entry == null ? null : entry.getLoadedState(), version, session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDynamicDelete(Object entity, Object id, Object rowId, Object[] loadedState, SharedSessionContractImplementor session) {
        MutationOperationGroup operationGroup = this.generateOperationGroup(null, loadedState, true, session);
        MutationExecutor mutationExecutor = this.executor(session, operationGroup);
        for (int i = 0; i < operationGroup.getNumberOfOperations(); ++i) {
            MutationOperation mutation = operationGroup.getOperation(i);
            if (mutation == null) continue;
            String tableName = mutation.getTableDetails().getTableName();
            mutationExecutor.getPreparedStatementDetails(tableName);
        }
        this.applyDynamicDeleteTableDetails(id, rowId, loadedState, mutationExecutor, operationGroup, session);
        try {
            mutationExecutor.execute(entity, null, null, (statementDetails, affectedRowCount, batchPosition) -> ModelMutationHelper.identifiedResultsCheck(statementDetails, affectedRowCount, batchPosition, this.entityPersister(), id, this.factory()), session);
        }
        finally {
            mutationExecutor.release();
        }
    }

    protected void applyDynamicDeleteTableDetails(Object id, Object rowId, Object[] loadedState, MutationExecutor mutationExecutor, MutationOperationGroup operationGroup, SharedSessionContractImplementor session) {
        this.applyLocking(null, loadedState, mutationExecutor, session);
        this.applyId(id, null, mutationExecutor, operationGroup, session);
    }

    protected void applyLocking(Object version, Object[] loadedState, MutationExecutor mutationExecutor, SharedSessionContractImplementor session) {
        JdbcValueBindings jdbcValueBindings = mutationExecutor.getJdbcValueBindings();
        OptimisticLockStyle optimisticLockStyle = this.entityPersister().optimisticLockStyle();
        switch (optimisticLockStyle) {
            case VERSION: {
                this.applyVersionLocking(version, jdbcValueBindings);
                break;
            }
            case ALL: 
            case DIRTY: {
                this.applyAllOrDirtyLocking(loadedState, session, jdbcValueBindings);
            }
        }
    }

    private void applyAllOrDirtyLocking(Object[] loadedState, SharedSessionContractImplementor session, JdbcValueBindings jdbcValueBindings) {
        if (loadedState != null) {
            EntityPersister persister = this.entityPersister();
            boolean[] versionability = persister.getPropertyVersionability();
            for (int attributeIndex = 0; attributeIndex < versionability.length; ++attributeIndex) {
                Object loadedValue;
                AttributeMapping attribute;
                if (!versionability[attributeIndex] || (attribute = persister.getAttributeMapping(attributeIndex)).isPluralAttributeMapping() || (loadedValue = loadedState[attributeIndex]) == null) continue;
                String mutationTableName = persister.getAttributeMutationTableName(attributeIndex);
                attribute.breakDownJdbcValues(loadedValue, 0, jdbcValueBindings, mutationTableName, (valueIndex, bindings, tableName, jdbcValue, jdbcValueMapping) -> {
                    if (jdbcValue == null) {
                        return;
                    }
                    bindings.bindValue(jdbcValue, (String)tableName, jdbcValueMapping.getSelectionExpression(), ParameterUsage.RESTRICT);
                }, session);
            }
        }
    }

    private void applyVersionLocking(Object version, JdbcValueBindings jdbcValueBindings) {
        EntityPersister persister = this.entityPersister();
        EntityVersionMapping versionMapping = persister.getVersionMapping();
        if (version != null && versionMapping != null) {
            jdbcValueBindings.bindValue(version, persister.physicalTableNameForMutation(versionMapping), versionMapping.getSelectionExpression(), ParameterUsage.RESTRICT);
        }
    }

    protected void applyId(Object id, Object rowId, MutationExecutor mutationExecutor, MutationOperationGroup operationGroup, SharedSessionContractImplementor session) {
        JdbcValueBindings jdbcValueBindings = mutationExecutor.getJdbcValueBindings();
        for (int position = 0; position < operationGroup.getNumberOfOperations(); ++position) {
            MutationOperation jdbcMutation = operationGroup.getOperation(position);
            EntityTableMapping tableDetails = (EntityTableMapping)jdbcMutation.getTableDetails();
            this.breakDownKeyJdbcValues(id, rowId, session, jdbcValueBindings, tableDetails);
            PreparedStatementDetails statementDetails = mutationExecutor.getPreparedStatementDetails(tableDetails.getTableName());
            if (statementDetails == null) continue;
            statementDetails.resolveStatement();
        }
    }

    protected void doStaticDelete(Object entity, Object id, Object rowId, Object[] loadedState, Object version, SharedSessionContractImplementor session) {
        MutationOperationGroup operationGroupToUse;
        boolean applyVersion;
        if (entity == null) {
            applyVersion = false;
            operationGroupToUse = this.resolveNoVersionDeleteGroup(session);
        } else {
            applyVersion = true;
            operationGroupToUse = this.staticOperationGroup;
        }
        MutationExecutor mutationExecutor = this.executor(session, operationGroupToUse);
        for (int position = 0; position < this.staticOperationGroup.getNumberOfOperations(); ++position) {
            MutationOperation mutation = this.staticOperationGroup.getOperation(position);
            if (mutation == null) continue;
            mutationExecutor.getPreparedStatementDetails(mutation.getTableDetails().getTableName());
        }
        this.applyStaticDeleteTableDetails(id, rowId, loadedState, version, applyVersion, mutationExecutor, session);
        mutationExecutor.execute(entity, null, null, (statementDetails, affectedRowCount, batchPosition) -> ModelMutationHelper.identifiedResultsCheck(statementDetails, affectedRowCount, batchPosition, this.entityPersister(), id, this.factory()), session);
        mutationExecutor.release();
    }

    protected void applyStaticDeleteTableDetails(Object id, Object rowId, Object[] loadedState, Object version, boolean applyVersion, MutationExecutor mutationExecutor, SharedSessionContractImplementor session) {
        if (applyVersion) {
            this.applyLocking(version, null, mutationExecutor, session);
        }
        JdbcValueBindings jdbcValueBindings = mutationExecutor.getJdbcValueBindings();
        this.bindPartitionColumnValueBindings(loadedState, session, jdbcValueBindings);
        this.applyId(id, rowId, mutationExecutor, this.staticOperationGroup, session);
    }

    private MutationExecutor executor(SharedSessionContractImplementor session, MutationOperationGroup group) {
        return this.mutationExecutorService.createExecutor(this.resolveBatchKeyAccess(false, session), group, session);
    }

    protected MutationOperationGroup resolveNoVersionDeleteGroup(SharedSessionContractImplementor session) {
        if (this.noVersionDeleteGroup == null) {
            this.noVersionDeleteGroup = this.generateOperationGroup("", null, false, session);
        }
        return this.noVersionDeleteGroup;
    }
}

