/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.internal;

import jakarta.persistence.Parameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.internal.util.collections.LinkedIdentityHashMap;
import org.hibernate.internal.util.compare.ComparableComparator;
import org.hibernate.query.BindableType;
import org.hibernate.query.ParameterLabelException;
import org.hibernate.query.QueryParameter;
import org.hibernate.query.UnknownParameterException;
import org.hibernate.query.spi.ParameterMetadataImplementor;
import org.hibernate.query.spi.QueryParameterImplementor;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.query.sqm.tree.expression.SqmParameter;

public class ParameterMetadataImpl
implements ParameterMetadataImplementor {
    public static final ParameterMetadataImpl EMPTY = new ParameterMetadataImpl();
    private final Map<QueryParameterImplementor<?>, List<SqmParameter<?>>> queryParameters;
    private final Map<String, QueryParameterImplementor<?>> queryParametersByName;
    private final Map<Integer, QueryParameterImplementor<?>> queryParametersByPosition;

    private ParameterMetadataImpl() {
        this.queryParameters = Collections.emptyMap();
        this.queryParametersByName = null;
        this.queryParametersByPosition = null;
    }

    public ParameterMetadataImpl(Map<QueryParameterImplementor<?>, List<SqmParameter<?>>> queryParameters) {
        this.queryParameters = queryParameters;
        HashMap tempQueryParametersByName = null;
        HashMap tempQueryParametersByPosition = null;
        for (QueryParameterImplementor<?> queryParameter : queryParameters.keySet()) {
            if (queryParameter.getPosition() != null) {
                if (tempQueryParametersByPosition == null) {
                    tempQueryParametersByPosition = new HashMap();
                }
                tempQueryParametersByPosition.put(queryParameter.getPosition(), queryParameter);
                continue;
            }
            if (queryParameter.getName() == null) continue;
            if (tempQueryParametersByName == null) {
                tempQueryParametersByName = new HashMap();
            }
            tempQueryParametersByName.put(queryParameter.getName(), queryParameter);
        }
        if (tempQueryParametersByPosition != null) {
            ParameterMetadataImpl.verifyOrdinalParamLabels(tempQueryParametersByPosition.keySet());
        }
        this.queryParametersByPosition = tempQueryParametersByPosition;
        this.queryParametersByName = tempQueryParametersByName;
    }

    public ParameterMetadataImpl(Map<Integer, QueryParameterImplementor<?>> positionalQueryParameters, Map<String, QueryParameterImplementor<?>> namedQueryParameters) {
        if (CollectionHelper.isEmpty(positionalQueryParameters) && CollectionHelper.isEmpty(namedQueryParameters)) {
            this.queryParameters = Collections.emptyMap();
            this.queryParametersByName = null;
            this.queryParametersByPosition = null;
        } else {
            this.queryParameters = new LinkedIdentityHashMap();
            HashMap tempQueryParametersByName = null;
            HashMap tempQueryParametersByPosition = null;
            if (positionalQueryParameters != null) {
                for (QueryParameterImplementor<?> value : positionalQueryParameters.values()) {
                    this.queryParameters.put(value, Collections.emptyList());
                    if (tempQueryParametersByPosition == null) {
                        tempQueryParametersByPosition = new HashMap();
                    }
                    tempQueryParametersByPosition.put(value.getPosition(), value);
                }
                if (tempQueryParametersByPosition != null) {
                    ParameterMetadataImpl.verifyOrdinalParamLabels(tempQueryParametersByPosition.keySet());
                }
            }
            if (namedQueryParameters != null) {
                for (QueryParameterImplementor<?> value : namedQueryParameters.values()) {
                    if (tempQueryParametersByName == null) {
                        tempQueryParametersByName = new HashMap();
                    }
                    this.queryParameters.put(value, Collections.emptyList());
                    tempQueryParametersByName.put(value.getName(), value);
                }
            }
            this.queryParametersByPosition = tempQueryParametersByPosition;
            this.queryParametersByName = tempQueryParametersByName;
        }
    }

    private static void verifyOrdinalParamLabels(Set<Integer> labels) {
        if (CollectionHelper.isEmpty(labels)) {
            return;
        }
        ArrayList<Integer> sortedLabels = new ArrayList<Integer>(labels);
        sortedLabels.sort(ComparableComparator.instance());
        int lastPosition = -1;
        for (Integer sortedPosition : sortedLabels) {
            if (lastPosition == -1) {
                if (sortedPosition != 1) {
                    throw new ParameterLabelException(String.format(Locale.ROOT, "Ordinal parameter labels start from '?%s' (ordinal parameters must be labelled from '?1')", sortedPosition));
                }
                lastPosition = sortedPosition;
                continue;
            }
            if (sortedPosition != lastPosition + 1) {
                throw new ParameterLabelException(String.format(Locale.ROOT, "Gap between '?%s' and '?%s' in ordinal parameter labels [%s] (ordinal parameters must be labelled sequentially)", lastPosition, sortedPosition, StringHelper.join(",", sortedLabels.iterator())));
            }
            lastPosition = sortedPosition;
        }
    }

    @Override
    public int getParameterCount() {
        return this.queryParameters.size();
    }

    @Override
    public <T> BindableType<T> getInferredParameterType(QueryParameter<T> parameter) {
        List<SqmParameter<?>> sqmParameters = this.queryParameters.get(parameter);
        if (sqmParameters == null || sqmParameters.isEmpty()) {
            return null;
        }
        for (SqmParameter<?> sqmParameter : sqmParameters) {
            SqmExpressible nodeType = sqmParameter.getNodeType();
            if (nodeType == null) continue;
            return nodeType;
        }
        return null;
    }

    @Override
    public boolean containsReference(QueryParameter<?> parameter) {
        return this.queryParameters.containsKey(parameter);
    }

    @Override
    public void visitParameters(Consumer<QueryParameterImplementor<?>> consumer) {
        this.queryParameters.keySet().forEach(consumer);
    }

    public Set<QueryParameterImplementor<?>> getRegistrations() {
        return Collections.unmodifiableSet(this.queryParameters.keySet());
    }

    @Override
    public boolean hasAnyMatching(Predicate<QueryParameterImplementor<?>> filter) {
        for (QueryParameterImplementor<?> queryParameter : this.queryParameters.keySet()) {
            if (!filter.test(queryParameter)) continue;
            return true;
        }
        return false;
    }

    @Override
    public <P> QueryParameterImplementor<P> resolve(Parameter<P> param) {
        if (param instanceof QueryParameterImplementor) {
            return (QueryParameterImplementor)param;
        }
        String errorMessage = "Could not resolve jakarta.persistence.Parameter '" + param + "' to org.hibernate.query.QueryParameter";
        throw new IllegalArgumentException(errorMessage, (Throwable)((Object)new UnknownParameterException(errorMessage)));
    }

    @Override
    public boolean hasNamedParameters() {
        return this.queryParametersByName != null && !this.queryParametersByName.isEmpty();
    }

    @Override
    public Set<String> getNamedParameterNames() {
        if (this.queryParametersByName == null) {
            return Collections.EMPTY_SET;
        }
        return this.queryParametersByName.keySet();
    }

    @Override
    public QueryParameterImplementor<?> findQueryParameter(String name) {
        if (this.queryParametersByName == null) {
            return null;
        }
        return this.queryParametersByName.get(name);
    }

    @Override
    public QueryParameterImplementor<?> getQueryParameter(String name) {
        QueryParameter parameter = this.findQueryParameter(name);
        if (parameter != null) {
            return parameter;
        }
        String errorMessage = String.format(Locale.ROOT, "No parameter named ':%s' in query with named parameters [%s]", name, String.join((CharSequence)", ", this.getNamedParameterNames()));
        throw new IllegalArgumentException(errorMessage, (Throwable)((Object)new UnknownParameterException(errorMessage)));
    }

    @Override
    public boolean hasPositionalParameters() {
        return this.queryParametersByPosition != null && !this.queryParametersByPosition.isEmpty();
    }

    @Override
    public Set<Integer> getOrdinalParameterLabels() {
        if (this.queryParametersByPosition == null) {
            return Collections.EMPTY_SET;
        }
        return this.queryParametersByPosition.keySet();
    }

    @Override
    public QueryParameterImplementor<?> findQueryParameter(int positionLabel) {
        if (this.queryParametersByPosition == null) {
            return null;
        }
        return this.queryParametersByPosition.get(positionLabel);
    }

    @Override
    public QueryParameterImplementor<?> getQueryParameter(int positionLabel) {
        QueryParameter queryParameter = this.findQueryParameter(positionLabel);
        if (queryParameter != null) {
            return queryParameter;
        }
        String errorMessage = String.format(Locale.ROOT, "No parameter labelled '?%s' in query with ordinal parameters [%s]", positionLabel, StringHelper.join(", ", this.getOrdinalParameterLabels()));
        throw new IllegalArgumentException(errorMessage, (Throwable)((Object)new UnknownParameterException(errorMessage)));
    }
}

