/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression;

import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.query.criteria.JpaExpression;
import org.hibernate.query.internal.QueryHelper;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.query.sqm.SqmTreeCreationLogger;
import org.hibernate.query.sqm.internal.SqmCriteriaNodeBuilder;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.jpa.AbstractJpaSelection;
import org.hibernate.query.sqm.tree.predicate.SqmPredicate;
import org.hibernate.type.descriptor.java.JavaType;

public abstract class AbstractSqmExpression<T>
extends AbstractJpaSelection<T>
implements SqmExpression<T> {
    public AbstractSqmExpression(@Nullable SqmExpressible<? super T> type, NodeBuilder criteriaBuilder) {
        super(type, criteriaBuilder);
    }

    @Override
    public SqmCriteriaNodeBuilder nodeBuilder() {
        return (SqmCriteriaNodeBuilder)super.nodeBuilder();
    }

    @Override
    public void applyInferableType(@Nullable SqmExpressible<?> type) {
    }

    protected void internalApplyInferableType(@Nullable SqmExpressible<?> newType) {
        SqmTreeCreationLogger.LOGGER.debugf("Applying inferable type to SqmExpression [%s] : %s -> %s", (Object)this, (Object)this.getExpressible(), newType);
        this.setExpressibleType(QueryHelper.highestPrecedenceType2(newType, this.getExpressible()));
    }

    private <B> SqmExpression<B> castToBasicType(Class<B> javaType) {
        return this.castAs(this.nodeBuilder().getTypeConfiguration().getBasicTypeForJavaType(javaType));
    }

    @Override
    public SqmExpression<Long> asLong() {
        return this.castToBasicType(Long.class);
    }

    @Override
    public SqmExpression<Integer> asInteger() {
        return this.castToBasicType(Integer.class);
    }

    @Override
    public SqmExpression<Float> asFloat() {
        return this.castToBasicType(Float.class);
    }

    @Override
    public SqmExpression<Double> asDouble() {
        return this.castToBasicType(Double.class);
    }

    @Override
    public SqmExpression<BigDecimal> asBigDecimal() {
        return this.castToBasicType(BigDecimal.class);
    }

    @Override
    public SqmExpression<BigInteger> asBigInteger() {
        return this.castToBasicType(BigInteger.class);
    }

    @Override
    public SqmExpression<String> asString() {
        return this.castToBasicType(String.class);
    }

    @Override
    public <X> SqmExpression<X> as(Class<X> type) {
        return this.nodeBuilder().cast((JpaExpression)this, (Class)type);
    }

    @Override
    public SqmPredicate isNull() {
        return this.nodeBuilder().isNull(this);
    }

    @Override
    public SqmPredicate isNotNull() {
        return this.nodeBuilder().isNotNull(this);
    }

    @Override
    public SqmPredicate equalTo(Expression<?> value) {
        return this.nodeBuilder().equal((Expression)this, (Expression)value);
    }

    @Override
    public SqmPredicate equalTo(Object value) {
        return this.nodeBuilder().equal((Expression)this, value);
    }

    public Predicate notEqualTo(Expression<?> value) {
        return this.nodeBuilder().notEqual((Expression)this, (Expression)value);
    }

    public Predicate notEqualTo(Object value) {
        return this.nodeBuilder().notEqual((Expression)this, value);
    }

    public <X> Expression<X> cast(Class<X> castTarget) {
        return this.nodeBuilder().cast((JpaExpression)this, (Class)castTarget);
    }

    @Override
    public SqmPredicate in(Object ... values) {
        return this.nodeBuilder().in((Expression)this, values);
    }

    @Override
    public SqmPredicate in(Expression<?> ... values) {
        return this.nodeBuilder().in((Expression)this, (Expression[])values);
    }

    @Override
    public SqmPredicate in(Collection<?> values) {
        return this.nodeBuilder().in((Expression)this, values);
    }

    @Override
    public SqmPredicate in(Expression<Collection<?>> values) {
        return this.nodeBuilder().in((Expression)this, new Expression[]{values});
    }

    @Override
    public @Nullable JavaType<T> getJavaTypeDescriptor() {
        return this.getNodeType() == null ? null : this.getNodeType().getExpressibleJavaType();
    }
}

