/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.collection.internal;

import java.util.function.BiConsumer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.collection.spi.CollectionSemantics;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.CollectionKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.CollectionClassification;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.InitializerData;
import org.hibernate.sql.results.graph.InitializerParent;
import org.hibernate.sql.results.graph.collection.CollectionInitializer;
import org.hibernate.sql.results.graph.collection.LoadingCollectionEntry;
import org.hibernate.sql.results.graph.entity.EntityInitializer;
import org.hibernate.sql.results.graph.internal.AbstractInitializer;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;

public abstract class AbstractCollectionInitializer<Data extends CollectionInitializerData>
extends AbstractInitializer<Data>
implements CollectionInitializer<Data> {
    protected final NavigablePath collectionPath;
    protected final PluralAttributeMapping collectionAttributeMapping;
    protected final boolean isResultInitializer;
    protected final @Nullable InitializerParent<?> parent;
    protected final @Nullable EntityInitializer<?> owningEntityInitializer;
    protected final @Nullable DomainResultAssembler<?> collectionKeyResultAssembler;

    protected AbstractCollectionInitializer(NavigablePath collectionPath, PluralAttributeMapping collectionAttributeMapping, InitializerParent<?> parent, @Nullable DomainResult<?> collectionKeyResult, boolean isResultInitializer, AssemblerCreationState creationState) {
        super(creationState);
        this.collectionPath = collectionPath;
        this.collectionAttributeMapping = collectionAttributeMapping;
        this.isResultInitializer = isResultInitializer;
        this.parent = parent;
        this.owningEntityInitializer = Initializer.findOwningEntityInitializer(parent);
        this.collectionKeyResultAssembler = collectionKeyResult == null ? null : collectionKeyResult.createResultAssembler(this, creationState);
    }

    @Override
    protected InitializerData createInitializerData(RowProcessingState rowProcessingState) {
        return new CollectionInitializerData(rowProcessingState);
    }

    @Override
    public void resolveKey(Data data) {
        if (((InitializerData)data).getState() != Initializer.State.UNINITIALIZED) {
            return;
        }
        ((InitializerData)data).setState(Initializer.State.KEY_RESOLVED);
        ((CollectionInitializerData)data).collectionKeyValue = null;
        if (this.collectionKeyResultAssembler != null) {
            Initializer<?> initializer = this.collectionKeyResultAssembler.getInitializer();
            RowProcessingState rowProcessingState = ((InitializerData)data).getRowProcessingState();
            if (initializer != null) {
                Object subData = initializer.getData(rowProcessingState);
                initializer.resolveKey(subData);
                if (((InitializerData)subData).getState() == Initializer.State.MISSING) {
                    this.setMissing(data);
                }
                return;
            }
            ((CollectionInitializerData)data).collectionKeyValue = this.collectionKeyResultAssembler.assemble(rowProcessingState);
            if (((CollectionInitializerData)data).collectionKeyValue == null) {
                this.setMissing(data);
            }
        }
    }

    protected void setMissing(Data data) {
        ((InitializerData)data).setState(Initializer.State.MISSING);
        ((CollectionInitializerData)data).collectionKey = null;
        ((CollectionInitializerData)data).collectionKeyValue = null;
        ((CollectionInitializerData)data).setCollectionInstance(null);
    }

    protected void resolveCollectionKey(Data data, boolean checkPreviousRow) {
        CollectionKey oldKey = ((CollectionInitializerData)data).collectionKey;
        PersistentCollection<?> oldCollectionInstance = ((CollectionInitializerData)data).getCollectionInstance();
        ((CollectionInitializerData)data).collectionKey = null;
        ((CollectionInitializerData)data).setCollectionInstance(null);
        if (((CollectionInitializerData)data).collectionKeyValue == null) {
            if (this.collectionKeyResultAssembler == null) {
                assert (this.owningEntityInitializer != null);
                ((CollectionInitializerData)data).collectionKeyValue = this.owningEntityInitializer.getEntityIdentifier(((InitializerData)data).getRowProcessingState());
            } else {
                ((CollectionInitializerData)data).collectionKeyValue = this.collectionKeyResultAssembler.assemble(((InitializerData)data).getRowProcessingState());
            }
            if (((CollectionInitializerData)data).collectionKeyValue == null) {
                ((InitializerData)data).setState(Initializer.State.MISSING);
                ((CollectionInitializerData)data).collectionKey = null;
                ((CollectionInitializerData)data).setCollectionInstance(null);
                return;
            }
        }
        CollectionPersister persister = this.collectionAttributeMapping.getCollectionDescriptor();
        if (checkPreviousRow && oldKey != null && persister.getKeyType().isEqual(oldKey.getKey(), ((CollectionInitializerData)data).collectionKeyValue)) {
            ((CollectionInitializerData)data).collectionKey = oldKey;
            ((CollectionInitializerData)data).setCollectionInstance(oldCollectionInstance);
            ((InitializerData)data).setState(oldCollectionInstance == null ? Initializer.State.MISSING : Initializer.State.RESOLVED);
        } else {
            ((CollectionInitializerData)data).collectionKey = new CollectionKey(persister, ((CollectionInitializerData)data).collectionKeyValue);
            ((InitializerData)data).setState(Initializer.State.KEY_RESOLVED);
        }
    }

    @Override
    protected void resolveInstance(Data data, boolean isEager) {
        if (((InitializerData)data).getState() != Initializer.State.KEY_RESOLVED) {
            return;
        }
        this.resolveCollectionKey(data, false);
        if (((InitializerData)data).getState() == Initializer.State.KEY_RESOLVED) {
            assert (this.parent != null);
            RowProcessingState rowProcessingState = ((InitializerData)data).getRowProcessingState();
            if (this.owningEntityInitializer != null && ((InitializerData)this.owningEntityInitializer.getData(rowProcessingState)).getState() == Initializer.State.INITIALIZED) {
                ((InitializerData)data).setState(Initializer.State.MISSING);
                return;
            }
            ((InitializerData)data).setState(Initializer.State.RESOLVED);
            SharedSessionContractImplementor session = rowProcessingState.getSession();
            PersistenceContext persistenceContext = session.getPersistenceContext();
            LoadingCollectionEntry loadingEntry = persistenceContext.getLoadContexts().findLoadingCollectionEntry(((CollectionInitializerData)data).collectionKey);
            if (loadingEntry != null) {
                ((CollectionInitializerData)data).setCollectionInstance(loadingEntry.getCollectionInstance());
                if (((CollectionInitializerData)data).getCollectionInstance().getOwner() == null) {
                    assert (this.owningEntityInitializer.getTargetInstance(rowProcessingState) != null);
                    ((CollectionInitializerData)data).getCollectionInstance().setOwner(this.owningEntityInitializer.getTargetInstance(rowProcessingState));
                }
                return;
            }
            PersistentCollection<?> existing = persistenceContext.getCollection(((CollectionInitializerData)data).collectionKey);
            if (existing != null) {
                ((CollectionInitializerData)data).setCollectionInstance(existing);
                if (((CollectionInitializerData)data).getCollectionInstance().getOwner() == null) {
                    assert (this.owningEntityInitializer.getTargetInstance(rowProcessingState) != null);
                    ((CollectionInitializerData)data).getCollectionInstance().setOwner(this.owningEntityInitializer.getTargetInstance(rowProcessingState));
                }
                return;
            }
            CollectionPersister collectionDescriptor = this.collectionAttributeMapping.getCollectionDescriptor();
            CollectionSemantics<?, ?> collectionSemantics = collectionDescriptor.getCollectionSemantics();
            Object key = ((CollectionInitializerData)data).collectionKey.getKey();
            ((CollectionInitializerData)data).setCollectionInstance(collectionSemantics.instantiateWrapper(key, collectionDescriptor, session));
            assert (this.owningEntityInitializer.getTargetInstance(rowProcessingState) != null);
            ((CollectionInitializerData)data).getCollectionInstance().setOwner(this.owningEntityInitializer.getTargetInstance(rowProcessingState));
            persistenceContext.addUninitializedCollection(collectionDescriptor, ((CollectionInitializerData)data).getCollectionInstance(), key);
            if (isEager) {
                persistenceContext.addNonLazyCollection(((CollectionInitializerData)data).getCollectionInstance());
            }
            if (collectionSemantics.getCollectionClassification() == CollectionClassification.ARRAY) {
                session.getPersistenceContext().addCollectionHolder(((CollectionInitializerData)data).getCollectionInstance());
            }
        }
    }

    protected void resolveInstance(Object instance, Data data, boolean isEager) {
        if (instance == null) {
            this.setMissing(data);
        } else {
            RowProcessingState rowProcessingState = ((InitializerData)data).getRowProcessingState();
            PersistenceContext persistenceContext = rowProcessingState.getSession().getPersistenceContextInternal();
            PersistentCollection<?> persistentCollection = this.collectionAttributeMapping.getCollectionDescriptor().getCollectionSemantics().getCollectionClassification() == CollectionClassification.ARRAY ? persistenceContext.getCollectionHolder(instance) : (PersistentCollection<?>)instance;
            ((CollectionInitializerData)data).setCollectionInstance(persistentCollection);
            ((InitializerData)data).setState(Initializer.State.RESOLVED);
            if (isEager && !((CollectionInitializerData)data).getCollectionInstance().wasInitialized()) {
                persistenceContext.addNonLazyCollection(((CollectionInitializerData)data).getCollectionInstance());
            }
            if (this.collectionKeyResultAssembler != null && rowProcessingState.needsResolveState()) {
                this.collectionKeyResultAssembler.resolveState(rowProcessingState);
            }
        }
    }

    @Override
    protected void forEachSubInitializer(BiConsumer<Initializer<?>, RowProcessingState> consumer, InitializerData data) {
        Initializer<?> initializer;
        if (this.collectionKeyResultAssembler != null && (initializer = this.collectionKeyResultAssembler.getInitializer()) != null) {
            consumer.accept(initializer, data.getRowProcessingState());
        }
    }

    @Override
    public @Nullable PersistentCollection<?> getCollectionInstance(Data data) {
        return ((InitializerData)data).getState() == Initializer.State.UNINITIALIZED || ((InitializerData)data).getState() == Initializer.State.MISSING ? null : ((CollectionInitializerData)data).getCollectionInstance();
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.collectionPath;
    }

    public PluralAttributeMapping getCollectionAttributeMapping() {
        return this.collectionAttributeMapping;
    }

    @Override
    public PluralAttributeMapping getInitializedPart() {
        return this.getCollectionAttributeMapping();
    }

    @Override
    public @Nullable InitializerParent<?> getParent() {
        return this.parent;
    }

    @Override
    public boolean isPartOfKey() {
        return false;
    }

    @Override
    public boolean isResultInitializer() {
        return this.isResultInitializer;
    }

    public static class CollectionInitializerData
    extends InitializerData {
        protected @Nullable Object collectionKeyValue;
        protected @Nullable CollectionKey collectionKey;

        public CollectionInitializerData(RowProcessingState rowProcessingState) {
            super(rowProcessingState);
        }

        public @Nullable PersistentCollection<?> getCollectionInstance() {
            return (PersistentCollection)this.getInstance();
        }

        public void setCollectionInstance(@Nullable PersistentCollection<?> collectionInstance) {
            this.setInstance(collectionInstance);
        }
    }
}

