/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.collection.internal;

import java.util.List;
import java.util.function.BiConsumer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.collection.spi.PersistentList;
import org.hibernate.engine.spi.CollectionKey;
import org.hibernate.internal.log.LoggingHelper;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.InitializerData;
import org.hibernate.sql.results.graph.InitializerParent;
import org.hibernate.sql.results.graph.collection.internal.AbstractImmediateCollectionInitializer;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;

public class ListInitializer
extends AbstractImmediateCollectionInitializer<AbstractImmediateCollectionInitializer.ImmediateCollectionInitializerData> {
    private static final String CONCRETE_NAME = ListInitializer.class.getSimpleName();
    private final DomainResultAssembler<Integer> listIndexAssembler;
    private final DomainResultAssembler<?> elementAssembler;
    private final int listIndexBase;

    public ListInitializer(NavigablePath navigablePath, PluralAttributeMapping attributeMapping, InitializerParent<?> parent, LockMode lockMode, DomainResult<?> collectionKeyResult, DomainResult<?> collectionValueKeyResult, boolean isResultInitializer, AssemblerCreationState creationState, Fetch listIndexFetch, Fetch elementFetch) {
        super(navigablePath, attributeMapping, parent, lockMode, collectionKeyResult, collectionValueKeyResult, isResultInitializer, creationState);
        this.listIndexAssembler = listIndexFetch.createAssembler(this, creationState);
        this.elementAssembler = elementFetch.createAssembler(this, creationState);
        this.listIndexBase = attributeMapping.getIndexMetadata().getListIndexBase();
    }

    @Override
    protected String getSimpleConcreteImplName() {
        return CONCRETE_NAME;
    }

    @Override
    protected void forEachSubInitializer(BiConsumer<Initializer<?>, RowProcessingState> consumer, InitializerData data) {
        super.forEachSubInitializer(consumer, data);
        Initializer<?> initializer = this.elementAssembler.getInitializer();
        if (initializer != null) {
            consumer.accept(initializer, data.getRowProcessingState());
        }
    }

    @Override
    public @Nullable PersistentList<?> getCollectionInstance(AbstractImmediateCollectionInitializer.ImmediateCollectionInitializerData data) {
        return (PersistentList)super.getCollectionInstance(data);
    }

    @Override
    protected void readCollectionRow(CollectionKey collectionKey, List<Object> loadingState, RowProcessingState rowProcessingState) {
        Integer indexValue = this.listIndexAssembler.assemble(rowProcessingState);
        if (indexValue == null) {
            throw new HibernateException("Illegal null value for list index encountered while reading: " + this.getCollectionAttributeMapping().getNavigableRole());
        }
        Object element = this.elementAssembler.assemble(rowProcessingState);
        if (element == null) {
            return;
        }
        int index = indexValue;
        if (this.listIndexBase != 0) {
            index -= this.listIndexBase;
        }
        for (int i = loadingState.size(); i <= index; ++i) {
            loadingState.add(i, null);
        }
        loadingState.set(index, element);
    }

    @Override
    protected void initializeSubInstancesFromParent(AbstractImmediateCollectionInitializer.ImmediateCollectionInitializerData data) {
        Initializer<?> initializer = this.elementAssembler.getInitializer();
        if (initializer != null) {
            RowProcessingState rowProcessingState = data.getRowProcessingState();
            PersistentList<?> list = this.getCollectionInstance(data);
            assert (list != null);
            for (Object element : list) {
                initializer.initializeInstanceFromParent(element, rowProcessingState);
            }
        }
    }

    @Override
    protected void resolveInstanceSubInitializers(AbstractImmediateCollectionInitializer.ImmediateCollectionInitializerData data) {
        Initializer<?> initializer = this.elementAssembler.getInitializer();
        if (initializer != null) {
            RowProcessingState rowProcessingState = data.getRowProcessingState();
            PersistentList<?> list = this.getCollectionInstance(data);
            assert (list != null);
            for (Object element : list) {
                initializer.resolveInstance(element, rowProcessingState);
            }
        }
    }

    @Override
    public DomainResultAssembler<?> getIndexAssembler() {
        return this.listIndexAssembler;
    }

    @Override
    public DomainResultAssembler<?> getElementAssembler() {
        return this.elementAssembler;
    }

    public String toString() {
        return "ListInitializer(" + LoggingHelper.toLoggableString(this.getNavigablePath()) + ")";
    }
}

