/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.collection.internal;

import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.internal.log.LoggingHelper;
import org.hibernate.metamodel.CollectionClassification;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.InitializerParent;
import org.hibernate.sql.results.graph.collection.internal.AbstractCollectionInitializer;

public class SelectEagerCollectionInitializer
extends AbstractCollectionInitializer<AbstractCollectionInitializer.CollectionInitializerData> {
    public SelectEagerCollectionInitializer(NavigablePath fetchedPath, PluralAttributeMapping fetchedMapping, InitializerParent<?> parent, @Nullable DomainResult<?> collectionKeyResult, AssemblerCreationState creationState) {
        super(fetchedPath, fetchedMapping, parent, collectionKeyResult, false, creationState);
    }

    @Override
    public void resolveInstance(AbstractCollectionInitializer.CollectionInitializerData data) {
        this.resolveInstance(data, true);
    }

    @Override
    public void resolveInstance(@Nullable Object instance, AbstractCollectionInitializer.CollectionInitializerData data) {
        this.resolveInstance(instance, data, true);
    }

    @Override
    public void initializeInstanceFromParent(Object parentInstance, AbstractCollectionInitializer.CollectionInitializerData data) {
        Object instance = this.getInitializedPart().getValue(parentInstance);
        if (this.collectionAttributeMapping.getCollectionDescriptor().getCollectionSemantics().getCollectionClassification() == CollectionClassification.ARRAY) {
            data.setCollectionInstance(data.getRowProcessingState().getSession().getPersistenceContextInternal().getCollectionHolder(instance));
        } else {
            data.setCollectionInstance((PersistentCollection)instance);
        }
        data.setState(Initializer.State.INITIALIZED);
        data.getCollectionInstance().forceInitialization();
    }

    public String toString() {
        return "SelectEagerCollectionInitializer(" + LoggingHelper.toLoggableString(this.getNavigablePath()) + ")";
    }
}

