/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.embeddable.internal;

import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.InitializerData;
import org.hibernate.sql.results.graph.InitializerParent;
import org.hibernate.sql.results.graph.basic.BasicFetch;
import org.hibernate.sql.results.graph.embeddable.EmbeddableInitializer;
import org.hibernate.sql.results.graph.embeddable.EmbeddableResultGraphNode;
import org.hibernate.sql.results.graph.embeddable.internal.EmbeddableInitializerImpl;
import org.hibernate.sql.results.graph.embeddable.internal.NestedRowProcessingState;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;

public class AggregateEmbeddableInitializerImpl
extends EmbeddableInitializerImpl {
    private final int[] aggregateValuesArrayPositions;

    public AggregateEmbeddableInitializerImpl(EmbeddableResultGraphNode resultDescriptor, BasicFetch<?> discriminatorFetch, InitializerParent<?> parent, AssemblerCreationState creationState, boolean isResultInitializer, SqlSelection structSelection) {
        super(resultDescriptor, discriminatorFetch, parent, creationState, isResultInitializer);
        this.aggregateValuesArrayPositions = AggregateEmbeddableInitializerImpl.determineAggregateValuesArrayPositions(parent, structSelection);
        DomainResultAssembler<?>[][] assemblers = super.createAssemblers(resultDescriptor, creationState, resultDescriptor.getReferencedMappingType());
        System.arraycopy(assemblers, 0, this.assemblers, 0, assemblers.length);
        Initializer<InitializerData>[][] initializers = AggregateEmbeddableInitializerImpl.createInitializers(assemblers);
        System.arraycopy(initializers, 0, this.subInitializers, 0, initializers.length);
    }

    @Override
    public void startLoading(RowProcessingState rowProcessingState) {
        super.startLoading(NestedRowProcessingState.wrap(this, rowProcessingState));
    }

    @Override
    protected DomainResultAssembler<?>[][] createAssemblers(EmbeddableResultGraphNode resultDescriptor, AssemblerCreationState creationState, EmbeddableMappingType embeddableTypeDescriptor) {
        return new DomainResultAssembler[embeddableTypeDescriptor.isPolymorphic() ? embeddableTypeDescriptor.getConcreteEmbeddableTypes().size() : 1][];
    }

    public int[] getAggregateValuesArrayPositions() {
        return this.aggregateValuesArrayPositions;
    }

    public Object[] getJdbcValues(RowProcessingState processingState) {
        int[] aggregateValuesArrayPositions = this.getAggregateValuesArrayPositions();
        Object[] jdbcValue = (Object[])processingState.getJdbcValue(aggregateValuesArrayPositions[0]);
        for (int i = 1; i < aggregateValuesArrayPositions.length && jdbcValue != null; ++i) {
            jdbcValue = (Object[])jdbcValue[aggregateValuesArrayPositions[i]];
        }
        return jdbcValue;
    }

    static int[] determineAggregateValuesArrayPositions(InitializerParent<?> parent, SqlSelection structSelection) {
        if (parent instanceof AggregateEmbeddableInitializerImpl) {
            int[] parentAggregateValuesArrayPositions = ((AggregateEmbeddableInitializerImpl)parent).getAggregateValuesArrayPositions();
            int[] aggregateValuesArrayPositions = new int[parentAggregateValuesArrayPositions.length + 1];
            System.arraycopy(parentAggregateValuesArrayPositions, 0, aggregateValuesArrayPositions, 0, parentAggregateValuesArrayPositions.length);
            aggregateValuesArrayPositions[aggregateValuesArrayPositions.length - 1] = structSelection.getValuesArrayPosition();
            return aggregateValuesArrayPositions;
        }
        if (parent instanceof EmbeddableInitializer) {
            return AggregateEmbeddableInitializerImpl.determineAggregateValuesArrayPositions(parent.getParent(), structSelection);
        }
        return new int[]{structSelection.getValuesArrayPosition()};
    }
}

