/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.embeddable.internal;

import java.util.function.BiConsumer;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.InitializerData;
import org.hibernate.sql.results.graph.embeddable.EmbeddableInitializer;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;
import org.hibernate.type.descriptor.java.JavaType;

public class EmbeddableAssembler
implements DomainResultAssembler {
    protected final EmbeddableInitializer<InitializerData> initializer;

    public EmbeddableAssembler(EmbeddableInitializer<?> initializer) {
        this.initializer = initializer;
    }

    public JavaType getAssembledJavaType() {
        return this.initializer.getInitializedPart().getJavaType();
    }

    public Object assemble(RowProcessingState rowProcessingState) {
        Object data = this.initializer.getData(rowProcessingState);
        this.initializer.resolveInstance((InitializerData)data);
        return this.initializer.getCompositeInstance((InitializerData)data);
    }

    @Override
    public void resolveState(RowProcessingState rowProcessingState) {
        this.initializer.resolveState(rowProcessingState);
    }

    public EmbeddableInitializer<?> getInitializer() {
        return this.initializer;
    }

    public void forEachResultAssembler(BiConsumer consumer, Object arg) {
        if (this.initializer.isResultInitializer()) {
            consumer.accept(this.initializer, arg);
        }
    }
}

