/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.entity.internal;

import java.util.Collection;
import java.util.function.BiConsumer;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.EntityFilterException;
import org.hibernate.FetchNotFoundException;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.StaleObjectStateException;
import org.hibernate.WrongClassException;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.bytecode.enhance.spi.LazyPropertyInitializer;
import org.hibernate.bytecode.enhance.spi.interceptor.EnhancementAsProxyLazinessInterceptor;
import org.hibernate.cache.spi.access.CachedDomainDataAccess;
import org.hibernate.cache.spi.access.EntityDataAccess;
import org.hibernate.cache.spi.entry.CacheEntry;
import org.hibernate.engine.internal.ManagedTypeHelper;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityHolder;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.EntityUniqueKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.hibernate.engine.spi.SessionEventListenerManager;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.event.spi.EventManager;
import org.hibernate.event.spi.HibernateMonitoringEvent;
import org.hibernate.event.spi.PreLoadEvent;
import org.hibernate.event.spi.PreLoadEventListener;
import org.hibernate.internal.log.LoggingHelper;
import org.hibernate.loader.ast.internal.CacheEntityLoaderHelper;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.AttributeMetadata;
import org.hibernate.metamodel.mapping.CompositeIdentifierMapping;
import org.hibernate.metamodel.mapping.DiscriminatorValueDetails;
import org.hibernate.metamodel.mapping.EntityDiscriminatorMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.EntityValuedModelPart;
import org.hibernate.metamodel.mapping.EntityVersionMapping;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.ManagedMappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.UniqueKeyEntry;
import org.hibernate.property.access.internal.PropertyAccessStrategyBackRefImpl;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.proxy.map.MapProxy;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.InitializerData;
import org.hibernate.sql.results.graph.InitializerParent;
import org.hibernate.sql.results.graph.basic.BasicResultAssembler;
import org.hibernate.sql.results.graph.entity.EntityInitializer;
import org.hibernate.sql.results.graph.entity.EntityResultGraphNode;
import org.hibernate.sql.results.graph.internal.AbstractInitializer;
import org.hibernate.sql.results.internal.NullValueAssembler;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesSourceProcessingOptions;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;
import org.hibernate.stat.spi.StatisticsImplementor;
import org.hibernate.type.Type;

public class EntityInitializerImpl
extends AbstractInitializer<EntityInitializerData>
implements EntityInitializer<EntityInitializerData> {
    private final EntityValuedModelPart referencedModelPart;
    private final EntityPersister entityDescriptor;
    private final EntityPersister rootEntityDescriptor;
    private final NavigablePath navigablePath;
    private final String sourceAlias;
    private final @Nullable InitializerParent<?> parent;
    private final NotFoundAction notFoundAction;
    private final boolean affectedByFilter;
    private final boolean isPartOfKey;
    private final boolean isResultInitializer;
    private final boolean hasKeyManyToOne;
    private final @Nullable DomainResultAssembler<?> keyAssembler;
    private final @Nullable DomainResultAssembler<?> identifierAssembler;
    private final @Nullable BasicResultAssembler<?> discriminatorAssembler;
    private final @Nullable DomainResultAssembler<?> versionAssembler;
    private final @Nullable DomainResultAssembler<Object> rowIdAssembler;
    private final DomainResultAssembler<?>[][] assemblers;
    private final Initializer<?>[][] subInitializers;

    public EntityInitializerImpl(EntityResultGraphNode resultDescriptor, String sourceAlias, @Nullable Fetch identifierFetch, @Nullable Fetch discriminatorFetch, @Nullable DomainResult<?> keyResult, @Nullable DomainResult<Object> rowIdResult, NotFoundAction notFoundAction, boolean affectedByFilter, @Nullable InitializerParent<?> parent, boolean isResultInitializer, AssemblerCreationState creationState) {
        super(creationState);
        int i;
        this.referencedModelPart = resultDescriptor.getEntityValuedModelPart();
        this.entityDescriptor = (EntityPersister)this.referencedModelPart.getEntityMappingType();
        String rootEntityName = this.entityDescriptor.getRootEntityName();
        this.rootEntityDescriptor = rootEntityName == null || rootEntityName.equals(this.entityDescriptor.getEntityName()) ? this.entityDescriptor : this.entityDescriptor.getRootEntityDescriptor().getEntityPersister();
        this.navigablePath = resultDescriptor.getNavigablePath();
        this.sourceAlias = sourceAlias;
        this.parent = parent;
        this.isResultInitializer = isResultInitializer;
        this.isPartOfKey = Initializer.isPartOfKey(this.navigablePath, parent);
        assert (identifierFetch != null || isResultInitializer) : "Identifier must be fetched, unless this is a result initializer";
        if (identifierFetch == null) {
            this.identifierAssembler = null;
            this.hasKeyManyToOne = false;
        } else {
            this.identifierAssembler = identifierFetch.createAssembler(this, creationState);
            Initializer<?> initializer = this.identifierAssembler.getInitializer();
            boolean bl = this.hasKeyManyToOne = initializer != null;
        }
        assert (this.entityDescriptor.hasSubclasses() == (discriminatorFetch != null)) : "Discriminator should only be fetched if the entity has subclasses";
        this.discriminatorAssembler = discriminatorFetch != null ? (BasicResultAssembler)discriminatorFetch.createAssembler(this, creationState) : null;
        EntityVersionMapping versionMapping = this.entityDescriptor.getVersionMapping();
        if (versionMapping != null) {
            Fetch versionFetch = resultDescriptor.findFetch(versionMapping);
            assert (versionFetch != null);
            this.versionAssembler = versionFetch.createAssembler(this, creationState);
        } else {
            this.versionAssembler = null;
        }
        this.rowIdAssembler = rowIdResult != null ? rowIdResult.createResultAssembler(this, creationState) : null;
        Collection<EntityMappingType> subMappingTypes = this.rootEntityDescriptor.getSubMappingTypes();
        DomainResultAssembler[][] assemblers = new DomainResultAssembler[subMappingTypes.size() + 1][];
        Initializer[][] subInitializers = new Initializer[subMappingTypes.size() + 1][];
        assemblers[this.rootEntityDescriptor.getSubclassId()] = new DomainResultAssembler[this.rootEntityDescriptor.getNumberOfFetchables()];
        for (EntityMappingType subMappingType : subMappingTypes) {
            assemblers[subMappingType.getSubclassId()] = new DomainResultAssembler[subMappingType.getNumberOfFetchables()];
        }
        int size = this.entityDescriptor.getNumberOfFetchables();
        for (i = 0; i < size; ++i) {
            AttributeMapping attributeMapping = this.entityDescriptor.getFetchable(i).asAttributeMapping();
            Fetch fetch = resultDescriptor.findFetch(attributeMapping);
            DomainResultAssembler<?> stateAssembler = fetch == null ? new NullValueAssembler(attributeMapping.getMappedType().getMappedJavaType()) : fetch.createAssembler(this, creationState);
            int stateArrayPosition = attributeMapping.getStateArrayPosition();
            EntityMappingType declaringType = attributeMapping.getDeclaringType().asEntityMappingType();
            int subclassId = declaringType.getSubclassId();
            Initializer<?> subInitializer = stateAssembler.getInitializer();
            if (subInitializer != null) {
                if (subInitializers[subclassId] == null) {
                    subInitializers[subclassId] = new Initializer[size];
                }
                subInitializers[subclassId][stateArrayPosition] = subInitializer;
            }
            assemblers[subclassId][stateArrayPosition] = stateAssembler;
            for (EntityMappingType subMappingType : declaringType.getSubMappingTypes()) {
                assemblers[subMappingType.getSubclassId()][stateArrayPosition] = stateAssembler;
                if (subInitializer == null) continue;
                if (subInitializers[subMappingType.getSubclassId()] == null) {
                    subInitializers[subMappingType.getSubclassId()] = new Initializer[size];
                }
                subInitializers[subMappingType.getSubclassId()][stateArrayPosition] = subInitializer;
            }
        }
        block3: for (i = 0; i < subInitializers.length; ++i) {
            if (subInitializers[i] != null) {
                for (Initializer initializer : subInitializers[i]) {
                    if (initializer != null) continue block3;
                }
            }
            subInitializers[i] = Initializer.EMPTY_ARRAY;
        }
        this.assemblers = assemblers;
        this.subInitializers = subInitializers;
        this.notFoundAction = notFoundAction;
        this.keyAssembler = keyResult == null ? null : keyResult.createResultAssembler(this, creationState);
        this.affectedByFilter = affectedByFilter;
    }

    @Override
    protected EntityInitializerData createInitializerData(RowProcessingState rowProcessingState) {
        return new EntityInitializerData(rowProcessingState);
    }

    @Override
    public void resolveKey(EntityInitializerData data) {
        this.resolveKey(data, false);
    }

    @Override
    public @Nullable Object getEntityIdentifier(EntityInitializerData data) {
        return data.entityKey == null ? null : data.entityKey.getIdentifier();
    }

    @Override
    public @Nullable EntityKey resolveEntityKeyOnly(RowProcessingState rowProcessingState) {
        EntityInitializerData data = (EntityInitializerData)this.getData(rowProcessingState);
        this.resolveKey(data, true);
        if (data.getState() == Initializer.State.MISSING) {
            return null;
        }
        if (data.entityKey == null) {
            assert (this.identifierAssembler != null);
            Object id = this.identifierAssembler.assemble(rowProcessingState);
            if (id == null) {
                this.setMissing(data);
                return null;
            }
            this.resolveEntityKey(data, id);
        }
        return data.entityKey;
    }

    protected void resolveKey(EntityInitializerData data, boolean entityKeyOnly) {
        Object id;
        if (data.getState() != Initializer.State.UNINITIALIZED) {
            return;
        }
        data.setState(Initializer.State.KEY_RESOLVED);
        data.concreteDescriptor = null;
        data.entityKey = null;
        data.setInstance(null);
        data.entityInstanceForNotify = null;
        data.entityHolder = null;
        RowProcessingState rowProcessingState = data.getRowProcessingState();
        if (this.identifierAssembler == null) {
            id = rowProcessingState.getEntityId();
            assert (id != null) : "Initializer requires a not null id for loading";
        } else {
            Initializer<?> initializer = this.identifierAssembler.getInitializer();
            if (initializer != null) {
                Object subData = initializer.getData(rowProcessingState);
                initializer.resolveKey(subData);
                if (((InitializerData)subData).getState() == Initializer.State.MISSING) {
                    this.setMissing(data);
                    return;
                }
                data.concreteDescriptor = EntityInitializerImpl.determineConcreteEntityDescriptor(rowProcessingState, this.discriminatorAssembler, this.entityDescriptor);
                assert (data.concreteDescriptor != null);
                if (this.hasKeyManyToOne) {
                    if (!data.shallowCached && !entityKeyOnly) {
                        this.resolveKeySubInitializers(data);
                    }
                    return;
                }
            }
            if ((id = this.identifierAssembler.assemble(rowProcessingState)) == null) {
                this.setMissing(data);
                return;
            }
        }
        this.resolveEntityKey(data, id);
        if (!entityKeyOnly) {
            this.resolveInstance(data);
            if (!data.shallowCached) {
                if (data.getState() == Initializer.State.INITIALIZED) {
                    if (data.entityHolder.getEntityInitializer() == null) {
                        this.resolveInstanceSubInitializers(data);
                    } else {
                        this.resolveKeySubInitializers(data);
                    }
                } else {
                    this.resolveKeySubInitializers(data);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void resolveInstanceSubInitializers(EntityInitializerData data) {
        Object[] state;
        RowProcessingState rowProcessingState;
        Initializer<?>[] initializers;
        block11: {
            initializers = this.subInitializers[data.concreteDescriptor.getSubclassId()];
            if (initializers.length == 0) {
                return;
            }
            EntityEntry entityEntry = data.entityHolder.getEntityEntry();
            rowProcessingState = data.getRowProcessingState();
            assert (entityEntry == rowProcessingState.getSession().getPersistenceContextInternal().getEntry(data.entityInstanceForNotify));
            Object[] loadedState = entityEntry.getLoadedState();
            if (loadedState == null) {
                if (entityEntry.getStatus() == Status.READ_ONLY) {
                    state = data.concreteDescriptor.getValues(data.entityInstanceForNotify);
                    break block11;
                } else {
                    assert (entityEntry.getStatus() == Status.LOADING);
                    return;
                }
            }
            state = loadedState;
        }
        int i = 0;
        while (i < initializers.length) {
            Initializer<?> initializer = initializers[i];
            if (initializer != null) {
                Object subInstance = state[i];
                if (subInstance == LazyPropertyInitializer.UNFETCHED_PROPERTY) {
                    initializer.resolveKey(rowProcessingState);
                } else {
                    initializer.resolveInstance(subInstance, rowProcessingState);
                }
            }
            ++i;
        }
        return;
    }

    private void resolveKeySubInitializers(EntityInitializerData data) {
        RowProcessingState rowProcessingState = data.getRowProcessingState();
        for (Initializer<?> initializer : this.subInitializers[data.concreteDescriptor.getSubclassId()]) {
            if (initializer == null) continue;
            initializer.resolveKey(rowProcessingState);
        }
    }

    @EnsuresNonNull(value={"entityKey"})
    protected void resolveEntityKey(EntityInitializerData data, Object id) {
        if (data.concreteDescriptor == null) {
            data.concreteDescriptor = EntityInitializerImpl.determineConcreteEntityDescriptor(data.getRowProcessingState(), this.discriminatorAssembler, this.entityDescriptor);
            assert (data.concreteDescriptor != null);
        }
        data.entityKey = new EntityKey(id, data.concreteDescriptor);
    }

    protected void setMissing(EntityInitializerData data) {
        Object fkKeyValue;
        data.entityKey = null;
        data.concreteDescriptor = null;
        data.setInstance(null);
        data.entityInstanceForNotify = null;
        data.entityHolder = null;
        data.setState(Initializer.State.MISSING);
        if (this.keyAssembler != null && (fkKeyValue = this.keyAssembler.assemble(data.getRowProcessingState())) != null && this.notFoundAction != NotFoundAction.IGNORE) {
            if (this.affectedByFilter) {
                throw new EntityFilterException(this.getEntityDescriptor().getEntityName(), fkKeyValue, this.referencedModelPart.getNavigableRole().getFullPath());
            }
            throw new FetchNotFoundException(this.getEntityDescriptor().getEntityName(), fkKeyValue);
        }
    }

    @Override
    public void initializeInstanceFromParent(Object parentInstance, EntityInitializerData data) {
        AttributeMapping attributeMapping = this.getInitializedPart().asAttributeMapping();
        Object instance = attributeMapping != null ? attributeMapping.getValue(parentInstance) : parentInstance;
        SharedSessionContractImplementor session = data.getRowProcessingState().getSession();
        if (instance == null) {
            this.setMissing(data);
        } else {
            data.setInstance(instance);
            data.entityInstanceForNotify = Hibernate.unproxy(instance);
            data.concreteDescriptor = session.getEntityPersister(null, data.entityInstanceForNotify);
            this.resolveEntityKey(data, data.concreteDescriptor.getIdentifier(data.entityInstanceForNotify, session));
            data.entityHolder = session.getPersistenceContextInternal().getEntityHolder(data.entityKey);
            data.setState(Initializer.State.INITIALIZED);
            this.initializeSubInstancesFromParent(data);
        }
    }

    protected String getSimpleConcreteImplName() {
        return "EntityInitializerImpl";
    }

    @Override
    public boolean isResultInitializer() {
        return this.isResultInitializer;
    }

    private static void deepCopy(ManagedMappingType containerDescriptor, Object[] source, Object[] target) {
        int numberOfAttributeMappings = containerDescriptor.getNumberOfAttributeMappings();
        for (int i = 0; i < numberOfAttributeMappings; ++i) {
            AttributeMapping attributeMapping = containerDescriptor.getAttributeMapping(i);
            AttributeMetadata attributeMetadata = attributeMapping.getAttributeMetadata();
            if (!attributeMetadata.isUpdatable()) continue;
            int position = attributeMapping.getStateArrayPosition();
            target[position] = EntityInitializerImpl.copy(attributeMetadata, source[position]);
        }
    }

    private static Object copy(AttributeMetadata attributeMetadata, Object sourceValue) {
        return sourceValue == LazyPropertyInitializer.UNFETCHED_PROPERTY || sourceValue == PropertyAccessStrategyBackRefImpl.UNKNOWN ? sourceValue : attributeMetadata.getMutabilityPlan().deepCopy(sourceValue);
    }

    @Override
    public ModelPart getInitializedPart() {
        return this.referencedModelPart;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    protected DomainResultAssembler<?> getIdentifierAssembler() {
        return this.identifierAssembler;
    }

    @Override
    public EntityPersister getEntityDescriptor() {
        return this.entityDescriptor;
    }

    @Override
    public Object getEntityInstance(EntityInitializerData data) {
        return data.getInstance();
    }

    @Override
    public Object getTargetInstance(EntityInitializerData data) {
        return data.entityInstanceForNotify;
    }

    @Override
    public @Nullable InitializerParent<?> getParent() {
        return this.parent;
    }

    @Override
    public void startLoading(RowProcessingState rowProcessingState) {
        EntityInitializerData data = this.createInitializerData(rowProcessingState);
        rowProcessingState.setInitializerData(this.initializerId, data);
        if (rowProcessingState.isQueryCacheHit() && this.entityDescriptor.useShallowQueryCacheLayout()) {
            data.shallowCached = true;
        }
        data.lockMode = rowProcessingState.determineEffectiveLockMode(this.sourceAlias);
        if (this.isResultInitializer()) {
            data.uniqueKeyAttributePath = rowProcessingState.getEntityUniqueKeyAttributePath();
            data.uniqueKeyPropertyTypes = data.uniqueKeyAttributePath != null ? this.getParentEntityAttributeTypes(data.uniqueKeyAttributePath) : null;
            data.canUseEmbeddedIdentifierInstanceAsEntity = data.getRowProcessingState().getEntityId() != null && this.entityDescriptor.getIdentifierMapping() instanceof CompositeIdentifierMapping && !((CompositeIdentifierMapping)this.entityDescriptor.getIdentifierMapping()).hasContainingClass();
        } else {
            data.uniqueKeyAttributePath = null;
            data.uniqueKeyPropertyTypes = null;
            data.canUseEmbeddedIdentifierInstanceAsEntity = false;
        }
        data.hasCallbackActions = rowProcessingState.hasCallbackActions();
        this.forEachSubInitializer(Initializer::startLoading, data);
    }

    protected Type[] getParentEntityAttributeTypes(String attributeName) {
        Type[] attributeTypes = new Type[this.entityDescriptor.getRootEntityDescriptor().getSubclassEntityNames().size()];
        this.initializeAttributeType(attributeTypes, this.entityDescriptor, attributeName);
        for (EntityMappingType subMappingType : this.entityDescriptor.getSubMappingTypes()) {
            this.initializeAttributeType(attributeTypes, subMappingType.getEntityPersister(), attributeName);
        }
        return attributeTypes;
    }

    protected void initializeAttributeType(Type[] attributeTypes, EntityPersister entityDescriptor, String attributeName) {
        if (entityDescriptor.findByPath(attributeName) != null) {
            attributeTypes[entityDescriptor.getSubclassId()] = entityDescriptor.getPropertyType(attributeName);
        }
    }

    public static @Nullable EntityPersister determineConcreteEntityDescriptor(RowProcessingState rowProcessingState, BasicResultAssembler<?> discriminatorAssembler, EntityPersister entityDescriptor) throws WrongClassException {
        if (discriminatorAssembler == null || rowProcessingState.isQueryCacheHit() && !entityDescriptor.storeDiscriminatorInShallowQueryCacheLayout()) {
            return entityDescriptor;
        }
        assert (entityDescriptor.hasSubclasses()) : "Reading a discriminator from a result set should only happen if the entity has subclasses";
        EntityDiscriminatorMapping discriminatorMapping = entityDescriptor.getDiscriminatorMapping();
        assert (discriminatorMapping != null);
        Object discriminator = discriminatorAssembler.extractRawValue(rowProcessingState);
        DiscriminatorValueDetails discriminatorDetails = discriminatorMapping.resolveDiscriminatorValue(discriminator);
        if (discriminatorDetails == null) {
            assert (discriminator == null) : "Discriminator details should only be null for null values";
            return null;
        }
        EntityMappingType indicatedEntity = discriminatorDetails.getIndicatedEntity();
        if (indicatedEntity.isTypeOrSuperType(entityDescriptor)) {
            return indicatedEntity.getEntityPersister();
        }
        throw new WrongClassException(indicatedEntity.getEntityName(), null, entityDescriptor.getEntityName(), discriminator);
    }

    private boolean useEmbeddedIdentifierInstanceAsEntity(EntityInitializerData data) {
        return data.canUseEmbeddedIdentifierInstanceAsEntity && (data.concreteDescriptor = EntityInitializerImpl.determineConcreteEntityDescriptor(data.getRowProcessingState(), this.discriminatorAssembler, this.entityDescriptor)) != null && data.concreteDescriptor.isInstance(data.getRowProcessingState().getEntityId());
    }

    @Override
    public void resolveInstance(Object instance, EntityInitializerData data) {
        Initializer<?> initializer;
        if (instance == null) {
            this.setMissing(data);
            return;
        }
        data.setInstance(instance);
        LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(data.getInstance());
        RowProcessingState rowProcessingState = data.getRowProcessingState();
        SharedSessionContractImplementor session = rowProcessingState.getSession();
        if (lazyInitializer == null) {
            data.entityInstanceForNotify = data.getInstance();
            data.concreteDescriptor = session.getEntityPersister(null, data.getInstance());
            this.resolveEntityKey(data, data.concreteDescriptor.getIdentifier(data.getInstance(), session));
            data.entityHolder = session.getPersistenceContextInternal().getEntityHolder(data.entityKey);
            if (data.entityHolder == null) {
                this.resolveKey(data);
                assert (data.getState() == Initializer.State.MISSING);
                assert (this.referencedModelPart instanceof ToOneAttributeMapping && ((ToOneAttributeMapping)this.referencedModelPart).getSideNature() == ForeignKeyDescriptor.Nature.TARGET);
                return;
            }
            data.setState(data.entityHolder.getEntityInitializer() == null ? Initializer.State.INITIALIZED : Initializer.State.RESOLVED);
        } else if (lazyInitializer.isUninitialized()) {
            data.setState(Initializer.State.RESOLVED);
            EntityPersister entityPersister = data.concreteDescriptor = this.discriminatorAssembler == null ? this.entityDescriptor : EntityInitializerImpl.determineConcreteEntityDescriptor(rowProcessingState, this.discriminatorAssembler, this.entityDescriptor);
            assert (data.concreteDescriptor != null);
            this.resolveEntityKey(data, lazyInitializer.getIdentifier());
            data.entityHolder = session.getPersistenceContextInternal().claimEntityHolderIfPossible(data.entityKey, null, rowProcessingState.getJdbcValuesSourceProcessingState(), this);
            data.entityInstanceForNotify = this.resolveEntityInstance(data);
            lazyInitializer.setImplementation(data.entityInstanceForNotify);
            this.registerLoadingEntity(data, data.entityInstanceForNotify);
        } else {
            data.setState(Initializer.State.INITIALIZED);
            data.entityInstanceForNotify = lazyInitializer.getImplementation();
            data.concreteDescriptor = session.getEntityPersister(null, data.entityInstanceForNotify);
            this.resolveEntityKey(data, lazyInitializer.getIdentifier());
            data.entityHolder = session.getPersistenceContextInternal().getEntityHolder(data.entityKey);
        }
        if (this.identifierAssembler != null && (initializer = this.identifierAssembler.getInitializer()) != null) {
            initializer.resolveInstance(data.entityKey.getIdentifier(), rowProcessingState);
        }
        this.upgradeLockMode(data);
        if (data.getState() == Initializer.State.INITIALIZED) {
            this.registerReloadedEntity(data);
            this.resolveInstanceSubInitializers(data);
            if (rowProcessingState.needsResolveState()) {
                this.resolveState(data);
            }
        } else {
            this.resolveKeySubInitializers(data);
        }
    }

    @Override
    public void resolveInstance(EntityInitializerData data) {
        if (data.getState() != Initializer.State.KEY_RESOLVED) {
            return;
        }
        RowProcessingState rowProcessingState = data.getRowProcessingState();
        data.setState(Initializer.State.RESOLVED);
        if (data.entityKey == null) {
            assert (this.identifierAssembler != null);
            Object id = this.identifierAssembler.assemble(rowProcessingState);
            if (id == null) {
                this.setMissing(data);
                return;
            }
            this.resolveEntityKey(data, id);
        }
        PersistenceContext persistenceContext = rowProcessingState.getSession().getPersistenceContextInternal();
        data.entityHolder = persistenceContext.claimEntityHolderIfPossible(data.entityKey, null, rowProcessingState.getJdbcValuesSourceProcessingState(), this);
        if (this.useEmbeddedIdentifierInstanceAsEntity(data)) {
            data.entityInstanceForNotify = rowProcessingState.getEntityId();
            data.setInstance(data.entityInstanceForNotify);
        } else {
            this.resolveEntityInstance1(data);
            if (data.uniqueKeyAttributePath != null) {
                SharedSessionContractImplementor session = rowProcessingState.getSession();
                EntityPersister concreteDescriptor = this.getConcreteDescriptor(data);
                EntityUniqueKey euk = new EntityUniqueKey(concreteDescriptor.getEntityName(), data.uniqueKeyAttributePath, rowProcessingState.getEntityUniqueKey(), data.uniqueKeyPropertyTypes[concreteDescriptor.getSubclassId()], session.getFactory());
                session.getPersistenceContextInternal().addEntity(euk, this.getEntityInstance(data));
            }
        }
        if (data.getInstance() != null) {
            this.upgradeLockMode(data);
            if (data.getState() == Initializer.State.INITIALIZED) {
                this.registerReloadedEntity(data);
                if (rowProcessingState.needsResolveState()) {
                    this.resolveState(data);
                }
            }
            if (data.shallowCached) {
                this.initializeSubInstancesFromParent(data);
            }
        }
    }

    protected void resolveEntityInstance1(EntityInitializerData data) {
        boolean unwrapProxy;
        Object proxy = data.entityHolder.getProxy();
        boolean bl = unwrapProxy = proxy != null && this.referencedModelPart instanceof ToOneAttributeMapping && ((ToOneAttributeMapping)this.referencedModelPart).isUnwrapProxy() && this.getConcreteDescriptor(data).getBytecodeEnhancementMetadata().isEnhancedForLazyLoading();
        if (!unwrapProxy && this.isProxyInstance(proxy)) {
            Object entityFromExecutionContext = this.getEntityFromExecutionContext(data);
            if (entityFromExecutionContext != null) {
                data.entityInstanceForNotify = entityFromExecutionContext;
                data.setInstance(data.entityInstanceForNotify);
                this.registerReloadedEntity(data);
            } else {
                data.setInstance(proxy);
                if (Hibernate.isInitialized(data.getInstance())) {
                    data.setState(Initializer.State.INITIALIZED);
                    data.entityInstanceForNotify = Hibernate.unproxy(data.getInstance());
                } else {
                    LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(data.getInstance());
                    assert (lazyInitializer != null);
                    data.entityInstanceForNotify = this.resolveEntityInstance2(data);
                    lazyInitializer.setImplementation(data.entityInstanceForNotify);
                }
            }
        } else {
            Object existingEntity = data.entityHolder.getEntity();
            if (existingEntity != null) {
                data.entityInstanceForNotify = existingEntity;
                data.setInstance(data.entityInstanceForNotify);
                if (data.entityHolder.getEntityInitializer() == null) {
                    assert (data.entityHolder.isInitialized() == this.isExistingEntityInitialized(existingEntity));
                    if (data.entityHolder.isInitialized()) {
                        data.setState(Initializer.State.INITIALIZED);
                    } else if (this.isResultInitializer()) {
                        this.registerLoadingEntity(data, data.getInstance());
                    }
                } else if (data.entityHolder.getEntityInitializer() != this) {
                    data.setState(Initializer.State.INITIALIZED);
                }
            } else {
                Object entityFromExecutionContext = this.getEntityFromExecutionContext(data);
                if (entityFromExecutionContext != null) {
                    data.entityInstanceForNotify = entityFromExecutionContext;
                    data.setInstance(data.entityInstanceForNotify);
                    if (this.isResultInitializer()) {
                        this.registerLoadingEntity(data, data.getInstance());
                    }
                } else {
                    Initializer<?> idInitializer;
                    assert (data.entityHolder.getEntityInitializer() == this);
                    data.entityInstanceForNotify = this.resolveEntityInstance2(data);
                    data.setInstance(data.entityInstanceForNotify);
                    if (data.entityHolder.getEntityInitializer() == this && data.getState() != Initializer.State.INITIALIZED && this.identifierAssembler != null && (idInitializer = this.identifierAssembler.getInitializer()) != null) {
                        idInitializer.initializeInstance(data.getRowProcessingState());
                    }
                }
            }
        }
        assert (!data.shallowCached || data.getState() == Initializer.State.INITIALIZED) : "Forgot to initialize the entity";
    }

    protected Object getEntityFromExecutionContext(EntityInitializerData data) {
        RowProcessingState rowProcessingState = data.getRowProcessingState();
        ExecutionContext executionContext = rowProcessingState.getJdbcValuesSourceProcessingState().getExecutionContext();
        if (this.rootEntityDescriptor == executionContext.getRootEntityDescriptor() && data.entityKey.getIdentifier().equals(executionContext.getEntityId())) {
            return executionContext.getEntityInstance();
        }
        return null;
    }

    private void upgradeLockMode(EntityInitializerData data) {
        RowProcessingState rowProcessingState = data.getRowProcessingState();
        if (data.lockMode != LockMode.NONE && rowProcessingState.upgradeLocks()) {
            EntityEntry entry = data.entityHolder.getEntityEntry();
            assert (entry == rowProcessingState.getSession().getPersistenceContextInternal().getEntry(data.entityInstanceForNotify));
            if (entry != null && entry.getLockMode().lessThan(data.lockMode)) {
                if (this.versionAssembler != null && entry.getLockMode() != LockMode.NONE) {
                    this.checkVersion(data, entry, rowProcessingState);
                }
                entry.setLockMode(data.lockMode);
            }
        }
    }

    private boolean isProxyInstance(Object proxy) {
        return proxy != null && (proxy instanceof MapProxy || this.entityDescriptor.getJavaType().getJavaTypeClass().isInstance(proxy));
    }

    private boolean isExistingEntityInitialized(Object existingEntity) {
        return Hibernate.isInitialized(existingEntity);
    }

    private void checkVersion(EntityInitializerData data, EntityEntry entry, RowProcessingState rowProcessingState) throws HibernateException {
        Object version = entry.getVersion();
        if (version != null) {
            Object currentVersion = this.versionAssembler.assemble(rowProcessingState);
            if (!data.concreteDescriptor.getVersionType().isEqual(version, currentVersion)) {
                StatisticsImplementor statistics = rowProcessingState.getSession().getFactory().getStatistics();
                if (statistics.isStatisticsEnabled()) {
                    statistics.optimisticFailure(data.concreteDescriptor.getEntityName());
                }
                throw new StaleObjectStateException(data.concreteDescriptor.getEntityName(), entry.getId());
            }
        }
    }

    protected Object resolveEntityInstance2(EntityInitializerData data) {
        if (data.entityHolder.getEntityInitializer() == this) {
            assert (data.entityHolder.getEntity() == null);
            return this.resolveEntityInstance(data);
        }
        return data.entityHolder.getEntity();
    }

    protected Object resolveEntityInstance(EntityInitializerData data) {
        Object cached;
        RowProcessingState rowProcessingState = data.getRowProcessingState();
        Object resolved = this.resolveToOptionalInstance(data);
        if (resolved != null) {
            this.registerLoadingEntity(data, resolved);
            return resolved;
        }
        if (rowProcessingState.isQueryCacheHit() && this.entityDescriptor.useShallowQueryCacheLayout()) {
            data.setState(Initializer.State.INITIALIZED);
            SharedSessionContractImplementor session = rowProcessingState.getSession();
            assert (data.entityHolder.getEntityInitializer() == this);
            session.getPersistenceContextInternal().removeEntityHolder(data.entityKey);
            return session.internalLoad(data.concreteDescriptor.getEntityName(), data.entityKey.getIdentifier(), true, false);
        }
        if (this.entityDescriptor.canUseReferenceCacheEntries() && (cached = this.resolveInstanceFromCache(data)) != null) {
            data.setState(Initializer.State.INITIALIZED);
            return cached;
        }
        Object instance = this.instantiateEntity(data);
        this.registerLoadingEntity(data, instance);
        return instance;
    }

    protected Object instantiateEntity(EntityInitializerData data) {
        Object instance = data.getRowProcessingState().getSession().instantiate(data.concreteDescriptor, data.entityKey.getIdentifier());
        return instance;
    }

    private Object resolveToOptionalInstance(EntityInitializerData data) {
        if (this.isResultInitializer()) {
            JdbcValuesSourceProcessingOptions processingOptions = data.getRowProcessingState().getJdbcValuesSourceProcessingState().getProcessingOptions();
            return this.matchesOptionalInstance(data, processingOptions) ? processingOptions.getEffectiveOptionalObject() : null;
        }
        return null;
    }

    private boolean matchesOptionalInstance(EntityInitializerData data, JdbcValuesSourceProcessingOptions processingOptions) {
        Object optionalEntityInstance = processingOptions.getEffectiveOptionalObject();
        Object requestedEntityId = processingOptions.getEffectiveOptionalId();
        return requestedEntityId != null && optionalEntityInstance != null && requestedEntityId.equals(data.entityKey.getIdentifier());
    }

    private Object resolveInstanceFromCache(EntityInitializerData data) {
        return CacheEntityLoaderHelper.INSTANCE.loadFromSecondLevelCache(data.getRowProcessingState().getSession().asEventSource(), null, data.lockMode, this.entityDescriptor, data.entityKey);
    }

    protected void registerLoadingEntity(EntityInitializerData data, Object instance) {
        data.getRowProcessingState().getSession().getPersistenceContextInternal().claimEntityHolderIfPossible(data.entityKey, instance, data.getRowProcessingState().getJdbcValuesSourceProcessingState(), this);
    }

    protected void registerReloadedEntity(EntityInitializerData data) {
        if (data.hasCallbackActions) {
            data.entityHolder.markAsReloaded(data.getRowProcessingState().getJdbcValuesSourceProcessingState());
        }
    }

    @Override
    public void initializeInstance(EntityInitializerData data) {
        if (data.getState() != Initializer.State.RESOLVED) {
            return;
        }
        if (!this.skipInitialization(data)) {
            assert (this.consistentInstance(data));
            this.initializeEntityInstance(data);
        }
        data.setState(Initializer.State.INITIALIZED);
    }

    protected boolean consistentInstance(EntityInitializerData data) {
        PersistenceContext persistenceContextInternal = data.getRowProcessingState().getSession().getPersistenceContextInternal();
        Object entity = persistenceContextInternal.getEntity(data.entityKey);
        return entity == null || entity == data.entityInstanceForNotify;
    }

    private void initializeEntityInstance(EntityInitializerData data) {
        PersistentAttributeInterceptor persistentAttributeInterceptor;
        RowProcessingState rowProcessingState = data.getRowProcessingState();
        Object entityIdentifier = data.entityKey.getIdentifier();
        SharedSessionContractImplementor session = rowProcessingState.getSession();
        PersistenceContext persistenceContext = session.getPersistenceContextInternal();
        Object[] resolvedEntityState = this.extractConcreteTypeStateValues(data);
        this.preLoad(data, resolvedEntityState);
        if (ManagedTypeHelper.isPersistentAttributeInterceptable(data.entityInstanceForNotify) && ((persistentAttributeInterceptor = ManagedTypeHelper.asPersistentAttributeInterceptable(data.entityInstanceForNotify).$$_hibernate_getInterceptor()) == null || persistentAttributeInterceptor instanceof EnhancementAsProxyLazinessInterceptor)) {
            data.concreteDescriptor.getBytecodeEnhancementMetadata().injectInterceptor(data.entityInstanceForNotify, entityIdentifier, session);
        }
        data.concreteDescriptor.setPropertyValues(data.entityInstanceForNotify, resolvedEntityState);
        persistenceContext.addEntity(data.entityKey, data.entityInstanceForNotify);
        this.registerPossibleUniqueKeyEntries(data, resolvedEntityState, session);
        Object version = this.versionAssembler != null ? this.versionAssembler.assemble(rowProcessingState) : null;
        Object rowId = this.rowIdAssembler != null ? this.rowIdAssembler.assemble(rowProcessingState) : null;
        LockMode lockModeToAcquire = data.lockMode == LockMode.NONE ? LockMode.READ : data.lockMode;
        EntityEntry entityEntry = persistenceContext.addEntry(data.entityInstanceForNotify, Status.LOADING, resolvedEntityState, rowId, data.entityKey.getIdentifier(), version, lockModeToAcquire, true, data.concreteDescriptor, false);
        data.entityHolder.setEntityEntry(entityEntry);
        this.registerNaturalIdResolution(data, persistenceContext, resolvedEntityState);
        this.takeSnapshot(data, session, persistenceContext, entityEntry, resolvedEntityState);
        data.concreteDescriptor.afterInitialize(data.entityInstanceForNotify, session);
        assert (data.concreteDescriptor.getIdentifier(data.entityInstanceForNotify, session) != null);
        StatisticsImplementor statistics = session.getFactory().getStatistics();
        if (statistics.isStatisticsEnabled() && !rowProcessingState.isQueryCacheHit()) {
            statistics.loadEntity(data.concreteDescriptor.getEntityName());
        }
        this.updateCaches(data, session, session.getPersistenceContextInternal(), resolvedEntityState, version);
    }

    protected void updateCaches(EntityInitializerData data, SharedSessionContractImplementor session, PersistenceContext persistenceContext, Object[] resolvedEntityState, Object version) {
        EntityDataAccess cacheAccess;
        if (data.concreteDescriptor.canWriteToCache() && !data.getRowProcessingState().isQueryCacheHit() && session.getCacheMode().isPutEnabled() && (cacheAccess = data.concreteDescriptor.getCacheAccessStrategy()) != null) {
            this.putInCache(data, session, persistenceContext, resolvedEntityState, version, cacheAccess);
        }
    }

    protected void registerNaturalIdResolution(EntityInitializerData data, PersistenceContext persistenceContext, Object[] resolvedEntityState) {
        if (this.entityDescriptor.getNaturalIdMapping() != null) {
            Object naturalId = this.entityDescriptor.getNaturalIdMapping().extractNaturalIdFromEntityState(resolvedEntityState);
            persistenceContext.getNaturalIdResolutions().cacheResolutionFromLoad(data.entityKey.getIdentifier(), naturalId, this.entityDescriptor);
        }
    }

    protected void takeSnapshot(EntityInitializerData data, SharedSessionContractImplementor session, PersistenceContext persistenceContext, EntityEntry entityEntry, Object[] resolvedEntityState) {
        if (this.isReallyReadOnly(data, session)) {
            persistenceContext.setEntryStatus(entityEntry, Status.READ_ONLY);
        } else {
            EntityInitializerImpl.deepCopy(data.concreteDescriptor, resolvedEntityState, resolvedEntityState);
            persistenceContext.setEntryStatus(entityEntry, Status.MANAGED);
        }
    }

    private boolean isReallyReadOnly(EntityInitializerData data, SharedSessionContractImplementor session) {
        if (!data.concreteDescriptor.isMutable()) {
            return true;
        }
        LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(data.getInstance());
        if (lazyInitializer != null) {
            return lazyInitializer.isReadOnly();
        }
        return this.isReadOnly(data.getRowProcessingState(), session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putInCache(EntityInitializerData data, SharedSessionContractImplementor session, PersistenceContext persistenceContext, Object[] resolvedEntityState, Object version, EntityDataAccess cacheAccess) {
        SessionFactoryImplementor factory = session.getFactory();
        CacheEntry cacheEntry = data.concreteDescriptor.buildCacheEntry(data.entityInstanceForNotify, resolvedEntityState, version, session);
        Object cacheKey = cacheAccess.generateCacheKey(data.entityKey.getIdentifier(), this.rootEntityDescriptor, factory, session.getTenantIdentifier());
        EventManager eventManager = session.getEventManager();
        if (persistenceContext.wasInsertedDuringTransaction(data.concreteDescriptor, data.entityKey.getIdentifier())) {
            boolean update = false;
            HibernateMonitoringEvent cachePutEvent = eventManager.beginCachePutEvent();
            try {
                update = cacheAccess.update(session, cacheKey, data.concreteDescriptor.getCacheEntryStructure().structure(cacheEntry), version, version);
            }
            finally {
                eventManager.completeCachePutEvent(cachePutEvent, session, (CachedDomainDataAccess)cacheAccess, data.concreteDescriptor, update, EventManager.CacheActionDescription.ENTITY_UPDATE);
            }
        }
        SessionEventListenerManager eventListenerManager = session.getEventListenerManager();
        boolean put = false;
        HibernateMonitoringEvent cachePutEvent = eventManager.beginCachePutEvent();
        try {
            eventListenerManager.cachePutStart();
            put = cacheAccess.putFromLoad(session, cacheKey, data.concreteDescriptor.getCacheEntryStructure().structure(cacheEntry), version, false);
        }
        finally {
            eventManager.completeCachePutEvent(cachePutEvent, session, (CachedDomainDataAccess)cacheAccess, data.concreteDescriptor, put, EventManager.CacheActionDescription.ENTITY_LOAD);
            StatisticsImplementor statistics = factory.getStatistics();
            if (put && statistics.isStatisticsEnabled()) {
                statistics.entityCachePut(this.rootEntityDescriptor.getNavigableRole(), cacheAccess.getRegion().getName());
            }
            eventListenerManager.cachePutEnd();
        }
    }

    protected void registerPossibleUniqueKeyEntries(EntityInitializerData data, Object[] resolvedEntityState, SharedSessionContractImplementor session) {
        for (UniqueKeyEntry entry : data.concreteDescriptor.uniqueKeyEntries()) {
            String ukName = entry.getUniqueKeyName();
            int index = entry.getStateArrayPosition();
            Type type = entry.getPropertyType();
            if (resolvedEntityState[index] == null) continue;
            EntityUniqueKey entityUniqueKey = new EntityUniqueKey(data.concreteDescriptor.getRootEntityDescriptor().getEntityName(), ukName, resolvedEntityState[index], type, session.getFactory());
            session.getPersistenceContextInternal().addEntity(entityUniqueKey, data.entityInstanceForNotify);
        }
    }

    protected Object[] extractConcreteTypeStateValues(EntityInitializerData data) {
        RowProcessingState rowProcessingState = data.getRowProcessingState();
        Object[] values = new Object[data.concreteDescriptor.getNumberOfAttributeMappings()];
        DomainResultAssembler<?>[] concreteAssemblers = this.assemblers[data.concreteDescriptor.getSubclassId()];
        for (int i = 0; i < values.length; ++i) {
            DomainResultAssembler<?> assembler = concreteAssemblers[i];
            values[i] = assembler == null ? LazyPropertyInitializer.UNFETCHED_PROPERTY : assembler.assemble(rowProcessingState);
        }
        return values;
    }

    private void resolveState(EntityInitializerData data) {
        RowProcessingState rowProcessingState = data.getRowProcessingState();
        for (DomainResultAssembler<?> assembler : this.assemblers[data.concreteDescriptor.getSubclassId()]) {
            if (assembler == null) continue;
            assembler.resolveState(rowProcessingState);
        }
    }

    protected boolean skipInitialization(EntityInitializerData data) {
        PersistentAttributeInterceptor interceptor;
        if (data.entityHolder.getEntityInitializer() != this) {
            return true;
        }
        RowProcessingState rowProcessingState = data.getRowProcessingState();
        EntityEntry entry = data.entityHolder.getEntityEntry();
        assert (entry == rowProcessingState.getSession().getPersistenceContextInternal().getEntry(data.entityInstanceForNotify));
        if (entry == null) {
            return false;
        }
        if (entry.getStatus().isDeletedOrGone()) {
            return true;
        }
        if (ManagedTypeHelper.isPersistentAttributeInterceptable(data.entityInstanceForNotify) && (interceptor = ManagedTypeHelper.asPersistentAttributeInterceptable(data.entityInstanceForNotify).$$_hibernate_getInterceptor()) instanceof EnhancementAsProxyLazinessInterceptor) {
            return entry.getStatus() == Status.LOADING;
        }
        if (entry.getStatus() != Status.LOADING) {
            return rowProcessingState.getJdbcValuesSourceProcessingState().getProcessingOptions().getEffectiveOptionalObject() != data.entityInstanceForNotify;
        }
        return false;
    }

    private boolean isReadOnly(RowProcessingState rowProcessingState, SharedSessionContractImplementor persistenceContext) {
        Boolean readOnly = rowProcessingState.getQueryOptions().isReadOnly();
        return readOnly == null ? persistenceContext.isDefaultReadOnly() : readOnly.booleanValue();
    }

    protected void preLoad(EntityInitializerData data, Object[] resolvedEntityState) {
        RowProcessingState rowProcessingState = data.getRowProcessingState();
        SharedSessionContractImplementor session = rowProcessingState.getSession();
        if (session.isEventSource()) {
            PreLoadEvent preLoadEvent = rowProcessingState.getJdbcValuesSourceProcessingState().getPreLoadEvent();
            assert (preLoadEvent != null);
            preLoadEvent.reset();
            preLoadEvent.setEntity(data.getInstance()).setState(resolvedEntityState).setId(data.entityKey.getIdentifier()).setPersister(data.concreteDescriptor);
            session.getFactory().getFastSessionServices().eventListenerGroup_PRE_LOAD.fireEventOnEachListener(preLoadEvent, PreLoadEventListener::onPreLoad);
        }
    }

    @Override
    public boolean isPartOfKey() {
        return this.isPartOfKey;
    }

    @Override
    public EntityPersister getConcreteDescriptor(EntityInitializerData data) {
        assert (data.getState() != Initializer.State.UNINITIALIZED);
        return data.concreteDescriptor == null ? this.entityDescriptor : data.concreteDescriptor;
    }

    protected void initializeSubInstancesFromParent(EntityInitializerData data) {
        if (data.entityInstanceForNotify != null) {
            for (Initializer<?> initializer : this.subInitializers[data.concreteDescriptor.getSubclassId()]) {
                if (initializer == null) continue;
                initializer.initializeInstanceFromParent(data.entityInstanceForNotify, data.getRowProcessingState());
            }
        }
    }

    @Override
    protected void forEachSubInitializer(BiConsumer<Initializer<?>, RowProcessingState> consumer, InitializerData data) {
        Initializer<?> initializer;
        RowProcessingState rowProcessingState = data.getRowProcessingState();
        if (this.keyAssembler != null && (initializer = this.keyAssembler.getInitializer()) != null) {
            consumer.accept(initializer, rowProcessingState);
        }
        if (this.identifierAssembler != null && (initializer = this.identifierAssembler.getInitializer()) != null) {
            consumer.accept(initializer, rowProcessingState);
        }
        EntityInitializerData entityInitializerData = (EntityInitializerData)data;
        if (entityInitializerData.concreteDescriptor == null) {
            Initializer<?>[][] initializerArray = this.subInitializers;
            int n = initializerArray.length;
            for (int i = 0; i < n; ++i) {
                Initializer<?>[] initializers;
                for (Initializer<?> initializer2 : initializers = initializerArray[i]) {
                    if (initializer2 == null) continue;
                    consumer.accept(initializer2, rowProcessingState);
                }
            }
        } else {
            for (Initializer<?> initializer3 : this.subInitializers[entityInitializerData.concreteDescriptor.getSubclassId()]) {
                if (initializer3 == null) continue;
                consumer.accept(initializer3, rowProcessingState);
            }
        }
    }

    @Override
    public void endLoading(EntityInitializerData data) {
        super.endLoading(data);
        data.shallowCached = false;
    }

    public String toString() {
        return "EntityJoinedFetchInitializer(" + LoggingHelper.toLoggableString(this.getNavigablePath()) + ")";
    }

    protected DomainResultAssembler<?> getVersionAssembler() {
        return this.versionAssembler;
    }

    protected DomainResultAssembler<Object> getRowIdAssembler() {
        return this.rowIdAssembler;
    }

    protected DomainResultAssembler<?>[][] getAssemblers() {
        return this.assemblers;
    }

    public static class EntityInitializerData
    extends InitializerData {
        protected boolean shallowCached;
        protected LockMode lockMode;
        protected String uniqueKeyAttributePath;
        protected Type[] uniqueKeyPropertyTypes;
        protected boolean canUseEmbeddedIdentifierInstanceAsEntity;
        protected boolean hasCallbackActions;
        protected @Nullable EntityPersister concreteDescriptor;
        protected @Nullable EntityKey entityKey;
        protected @Nullable Object entityInstanceForNotify;
        protected @Nullable EntityHolder entityHolder;

        public EntityInitializerData(RowProcessingState rowProcessingState) {
            super(rowProcessingState);
        }
    }
}

