/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal.domain;

import java.util.BitSet;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.engine.FetchTiming;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.BiDirectionalFetch;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.InitializerData;
import org.hibernate.sql.results.graph.InitializerParent;
import org.hibernate.sql.results.graph.entity.EntityInitializer;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;
import org.hibernate.type.descriptor.java.JavaType;

public class CircularBiDirectionalFetchImpl
implements BiDirectionalFetch {
    private final NavigablePath navigablePath;
    private final ToOneAttributeMapping fetchedModelPart;
    private final FetchParent fetchParent;
    private final @Nullable DomainResult<?> keyResult;
    private final FetchTiming timing;
    private final NavigablePath referencedNavigablePath;

    public CircularBiDirectionalFetchImpl(FetchTiming timing, NavigablePath navigablePath, FetchParent fetchParent, ToOneAttributeMapping referencedModelPart, NavigablePath referencedNavigablePath, @Nullable DomainResult<?> keyResult) {
        this.navigablePath = navigablePath;
        this.fetchedModelPart = referencedModelPart;
        this.fetchParent = fetchParent;
        this.keyResult = keyResult;
        this.timing = timing;
        this.referencedNavigablePath = referencedNavigablePath;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public ToOneAttributeMapping getFetchedMapping() {
        return this.fetchedModelPart;
    }

    @Override
    public JavaType<?> getResultJavaType() {
        return this.fetchedModelPart.getJavaType();
    }

    @Override
    public FetchParent getFetchParent() {
        return this.fetchParent;
    }

    @Override
    public NavigablePath getReferencedPath() {
        return this.referencedNavigablePath;
    }

    @Override
    public FetchTiming getTiming() {
        return this.timing;
    }

    @Override
    public boolean hasTableGroup() {
        return true;
    }

    @Override
    public void collectValueIndexesToCache(BitSet valueIndexes) {
        if (this.keyResult != null) {
            this.keyResult.collectValueIndexesToCache(valueIndexes);
        }
    }

    public DomainResultAssembler createAssembler(InitializerParent<?> parent, AssemblerCreationState creationState) {
        return new CircularBiDirectionalFetchAssembler(this.getResultJavaType(), this.keyResult == null ? null : this.keyResult.createResultAssembler(parent, creationState), this.resolveCircularInitializer(parent));
    }

    private EntityInitializer<?> resolveCircularInitializer(InitializerParent<?> parent) {
        while (parent != null && this.getReferencedPath().isParent(parent.getNavigablePath())) {
            parent = parent.getParent();
        }
        assert (parent instanceof EntityInitializer && parent.getNavigablePath().equals(this.getReferencedPath()));
        return parent.asEntityInitializer();
    }

    private static class CircularBiDirectionalFetchAssembler
    implements DomainResultAssembler<Object> {
        private final JavaType<Object> javaType;
        private final @Nullable DomainResultAssembler<?> keyDomainResultAssembler;
        private final EntityInitializer<InitializerData> initializer;

        public CircularBiDirectionalFetchAssembler(JavaType<?> javaType, @Nullable DomainResultAssembler<?> keyDomainResultAssembler, EntityInitializer<?> initializer) {
            this.javaType = javaType;
            this.keyDomainResultAssembler = keyDomainResultAssembler;
            this.initializer = initializer;
        }

        @Override
        public Object assemble(RowProcessingState rowProcessingState) {
            Object foreignKey;
            if (this.keyDomainResultAssembler != null && (foreignKey = this.keyDomainResultAssembler.assemble(rowProcessingState)) == null) {
                return null;
            }
            Object data = this.initializer.getData(rowProcessingState);
            this.initializer.resolveInstance((InitializerData)data);
            Object initializedInstance = this.initializer.getEntityInstance((InitializerData)data);
            LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(initializedInstance);
            if (lazyInitializer != null) {
                Class<?> concreteProxyClass = this.initializer.getConcreteDescriptor((InitializerData)data).getConcreteProxyClass();
                if (concreteProxyClass.isInstance(initializedInstance)) {
                    return initializedInstance;
                }
                this.initializer.initializeInstance(rowProcessingState);
                return lazyInitializer.getImplementation();
            }
            return initializedInstance;
        }

        @Override
        public void resolveState(RowProcessingState rowProcessingState) {
            if (this.keyDomainResultAssembler != null) {
                this.keyDomainResultAssembler.resolveState(rowProcessingState);
            }
        }

        @Override
        public @Nullable Initializer<?> getInitializer() {
            return this.keyDomainResultAssembler == null ? null : this.keyDomainResultAssembler.getInitializer();
        }

        @Override
        public JavaType<Object> getAssembledJavaType() {
            return this.javaType;
        }
    }
}

