/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal.domain;

import java.util.function.BiConsumer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.engine.FetchTiming;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.BiDirectionalFetch;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.InitializerData;
import org.hibernate.sql.results.graph.InitializerParent;
import org.hibernate.sql.results.graph.basic.BasicFetch;
import org.hibernate.sql.results.graph.entity.EntityInitializer;
import org.hibernate.sql.results.graph.entity.internal.AbstractNonJoinedEntityFetch;
import org.hibernate.sql.results.graph.entity.internal.EntityDelayedFetchInitializer;
import org.hibernate.sql.results.graph.entity.internal.EntitySelectFetchInitializerBuilder;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;
import org.hibernate.type.descriptor.java.JavaType;

public class CircularFetchImpl
extends AbstractNonJoinedEntityFetch
implements BiDirectionalFetch {
    private final FetchTiming timing;
    private final NavigablePath referencedNavigablePath;

    public CircularFetchImpl(ToOneAttributeMapping referencedModelPart, FetchTiming timing, NavigablePath navigablePath, FetchParent fetchParent, boolean selectByUniqueKey, NavigablePath referencedNavigablePath, DomainResult<?> keyResult, DomainResultCreationState creationState) {
        super(navigablePath, referencedModelPart, fetchParent, keyResult, timing == FetchTiming.DELAYED && referencedModelPart.getEntityMappingType().getEntityPersister().isConcreteProxy(), selectByUniqueKey, creationState);
        this.timing = timing;
        this.referencedNavigablePath = referencedNavigablePath;
    }

    @Override
    public NavigablePath getReferencedPath() {
        return this.referencedNavigablePath;
    }

    @Override
    public FetchTiming getTiming() {
        return this.timing;
    }

    @Override
    public boolean hasTableGroup() {
        return true;
    }

    @Override
    public DomainResultAssembler<?> createAssembler(InitializerParent<?> parent, AssemblerCreationState creationState) {
        return new CircularFetchAssembler(this.getResultJavaType(), creationState.resolveInitializer(this, parent, this).asEntityInitializer());
    }

    @Override
    public EntityInitializer<?> createInitializer(InitializerParent<?> parent, AssemblerCreationState creationState) {
        if (this.timing == FetchTiming.IMMEDIATE) {
            return this.buildEntitySelectFetchInitializer(parent, this.getFetchedMapping(), this.getFetchedMapping().getEntityMappingType().getEntityPersister(), this.getKeyResult(), this.getNavigablePath(), this.isSelectByUniqueKey(), creationState);
        }
        return this.buildEntityDelayedFetchInitializer(parent, this.getNavigablePath(), this.getFetchedMapping(), this.isSelectByUniqueKey(), this.getKeyResult(), this.getDiscriminatorFetch(), creationState);
    }

    protected EntityInitializer<?> buildEntitySelectFetchInitializer(InitializerParent<?> parent, ToOneAttributeMapping fetchable, EntityPersister entityPersister, DomainResult<?> keyResult, NavigablePath navigablePath, boolean selectByUniqueKey, AssemblerCreationState creationState) {
        return EntitySelectFetchInitializerBuilder.createInitializer(parent, fetchable, entityPersister, keyResult, navigablePath, selectByUniqueKey, false, creationState);
    }

    protected EntityInitializer<?> buildEntityDelayedFetchInitializer(InitializerParent<?> parent, NavigablePath referencedPath, ToOneAttributeMapping fetchable, boolean selectByUniqueKey, DomainResult<?> keyResult, BasicFetch<?> discriminatorFetch, AssemblerCreationState creationState) {
        return new EntityDelayedFetchInitializer(parent, referencedPath, fetchable, selectByUniqueKey, keyResult, discriminatorFetch, creationState);
    }

    private static class CircularFetchAssembler
    implements DomainResultAssembler<Object> {
        private final EntityInitializer<InitializerData> initializer;
        private final JavaType<Object> assembledJavaType;

        public CircularFetchAssembler(JavaType<?> assembledJavaType, EntityInitializer<?> initializer) {
            this.assembledJavaType = assembledJavaType;
            this.initializer = initializer;
        }

        @Override
        public Object assemble(RowProcessingState rowProcessingState) {
            Object data = this.initializer.getData(rowProcessingState);
            this.initializer.resolveInstance((InitializerData)data);
            return this.initializer.getEntityInstance((InitializerData)data);
        }

        @Override
        public @Nullable Initializer<?> getInitializer() {
            return this.initializer;
        }

        @Override
        public <X> void forEachResultAssembler(BiConsumer<Initializer<?>, X> consumer, X arg) {
            if (this.initializer.isResultInitializer()) {
                consumer.accept(this.initializer, arg);
            }
        }

        @Override
        public JavaType<Object> getAssembledJavaType() {
            return this.assembledJavaType;
        }
    }
}

