/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.jdbc;

import java.sql.CallableStatement;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.engine.jdbc.CharacterStream;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.BasicBinder;
import org.hibernate.type.descriptor.jdbc.BasicExtractor;
import org.hibernate.type.descriptor.jdbc.JdbcType;

public abstract class NClobJdbcType
implements JdbcType {
    public static final NClobJdbcType DEFAULT = new NClobJdbcType(){

        @Override
        public String toString() {
            return "NClobTypeDescriptor(DEFAULT)";
        }

        @Override
        public Class<?> getPreferredJavaTypeClass(WrapperOptions options) {
            return String.class;
        }

        private NClobJdbcType getDescriptor(Object value, WrapperOptions options) {
            if (value instanceof String) {
                return STRING_BINDING;
            }
            if (options.useStreamForLobBinding()) {
                return STREAM_BINDING;
            }
            return NCLOB_BINDING;
        }

        @Override
        public <X> BasicBinder<X> getNClobBinder(final JavaType<X> javaType) {
            return new BasicBinder<X>(javaType, this){

                @Override
                protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                    this.getDescriptor(value, options).getNClobBinder(javaType).doBind(st, value, index, options);
                }

                @Override
                protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                    this.getDescriptor(value, options).getNClobBinder(javaType).doBind(st, value, name, options);
                }
            };
        }
    };
    public static final NClobJdbcType STRING_BINDING = new NClobJdbcType(){

        @Override
        public String toString() {
            return "NClobTypeDescriptor(STRING_BINDING)";
        }

        @Override
        public Class<?> getPreferredJavaTypeClass(WrapperOptions options) {
            return String.class;
        }

        @Override
        public <X> BasicBinder<X> getNClobBinder(final JavaType<X> javaType) {
            return new BasicBinder<X>(javaType, this){

                @Override
                protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                    st.setNString(index, javaType.unwrap(value, String.class, options));
                }

                @Override
                protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                    st.setNString(name, javaType.unwrap(value, String.class, options));
                }
            };
        }

        @Override
        public <X> ValueExtractor<X> getExtractor(final JavaType<X> javaType) {
            return new BasicExtractor<X>(javaType, this){

                @Override
                protected X doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
                    return javaType.wrap(rs.getNString(paramIndex), options);
                }

                @Override
                protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                    return javaType.wrap(statement.getNString(index), options);
                }

                @Override
                protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                    return javaType.wrap(statement.getNString(name), options);
                }
            };
        }
    };
    public static final NClobJdbcType NCLOB_BINDING = new NClobJdbcType(){

        @Override
        public String toString() {
            return "NClobTypeDescriptor(NCLOB_BINDING)";
        }

        @Override
        public Class<?> getPreferredJavaTypeClass(WrapperOptions options) {
            return NClob.class;
        }

        @Override
        public <X> BasicBinder<X> getNClobBinder(final JavaType<X> javaType) {
            return new BasicBinder<X>(javaType, this){

                @Override
                protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                    st.setNClob(index, javaType.unwrap(value, NClob.class, options));
                }

                @Override
                protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                    st.setNClob(name, javaType.unwrap(value, NClob.class, options));
                }
            };
        }
    };
    public static final NClobJdbcType STREAM_BINDING = new NClobJdbcType(){

        @Override
        public String toString() {
            return "NClobTypeDescriptor(STREAM_BINDING)";
        }

        @Override
        public Class<?> getPreferredJavaTypeClass(WrapperOptions options) {
            return CharacterStream.class;
        }

        @Override
        public <X> BasicBinder<X> getNClobBinder(final JavaType<X> javaType) {
            return new BasicBinder<X>(javaType, this){

                @Override
                protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                    CharacterStream characterStream = javaType.unwrap(value, CharacterStream.class, options);
                    st.setNCharacterStream(index, characterStream.asReader(), characterStream.getLength());
                }

                @Override
                protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                    CharacterStream characterStream = javaType.unwrap(value, CharacterStream.class, options);
                    st.setNCharacterStream(name, characterStream.asReader(), characterStream.getLength());
                }
            };
        }
    };
    public static final NClobJdbcType MATERIALIZED = new NClobJdbcType(){

        @Override
        public String toString() {
            return "NClobTypeDescriptor(MATERIALIZED)";
        }

        @Override
        public Class<?> getPreferredJavaTypeClass(WrapperOptions options) {
            return String.class;
        }

        @Override
        public <X> BasicBinder<X> getNClobBinder(final JavaType<X> javaType) {
            return new BasicBinder<X>(javaType, this){

                @Override
                protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                    st.setNString(index, javaType.unwrap(value, String.class, options));
                }

                @Override
                protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                    st.setNString(name, javaType.unwrap(value, String.class, options));
                }
            };
        }

        @Override
        public <X> ValueExtractor<X> getExtractor(final JavaType<X> javaType) {
            return new BasicExtractor<X>(javaType, this){

                @Override
                protected X doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
                    return javaType.wrap(rs.getNString(paramIndex), options);
                }

                @Override
                protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                    return javaType.wrap(statement.getNString(index), options);
                }

                @Override
                protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                    return javaType.wrap(statement.getNString(name), options);
                }
            };
        }
    };

    @Override
    public int getJdbcTypeCode() {
        return 2011;
    }

    @Override
    public String getFriendlyName() {
        return "NCLOB";
    }

    public String toString() {
        return "NClobTypeDescriptor";
    }

    @Override
    public <X> ValueExtractor<X> getExtractor(final JavaType<X> javaType) {
        return new BasicExtractor<X>(javaType, this){

            @Override
            protected X doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
                return javaType.wrap(rs.getNClob(paramIndex), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                return javaType.wrap(statement.getNClob(index), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                return javaType.wrap(statement.getNClob(name), options);
            }
        };
    }

    protected abstract <X> BasicBinder<X> getNClobBinder(JavaType<X> var1);

    @Override
    public <X> ValueBinder<X> getBinder(JavaType<X> javaType) {
        return this.getNClobBinder(javaType);
    }
}

