/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.internal;

import jakarta.persistence.AttributeConverter;
import jakarta.persistence.ConstraintMode;
import jakarta.persistence.SharedCacheMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import org.hibernate.AnnotationException;
import org.hibernate.HibernateException;
import org.hibernate.TimeZoneStorageStrategy;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.TimeZoneStorageType;
import org.hibernate.boot.CacheRegionDefinition;
import org.hibernate.boot.MetadataBuilder;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.archive.scan.spi.ScanEnvironment;
import org.hibernate.boot.archive.scan.spi.ScanOptions;
import org.hibernate.boot.archive.scan.spi.Scanner;
import org.hibernate.boot.archive.spi.ArchiveDescriptorFactory;
import org.hibernate.boot.cfgxml.spi.CfgXmlAccessService;
import org.hibernate.boot.cfgxml.spi.LoadedConfig;
import org.hibernate.boot.cfgxml.spi.MappingReference;
import org.hibernate.boot.internal.BootstrapContextImpl;
import org.hibernate.boot.jaxb.Origin;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmHibernateMapping;
import org.hibernate.boot.jaxb.hbm.transform.HbmXmlTransformer;
import org.hibernate.boot.jaxb.hbm.transform.UnsupportedFeatureHandling;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEntityMappingsImpl;
import org.hibernate.boot.jaxb.spi.Binding;
import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.boot.model.FunctionContributor;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.boot.model.TypeContributor;
import org.hibernate.boot.model.convert.internal.ClassBasedConverterDescriptor;
import org.hibernate.boot.model.convert.internal.InstanceBasedConverterDescriptor;
import org.hibernate.boot.model.convert.spi.ConverterDescriptor;
import org.hibernate.boot.model.naming.ImplicitNamingStrategy;
import org.hibernate.boot.model.naming.ImplicitNamingStrategyJpaCompliantImpl;
import org.hibernate.boot.model.naming.PhysicalNamingStrategy;
import org.hibernate.boot.model.naming.PhysicalNamingStrategyStandardImpl;
import org.hibernate.boot.model.process.spi.MetadataBuildingProcess;
import org.hibernate.boot.model.relational.AuxiliaryDatabaseObject;
import org.hibernate.boot.model.relational.ColumnOrderingStrategy;
import org.hibernate.boot.model.relational.ColumnOrderingStrategyStandard;
import org.hibernate.boot.models.xml.spi.PersistenceUnitMetadata;
import org.hibernate.boot.registry.BootstrapServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.selector.spi.StrategySelector;
import org.hibernate.boot.spi.BasicTypeRegistration;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.boot.spi.JpaOrmXmlPersistenceUnitDefaultAware;
import org.hibernate.boot.spi.MappingDefaults;
import org.hibernate.boot.spi.MetadataBuilderImplementor;
import org.hibernate.boot.spi.MetadataBuilderInitializer;
import org.hibernate.boot.spi.MetadataBuildingOptions;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.boot.spi.MetadataSourcesContributor;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.TimeZoneSupport;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.config.spi.StandardConverters;
import org.hibernate.engine.jdbc.env.internal.JdbcEnvironmentImpl;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.log.DeprecationLogger;
import org.hibernate.internal.util.NullnessHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.metamodel.CollectionClassification;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.query.sqm.function.SqmFunctionRegistry;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.spi.ServiceException;
import org.hibernate.type.BasicType;
import org.hibernate.type.WrapperArrayHandling;
import org.hibernate.type.spi.TypeConfiguration;
import org.hibernate.usertype.CompositeUserType;
import org.hibernate.usertype.UserType;
import org.jboss.jandex.IndexView;

public class MetadataBuilderImpl
implements MetadataBuilderImplementor,
TypeContributions {
    private static final CoreMessageLogger log = CoreLogging.messageLogger(MetadataBuilderImpl.class);
    private final MetadataSources sources;
    private final BootstrapContextImpl bootstrapContext;
    private final MetadataBuildingOptionsImpl options;

    public MetadataBuilderImpl(MetadataSources sources) {
        this(sources, MetadataBuilderImpl.getStandardServiceRegistry(sources.getServiceRegistry()));
    }

    public static StandardServiceRegistry getStandardServiceRegistry(ServiceRegistry serviceRegistry) {
        if (serviceRegistry == null) {
            throw new HibernateException("ServiceRegistry passed to MetadataBuilder cannot be null");
        }
        if (serviceRegistry instanceof StandardServiceRegistry) {
            return (StandardServiceRegistry)serviceRegistry;
        }
        if (serviceRegistry instanceof BootstrapServiceRegistry) {
            log.debug("ServiceRegistry passed to MetadataBuilder was a BootstrapServiceRegistry; this likely won't end well if attempt is made to build SessionFactory");
            return new StandardServiceRegistryBuilder((BootstrapServiceRegistry)serviceRegistry).build();
        }
        throw new HibernateException(String.format("Unexpected type of ServiceRegistry [%s] encountered in attempt to build MetadataBuilder", serviceRegistry.getClass().getName()));
    }

    public MetadataBuilderImpl(MetadataSources sources, StandardServiceRegistry serviceRegistry) {
        this.sources = sources;
        this.options = new MetadataBuildingOptionsImpl(serviceRegistry);
        this.bootstrapContext = new BootstrapContextImpl(serviceRegistry, this.options);
        this.options.setBootstrapContext(this.bootstrapContext);
        for (MetadataSourcesContributor metadataSourcesContributor : sources.getServiceRegistry().requireService(ClassLoaderService.class).loadJavaServices(MetadataSourcesContributor.class)) {
            metadataSourcesContributor.contribute(sources);
        }
        this.applyCfgXmlValues(serviceRegistry.requireService(CfgXmlAccessService.class));
        for (MetadataBuilderInitializer metadataBuilderInitializer : serviceRegistry.requireService(ClassLoaderService.class).loadJavaServices(MetadataBuilderInitializer.class)) {
            metadataBuilderInitializer.contribute(this, serviceRegistry);
        }
    }

    private void applyCfgXmlValues(CfgXmlAccessService service) {
        LoadedConfig aggregatedConfig = service.getAggregatedConfig();
        if (aggregatedConfig != null) {
            for (CacheRegionDefinition cacheRegionDefinition : aggregatedConfig.getCacheRegionDefinitions()) {
                this.applyCacheRegionDefinition(cacheRegionDefinition);
            }
        }
    }

    @Override
    public MetadataBuilder applyImplicitSchemaName(String implicitSchemaName) {
        this.options.mappingDefaults.implicitSchemaName = implicitSchemaName;
        return this;
    }

    @Override
    public MetadataBuilder applyImplicitCatalogName(String implicitCatalogName) {
        this.options.mappingDefaults.implicitCatalogName = implicitCatalogName;
        return this;
    }

    @Override
    public MetadataBuilder applyImplicitNamingStrategy(ImplicitNamingStrategy namingStrategy) {
        this.options.implicitNamingStrategy = namingStrategy;
        return this;
    }

    @Override
    public MetadataBuilder applyPhysicalNamingStrategy(PhysicalNamingStrategy namingStrategy) {
        this.options.physicalNamingStrategy = namingStrategy;
        return this;
    }

    @Override
    public MetadataBuilder applyColumnOrderingStrategy(ColumnOrderingStrategy columnOrderingStrategy) {
        this.options.columnOrderingStrategy = columnOrderingStrategy;
        return this;
    }

    @Override
    public MetadataBuilder applySharedCacheMode(SharedCacheMode sharedCacheMode) {
        this.options.sharedCacheMode = sharedCacheMode;
        return this;
    }

    @Override
    public MetadataBuilder applyAccessType(AccessType implicitCacheAccessType) {
        this.options.mappingDefaults.implicitCacheAccessType = implicitCacheAccessType;
        return this;
    }

    @Override
    public MetadataBuilder applyIndexView(IndexView jandexView) {
        this.bootstrapContext.injectJandexView(jandexView);
        return this;
    }

    @Override
    public MetadataBuilder applyScanOptions(ScanOptions scanOptions) {
        this.bootstrapContext.injectScanOptions(scanOptions);
        return this;
    }

    @Override
    public MetadataBuilder applyScanEnvironment(ScanEnvironment scanEnvironment) {
        this.bootstrapContext.injectScanEnvironment(scanEnvironment);
        return this;
    }

    @Override
    public MetadataBuilder applyScanner(Scanner scanner) {
        this.bootstrapContext.injectScanner(scanner);
        return this;
    }

    @Override
    public MetadataBuilder applyArchiveDescriptorFactory(ArchiveDescriptorFactory factory) {
        this.bootstrapContext.injectArchiveDescriptorFactory(factory);
        return this;
    }

    @Override
    public MetadataBuilder applyImplicitListSemantics(CollectionClassification classification) {
        if (classification != null) {
            this.options.mappingDefaults.implicitListClassification = classification;
        }
        return this;
    }

    @Override
    public MetadataBuilder enableExplicitDiscriminatorsForJoinedSubclassSupport(boolean supported) {
        this.options.explicitDiscriminatorsForJoinedInheritanceSupported = supported;
        return this;
    }

    @Override
    public MetadataBuilder enableImplicitDiscriminatorsForJoinedSubclassSupport(boolean supported) {
        this.options.implicitDiscriminatorsForJoinedInheritanceSupported = supported;
        return this;
    }

    @Override
    public MetadataBuilder enableImplicitForcingOfDiscriminatorsInSelect(boolean supported) {
        this.options.implicitlyForceDiscriminatorInSelect = supported;
        return this;
    }

    @Override
    public MetadataBuilder enableGlobalNationalizedCharacterDataSupport(boolean enabled) {
        this.options.useNationalizedCharacterData = enabled;
        return this;
    }

    @Override
    public MetadataBuilder applyBasicType(BasicType<?> type) {
        this.options.basicTypeRegistrations.add(new BasicTypeRegistration(type));
        return this;
    }

    @Override
    public MetadataBuilder applyBasicType(BasicType<?> type, String ... keys) {
        this.options.basicTypeRegistrations.add(new BasicTypeRegistration(type, keys));
        return this;
    }

    @Override
    public MetadataBuilder applyBasicType(UserType<?> type, String ... keys) {
        this.options.basicTypeRegistrations.add(new BasicTypeRegistration(type, keys, this.getTypeConfiguration()));
        return this;
    }

    @Override
    public MetadataBuilder applyTypes(TypeContributor typeContributor) {
        typeContributor.contribute(this, this.options.serviceRegistry);
        return this;
    }

    @Override
    @Deprecated
    public void contributeType(BasicType<?> type) {
        this.options.basicTypeRegistrations.add(new BasicTypeRegistration(type));
    }

    @Override
    @Deprecated
    public void contributeType(BasicType<?> type, String ... keys) {
        this.options.basicTypeRegistrations.add(new BasicTypeRegistration(type, keys));
    }

    @Override
    @Deprecated
    public void contributeType(UserType<?> type, String[] keys) {
        this.options.basicTypeRegistrations.add(new BasicTypeRegistration(type, keys, this.getTypeConfiguration()));
    }

    @Override
    public void contributeType(CompositeUserType<?> type) {
        this.options.compositeUserTypes.add(type);
    }

    @Override
    public TypeConfiguration getTypeConfiguration() {
        return this.bootstrapContext.getTypeConfiguration();
    }

    @Override
    public void contributeAttributeConverter(Class<? extends AttributeConverter<?, ?>> converterClass) {
        this.bootstrapContext.addAttributeConverterDescriptor(new ClassBasedConverterDescriptor(converterClass, this.bootstrapContext.getClassmateContext()));
    }

    @Override
    public MetadataBuilder applyCacheRegionDefinition(CacheRegionDefinition cacheRegionDefinition) {
        this.bootstrapContext.addCacheRegionDefinition(cacheRegionDefinition);
        return this;
    }

    @Override
    public MetadataBuilder applyTempClassLoader(ClassLoader tempClassLoader) {
        this.bootstrapContext.injectJpaTempClassLoader(tempClassLoader);
        return this;
    }

    public MetadataBuilder allowSpecjSyntax() {
        this.options.specjProprietarySyntaxEnabled = true;
        return this;
    }

    public MetadataBuilder noConstraintByDefault() {
        this.options.noConstraintByDefault = true;
        return this;
    }

    @Override
    public MetadataBuilder applyFunctions(FunctionContributor functionContributor) {
        functionContributor.contributeFunctions(new FunctionContributions(){

            @Override
            public SqmFunctionRegistry getFunctionRegistry() {
                return MetadataBuilderImpl.this.bootstrapContext.getFunctionRegistry();
            }

            @Override
            public TypeConfiguration getTypeConfiguration() {
                return MetadataBuilderImpl.this.bootstrapContext.getTypeConfiguration();
            }

            @Override
            public ServiceRegistry getServiceRegistry() {
                return MetadataBuilderImpl.this.bootstrapContext.getServiceRegistry();
            }
        });
        return this;
    }

    @Override
    public MetadataBuilder applySqlFunction(String functionName, SqmFunctionDescriptor function) {
        this.bootstrapContext.addSqlFunction(functionName, function);
        return this;
    }

    @Override
    public MetadataBuilder applyAuxiliaryDatabaseObject(AuxiliaryDatabaseObject auxiliaryDatabaseObject) {
        this.bootstrapContext.addAuxiliaryDatabaseObject(auxiliaryDatabaseObject);
        return this;
    }

    @Override
    public MetadataBuilder applyAttributeConverter(ConverterDescriptor descriptor) {
        this.bootstrapContext.addAttributeConverterDescriptor(descriptor);
        return this;
    }

    @Override
    public <O, R> MetadataBuilder applyAttributeConverter(Class<? extends AttributeConverter<O, R>> attributeConverterClass) {
        this.bootstrapContext.addAttributeConverterDescriptor(new ClassBasedConverterDescriptor(attributeConverterClass, this.bootstrapContext.getClassmateContext()));
        return this;
    }

    @Override
    public <O, R> MetadataBuilder applyAttributeConverter(Class<? extends AttributeConverter<O, R>> attributeConverterClass, boolean autoApply) {
        this.bootstrapContext.addAttributeConverterDescriptor(new ClassBasedConverterDescriptor(attributeConverterClass, autoApply, this.bootstrapContext.getClassmateContext()));
        return this;
    }

    @Override
    public <O, R> MetadataBuilder applyAttributeConverter(AttributeConverter<O, R> attributeConverter) {
        this.bootstrapContext.addAttributeConverterDescriptor(new InstanceBasedConverterDescriptor(attributeConverter, this.bootstrapContext.getClassmateContext()));
        return this;
    }

    @Override
    public MetadataBuilder applyAttributeConverter(AttributeConverter<?, ?> attributeConverter, boolean autoApply) {
        this.bootstrapContext.addAttributeConverterDescriptor(new InstanceBasedConverterDescriptor(attributeConverter, (Boolean)autoApply, this.bootstrapContext.getClassmateContext()));
        return this;
    }

    @Override
    public MetadataImplementor build() {
        CfgXmlAccessService cfgXmlAccessService = this.options.serviceRegistry.requireService(CfgXmlAccessService.class);
        if (cfgXmlAccessService.getAggregatedConfig() != null && cfgXmlAccessService.getAggregatedConfig().getMappingReferences() != null) {
            for (MappingReference mappingReference : cfgXmlAccessService.getAggregatedConfig().getMappingReferences()) {
                mappingReference.apply(this.sources);
            }
        }
        MetadataImplementor bootModel = MetadataBuildingProcess.build(this.sources, this.bootstrapContext, this.options);
        if (CollectionHelper.isNotEmpty(this.sources.getHbmXmlBindings())) {
            boolean transformHbm;
            ConfigurationService configurationService = this.bootstrapContext.getServiceRegistry().getService(ConfigurationService.class);
            boolean bl = transformHbm = configurationService != null && configurationService.getSetting("hibernate.transform_hbm_xml.enabled", StandardConverters.BOOLEAN, Boolean.valueOf(false)) != false;
            if (!transformHbm) {
                for (Binding<JaxbHbmHibernateMapping> hbmXmlBinding : this.sources.getHbmXmlBindings()) {
                    Origin origin = hbmXmlBinding.getOrigin();
                    DeprecationLogger.DEPRECATION_LOGGER.logDeprecatedHbmXmlProcessing(origin.getType(), origin.getName());
                }
            } else {
                List<Binding<JaxbEntityMappingsImpl>> transformed = HbmXmlTransformer.transform(this.sources.getHbmXmlBindings(), bootModel, this.bootstrapContext.getServiceRegistry(), UnsupportedFeatureHandling.fromSetting(configurationService.getSettings().get("hibernate.transform_hbm_xml.unsupported_feature_handling"), UnsupportedFeatureHandling.ERROR));
                MetadataSources newSources = new MetadataSources(this.bootstrapContext.getServiceRegistry());
                if (this.sources.getAnnotatedClasses() != null) {
                    this.sources.getAnnotatedClasses().forEach(newSources::addAnnotatedClass);
                }
                if (this.sources.getAnnotatedClassNames() != null) {
                    this.sources.getAnnotatedClassNames().forEach(newSources::addAnnotatedClassName);
                }
                if (this.sources.getAnnotatedPackages() != null) {
                    this.sources.getAnnotatedPackages().forEach(newSources::addPackage);
                }
                if (this.sources.getExtraQueryImports() != null) {
                    this.sources.getExtraQueryImports().forEach(newSources::addQueryImport);
                }
                for (Binding<JaxbEntityMappingsImpl> mappingXmlBinding : transformed) {
                    newSources.addMappingXmlBinding(mappingXmlBinding);
                }
                return (MetadataImplementor)newSources.buildMetadata();
            }
        }
        return bootModel;
    }

    @Override
    public BootstrapContext getBootstrapContext() {
        return this.bootstrapContext;
    }

    @Override
    public MetadataBuildingOptions getMetadataBuildingOptions() {
        return this.options;
    }

    private static TimeZoneStorageType resolveTimeZoneStorageStrategy(ConfigurationService configService) {
        return configService.getSetting("hibernate.timezone.default_storage", value -> TimeZoneStorageType.valueOf(value.toString()), TimeZoneStorageType.DEFAULT);
    }

    private static WrapperArrayHandling resolveWrapperArrayHandling(ConfigurationService configService, StandardServiceRegistry serviceRegistry) {
        WrapperArrayHandling setting = (WrapperArrayHandling)((Object)NullnessHelper.coalesceSuppliedValues(() -> configService.getSetting("hibernate.type.wrapper_array_handling", WrapperArrayHandling::interpretExternalSettingLeniently), () -> MetadataBuilderImpl.resolveFallbackWrapperArrayHandling(configService)));
        if (setting == WrapperArrayHandling.PICK) {
            Dialect dialect = serviceRegistry.requireService(JdbcServices.class).getDialect();
            if (dialect.supportsStandardArrays() && (dialect.getPreferredSqlTypeCodeForArray() == 2003 || dialect.getPreferredSqlTypeCodeForArray() == 2009)) {
                return WrapperArrayHandling.ALLOW;
            }
            return WrapperArrayHandling.LEGACY;
        }
        return setting;
    }

    private static WrapperArrayHandling resolveFallbackWrapperArrayHandling(ConfigurationService configService) {
        if (configService.getSetting("hibernate.jpa.compliance", StandardConverters.BOOLEAN, Boolean.valueOf(false)).booleanValue()) {
            return WrapperArrayHandling.PICK;
        }
        return WrapperArrayHandling.DISALLOW;
    }

    public static class MetadataBuildingOptionsImpl
    implements MetadataBuildingOptions,
    JpaOrmXmlPersistenceUnitDefaultAware {
        private final StandardServiceRegistry serviceRegistry;
        private final MappingDefaultsImpl mappingDefaults;
        private final TimeZoneStorageType defaultTimezoneStorage;
        private final WrapperArrayHandling wrapperArrayHandling;
        private BootstrapContext bootstrapContext;
        private final ArrayList<BasicTypeRegistration> basicTypeRegistrations = new ArrayList();
        private final ArrayList<CompositeUserType<?>> compositeUserTypes = new ArrayList();
        private ImplicitNamingStrategy implicitNamingStrategy;
        private PhysicalNamingStrategy physicalNamingStrategy;
        private ColumnOrderingStrategy columnOrderingStrategy;
        private SharedCacheMode sharedCacheMode;
        private final AccessType defaultCacheAccessType;
        private final boolean multiTenancyEnabled;
        private boolean explicitDiscriminatorsForJoinedInheritanceSupported;
        private boolean implicitDiscriminatorsForJoinedInheritanceSupported;
        private boolean implicitlyForceDiscriminatorInSelect;
        private boolean useNationalizedCharacterData;
        private boolean specjProprietarySyntaxEnabled;
        private boolean noConstraintByDefault;
        private final String schemaCharset;
        private final boolean xmlMappingEnabled;
        private final boolean allowExtensionsInCdi;

        public MetadataBuildingOptionsImpl(StandardServiceRegistry serviceRegistry) {
            this.serviceRegistry = serviceRegistry;
            final StrategySelector strategySelector = serviceRegistry.requireService(StrategySelector.class);
            ConfigurationService configService = serviceRegistry.requireService(ConfigurationService.class);
            this.mappingDefaults = new MappingDefaultsImpl(serviceRegistry);
            this.defaultTimezoneStorage = MetadataBuilderImpl.resolveTimeZoneStorageStrategy(configService);
            this.wrapperArrayHandling = MetadataBuilderImpl.resolveWrapperArrayHandling(configService, serviceRegistry);
            this.multiTenancyEnabled = JdbcEnvironmentImpl.isMultiTenancyEnabled(serviceRegistry);
            this.xmlMappingEnabled = configService.getSetting("hibernate.xml_mapping_enabled", StandardConverters.BOOLEAN, Boolean.valueOf(true));
            this.implicitDiscriminatorsForJoinedInheritanceSupported = configService.getSetting("hibernate.discriminator.implicit_for_joined", StandardConverters.BOOLEAN, Boolean.valueOf(false));
            this.explicitDiscriminatorsForJoinedInheritanceSupported = configService.getSetting("hibernate.discriminator.ignore_explicit_for_joined", StandardConverters.BOOLEAN, Boolean.valueOf(false)) == false;
            this.implicitlyForceDiscriminatorInSelect = configService.getSetting("hibernate.discriminator.force_in_select", StandardConverters.BOOLEAN, Boolean.valueOf(false));
            this.sharedCacheMode = configService.getSetting("jakarta.persistence.sharedCache.mode", value -> {
                if (value instanceof SharedCacheMode) {
                    return (SharedCacheMode)value;
                }
                return SharedCacheMode.valueOf((String)value.toString());
            }, configService.getSetting("javax.persistence.sharedCache.mode", value -> {
                if (value == null) {
                    return null;
                }
                DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("javax.persistence.sharedCache.mode", "jakarta.persistence.sharedCache.mode");
                if (value instanceof SharedCacheMode) {
                    return (SharedCacheMode)value;
                }
                return SharedCacheMode.valueOf((String)value.toString());
            }, SharedCacheMode.UNSPECIFIED));
            this.defaultCacheAccessType = configService.getSetting("hibernate.cache.default_cache_concurrency_strategy", value -> {
                if (value == null) {
                    return null;
                }
                if (value instanceof CacheConcurrencyStrategy) {
                    return ((CacheConcurrencyStrategy)((Object)((Object)value))).toAccessType();
                }
                if (value instanceof AccessType) {
                    return (AccessType)((Object)((Object)value));
                }
                return AccessType.fromExternalName(value.toString());
            }, serviceRegistry.getService(RegionFactory.class) == null ? null : serviceRegistry.requireService(RegionFactory.class).getDefaultAccessType());
            this.specjProprietarySyntaxEnabled = configService.getSetting("hibernate.enable_specj_proprietary_syntax", StandardConverters.BOOLEAN, Boolean.valueOf(false));
            this.noConstraintByDefault = ConstraintMode.NO_CONSTRAINT.name().equalsIgnoreCase(configService.getSetting("hibernate.hbm2ddl.default_constraint_mode", String.class, null));
            this.implicitNamingStrategy = strategySelector.resolveDefaultableStrategy(ImplicitNamingStrategy.class, configService.getSettings().get("hibernate.implicit_naming_strategy"), new Callable<ImplicitNamingStrategy>(){

                @Override
                public ImplicitNamingStrategy call() {
                    return strategySelector.resolveDefaultableStrategy(ImplicitNamingStrategy.class, (Object)"default", ImplicitNamingStrategyJpaCompliantImpl.INSTANCE);
                }
            });
            this.physicalNamingStrategy = strategySelector.resolveDefaultableStrategy(PhysicalNamingStrategy.class, configService.getSettings().get("hibernate.physical_naming_strategy"), PhysicalNamingStrategyStandardImpl.INSTANCE);
            this.columnOrderingStrategy = strategySelector.resolveDefaultableStrategy(ColumnOrderingStrategy.class, configService.getSettings().get("hibernate.column_ordering_strategy"), new Callable<ColumnOrderingStrategy>(){

                @Override
                public ColumnOrderingStrategy call() {
                    return strategySelector.resolveDefaultableStrategy(ColumnOrderingStrategy.class, (Object)"default", ColumnOrderingStrategyStandard.INSTANCE);
                }
            });
            this.useNationalizedCharacterData = configService.getSetting("hibernate.use_nationalized_character_data", StandardConverters.BOOLEAN, Boolean.valueOf(false));
            this.schemaCharset = configService.getSetting("hibernate.hbm2ddl.charset_name", String.class, null);
            this.allowExtensionsInCdi = configService.getSetting("hibernate.cdi.extensions", StandardConverters.BOOLEAN, Boolean.valueOf(false));
        }

        @Override
        public StandardServiceRegistry getServiceRegistry() {
            return this.serviceRegistry;
        }

        @Override
        public MappingDefaults getMappingDefaults() {
            return this.mappingDefaults;
        }

        @Override
        public TimeZoneStorageStrategy getDefaultTimeZoneStorage() {
            return this.toTimeZoneStorageStrategy(this.getTimeZoneSupport());
        }

        @Override
        public TimeZoneSupport getTimeZoneSupport() {
            try {
                return this.serviceRegistry.requireService(JdbcServices.class).getDialect().getTimeZoneSupport();
            }
            catch (ServiceException se) {
                return TimeZoneSupport.NONE;
            }
        }

        private TimeZoneStorageStrategy toTimeZoneStorageStrategy(TimeZoneSupport timeZoneSupport) {
            switch (this.defaultTimezoneStorage) {
                case NATIVE: {
                    if (timeZoneSupport != TimeZoneSupport.NATIVE) {
                        throw new HibernateException("The configured time zone storage type NATIVE is not supported with the configured dialect");
                    }
                    return TimeZoneStorageStrategy.NATIVE;
                }
                case COLUMN: {
                    return TimeZoneStorageStrategy.COLUMN;
                }
                case NORMALIZE: {
                    return TimeZoneStorageStrategy.NORMALIZE;
                }
                case NORMALIZE_UTC: {
                    return TimeZoneStorageStrategy.NORMALIZE_UTC;
                }
                case AUTO: {
                    switch (timeZoneSupport) {
                        case NATIVE: {
                            return TimeZoneStorageStrategy.NATIVE;
                        }
                        case NORMALIZE: 
                        case NONE: {
                            return TimeZoneStorageStrategy.COLUMN;
                        }
                    }
                    throw new HibernateException("Unsupported time zone support: " + timeZoneSupport);
                }
                case DEFAULT: {
                    switch (timeZoneSupport) {
                        case NATIVE: {
                            return TimeZoneStorageStrategy.NATIVE;
                        }
                        case NORMALIZE: 
                        case NONE: {
                            return TimeZoneStorageStrategy.NORMALIZE_UTC;
                        }
                    }
                    throw new HibernateException("Unsupported time zone support: " + timeZoneSupport);
                }
            }
            throw new HibernateException("Unsupported time zone storage type: " + this.defaultTimezoneStorage);
        }

        @Override
        public WrapperArrayHandling getWrapperArrayHandling() {
            return this.wrapperArrayHandling;
        }

        @Override
        public List<BasicTypeRegistration> getBasicTypeRegistrations() {
            return this.basicTypeRegistrations;
        }

        @Override
        public List<CompositeUserType<?>> getCompositeUserTypes() {
            return this.compositeUserTypes;
        }

        @Override
        public TypeConfiguration getTypeConfiguration() {
            return this.bootstrapContext.getTypeConfiguration();
        }

        @Override
        public ImplicitNamingStrategy getImplicitNamingStrategy() {
            return this.implicitNamingStrategy;
        }

        @Override
        public PhysicalNamingStrategy getPhysicalNamingStrategy() {
            return this.physicalNamingStrategy;
        }

        @Override
        public ColumnOrderingStrategy getColumnOrderingStrategy() {
            return this.columnOrderingStrategy;
        }

        @Override
        public SharedCacheMode getSharedCacheMode() {
            return this.sharedCacheMode;
        }

        @Override
        public AccessType getImplicitCacheAccessType() {
            return this.defaultCacheAccessType;
        }

        @Override
        public boolean isMultiTenancyEnabled() {
            return this.multiTenancyEnabled;
        }

        @Override
        public boolean ignoreExplicitDiscriminatorsForJoinedInheritance() {
            return !this.explicitDiscriminatorsForJoinedInheritanceSupported;
        }

        @Override
        public boolean createImplicitDiscriminatorsForJoinedInheritance() {
            return this.implicitDiscriminatorsForJoinedInheritanceSupported;
        }

        @Override
        public boolean shouldImplicitlyForceDiscriminatorInSelect() {
            return this.implicitlyForceDiscriminatorInSelect;
        }

        @Override
        public boolean useNationalizedCharacterData() {
            return this.useNationalizedCharacterData;
        }

        @Override
        public boolean isSpecjProprietarySyntaxEnabled() {
            return this.specjProprietarySyntaxEnabled;
        }

        @Override
        public boolean isNoConstraintByDefault() {
            return this.noConstraintByDefault;
        }

        @Override
        public String getSchemaCharset() {
            return this.schemaCharset;
        }

        @Override
        public boolean isXmlMappingEnabled() {
            return this.xmlMappingEnabled;
        }

        @Override
        public boolean isAllowExtensionsInCdi() {
            return this.allowExtensionsInCdi;
        }

        @Override
        public void apply(JpaOrmXmlPersistenceUnitDefaultAware.JpaOrmXmlPersistenceUnitDefaults jpaOrmXmlPersistenceUnitDefaults) {
            if (!this.mappingDefaults.shouldImplicitlyQuoteIdentifiers()) {
                this.mappingDefaults.implicitlyQuoteIdentifiers = jpaOrmXmlPersistenceUnitDefaults.shouldImplicitlyQuoteIdentifiers();
            }
            if (this.mappingDefaults.getImplicitCatalogName() == null) {
                this.mappingDefaults.implicitCatalogName = StringHelper.nullIfEmpty(jpaOrmXmlPersistenceUnitDefaults.getDefaultCatalogName());
            }
            if (this.mappingDefaults.getImplicitSchemaName() == null) {
                this.mappingDefaults.implicitSchemaName = StringHelper.nullIfEmpty(jpaOrmXmlPersistenceUnitDefaults.getDefaultSchemaName());
            }
        }

        @Override
        public void apply(PersistenceUnitMetadata persistenceUnitMetadata) {
            if (!this.mappingDefaults.implicitlyQuoteIdentifiers) {
                this.mappingDefaults.implicitlyQuoteIdentifiers = persistenceUnitMetadata.useQuotedIdentifiers();
            }
            if (this.mappingDefaults.getImplicitCatalogName() == null) {
                this.mappingDefaults.implicitCatalogName = StringHelper.nullIfEmpty(persistenceUnitMetadata.getDefaultCatalog());
            }
            if (this.mappingDefaults.getImplicitSchemaName() == null) {
                this.mappingDefaults.implicitSchemaName = StringHelper.nullIfEmpty(persistenceUnitMetadata.getDefaultSchema());
            }
        }

        public void setBootstrapContext(BootstrapContext bootstrapContext) {
            this.bootstrapContext = bootstrapContext;
        }
    }

    public static class MappingDefaultsImpl
    implements MappingDefaults {
        private String implicitSchemaName;
        private String implicitCatalogName;
        private boolean implicitlyQuoteIdentifiers;
        private AccessType implicitCacheAccessType;
        private CollectionClassification implicitListClassification;

        public MappingDefaultsImpl(StandardServiceRegistry serviceRegistry) {
            ConfigurationService configService = serviceRegistry.requireService(ConfigurationService.class);
            this.implicitSchemaName = null;
            this.implicitCatalogName = null;
            this.implicitlyQuoteIdentifiers = configService.getSetting("hibernate.globally_quoted_identifiers", StandardConverters.BOOLEAN, Boolean.valueOf(false));
            this.implicitCacheAccessType = configService.getSetting("hibernate.cache.default_cache_concurrency_strategy", value -> AccessType.fromExternalName(value.toString()));
            this.implicitListClassification = configService.getSetting("hibernate.mapping.default_list_semantics", value -> {
                CollectionClassification classification = CollectionClassification.interpretSetting(value);
                if (classification != CollectionClassification.LIST && classification != CollectionClassification.BAG) {
                    throw new AnnotationException(String.format(Locale.ROOT, "'%s' should specify either '%s' or '%s' (was '%s')", "hibernate.mapping.default_list_semantics", List.class.getName(), Collection.class.getName(), classification.name()));
                }
                return classification;
            }, CollectionClassification.BAG);
        }

        @Override
        public String getImplicitSchemaName() {
            return this.implicitSchemaName;
        }

        @Override
        public String getImplicitCatalogName() {
            return this.implicitCatalogName;
        }

        @Override
        public boolean shouldImplicitlyQuoteIdentifiers() {
            return this.implicitlyQuoteIdentifiers;
        }

        @Override
        public String getImplicitIdColumnName() {
            return "id";
        }

        @Override
        public String getImplicitTenantIdColumnName() {
            return "tenant_id";
        }

        @Override
        public String getImplicitDiscriminatorColumnName() {
            return "class";
        }

        @Override
        public String getImplicitPackageName() {
            return null;
        }

        @Override
        public boolean isAutoImportEnabled() {
            return true;
        }

        @Override
        public String getImplicitCascadeStyleName() {
            return "none";
        }

        @Override
        public String getImplicitPropertyAccessorName() {
            return "property";
        }

        @Override
        public boolean areEntitiesImplicitlyLazy() {
            return false;
        }

        @Override
        public boolean areCollectionsImplicitlyLazy() {
            return true;
        }

        @Override
        public AccessType getImplicitCacheAccessType() {
            return this.implicitCacheAccessType;
        }

        @Override
        public CollectionClassification getImplicitListClassification() {
            return this.implicitListClassification;
        }
    }
}

