/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import jakarta.persistence.Access;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.AttributeOverrides;
import jakarta.persistence.CollectionTable;
import jakarta.persistence.ConstraintMode;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Embedded;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinColumns;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.MapKey;
import jakarta.persistence.MapKeyColumn;
import jakarta.persistence.MapKeyJoinColumn;
import jakarta.persistence.OrderColumn;
import jakarta.persistence.UniqueConstraint;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.function.Supplier;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.FetchMode;
import org.hibernate.MappingException;
import org.hibernate.annotations.Bag;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheLayout;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Check;
import org.hibernate.annotations.Checks;
import org.hibernate.annotations.CollectionId;
import org.hibernate.annotations.CollectionIdJavaType;
import org.hibernate.annotations.CollectionIdJdbcType;
import org.hibernate.annotations.CollectionIdJdbcTypeCode;
import org.hibernate.annotations.CollectionType;
import org.hibernate.annotations.Columns;
import org.hibernate.annotations.CompositeType;
import org.hibernate.annotations.EmbeddableInstantiator;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchProfileOverride;
import org.hibernate.annotations.Filter;
import org.hibernate.annotations.FilterJoinTable;
import org.hibernate.annotations.Formula;
import org.hibernate.annotations.HQLSelect;
import org.hibernate.annotations.Immutable;
import org.hibernate.annotations.LazyGroup;
import org.hibernate.annotations.ListIndexBase;
import org.hibernate.annotations.ListIndexJavaType;
import org.hibernate.annotations.ListIndexJdbcType;
import org.hibernate.annotations.ListIndexJdbcTypeCode;
import org.hibernate.annotations.ManyToAny;
import org.hibernate.annotations.MapKeyJavaType;
import org.hibernate.annotations.MapKeyJdbcType;
import org.hibernate.annotations.MapKeyJdbcTypeCode;
import org.hibernate.annotations.MapKeyMutability;
import org.hibernate.annotations.MapKeyType;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.annotations.OnDelete;
import org.hibernate.annotations.OnDeleteAction;
import org.hibernate.annotations.OptimisticLock;
import org.hibernate.annotations.OrderBy;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.QueryCacheLayout;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.SQLDeleteAll;
import org.hibernate.annotations.SQLInsert;
import org.hibernate.annotations.SQLJoinTableRestriction;
import org.hibernate.annotations.SQLOrder;
import org.hibernate.annotations.SQLRestriction;
import org.hibernate.annotations.SQLSelect;
import org.hibernate.annotations.SQLUpdate;
import org.hibernate.annotations.SoftDelete;
import org.hibernate.annotations.SortComparator;
import org.hibernate.annotations.SortNatural;
import org.hibernate.annotations.SqlFragmentAlias;
import org.hibernate.annotations.Synchronize;
import org.hibernate.boot.BootLogging;
import org.hibernate.boot.model.IdentifierGeneratorDefinition;
import org.hibernate.boot.model.TypeDefinition;
import org.hibernate.boot.model.internal.AnnotatedClassType;
import org.hibernate.boot.model.internal.AnnotatedColumn;
import org.hibernate.boot.model.internal.AnnotatedColumns;
import org.hibernate.boot.model.internal.AnnotatedJoinColumn;
import org.hibernate.boot.model.internal.AnnotatedJoinColumns;
import org.hibernate.boot.model.internal.ArrayBinder;
import org.hibernate.boot.model.internal.BagBinder;
import org.hibernate.boot.model.internal.BasicValueBinder;
import org.hibernate.boot.model.internal.BinderHelper;
import org.hibernate.boot.model.internal.CollectionPropertyHolder;
import org.hibernate.boot.model.internal.CollectionSecondPass;
import org.hibernate.boot.model.internal.ComponentPropertyHolder;
import org.hibernate.boot.model.internal.DelayedParameterizedTypeBean;
import org.hibernate.boot.model.internal.DialectOverridesAnnotationHelper;
import org.hibernate.boot.model.internal.EmbeddableBinder;
import org.hibernate.boot.model.internal.EntityBinder;
import org.hibernate.boot.model.internal.FetchSecondPass;
import org.hibernate.boot.model.internal.GeneratorBinder;
import org.hibernate.boot.model.internal.IdBagBinder;
import org.hibernate.boot.model.internal.IndexColumn;
import org.hibernate.boot.model.internal.InheritanceState;
import org.hibernate.boot.model.internal.ListBinder;
import org.hibernate.boot.model.internal.MapBinder;
import org.hibernate.boot.model.internal.Nullability;
import org.hibernate.boot.model.internal.PrimitiveArrayBinder;
import org.hibernate.boot.model.internal.PropertyBinder;
import org.hibernate.boot.model.internal.PropertyHolder;
import org.hibernate.boot.model.internal.PropertyHolderBuilder;
import org.hibernate.boot.model.internal.PropertyInferredData;
import org.hibernate.boot.model.internal.PropertyPreloadedData;
import org.hibernate.boot.model.internal.QueryBinder;
import org.hibernate.boot.model.internal.SetBinder;
import org.hibernate.boot.model.internal.SoftDeleteHelper;
import org.hibernate.boot.model.internal.TableBinder;
import org.hibernate.boot.model.internal.WrappedInferredData;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.annotations.internal.JoinColumnJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.MapKeyColumnJpaAnnotation;
import org.hibernate.boot.spi.AccessType;
import org.hibernate.boot.spi.InFlightMetadataCollector;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.PropertyData;
import org.hibernate.boot.spi.SecondPass;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.spi.ExecuteUpdateResultCheckStyle;
import org.hibernate.engine.spi.FilterDefinition;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.jdbc.Expectation;
import org.hibernate.mapping.Any;
import org.hibernate.mapping.Backref;
import org.hibernate.mapping.CheckConstraint;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.DependantValue;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.MappingHelper;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.Value;
import org.hibernate.metamodel.CollectionClassification;
import org.hibernate.metamodel.UnsupportedMappingException;
import org.hibernate.models.internal.ClassTypeDetailsImpl;
import org.hibernate.models.spi.AnnotationTarget;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.ClassDetailsRegistry;
import org.hibernate.models.spi.MemberDetails;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.hibernate.models.spi.TypeDetails;
import org.hibernate.models.spi.TypeVariableScope;
import org.hibernate.resource.beans.spi.ManagedBean;
import org.hibernate.resource.beans.spi.ManagedBeanRegistry;
import org.hibernate.usertype.CompositeUserType;
import org.hibernate.usertype.ParameterizedType;
import org.hibernate.usertype.UserCollectionType;
import org.jboss.logging.Logger;

public abstract class CollectionBinder {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)CollectionBinder.class.getName());
    private static final List<Class<?>> INFERRED_CLASS_PRIORITY = List.of(List.class, SortedSet.class, Set.class, SortedMap.class, Map.class, Collection.class);
    final MetadataBuildingContext buildingContext;
    private final Supplier<ManagedBean<? extends UserCollectionType>> customTypeBeanResolver;
    private final boolean isSortedCollection;
    protected org.hibernate.mapping.Collection collection;
    protected String propertyName;
    protected PropertyHolder propertyHolder;
    private String mappedBy;
    protected ClassDetails declaringClass;
    protected MemberDetails property;
    private TypeDetails collectionElementType;
    private TypeDetails targetEntity;
    private String cascadeStrategy;
    private String cacheConcurrencyStrategy;
    private String cacheRegionName;
    private CacheLayout queryCacheLayout;
    private boolean oneToMany;
    protected IndexColumn indexColumn;
    protected OnDeleteAction onDeleteAction;
    protected boolean hasMapKeyProperty;
    protected String mapKeyPropertyName;
    private boolean insertable = true;
    private boolean updatable = true;
    protected AnnotatedJoinColumns inverseJoinColumns;
    protected AnnotatedJoinColumns foreignJoinColumns;
    private AnnotatedJoinColumns joinColumns;
    private boolean isExplicitAssociationTable;
    private AnnotatedColumns elementColumns;
    protected boolean isEmbedded;
    protected NotFoundAction notFoundAction;
    private TableBinder tableBinder;
    protected AnnotatedColumns mapKeyColumns;
    protected AnnotatedJoinColumns mapKeyManyToManyColumns;
    protected Map<String, IdentifierGeneratorDefinition> localGenerators;
    protected Map<ClassDetails, InheritanceState> inheritanceStatePerClass;
    private boolean declaringClassSet;
    private AccessType accessType;
    private boolean hibernateExtensionMapping;
    private jakarta.persistence.OrderBy jpaOrderBy;
    private OrderBy sqlOrderBy;
    private SQLOrder sqlOrder;
    private SortNatural naturalSort;
    private SortComparator comparatorSort;
    private String explicitType;
    private final Map<String, String> explicitTypeParameters = new HashMap<String, String>();

    protected CollectionBinder(Supplier<ManagedBean<? extends UserCollectionType>> customTypeBeanResolver, boolean isSortedCollection, MetadataBuildingContext buildingContext) {
        this.customTypeBeanResolver = customTypeBeanResolver;
        this.isSortedCollection = isSortedCollection;
        this.buildingContext = buildingContext;
    }

    public static void bindCollection(PropertyHolder propertyHolder, Nullability nullability, PropertyData inferredData, Map<String, IdentifierGeneratorDefinition> classGenerators, EntityBinder entityBinder, boolean isIdentifierMapper, MetadataBuildingContext context, Map<ClassDetails, InheritanceState> inheritanceStatePerClass, MemberDetails property, AnnotatedJoinColumns joinColumns) {
        SourceModelBuildingContext sourceModelContext = context.getMetadataCollector().getSourceModelBuildingContext();
        jakarta.persistence.OneToMany oneToManyAnn = (jakarta.persistence.OneToMany)property.getAnnotationUsage(jakarta.persistence.OneToMany.class, sourceModelContext);
        ManyToMany manyToManyAnn = (ManyToMany)property.getAnnotationUsage(ManyToMany.class, sourceModelContext);
        ElementCollection elementCollectionAnn = (ElementCollection)property.getAnnotationUsage(ElementCollection.class, sourceModelContext);
        CollectionBinder.checkAnnotations(propertyHolder, inferredData, property, oneToManyAnn, manyToManyAnn, elementCollectionAnn);
        CollectionBinder collectionBinder = CollectionBinder.getCollectionBinder(property, CollectionBinder.hasMapKeyAnnotation(property), context);
        collectionBinder.setIndexColumn(CollectionBinder.getIndexColumn(propertyHolder, inferredData, entityBinder, context, property));
        collectionBinder.setMapKey((MapKey)property.getAnnotationUsage(MapKey.class, sourceModelContext));
        collectionBinder.setPropertyName(inferredData.getPropertyName());
        collectionBinder.setJpaOrderBy((jakarta.persistence.OrderBy)property.getAnnotationUsage(jakarta.persistence.OrderBy.class, sourceModelContext));
        collectionBinder.setSqlOrderBy(DialectOverridesAnnotationHelper.getOverridableAnnotation((AnnotationTarget)property, OrderBy.class, context));
        collectionBinder.setSqlOrder(DialectOverridesAnnotationHelper.getOverridableAnnotation((AnnotationTarget)property, SQLOrder.class, context));
        collectionBinder.setNaturalSort((SortNatural)property.getAnnotationUsage(SortNatural.class, sourceModelContext));
        collectionBinder.setComparatorSort((SortComparator)property.getAnnotationUsage(SortComparator.class, sourceModelContext));
        collectionBinder.setCache((Cache)property.getAnnotationUsage(Cache.class, sourceModelContext));
        collectionBinder.setQueryCacheLayout((QueryCacheLayout)property.getAnnotationUsage(QueryCacheLayout.class, sourceModelContext));
        collectionBinder.setPropertyHolder(propertyHolder);
        collectionBinder.setNotFoundAction(CollectionBinder.notFoundAction(propertyHolder, inferredData, property, manyToManyAnn, sourceModelContext));
        collectionBinder.setElementType(inferredData.getClassOrElementType());
        collectionBinder.setAccessType(inferredData.getDefaultAccess());
        collectionBinder.setEmbedded(property.hasAnnotationUsage(Embedded.class, sourceModelContext));
        collectionBinder.setProperty(property);
        collectionBinder.setOnDeleteActionAction(CollectionBinder.onDeleteAction(property));
        collectionBinder.setInheritanceStatePerClass(inheritanceStatePerClass);
        collectionBinder.setDeclaringClass(inferredData.getDeclaringClass());
        Cascade hibernateCascade = (Cascade)property.getAnnotationUsage(Cascade.class, sourceModelContext);
        collectionBinder.setElementColumns(CollectionBinder.elementColumns(propertyHolder, nullability, entityBinder, context, property, CollectionBinder.virtualPropertyData(inferredData, property)));
        collectionBinder.setMapKeyColumns(CollectionBinder.mapKeyColumns(propertyHolder, inferredData, entityBinder, context, property));
        collectionBinder.setMapKeyManyToManyColumns(CollectionBinder.mapKeyJoinColumns(propertyHolder, inferredData, entityBinder, context, property));
        CollectionBinder.bindJoinedTableAssociation(property, context, entityBinder, collectionBinder, propertyHolder, inferredData, CollectionBinder.handleTargetEntity(propertyHolder, inferredData, context, property, joinColumns, oneToManyAnn, manyToManyAnn, elementCollectionAnn, collectionBinder, hibernateCascade));
        if (isIdentifierMapper) {
            collectionBinder.setInsertable(false);
            collectionBinder.setUpdatable(false);
        }
        if (property.hasAnnotationUsage(CollectionId.class, sourceModelContext)) {
            HashMap<String, IdentifierGeneratorDefinition> localGenerators = new HashMap<String, IdentifierGeneratorDefinition>(classGenerators);
            localGenerators.putAll(GeneratorBinder.buildGenerators((AnnotationTarget)property, context));
            collectionBinder.setLocalGenerators(localGenerators);
        }
        collectionBinder.bind();
    }

    private static NotFoundAction notFoundAction(PropertyHolder propertyHolder, PropertyData inferredData, MemberDetails property, ManyToMany manyToManyAnn, SourceModelBuildingContext sourceModelContext) {
        NotFound notFound = (NotFound)property.getAnnotationUsage(NotFound.class, sourceModelContext);
        if (notFound != null) {
            if (manyToManyAnn == null) {
                throw new AnnotationException("Collection '" + BinderHelper.getPath(propertyHolder, inferredData) + "' annotated '@NotFound' is not a '@ManyToMany' association");
            }
            return notFound.action();
        }
        return null;
    }

    private static AnnotatedJoinColumns mapKeyJoinColumns(PropertyHolder propertyHolder, PropertyData inferredData, EntityBinder entityBinder, MetadataBuildingContext context, MemberDetails property) {
        return AnnotatedJoinColumns.buildJoinColumnsWithDefaultColumnSuffix(CollectionBinder.mapKeyJoinColumnAnnotations(propertyHolder, inferredData, property, context), null, entityBinder.getSecondaryTables(), propertyHolder, inferredData, "_KEY", context);
    }

    private static OnDeleteAction onDeleteAction(MemberDetails property) {
        OnDelete onDelete = (OnDelete)property.getDirectAnnotationUsage(OnDelete.class);
        return onDelete == null ? null : onDelete.action();
    }

    private static PropertyData virtualPropertyData(PropertyData inferredData, MemberDetails property) {
        return property.hasDirectAnnotationUsage(ElementCollection.class) ? inferredData : new WrappedInferredData(inferredData, "element");
    }

    private static void checkAnnotations(PropertyHolder propertyHolder, PropertyData inferredData, MemberDetails property, jakarta.persistence.OneToMany oneToMany, ManyToMany manyToMany, ElementCollection elementCollection) {
        if ((oneToMany != null || manyToMany != null || elementCollection != null) && CollectionBinder.isToManyAssociationWithinEmbeddableCollection(propertyHolder)) {
            throw new AnnotationException("Property '" + BinderHelper.getPath(propertyHolder, inferredData) + "' belongs to an '@Embeddable' class that is contained in an '@ElementCollection' and may not be a " + CollectionBinder.annotationName(oneToMany, manyToMany, elementCollection));
        }
        if (oneToMany != null && property.hasDirectAnnotationUsage(SoftDelete.class)) {
            throw new UnsupportedMappingException("@SoftDelete cannot be applied to @OneToMany - " + property.getDeclaringType().getName() + "." + property.getName());
        }
        if (property.hasDirectAnnotationUsage(OrderColumn.class) && manyToMany != null && StringHelper.isNotEmpty(manyToMany.mappedBy())) {
            throw new AnnotationException("Collection '" + BinderHelper.getPath(propertyHolder, inferredData) + "' is the unowned side of a bidirectional '@ManyToMany' and may not have an '@OrderColumn'");
        }
        if ((manyToMany != null || elementCollection != null) && (property.hasDirectAnnotationUsage(JoinColumn.class) || property.hasDirectAnnotationUsage(JoinColumns.class))) {
            throw new AnnotationException("Property '" + BinderHelper.getPath(propertyHolder, inferredData) + "' is a " + CollectionBinder.annotationName(oneToMany, manyToMany, elementCollection) + " and is directly annotated '@JoinColumn' (specify '@JoinColumn' inside '@JoinTable' or '@CollectionTable')");
        }
    }

    private static String annotationName(jakarta.persistence.OneToMany oneToMany, ManyToMany manyToMany, ElementCollection elementCollection) {
        return oneToMany != null ? "'@OneToMany'" : (manyToMany != null ? "'@ManyToMany'" : "'@ElementCollection'");
    }

    private static IndexColumn getIndexColumn(PropertyHolder propertyHolder, PropertyData inferredData, EntityBinder entityBinder, MetadataBuildingContext context, MemberDetails property) {
        return IndexColumn.fromAnnotations((OrderColumn)property.getDirectAnnotationUsage(OrderColumn.class), (ListIndexBase)property.getDirectAnnotationUsage(ListIndexBase.class), propertyHolder, inferredData, entityBinder.getSecondaryTables(), context);
    }

    private static String handleTargetEntity(PropertyHolder propertyHolder, PropertyData inferredData, MetadataBuildingContext context, MemberDetails property, AnnotatedJoinColumns joinColumns, jakarta.persistence.OneToMany oneToManyAnn, ManyToMany manyToManyAnn, ElementCollection elementCollectionAnn, CollectionBinder collectionBinder, Cascade hibernateCascade) {
        String mappedBy;
        if (oneToManyAnn != null && manyToManyAnn != null) {
            throw new AnnotationException("Property '" + BinderHelper.getPath(propertyHolder, inferredData) + "' is annotated both '@OneToMany' and '@ManyToMany'");
        }
        if (oneToManyAnn != null) {
            if (joinColumns.isSecondary()) {
                throw new AnnotationException("Collection '" + BinderHelper.getPath(propertyHolder, inferredData) + "' has foreign key in secondary table");
            }
            collectionBinder.setFkJoinColumns(joinColumns);
            mappedBy = StringHelper.nullIfEmpty(oneToManyAnn.mappedBy());
            collectionBinder.setTargetEntity(oneToManyAnn.targetEntity());
            collectionBinder.setCascadeStrategy(BinderHelper.getCascadeStrategy(oneToManyAnn.cascade(), hibernateCascade, oneToManyAnn.orphanRemoval(), context));
            collectionBinder.setOneToMany(true);
        } else if (elementCollectionAnn != null) {
            if (joinColumns.isSecondary()) {
                throw new AnnotationException("Collection '" + BinderHelper.getPath(propertyHolder, inferredData) + "' has foreign key in secondary table");
            }
            collectionBinder.setFkJoinColumns(joinColumns);
            mappedBy = null;
            collectionBinder.setTargetEntity(elementCollectionAnn.targetClass());
            collectionBinder.setOneToMany(false);
        } else if (manyToManyAnn != null) {
            mappedBy = StringHelper.nullIfEmpty(manyToManyAnn.mappedBy());
            collectionBinder.setTargetEntity(manyToManyAnn.targetEntity());
            collectionBinder.setCascadeStrategy(BinderHelper.getCascadeStrategy(manyToManyAnn.cascade(), hibernateCascade, false, context));
            collectionBinder.setOneToMany(false);
        } else if (property.hasDirectAnnotationUsage(ManyToAny.class)) {
            mappedBy = null;
            collectionBinder.setTargetEntity(ClassDetails.VOID_CLASS_DETAILS);
            collectionBinder.setCascadeStrategy(BinderHelper.getCascadeStrategy(null, hibernateCascade, false, context));
            collectionBinder.setOneToMany(false);
        } else {
            mappedBy = null;
        }
        collectionBinder.setMappedBy(mappedBy);
        return mappedBy;
    }

    private static boolean hasMapKeyAnnotation(MemberDetails property) {
        return property.hasDirectAnnotationUsage(MapKeyJavaType.class) || property.hasDirectAnnotationUsage(MapKeyJdbcType.class) || property.hasDirectAnnotationUsage(MapKeyJdbcTypeCode.class) || property.hasDirectAnnotationUsage(MapKeyMutability.class) || property.hasDirectAnnotationUsage(MapKey.class) || property.hasDirectAnnotationUsage(MapKeyType.class);
    }

    private static boolean isToManyAssociationWithinEmbeddableCollection(PropertyHolder propertyHolder) {
        if (propertyHolder instanceof ComponentPropertyHolder) {
            ComponentPropertyHolder componentPropertyHolder = (ComponentPropertyHolder)propertyHolder;
            return componentPropertyHolder.isWithinElementCollection();
        }
        return false;
    }

    private static AnnotatedColumns elementColumns(PropertyHolder propertyHolder, Nullability nullability, EntityBinder entityBinder, MetadataBuildingContext context, MemberDetails property, PropertyData virtualProperty) {
        if (property.hasDirectAnnotationUsage(jakarta.persistence.Column.class)) {
            return AnnotatedColumn.buildColumnFromAnnotation((jakarta.persistence.Column)property.getDirectAnnotationUsage(jakarta.persistence.Column.class), null, nullability, propertyHolder, virtualProperty, entityBinder.getSecondaryTables(), context);
        }
        if (property.hasDirectAnnotationUsage(Formula.class)) {
            return AnnotatedColumn.buildFormulaFromAnnotation(DialectOverridesAnnotationHelper.getOverridableAnnotation((AnnotationTarget)property, Formula.class, context), nullability, propertyHolder, virtualProperty, entityBinder.getSecondaryTables(), context);
        }
        if (property.hasDirectAnnotationUsage(Columns.class)) {
            return AnnotatedColumn.buildColumnsFromAnnotations(((Columns)property.getDirectAnnotationUsage(Columns.class)).columns(), null, nullability, propertyHolder, virtualProperty, entityBinder.getSecondaryTables(), context);
        }
        return AnnotatedColumn.buildColumnFromNoAnnotation(null, nullability, propertyHolder, virtualProperty, entityBinder.getSecondaryTables(), context);
    }

    private static JoinColumn[] mapKeyJoinColumnAnnotations(PropertyHolder propertyHolder, PropertyData inferredData, MemberDetails property, MetadataBuildingContext context) {
        Object[] mapKeyJoinColumns = (MapKeyJoinColumn[])property.getRepeatedAnnotationUsages(JpaAnnotations.MAP_KEY_JOIN_COLUMN, context.getMetadataCollector().getSourceModelBuildingContext());
        if (CollectionHelper.isEmpty(mapKeyJoinColumns)) {
            return null;
        }
        JoinColumn[] joinColumns = new JoinColumn[mapKeyJoinColumns.length];
        for (int i = 0; i < mapKeyJoinColumns.length; ++i) {
            JoinColumn joinColumn;
            joinColumns[i] = joinColumn = JoinColumnJpaAnnotation.toJoinColumn((MapKeyJoinColumn)mapKeyJoinColumns[i], context.getMetadataCollector().getSourceModelBuildingContext());
        }
        return joinColumns;
    }

    private static AnnotatedColumns mapKeyColumns(PropertyHolder propertyHolder, PropertyData inferredData, EntityBinder entityBinder, MetadataBuildingContext context, MemberDetails property) {
        jakarta.persistence.Column[] columnArray;
        jakarta.persistence.Column column = property.hasDirectAnnotationUsage(MapKeyColumn.class) ? MapKeyColumnJpaAnnotation.toColumnAnnotation((MapKeyColumn)property.getDirectAnnotationUsage(MapKeyColumn.class), context.getMetadataCollector().getSourceModelBuildingContext()) : null;
        if (column == null) {
            columnArray = null;
        } else {
            jakarta.persistence.Column[] columnArray2 = new jakarta.persistence.Column[1];
            columnArray = columnArray2;
            columnArray2[0] = column;
        }
        return AnnotatedColumn.buildColumnsFromAnnotations(columnArray, Nullability.FORCED_NOT_NULL, propertyHolder, inferredData, "_KEY", entityBinder.getSecondaryTables(), context);
    }

    private static void bindJoinedTableAssociation(MemberDetails property, MetadataBuildingContext buildingContext, EntityBinder entityBinder, CollectionBinder collectionBinder, PropertyHolder propertyHolder, PropertyData inferredData, String mappedBy) {
        Object[] annInverseJoins;
        Object[] annJoins;
        TableBinder associationTableBinder = new TableBinder();
        JoinTable assocTable = propertyHolder.getJoinTable(property);
        CollectionTable collectionTable = (CollectionTable)property.getDirectAnnotationUsage(CollectionTable.class);
        if (assocTable != null || collectionTable != null) {
            String options;
            Object[] jpaIndexes;
            Object[] inverseJoins;
            Object[] joins;
            UniqueConstraint[] uniqueConstraints;
            String tableName;
            String schema;
            String catalog;
            if (collectionTable != null) {
                catalog = collectionTable.catalog();
                schema = collectionTable.schema();
                tableName = collectionTable.name();
                uniqueConstraints = collectionTable.uniqueConstraints();
                joins = collectionTable.joinColumns();
                inverseJoins = null;
                jpaIndexes = collectionTable.indexes();
                options = collectionTable.options();
            } else {
                catalog = assocTable.catalog();
                schema = assocTable.schema();
                tableName = assocTable.name();
                uniqueConstraints = assocTable.uniqueConstraints();
                joins = assocTable.joinColumns();
                inverseJoins = assocTable.inverseJoinColumns();
                jpaIndexes = assocTable.indexes();
                options = assocTable.options();
            }
            collectionBinder.setExplicitAssociationTable(true);
            if (CollectionHelper.isNotEmpty(jpaIndexes)) {
                associationTableBinder.setJpaIndex((Index[])jpaIndexes);
            }
            if (!schema.isEmpty()) {
                associationTableBinder.setSchema(schema);
            }
            if (!catalog.isEmpty()) {
                associationTableBinder.setCatalog(catalog);
            }
            if (!tableName.isEmpty()) {
                associationTableBinder.setName(tableName);
            }
            associationTableBinder.setUniqueConstraints(uniqueConstraints);
            associationTableBinder.setJpaIndex((Index[])jpaIndexes);
            associationTableBinder.setOptions(options);
            annJoins = ArrayHelper.isEmpty(joins) ? null : joins;
            annInverseJoins = inverseJoins == null || ArrayHelper.isEmpty(inverseJoins) ? null : inverseJoins;
        } else {
            annJoins = null;
            annInverseJoins = null;
        }
        associationTableBinder.setBuildingContext(buildingContext);
        collectionBinder.setTableBinder(associationTableBinder);
        collectionBinder.setJoinColumns(AnnotatedJoinColumns.buildJoinTableJoinColumns(annJoins, entityBinder.getSecondaryTables(), propertyHolder, inferredData, mappedBy, buildingContext));
        collectionBinder.setInverseJoinColumns(AnnotatedJoinColumns.buildJoinTableJoinColumns(annInverseJoins, entityBinder.getSecondaryTables(), propertyHolder, inferredData, mappedBy, buildingContext));
    }

    protected MetadataBuildingContext getBuildingContext() {
        return this.buildingContext;
    }

    public Supplier<ManagedBean<? extends UserCollectionType>> getCustomTypeBeanResolver() {
        return this.customTypeBeanResolver;
    }

    public boolean isMap() {
        return false;
    }

    protected void setIsHibernateExtensionMapping(boolean hibernateExtensionMapping) {
        this.hibernateExtensionMapping = hibernateExtensionMapping;
    }

    protected boolean isHibernateExtensionMapping() {
        return this.hibernateExtensionMapping;
    }

    public void setUpdatable(boolean updatable) {
        this.updatable = updatable;
    }

    public void setInheritanceStatePerClass(Map<ClassDetails, InheritanceState> inheritanceStatePerClass) {
        this.inheritanceStatePerClass = inheritanceStatePerClass;
    }

    public void setInsertable(boolean insertable) {
        this.insertable = insertable;
    }

    public void setCascadeStrategy(String cascadeStrategy) {
        this.cascadeStrategy = cascadeStrategy;
    }

    public void setAccessType(AccessType accessType) {
        this.accessType = accessType;
    }

    public void setInverseJoinColumns(AnnotatedJoinColumns inverseJoinColumns) {
        this.inverseJoinColumns = inverseJoinColumns;
    }

    public void setJoinColumns(AnnotatedJoinColumns joinColumns) {
        this.joinColumns = joinColumns;
    }

    public void setPropertyHolder(PropertyHolder propertyHolder) {
        this.propertyHolder = propertyHolder;
    }

    public void setJpaOrderBy(jakarta.persistence.OrderBy jpaOrderBy) {
        this.jpaOrderBy = jpaOrderBy;
    }

    public void setSqlOrderBy(OrderBy sqlOrderBy) {
        this.sqlOrderBy = sqlOrderBy;
    }

    public void setSqlOrder(SQLOrder sqlOrder) {
        this.sqlOrder = sqlOrder;
    }

    public void setNaturalSort(SortNatural naturalSort) {
        this.naturalSort = naturalSort;
    }

    public void setComparatorSort(SortComparator comparatorSort) {
        this.comparatorSort = comparatorSort;
    }

    public static CollectionBinder getCollectionBinder(MemberDetails property, boolean isHibernateExtensionMapping, MetadataBuildingContext buildingContext) {
        CollectionBinder binder;
        CollectionType typeAnnotation = (CollectionType)property.getAnnotationUsage(CollectionType.class, buildingContext.getMetadataCollector().getSourceModelBuildingContext());
        if (typeAnnotation != null) {
            binder = CollectionBinder.createBinderFromCustomTypeAnnotation(property, typeAnnotation, buildingContext);
            binder.explicitType = typeAnnotation.type().getName();
            for (Parameter param : typeAnnotation.parameters()) {
                binder.explicitTypeParameters.put(param.name(), param.value());
            }
        } else {
            binder = CollectionBinder.createBinderAutomatically(property, buildingContext);
        }
        binder.setIsHibernateExtensionMapping(isHibernateExtensionMapping);
        return binder;
    }

    private static CollectionBinder createBinderAutomatically(MemberDetails property, MetadataBuildingContext context) {
        CollectionClassification classification = CollectionBinder.determineCollectionClassification(property, context);
        InFlightMetadataCollector.CollectionTypeRegistrationDescriptor typeRegistration = context.getMetadataCollector().findCollectionTypeRegistration(classification);
        return typeRegistration != null ? CollectionBinder.createBinderFromTypeRegistration(property, classification, typeRegistration, context) : CollectionBinder.createBinderFromProperty(property, context);
    }

    private static CollectionBinder createBinderFromTypeRegistration(MemberDetails property, CollectionClassification classification, InFlightMetadataCollector.CollectionTypeRegistrationDescriptor typeRegistration, MetadataBuildingContext buildingContext) {
        return CollectionBinder.createBinder(property, () -> CollectionBinder.createCustomType(property.getDeclaringType().getName() + "#" + property.getName(), typeRegistration.getImplementation(), typeRegistration.getParameters(), buildingContext), classification, buildingContext);
    }

    private static ManagedBean<? extends UserCollectionType> createCustomType(String role, Class<? extends UserCollectionType> implementation, Map<String, String> parameters, MetadataBuildingContext buildingContext) {
        boolean hasParameters = CollectionHelper.isNotEmpty(parameters);
        if (!buildingContext.getBuildingOptions().isAllowExtensionsInCdi()) {
            return MappingHelper.createLocalUserCollectionTypeBean(role, implementation, hasParameters, parameters);
        }
        ManagedBean<? extends UserCollectionType> managedBean = buildingContext.getBuildingOptions().getServiceRegistry().requireService(ManagedBeanRegistry.class).getBean(implementation);
        if (hasParameters) {
            if (ParameterizedType.class.isAssignableFrom(managedBean.getBeanClass())) {
                Properties copy = new Properties();
                copy.putAll(parameters);
                return new DelayedParameterizedTypeBean<UserCollectionType>(managedBean, copy);
            }
            BootLogging.BOOT_LOGGER.debugf("`@CollectionType` (%s) specified parameters, but the implementation does not implement `%s` which is used to inject them - `%s`", (Object)role, (Object)ParameterizedType.class.getName(), (Object)implementation.getName());
        }
        return managedBean;
    }

    private static CollectionBinder createBinderFromProperty(MemberDetails property, MetadataBuildingContext context) {
        CollectionClassification classification = CollectionBinder.determineCollectionClassification(property, context);
        return CollectionBinder.createBinder(property, null, classification, context);
    }

    private static CollectionBinder createBinderFromCustomTypeAnnotation(MemberDetails property, CollectionType typeAnnotation, MetadataBuildingContext buildingContext) {
        CollectionBinder.determineSemanticJavaType(property, buildingContext);
        ManagedBean<? extends UserCollectionType> customTypeBean = CollectionBinder.resolveCustomType(property, typeAnnotation, buildingContext);
        return CollectionBinder.createBinder(property, () -> customTypeBean, customTypeBean.getBeanInstance().getClassification(), buildingContext);
    }

    public static ManagedBean<? extends UserCollectionType> resolveCustomType(MemberDetails property, CollectionType typeAnnotation, MetadataBuildingContext context) {
        Properties parameters = CollectionBinder.extractParameters(typeAnnotation);
        return CollectionBinder.createCustomType(property.getDeclaringType().getName() + "." + property.getName(), typeAnnotation.type(), parameters, context);
    }

    private static Properties extractParameters(CollectionType typeAnnotation) {
        Parameter[] parameterAnnotations = typeAnnotation.parameters();
        Properties configParams = new Properties(parameterAnnotations.length);
        for (Parameter parameterAnnotation : parameterAnnotations) {
            configParams.put(parameterAnnotation.name(), parameterAnnotation.value());
        }
        return configParams;
    }

    private static CollectionBinder createBinder(MemberDetails property, Supplier<ManagedBean<? extends UserCollectionType>> customTypeBeanAccess, CollectionClassification classification, MetadataBuildingContext buildingContext) {
        TypeDetails elementType = property.getElementType();
        return switch (classification) {
            default -> throw new IncompatibleClassChangeError();
            case CollectionClassification.ARRAY -> {
                if (elementType.getTypeKind() == TypeDetails.Kind.PRIMITIVE) {
                    yield new PrimitiveArrayBinder(customTypeBeanAccess, buildingContext);
                }
                yield new ArrayBinder(customTypeBeanAccess, buildingContext);
            }
            case CollectionClassification.BAG -> new BagBinder(customTypeBeanAccess, buildingContext);
            case CollectionClassification.ID_BAG -> new IdBagBinder(customTypeBeanAccess, buildingContext);
            case CollectionClassification.LIST -> new ListBinder(customTypeBeanAccess, buildingContext);
            case CollectionClassification.MAP, CollectionClassification.ORDERED_MAP -> new MapBinder(customTypeBeanAccess, false, buildingContext);
            case CollectionClassification.SORTED_MAP -> new MapBinder(customTypeBeanAccess, true, buildingContext);
            case CollectionClassification.SET, CollectionClassification.ORDERED_SET -> new SetBinder(customTypeBeanAccess, false, buildingContext);
            case CollectionClassification.SORTED_SET -> new SetBinder(customTypeBeanAccess, true, buildingContext);
        };
    }

    private static CollectionClassification determineCollectionClassification(MemberDetails property, MetadataBuildingContext buildingContext) {
        if (property.isArray()) {
            return CollectionClassification.ARRAY;
        }
        SourceModelBuildingContext sourceModelContext = buildingContext.getMetadataCollector().getSourceModelBuildingContext();
        if (!property.hasAnnotationUsage(Bag.class, sourceModelContext)) {
            return CollectionBinder.determineCollectionClassification(CollectionBinder.determineSemanticJavaType(property, buildingContext), property, buildingContext);
        }
        if (property.hasAnnotationUsage(OrderColumn.class, sourceModelContext)) {
            throw new AnnotationException("Attribute '" + StringHelper.qualify(property.getDeclaringType().getName(), property.getName()) + "' is annotated '@Bag' and may not also be annotated '@OrderColumn'");
        }
        if (property.hasAnnotationUsage(ListIndexBase.class, sourceModelContext)) {
            throw new AnnotationException("Attribute '" + StringHelper.qualify(property.getDeclaringType().getName(), property.getName()) + "' is annotated '@Bag' and may not also be annotated '@ListIndexBase'");
        }
        ClassDetails collectionClassDetails = property.getType().determineRawClass();
        Class collectionJavaType = collectionClassDetails.toJavaClass();
        if (List.class.equals((Object)collectionJavaType) || Collection.class.equals((Object)collectionJavaType)) {
            return CollectionClassification.BAG;
        }
        throw new AnnotationException(String.format(Locale.ROOT, "Attribute '%s.%s' of type '%s' is annotated '@Bag' (bags are of type '%s' or '%s')", property.getDeclaringType().getName(), property.getName(), collectionJavaType.getName(), List.class.getName(), Collection.class.getName()));
    }

    private static CollectionClassification determineCollectionClassification(Class<?> semanticJavaType, MemberDetails property, MetadataBuildingContext buildingContext) {
        if (semanticJavaType.isArray()) {
            return CollectionClassification.ARRAY;
        }
        if (property.hasDirectAnnotationUsage(CollectionId.class) || property.hasDirectAnnotationUsage(CollectionIdJdbcType.class) || property.hasDirectAnnotationUsage(CollectionIdJdbcTypeCode.class) || property.hasDirectAnnotationUsage(CollectionIdJavaType.class)) {
            return CollectionClassification.ID_BAG;
        }
        if (List.class.isAssignableFrom(semanticJavaType)) {
            if (property.hasDirectAnnotationUsage(OrderColumn.class) || property.hasDirectAnnotationUsage(ListIndexBase.class) || property.hasDirectAnnotationUsage(ListIndexJdbcType.class) || property.hasDirectAnnotationUsage(ListIndexJdbcTypeCode.class) || property.hasDirectAnnotationUsage(ListIndexJavaType.class)) {
                return CollectionClassification.LIST;
            }
            if (property.hasDirectAnnotationUsage(jakarta.persistence.OrderBy.class) || property.hasDirectAnnotationUsage(OrderBy.class)) {
                return CollectionClassification.BAG;
            }
            SourceModelBuildingContext sourceModelContext = buildingContext.getMetadataCollector().getSourceModelBuildingContext();
            ManyToMany manyToMany = (ManyToMany)property.getAnnotationUsage(ManyToMany.class, sourceModelContext);
            if (manyToMany != null && !manyToMany.mappedBy().isEmpty()) {
                return CollectionClassification.BAG;
            }
            jakarta.persistence.OneToMany oneToMany = (jakarta.persistence.OneToMany)property.getAnnotationUsage(jakarta.persistence.OneToMany.class, sourceModelContext);
            if (oneToMany != null && !oneToMany.mappedBy().isEmpty()) {
                return CollectionClassification.BAG;
            }
            return buildingContext.getBuildingOptions().getMappingDefaults().getImplicitListClassification();
        }
        if (SortedSet.class.isAssignableFrom(semanticJavaType)) {
            return CollectionClassification.SORTED_SET;
        }
        if (Set.class.isAssignableFrom(semanticJavaType)) {
            return CollectionClassification.SET;
        }
        if (SortedMap.class.isAssignableFrom(semanticJavaType)) {
            return CollectionClassification.SORTED_MAP;
        }
        if (Map.class.isAssignableFrom(semanticJavaType)) {
            return CollectionClassification.MAP;
        }
        if (Collection.class.isAssignableFrom(semanticJavaType)) {
            if (property.hasDirectAnnotationUsage(CollectionId.class)) {
                return CollectionClassification.ID_BAG;
            }
            return CollectionClassification.BAG;
        }
        return null;
    }

    private static Class<?> determineSemanticJavaType(MemberDetails property, MetadataBuildingContext buildingContext) {
        if (property.isPlural()) {
            ClassDetails collectionClassDetails = property.getType().determineRawClass();
            Class collectionClass = collectionClassDetails.toJavaClass();
            return CollectionBinder.inferCollectionClassFromSubclass(collectionClass);
        }
        throw new AnnotationException(String.format(Locale.ROOT, "Property '%s.%s' is not a collection and may not be a '@OneToMany', '@ManyToMany', or '@ElementCollection'", property.getDeclaringType().getName(), property.resolveAttributeName()));
    }

    private static Class<?> inferCollectionClassFromSubclass(Class<?> clazz) {
        for (Class<?> priorityClass : INFERRED_CLASS_PRIORITY) {
            if (!priorityClass.isAssignableFrom(clazz)) continue;
            return priorityClass;
        }
        return null;
    }

    public void setMappedBy(String mappedBy) {
        this.mappedBy = StringHelper.nullIfEmpty(mappedBy);
    }

    public void setTableBinder(TableBinder tableBinder) {
        this.tableBinder = tableBinder;
    }

    public void setElementType(TypeDetails collectionElementType) {
        this.collectionElementType = collectionElementType;
    }

    public void setTargetEntity(Class<?> targetEntity) {
        SourceModelBuildingContext sourceModelContext = this.buildingContext.getMetadataCollector().getSourceModelBuildingContext();
        ClassDetailsRegistry classDetailsRegistry = sourceModelContext.getClassDetailsRegistry();
        this.setTargetEntity(classDetailsRegistry.resolveClassDetails(targetEntity.getName()));
    }

    public void setTargetEntity(ClassDetails targetEntity) {
        this.setTargetEntity((TypeDetails)new ClassTypeDetailsImpl(targetEntity, TypeDetails.Kind.CLASS));
    }

    public void setTargetEntity(TypeDetails targetEntity) {
        this.targetEntity = targetEntity;
    }

    protected abstract org.hibernate.mapping.Collection createCollection(PersistentClass var1);

    public org.hibernate.mapping.Collection getCollection() {
        return this.collection;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public void setDeclaringClass(ClassDetails declaringClass) {
        this.declaringClass = declaringClass;
        this.declaringClassSet = true;
    }

    public void bind() {
        this.collection = this.createCollection(this.propertyHolder.getPersistentClass());
        String role = StringHelper.qualify(this.propertyHolder.getPath(), this.propertyName);
        LOG.debugf("Collection role: %s", role);
        this.collection.setRole(role);
        this.collection.setMappedByProperty(this.mappedBy);
        this.checkMapKeyColumn();
        this.bindExplicitTypes();
        this.defineFetchingStrategy();
        this.collection.setMutable(this.isMutable());
        boolean isUnowned = this.isUnownedCollection();
        this.bindOptimisticLock(isUnowned);
        this.applySortingAndOrdering();
        this.bindCache();
        this.bindLoader();
        this.detectMappedByProblem(isUnowned);
        this.collection.setInverse(isUnowned);
        this.scheduleSecondPass(isUnowned);
        this.buildingContext.getMetadataCollector().addCollectionBinding(this.collection);
        this.bindProperty();
    }

    private boolean isUnownedCollection() {
        return this.mappedBy != null;
    }

    private boolean isMutable() {
        return !this.property.hasDirectAnnotationUsage(Immutable.class);
    }

    private void checkMapKeyColumn() {
        if (this.property.hasDirectAnnotationUsage(MapKeyColumn.class) && this.hasMapKeyProperty) {
            throw new AnnotationException("Collection '" + StringHelper.qualify(this.propertyHolder.getPath(), this.propertyName) + "' is annotated both '@MapKey' and '@MapKeyColumn'");
        }
    }

    private void scheduleSecondPass(boolean isMappedBy) {
        InFlightMetadataCollector metadataCollector = this.buildingContext.getMetadataCollector();
        if (!this.oneToMany && isMappedBy) {
            metadataCollector.addMappedBy(this.getElementType().getName(), this.mappedBy, this.propertyName);
        }
        if (this.inheritanceStatePerClass == null) {
            throw new AssertionFailure("inheritanceStatePerClass not set");
        }
        metadataCollector.addSecondPass(this.getSecondPass(), !isMappedBy);
    }

    private void bindOptimisticLock(boolean isMappedBy) {
        OptimisticLock lockAnn = (OptimisticLock)this.property.getDirectAnnotationUsage(OptimisticLock.class);
        boolean includeInOptimisticLockChecks = lockAnn != null ? !lockAnn.excluded() : !isMappedBy;
        this.collection.setOptimisticLocked(includeInOptimisticLockChecks);
    }

    private void bindCache() {
        if (StringHelper.isNotEmpty(this.cacheConcurrencyStrategy)) {
            this.collection.setCacheConcurrencyStrategy(this.cacheConcurrencyStrategy);
            this.collection.setCacheRegionName(this.cacheRegionName);
        }
        this.collection.setQueryCacheLayout(this.queryCacheLayout);
    }

    private void bindExplicitTypes() {
        InFlightMetadataCollector metadataCollector = this.buildingContext.getMetadataCollector();
        if (this.explicitType != null) {
            TypeDefinition typeDef = metadataCollector.getTypeDefinition(this.explicitType);
            if (typeDef == null) {
                this.collection.setTypeName(this.explicitType);
                this.collection.setTypeParameters(this.explicitTypeParameters);
            } else {
                this.collection.setTypeName(typeDef.getTypeImplementorClass().getName());
                this.collection.setTypeParameters(typeDef.getParameters());
            }
        }
    }

    private void detectMappedByProblem(boolean isMappedBy) {
        if (isMappedBy && (this.property.hasDirectAnnotationUsage(JoinColumn.class) || this.property.hasDirectAnnotationUsage(JoinColumns.class))) {
            throw new AnnotationException("Association '" + StringHelper.qualify(this.propertyHolder.getPath(), this.propertyName) + "' is 'mappedBy' another entity and may not specify the '@JoinColumn'");
        }
        if (isMappedBy && this.propertyHolder.getJoinTable(this.property) != null) {
            throw new AnnotationException("Association '" + StringHelper.qualify(this.propertyHolder.getPath(), this.propertyName) + "' is 'mappedBy' another entity and may not specify the '@JoinTable'");
        }
        if (!isMappedBy && this.oneToMany && this.property.hasDirectAnnotationUsage(OnDelete.class) && !this.property.hasDirectAnnotationUsage(JoinColumn.class) && !this.property.hasDirectAnnotationUsage(JoinColumns.class)) {
            throw new AnnotationException("Unidirectional '@OneToMany' association '" + StringHelper.qualify(this.propertyHolder.getPath(), this.propertyName) + "' is annotated '@OnDelete' and must explicitly specify a '@JoinColumn'");
        }
    }

    private void bindProperty() {
        PropertyBinder binder = new PropertyBinder();
        binder.setName(this.propertyName);
        binder.setValue(this.collection);
        binder.setCascade(this.cascadeStrategy);
        if (this.cascadeStrategy != null && this.cascadeStrategy.contains("delete-orphan")) {
            this.collection.setOrphanDelete(true);
        }
        binder.setLazy(this.collection.isLazy());
        LazyGroup lazyGroupAnnotation = (LazyGroup)this.property.getDirectAnnotationUsage(LazyGroup.class);
        if (lazyGroupAnnotation != null) {
            binder.setLazyGroup(lazyGroupAnnotation.value());
        }
        binder.setAccessType(this.accessType);
        binder.setMemberDetails(this.property);
        binder.setInsertable(this.insertable);
        binder.setUpdatable(this.updatable);
        binder.setBuildingContext(this.buildingContext);
        binder.setHolder(this.propertyHolder);
        Property prop = binder.makeProperty();
        if (!this.declaringClassSet) {
            throw new AssertionFailure("DeclaringClass is not set in CollectionBinder while binding");
        }
        this.propertyHolder.addProperty(prop, this.property, this.declaringClass);
    }

    private void bindLoader() {
        HQLSelect hqlSelect;
        SQLSelect sqlSelect;
        SQLDeleteAll sqlDeleteAll;
        SQLDelete sqlDelete;
        SQLUpdate sqlUpdate;
        SQLInsert sqlInsert = (SQLInsert)this.property.getDirectAnnotationUsage(SQLInsert.class);
        if (sqlInsert != null) {
            this.collection.setCustomSQLInsert(sqlInsert.sql().trim(), sqlInsert.callable(), ExecuteUpdateResultCheckStyle.fromResultCheckStyle(sqlInsert.check()));
            Class<? extends Expectation> verifier = sqlInsert.verify();
            if (!Expectation.class.equals(verifier)) {
                this.collection.setInsertExpectation(ReflectHelper.getDefaultSupplier(verifier));
            }
        }
        if ((sqlUpdate = (SQLUpdate)this.property.getDirectAnnotationUsage(SQLUpdate.class)) != null) {
            this.collection.setCustomSQLUpdate(sqlUpdate.sql().trim(), sqlUpdate.callable(), ExecuteUpdateResultCheckStyle.fromResultCheckStyle(sqlUpdate.check()));
            Class<? extends Expectation> verifier = sqlUpdate.verify();
            if (!Expectation.class.equals(verifier)) {
                this.collection.setUpdateExpectation(ReflectHelper.getDefaultSupplier(verifier));
            }
        }
        if ((sqlDelete = (SQLDelete)this.property.getDirectAnnotationUsage(SQLDelete.class)) != null) {
            this.collection.setCustomSQLDelete(sqlDelete.sql().trim(), sqlDelete.callable(), ExecuteUpdateResultCheckStyle.fromResultCheckStyle(sqlDelete.check()));
            Class<? extends Expectation> verifier = sqlDelete.verify();
            if (!Expectation.class.equals(verifier)) {
                this.collection.setDeleteExpectation(ReflectHelper.getDefaultSupplier(verifier));
            }
        }
        if ((sqlDeleteAll = (SQLDeleteAll)this.property.getDirectAnnotationUsage(SQLDeleteAll.class)) != null) {
            this.collection.setCustomSQLDeleteAll(sqlDeleteAll.sql().trim(), sqlDeleteAll.callable(), ExecuteUpdateResultCheckStyle.fromResultCheckStyle(sqlDeleteAll.check()));
            Class<? extends Expectation> verifier = sqlDeleteAll.verify();
            if (!Expectation.class.equals(verifier)) {
                this.collection.setDeleteAllExpectation(ReflectHelper.getDefaultSupplier(verifier));
            }
        }
        if ((sqlSelect = (SQLSelect)this.property.getDirectAnnotationUsage(SQLSelect.class)) != null) {
            String loaderName = this.collection.getRole() + "$SQLSelect";
            this.collection.setLoaderName(loaderName);
            QueryBinder.bindNativeQuery(loaderName, sqlSelect, null, this.buildingContext);
        }
        if ((hqlSelect = (HQLSelect)this.property.getDirectAnnotationUsage(HQLSelect.class)) != null) {
            String loaderName = this.collection.getRole() + "$HQLSelect";
            this.collection.setLoaderName(loaderName);
            QueryBinder.bindQuery(loaderName, hqlSelect, this.buildingContext);
        }
    }

    private void applySortingAndOrdering() {
        boolean isSorted;
        boolean ordered;
        boolean sorted;
        if (this.naturalSort != null && this.comparatorSort != null) {
            throw this.buildIllegalSortCombination();
        }
        boolean bl = sorted = this.naturalSort != null || this.comparatorSort != null;
        Class<Comparator<?>> comparatorClass = this.naturalSort != null ? null : (this.comparatorSort != null ? this.comparatorSort.value() : null);
        if (this.jpaOrderBy != null && (this.sqlOrderBy != null || this.sqlOrder != null)) {
            throw this.buildIllegalOrderCombination();
        }
        boolean bl2 = ordered = this.jpaOrderBy != null || this.sqlOrderBy != null || this.sqlOrder != null;
        if (ordered) {
            if (this.sqlOrderBy != null) {
                this.collection.setOrderBy(this.sqlOrderBy.clause());
            }
            if (this.sqlOrder != null) {
                this.collection.setOrderBy(this.sqlOrder.value());
            }
        }
        boolean bl3 = isSorted = this.isSortedCollection || sorted;
        if (isSorted && ordered) {
            throw this.buildIllegalOrderAndSortCombination();
        }
        this.collection.setSorted(isSorted);
        this.instantiateComparator(this.collection, comparatorClass);
    }

    private void instantiateComparator(org.hibernate.mapping.Collection collection, Class<? extends Comparator<?>> comparatorClass) {
        if (comparatorClass != null) {
            try {
                collection.setComparator(comparatorClass.newInstance());
            }
            catch (Exception e) {
                throw new AnnotationException(String.format("Could not instantiate comparator class '%s' for collection '%s'", comparatorClass.getName(), this.safeCollectionRole()), e);
            }
        }
    }

    private AnnotationException buildIllegalOrderCombination() {
        return new AnnotationException(String.format(Locale.ROOT, "Collection '%s' is annotated both '@%s' and '@%s'", this.safeCollectionRole(), jakarta.persistence.OrderBy.class.getName(), OrderBy.class.getName()));
    }

    private AnnotationException buildIllegalOrderAndSortCombination() {
        throw new AnnotationException(String.format(Locale.ROOT, "Collection '%s' is both sorted and ordered (only one of '@%s', '@%s', '@%s', and '@%s' may be used)", this.safeCollectionRole(), jakarta.persistence.OrderBy.class.getName(), OrderBy.class.getName(), SortComparator.class.getName(), SortNatural.class.getName()));
    }

    private AnnotationException buildIllegalSortCombination() {
        return new AnnotationException(String.format("Collection '%s' is annotated both '@%s' and '@%s'", this.safeCollectionRole(), SortNatural.class.getName(), SortComparator.class.getName()));
    }

    private void defineFetchingStrategy() {
        this.handleLazy();
        this.handleFetch();
        this.handleFetchProfileOverrides();
    }

    private SourceModelBuildingContext sourceModelContext() {
        return this.buildingContext.getMetadataCollector().getSourceModelBuildingContext();
    }

    private void handleFetchProfileOverrides() {
        this.property.forEachAnnotationUsage(FetchProfileOverride.class, this.sourceModelContext(), usage -> this.buildingContext.getMetadataCollector().addSecondPass(new FetchSecondPass((FetchProfileOverride)usage, this.propertyHolder, this.propertyName, this.buildingContext)));
    }

    private void handleFetch() {
        Fetch fetchAnnotation = (Fetch)this.property.getDirectAnnotationUsage(Fetch.class);
        if (fetchAnnotation != null) {
            this.setHibernateFetchMode(fetchAnnotation.value());
        } else {
            this.collection.setFetchMode(BinderHelper.getFetchMode(this.getJpaFetchType()));
        }
    }

    private void setHibernateFetchMode(org.hibernate.annotations.FetchMode fetchMode) {
        switch (fetchMode) {
            case JOIN: {
                this.collection.setFetchMode(FetchMode.JOIN);
                this.collection.setLazy(false);
                break;
            }
            case SELECT: {
                this.collection.setFetchMode(FetchMode.SELECT);
                break;
            }
            case SUBSELECT: {
                this.collection.setFetchMode(FetchMode.SELECT);
                this.collection.setSubselectLoadable(true);
                this.collection.getOwner().setSubselectLoadableCollections(true);
                break;
            }
            default: {
                throw new AssertionFailure("unknown fetch type");
            }
        }
    }

    private void handleLazy() {
        FetchType jpaFetchType = this.getJpaFetchType();
        this.collection.setLazy(jpaFetchType == FetchType.LAZY);
        this.collection.setExtraLazy(false);
    }

    private FetchType getJpaFetchType() {
        jakarta.persistence.OneToMany oneToMany = (jakarta.persistence.OneToMany)this.property.getDirectAnnotationUsage(jakarta.persistence.OneToMany.class);
        ManyToMany manyToMany = (ManyToMany)this.property.getDirectAnnotationUsage(ManyToMany.class);
        ElementCollection elementCollection = (ElementCollection)this.property.getDirectAnnotationUsage(ElementCollection.class);
        ManyToAny manyToAny = (ManyToAny)this.property.getDirectAnnotationUsage(ManyToAny.class);
        if (oneToMany != null) {
            return oneToMany.fetch();
        }
        if (manyToMany != null) {
            return manyToMany.fetch();
        }
        if (elementCollection != null) {
            return elementCollection.fetch();
        }
        if (manyToAny != null) {
            return FetchType.LAZY;
        }
        throw new AssertionFailure("Define fetch strategy on a property not annotated with @ManyToOne nor @OneToMany nor @CollectionOfElements");
    }

    TypeDetails getElementType() {
        if (BinderHelper.isDefault(this.targetEntity)) {
            if (this.collectionElementType != null) {
                return this.collectionElementType;
            }
            throw new AnnotationException("Collection '" + this.safeCollectionRole() + "' is declared with a raw type and has an explicit 'targetEntity'");
        }
        return this.targetEntity;
    }

    SecondPass getSecondPass() {
        return new CollectionSecondPass(this.collection){

            @Override
            public void secondPass(Map<String, PersistentClass> persistentClasses) throws MappingException {
                CollectionBinder.this.bindStarToManySecondPass(persistentClasses);
            }
        };
    }

    protected boolean bindStarToManySecondPass(Map<String, PersistentClass> persistentClasses) {
        if (this.noAssociationTable(persistentClasses)) {
            this.bindOneToManySecondPass(persistentClasses);
            return true;
        }
        this.bindManyToManySecondPass(persistentClasses);
        return false;
    }

    private boolean isReversePropertyInJoin(TypeDetails elementType, PersistentClass persistentClass, Map<String, PersistentClass> persistentClasses) {
        if (persistentClass != null && this.isUnownedCollection()) {
            Property mappedByProperty;
            try {
                mappedByProperty = persistentClass.getRecursiveProperty(this.mappedBy);
            }
            catch (MappingException e) {
                throw new AnnotationException("Collection '" + this.safeCollectionRole() + "' is 'mappedBy' a property named '" + this.mappedBy + "' which does not exist in the target entity '" + elementType.getName() + "'");
            }
            BinderHelper.checkMappedByType(this.mappedBy, mappedByProperty.getValue(), this.propertyName, this.propertyHolder, persistentClasses);
            return persistentClass.getJoinNumber(mappedByProperty) != 0;
        }
        return false;
    }

    private boolean noAssociationTable(Map<String, PersistentClass> persistentClasses) {
        PersistentClass persistentClass = persistentClasses.get(this.getElementType().getName());
        return persistentClass != null && !this.isReversePropertyInJoin(this.getElementType(), persistentClass, persistentClasses) && this.oneToMany && !this.isExplicitAssociationTable && (this.implicitJoinColumn() || this.explicitForeignJoinColumn());
    }

    private boolean implicitJoinColumn() {
        return this.joinColumns.getJoinColumns().get(0).isImplicit() && this.isUnownedCollection();
    }

    private boolean explicitForeignJoinColumn() {
        return !this.foreignJoinColumns.getJoinColumns().get(0).isImplicit();
    }

    protected void bindOneToManySecondPass(Map<String, PersistentClass> persistentClasses) {
        if (this.property == null) {
            throw new AssertionFailure("null was passed for argument property");
        }
        this.logOneToManySecondPass();
        OneToMany oneToMany = new OneToMany(this.buildingContext, this.getCollection().getOwner());
        this.collection.setElement(oneToMany);
        oneToMany.setReferencedEntityName(this.getElementType().getName());
        oneToMany.setNotFoundAction(this.notFoundAction);
        String referencedEntityName = oneToMany.getReferencedEntityName();
        PersistentClass associatedClass = persistentClasses.get(referencedEntityName);
        this.handleJpaOrderBy(this.collection, associatedClass);
        if (associatedClass == null) {
            throw new MappingException(String.format("Association [%s] for entity [%s] references unmapped class [%s]", this.propertyName, this.propertyHolder.getClassName(), referencedEntityName));
        }
        oneToMany.setAssociatedClass(associatedClass);
        Map<String, Join> joins = this.buildingContext.getMetadataCollector().getJoins(referencedEntityName);
        this.foreignJoinColumns.setPropertyHolder(PropertyHolderBuilder.buildPropertyHolder(associatedClass, joins, this.foreignJoinColumns.getBuildingContext(), this.inheritanceStatePerClass));
        this.foreignJoinColumns.setJoins(joins);
        if (this.foreignJoinColumns.hasMappedBy()) {
            this.collection.setCollectionTable(associatedClass.getRecursiveProperty(this.foreignJoinColumns.getMappedBy()).getValue().getTable());
        } else {
            this.collection.setCollectionTable(this.foreignJoinColumns.getTable());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Mapping collection: %s -> %s", this.collection.getRole(), this.collection.getCollectionTable().getName());
        }
        this.bindSynchronize();
        this.bindFilters(false);
        this.handleWhere(false);
        PersistentClass targetEntity = persistentClasses.get(this.getElementType().getName());
        this.bindCollectionSecondPass(targetEntity, this.foreignJoinColumns);
        if (!this.collection.isInverse() && !this.collection.getKey().isNullable()) {
            this.createOneToManyBackref(oneToMany);
        }
    }

    private void createOneToManyBackref(OneToMany oneToMany) {
        InFlightMetadataCollector collector = this.buildingContext.getMetadataCollector();
        String entityName = oneToMany.getReferencedEntityName();
        PersistentClass referenced = collector.getEntityBinding(entityName);
        Backref backref = new Backref();
        String backrefName = "_" + this.foreignJoinColumns.getPropertyName() + "_" + this.foreignJoinColumns.getColumns().get(0).getLogicalColumnName() + "Backref";
        backref.setName(backrefName);
        backref.setOptional(true);
        backref.setUpdateable(false);
        backref.setSelectable(false);
        backref.setCollectionRole(this.collection.getRole());
        backref.setEntityName(this.collection.getOwner().getEntityName());
        backref.setValue(this.collection.getKey());
        referenced.addProperty(backref);
    }

    private void handleJpaOrderBy(org.hibernate.mapping.Collection collection, PersistentClass associatedClass) {
        String orderByFragment;
        if (this.jpaOrderBy != null && StringHelper.isNotEmpty(orderByFragment = CollectionBinder.buildOrderByClauseFromHql(this.jpaOrderBy.value(), associatedClass))) {
            collection.setOrderBy(orderByFragment);
        }
    }

    private void bindSynchronize() {
        Synchronize synchronizeAnnotation = (Synchronize)this.property.getDirectAnnotationUsage(Synchronize.class);
        if (synchronizeAnnotation != null) {
            JdbcEnvironment jdbcEnvironment = this.buildingContext.getMetadataCollector().getDatabase().getJdbcEnvironment();
            for (String table : synchronizeAnnotation.value()) {
                String physicalName = synchronizeAnnotation.logical() ? this.toPhysicalName(jdbcEnvironment, table) : table;
                this.collection.addSynchronizedTable(physicalName);
            }
        }
    }

    private String toPhysicalName(JdbcEnvironment jdbcEnvironment, String logicalName) {
        return this.buildingContext.getBuildingOptions().getPhysicalNamingStrategy().toPhysicalTableName(jdbcEnvironment.getIdentifierHelper().toIdentifier(logicalName), jdbcEnvironment).render(jdbcEnvironment.getDialect());
    }

    private void bindFilters(boolean hasAssociationTable) {
        this.property.forEachAnnotationUsage(Filter.class, this.sourceModelContext(), usage -> this.addFilter(hasAssociationTable, (Filter)usage));
        this.property.forEachAnnotationUsage(FilterJoinTable.class, this.sourceModelContext(), usage -> this.addFilterJoinTable(hasAssociationTable, (FilterJoinTable)usage));
    }

    private void addFilter(boolean hasAssociationTable, Filter filterAnnotation) {
        SqlFragmentAlias[] aliasAnnotations;
        HashMap<String, String> aliasTableMap = new HashMap<String, String>();
        HashMap<String, String> aliasEntityMap = new HashMap<String, String>();
        for (SqlFragmentAlias aliasAnnotation : aliasAnnotations = filterAnnotation.aliases()) {
            Class<?> entityClassDetails;
            String alias = aliasAnnotation.alias();
            String table = aliasAnnotation.table();
            if (StringHelper.isNotEmpty(table)) {
                aliasTableMap.put(alias, table);
            }
            if ((entityClassDetails = aliasAnnotation.entity()) == Void.TYPE) continue;
            aliasEntityMap.put(alias, entityClassDetails.getName());
        }
        if (hasAssociationTable) {
            this.collection.addManyToManyFilter(filterAnnotation.name(), this.getFilterCondition(filterAnnotation), filterAnnotation.deduceAliasInjectionPoints(), aliasTableMap, aliasEntityMap);
        } else {
            this.collection.addFilter(filterAnnotation.name(), this.getFilterCondition(filterAnnotation), filterAnnotation.deduceAliasInjectionPoints(), aliasTableMap, aliasEntityMap);
        }
    }

    private void handleWhere(boolean hasAssociationTable) {
        String whereClause = this.getWhereClause();
        if (hasAssociationTable) {
            this.collection.setManyToManyWhere(whereClause);
        } else {
            this.collection.setWhere(whereClause);
        }
        String whereJoinTableClause = this.getWhereJoinTableClause();
        if (StringHelper.isNotEmpty(whereJoinTableClause)) {
            if (hasAssociationTable) {
                this.collection.setWhere(whereJoinTableClause);
            } else {
                throw new AnnotationException("Collection '" + StringHelper.qualify(this.propertyHolder.getPath(), this.propertyName) + "' is an association with no join table and may not have a 'WhereJoinTable'");
            }
        }
    }

    private String getWhereJoinTableClause() {
        SQLJoinTableRestriction joinTableRestriction = (SQLJoinTableRestriction)this.property.getDirectAnnotationUsage(SQLJoinTableRestriction.class);
        return joinTableRestriction != null ? joinTableRestriction.value() : null;
    }

    private String getWhereClause() {
        return StringHelper.getNonEmptyOrConjunctionIfBothNonEmpty(this.getWhereOnClassClause(), this.getWhereOnCollectionClause());
    }

    private String getWhereOnCollectionClause() {
        SQLRestriction restrictionOnCollection = DialectOverridesAnnotationHelper.getOverridableAnnotation((AnnotationTarget)this.property, SQLRestriction.class, this.getBuildingContext());
        return restrictionOnCollection != null ? restrictionOnCollection.value() : null;
    }

    private String getWhereOnClassClause() {
        TypeDetails elementType = this.property.getElementType();
        SQLRestriction restrictionOnClass = DialectOverridesAnnotationHelper.getOverridableAnnotation((AnnotationTarget)this.property.getAssociatedType().determineRawClass(), SQLRestriction.class, this.buildingContext);
        return restrictionOnClass != null ? restrictionOnClass.value() : null;
    }

    private void addFilterJoinTable(boolean hasAssociationTable, FilterJoinTable filter) {
        HashMap<String, String> aliasEntityMap;
        HashMap<String, String> aliasTableMap;
        if (hasAssociationTable) {
            SqlFragmentAlias[] aliasAnnotations;
            aliasTableMap = new HashMap<String, String>();
            aliasEntityMap = new HashMap<String, String>();
            for (SqlFragmentAlias aliasAnnotation : aliasAnnotations = filter.aliases()) {
                Class<?> entityClassDetails;
                String alias = aliasAnnotation.alias();
                String table = aliasAnnotation.table();
                if (StringHelper.isNotEmpty(table)) {
                    aliasTableMap.put(alias, table);
                }
                if ((entityClassDetails = aliasAnnotation.entity()) == Void.TYPE) continue;
                aliasEntityMap.put(alias, entityClassDetails.getName());
            }
        } else {
            throw new AnnotationException("Collection '" + StringHelper.qualify(this.propertyHolder.getPath(), this.propertyName) + "' is an association with no join table and may not have a '@FilterJoinTable'");
        }
        this.collection.addFilter(filter.name(), this.getFilterConditionForJoinTable(filter), filter.deduceAliasInjectionPoints(), aliasTableMap, aliasEntityMap);
    }

    private String getFilterConditionForJoinTable(FilterJoinTable filterJoinTableAnnotation) {
        String condition = filterJoinTableAnnotation.condition();
        return condition.isEmpty() ? this.getDefaultFilterCondition(filterJoinTableAnnotation.name(), filterJoinTableAnnotation) : condition;
    }

    private String getFilterCondition(Filter filter) {
        String condition = filter.condition();
        return condition.isEmpty() ? this.getDefaultFilterCondition(filter.name(), filter) : condition;
    }

    private String getDefaultFilterCondition(String name, Annotation annotation) {
        FilterDefinition definition = this.buildingContext.getMetadataCollector().getFilterDefinition(name);
        if (definition == null) {
            throw new AnnotationException("Collection '" + StringHelper.qualify(this.propertyHolder.getPath(), this.propertyName) + "' has a '@" + annotation.annotationType().getSimpleName() + "' for an undefined filter named '" + name + "'");
        }
        String defaultCondition = definition.getDefaultFilterCondition();
        if (StringHelper.isEmpty(defaultCondition)) {
            throw new AnnotationException("Collection '" + StringHelper.qualify(this.propertyHolder.getPath(), this.propertyName) + "' has a '@" + annotation.annotationType().getSimpleName() + "' with no 'condition' and no default condition was given by the '@FilterDef' named '" + name + "'");
        }
        return defaultCondition;
    }

    public void setCache(Cache cache) {
        if (cache != null) {
            this.cacheRegionName = StringHelper.nullIfEmpty(cache.region());
            this.cacheConcurrencyStrategy = EntityBinder.getCacheConcurrencyStrategy(cache.usage());
        } else {
            this.cacheConcurrencyStrategy = null;
            this.cacheRegionName = null;
        }
    }

    public void setQueryCacheLayout(QueryCacheLayout queryCacheLayout) {
        this.queryCacheLayout = queryCacheLayout == null ? null : queryCacheLayout.layout();
    }

    public void setOneToMany(boolean oneToMany) {
        this.oneToMany = oneToMany;
    }

    public void setIndexColumn(IndexColumn indexColumn) {
        this.indexColumn = indexColumn;
    }

    public void setMapKey(MapKey key) {
        boolean bl = this.hasMapKeyProperty = key != null;
        if (this.hasMapKeyProperty) {
            this.mapKeyPropertyName = StringHelper.nullIfEmpty(key.name());
        }
    }

    private static String buildOrderByClauseFromHql(String orderByFragment, PersistentClass associatedClass) {
        if (orderByFragment == null) {
            return null;
        }
        if (orderByFragment.isEmpty()) {
            return CollectionBinder.buildOrderById(associatedClass, " asc");
        }
        if ("desc".equalsIgnoreCase(orderByFragment)) {
            return CollectionBinder.buildOrderById(associatedClass, " desc");
        }
        return orderByFragment;
    }

    private static String buildOrderById(PersistentClass associatedClass, String order) {
        StringBuilder sb = new StringBuilder();
        for (Selectable selectable : associatedClass.getIdentifier().getSelectables()) {
            sb.append(selectable.getText());
            sb.append(order);
            sb.append(", ");
        }
        sb.setLength(sb.length() - 2);
        return sb.toString();
    }

    public static String adjustUserSuppliedValueCollectionOrderingFragment(String orderByFragment) {
        if (orderByFragment != null) {
            if ((orderByFragment = orderByFragment.trim()).length() == 0 || orderByFragment.equalsIgnoreCase("asc")) {
                return "$element$ asc";
            }
            if (orderByFragment.equalsIgnoreCase("desc")) {
                return "$element$ desc";
            }
        }
        return orderByFragment;
    }

    private DependantValue buildCollectionKey(AnnotatedJoinColumns joinColumns, OnDeleteAction onDeleteAction) {
        boolean noConstraintByDefault = this.buildingContext.getBuildingOptions().isNoConstraintByDefault();
        this.overrideReferencedPropertyName(this.collection, joinColumns);
        String referencedPropertyName = this.collection.getReferencedPropertyName();
        PersistentClass owner = this.collection.getOwner();
        KeyValue keyValue = referencedPropertyName == null ? owner.getIdentifier() : (KeyValue)owner.getReferencedProperty(referencedPropertyName).getValue();
        DependantValue key = new DependantValue(this.buildingContext, this.collection.getCollectionTable(), keyValue);
        key.setTypeName(null);
        joinColumns.checkPropertyConsistency();
        List<AnnotatedColumn> columns = joinColumns.getColumns();
        key.setNullable(columns.isEmpty() || columns.get(0).isNullable());
        key.setUpdateable(columns.isEmpty() || columns.get(0).isUpdatable());
        key.setOnDeleteAction(onDeleteAction);
        this.collection.setKey(key);
        if (this.property != null) {
            CollectionTable collectionTableAnn = (CollectionTable)this.property.getDirectAnnotationUsage(CollectionTable.class);
            if (collectionTableAnn != null) {
                ForeignKey foreignKey = collectionTableAnn.foreignKey();
                ConstraintMode constraintMode = foreignKey.value();
                if (constraintMode == ConstraintMode.NO_CONSTRAINT || constraintMode == ConstraintMode.PROVIDER_DEFAULT && noConstraintByDefault) {
                    key.disableForeignKey();
                } else {
                    key.setForeignKeyName(StringHelper.nullIfEmpty(foreignKey.name()));
                    key.setForeignKeyDefinition(StringHelper.nullIfEmpty(foreignKey.foreignKeyDefinition()));
                    if (key.getForeignKeyName() == null && key.getForeignKeyDefinition() == null && collectionTableAnn.joinColumns().length == 1) {
                        JoinColumn joinColumn = collectionTableAnn.joinColumns()[0];
                        ForeignKey nestedForeignKey = joinColumn.foreignKey();
                        key.setForeignKeyName(StringHelper.nullIfEmpty(nestedForeignKey.name()));
                        key.setForeignKeyDefinition(StringHelper.nullIfEmpty(nestedForeignKey.foreignKeyDefinition()));
                    }
                }
            } else {
                JoinTable joinTableAnn = (JoinTable)this.property.getDirectAnnotationUsage(JoinTable.class);
                if (joinTableAnn != null) {
                    ForeignKey foreignKey = joinTableAnn.foreignKey();
                    String foreignKeyName = foreignKey.name();
                    String foreignKeyDefinition = foreignKey.foreignKeyDefinition();
                    ConstraintMode foreignKeyValue = foreignKey.value();
                    Object[] joinColumnAnnotations = joinTableAnn.joinColumns();
                    if (!ArrayHelper.isEmpty(joinColumnAnnotations)) {
                        Object joinColumnAnn = joinColumnAnnotations[0];
                        ForeignKey joinColumnForeignKey = joinColumnAnn.foreignKey();
                        if (foreignKeyName.isEmpty()) {
                            foreignKeyName = joinColumnForeignKey.name();
                            foreignKeyDefinition = joinColumnForeignKey.foreignKeyDefinition();
                        }
                        if (foreignKeyValue != ConstraintMode.NO_CONSTRAINT) {
                            foreignKeyValue = joinColumnForeignKey.value();
                        }
                    }
                    if (foreignKeyValue == ConstraintMode.NO_CONSTRAINT || foreignKeyValue == ConstraintMode.PROVIDER_DEFAULT && noConstraintByDefault) {
                        key.disableForeignKey();
                    } else {
                        key.setForeignKeyName(StringHelper.nullIfEmpty(foreignKeyName));
                        key.setForeignKeyDefinition(StringHelper.nullIfEmpty(foreignKeyDefinition));
                    }
                } else {
                    String propertyPath = StringHelper.qualify(this.propertyHolder.getPath(), this.property.getName());
                    ForeignKey foreignKey = this.propertyHolder.getOverriddenForeignKey(propertyPath);
                    if (foreignKey != null) {
                        CollectionBinder.handleForeignKeyConstraint(noConstraintByDefault, key, foreignKey);
                    } else {
                        jakarta.persistence.OneToMany oneToManyAnn = (jakarta.persistence.OneToMany)this.property.getDirectAnnotationUsage(jakarta.persistence.OneToMany.class);
                        OnDelete onDeleteAnn = (OnDelete)this.property.getDirectAnnotationUsage(OnDelete.class);
                        if (!(oneToManyAnn == null || oneToManyAnn.mappedBy().isEmpty() || onDeleteAnn != null && onDeleteAnn.action() == OnDeleteAction.CASCADE)) {
                            key.disableForeignKey();
                        } else {
                            JoinColumn joinColumnAnn = (JoinColumn)this.property.getDirectAnnotationUsage(JoinColumn.class);
                            if (joinColumnAnn != null) {
                                CollectionBinder.handleForeignKeyConstraint(noConstraintByDefault, key, joinColumnAnn.foreignKey());
                            }
                        }
                    }
                }
            }
        }
        return key;
    }

    private static void handleForeignKeyConstraint(boolean noConstraintByDefault, DependantValue key, ForeignKey foreignKey) {
        ConstraintMode constraintMode = foreignKey.value();
        if (constraintMode == ConstraintMode.NO_CONSTRAINT || constraintMode == ConstraintMode.PROVIDER_DEFAULT && noConstraintByDefault) {
            key.disableForeignKey();
        } else {
            key.setForeignKeyName(StringHelper.nullIfEmpty(foreignKey.name()));
            key.setForeignKeyDefinition(StringHelper.nullIfEmpty(foreignKey.foreignKeyDefinition()));
        }
    }

    private void overrideReferencedPropertyName(org.hibernate.mapping.Collection collection, AnnotatedJoinColumns joinColumns) {
        if (this.isUnownedCollection() && !joinColumns.getColumns().isEmpty()) {
            Object entityName = joinColumns.getManyToManyOwnerSideEntityName() != null ? "inverse__" + joinColumns.getManyToManyOwnerSideEntityName() : joinColumns.getPropertyHolder().getEntityName();
            InFlightMetadataCollector collector = this.buildingContext.getMetadataCollector();
            String referencedProperty = collector.getPropertyReferencedAssociation((String)entityName, this.mappedBy);
            if (referencedProperty != null) {
                collection.setReferencedPropertyName(referencedProperty);
                collector.addPropertyReference(collection.getOwnerEntityName(), referencedProperty);
            }
        }
    }

    private void bindManyToManySecondPass(Map<String, PersistentClass> persistentClasses) throws MappingException {
        if (this.property == null) {
            throw new AssertionFailure("null was passed for argument property");
        }
        TypeDetails elementType = this.getElementType();
        PersistentClass targetEntity = persistentClasses.get(elementType.getName());
        String hqlOrderBy = this.extractHqlOrderBy(this.jpaOrderBy);
        boolean isCollectionOfEntities = targetEntity != null;
        boolean isManyToAny = this.property.hasDirectAnnotationUsage(ManyToAny.class);
        this.logManyToManySecondPass(this.oneToMany, isCollectionOfEntities, isManyToAny);
        this.detectManyToManyProblems(elementType, isCollectionOfEntities, isManyToAny);
        if (this.isUnownedCollection()) {
            this.handleUnownedManyToMany(elementType, targetEntity, isCollectionOfEntities);
        } else {
            this.handleOwnedManyToMany(targetEntity, isCollectionOfEntities);
        }
        this.bindSynchronize();
        this.bindFilters(isCollectionOfEntities);
        this.handleWhere(isCollectionOfEntities);
        this.bindCollectionSecondPass(targetEntity, this.joinColumns);
        if (isCollectionOfEntities) {
            ManyToOne element = this.handleCollectionOfEntities(elementType, targetEntity, hqlOrderBy);
            this.bindManyToManyInverseForeignKey(targetEntity, this.inverseJoinColumns, element, this.oneToMany);
        } else if (isManyToAny) {
            this.handleManyToAny();
        } else {
            this.handleElementCollection(elementType, hqlOrderBy);
        }
        CollectionBinder.checkFilterConditions(this.collection);
        CollectionBinder.checkConsistentColumnMutability(this.collection);
    }

    private void handleElementCollection(TypeDetails elementType, String hqlOrderBy) {
        boolean isPrimitive = BinderHelper.isPrimitive(elementType.getName());
        ClassDetails elementClass = isPrimitive ? null : elementType.determineRawClass();
        AnnotatedClassType classType = this.annotatedElementType(this.isEmbedded, isPrimitive, this.property, elementClass);
        if (!isPrimitive) {
            this.propertyHolder.startingProperty(this.property);
        }
        CollectionPropertyHolder holder = PropertyHolderBuilder.buildPropertyHolder(this.collection, this.collection.getRole(), elementClass, this.property, this.propertyHolder, this.buildingContext);
        Class<? extends CompositeUserType<?>> compositeUserType = CollectionBinder.resolveCompositeUserType(this.property, elementClass, this.buildingContext);
        boolean isComposite = classType == AnnotatedClassType.EMBEDDABLE || compositeUserType != null;
        holder.prepare(this.property, isComposite);
        if (isComposite) {
            this.handleCompositeCollectionElement(hqlOrderBy, elementType, elementClass, holder, compositeUserType);
        } else {
            this.handleCollectionElement(elementType, hqlOrderBy, elementClass, holder);
        }
    }

    private void handleCollectionElement(TypeDetails elementType, String hqlOrderBy, ClassDetails elementClass, CollectionPropertyHolder holder) {
        BasicValueBinder elementBinder = new BasicValueBinder(BasicValueBinder.Kind.COLLECTION_ELEMENT, this.buildingContext);
        elementBinder.setReturnedClassName(elementType.getName());
        AnnotatedColumns actualColumns = CollectionBinder.createElementColumnsIfNecessary(this.collection, this.elementColumns, "elt", null, this.buildingContext);
        elementBinder.setColumns(actualColumns);
        elementBinder.setType(this.property, elementType, this.collection.getOwnerEntityName(), holder.resolveElementAttributeConverterDescriptor(this.property, elementClass));
        elementBinder.setPersistentClassName(this.propertyHolder.getEntityName());
        elementBinder.setAccessType(this.accessType);
        this.collection.setElement(elementBinder.make());
        String orderBy = CollectionBinder.adjustUserSuppliedValueCollectionOrderingFragment(hqlOrderBy);
        if (orderBy != null) {
            this.collection.setOrderBy(orderBy);
        }
    }

    private void handleCompositeCollectionElement(String hqlOrderBy, TypeDetails elementType, ClassDetails elementClass, CollectionPropertyHolder holder, Class<? extends CompositeUserType<?>> compositeUserType) {
        String orderBy;
        AccessType accessType = CollectionBinder.accessType(this.property, this.collection.getOwner());
        EntityBinder entityBinder = new EntityBinder(this.buildingContext);
        entityBinder.setPropertyAccessType(accessType);
        Component component = EmbeddableBinder.fillEmbeddable(holder, this.getSpecialMembers(elementType), accessType, true, entityBinder, false, false, true, this.resolveCustomInstantiator(this.property, elementType, this.buildingContext), compositeUserType, null, this.buildingContext, this.inheritanceStatePerClass);
        this.collection.setElement(component);
        if (StringHelper.isNotEmpty(hqlOrderBy) && (orderBy = CollectionBinder.adjustUserSuppliedValueCollectionOrderingFragment(hqlOrderBy)) != null) {
            this.collection.setOrderBy(orderBy);
        }
    }

    static AccessType accessType(MemberDetails property, PersistentClass owner) {
        Access accessAnn = (Access)property.getDirectAnnotationUsage(Access.class);
        if (accessAnn != null) {
            return accessAnn.value() == jakarta.persistence.AccessType.PROPERTY ? AccessType.PROPERTY : AccessType.FIELD;
        }
        if (owner.getIdentifierProperty() != null) {
            return owner.getIdentifierProperty().getPropertyAccessorName().equals("property") ? AccessType.PROPERTY : AccessType.FIELD;
        }
        if (owner.getIdentifierMapper() != null && owner.getIdentifierMapper().getPropertySpan() > 0) {
            return owner.getIdentifierMapper().getProperties().get(0).getPropertyAccessorName().equals("property") ? AccessType.PROPERTY : AccessType.FIELD;
        }
        throw new AssertionFailure("Unable to guess collection property accessor name");
    }

    private AnnotatedClassType annotatedElementType(boolean isEmbedded, boolean isPrimitive, MemberDetails property, ClassDetails elementClass) {
        if (isPrimitive) {
            return AnnotatedClassType.NONE;
        }
        boolean attributeOverride = property.hasDirectAnnotationUsage(AttributeOverride.class) || property.hasDirectAnnotationUsage(AttributeOverrides.class);
        return isEmbedded || attributeOverride ? AnnotatedClassType.EMBEDDABLE : this.buildingContext.getMetadataCollector().getClassType(elementClass);
    }

    static AnnotatedColumns createElementColumnsIfNecessary(org.hibernate.mapping.Collection collection, AnnotatedColumns elementColumns, String defaultName, Long defaultLength, MetadataBuildingContext context) {
        if (elementColumns == null || elementColumns.getColumns().isEmpty()) {
            AnnotatedColumns columns = new AnnotatedColumns();
            columns.setBuildingContext(context);
            AnnotatedColumn column = new AnnotatedColumn();
            column.setLogicalColumnName(defaultName);
            if (defaultLength != null) {
                column.setLength(defaultLength);
            }
            column.setImplicit(false);
            column.setNullable(true);
            column.setParent(columns);
            column.bind();
            elementColumns = columns;
        }
        elementColumns.setTable(collection.getCollectionTable());
        return elementColumns;
    }

    private ManyToOne handleCollectionOfEntities(TypeDetails elementType, PersistentClass collectionEntity, String hqlOrderBy) {
        JoinTable joinTableAnn;
        ManyToOne element = new ManyToOne(this.buildingContext, this.collection.getCollectionTable());
        this.collection.setElement(element);
        element.setReferencedEntityName(elementType.getName());
        element.setFetchMode(FetchMode.JOIN);
        element.setLazy(false);
        element.setNotFoundAction(this.notFoundAction);
        if (hqlOrderBy != null) {
            this.collection.setManyToManyOrdering(CollectionBinder.buildOrderByClauseFromHql(hqlOrderBy, collectionEntity));
        }
        if ((joinTableAnn = (JoinTable)this.property.getDirectAnnotationUsage(JoinTable.class)) != null) {
            ConstraintMode constraintMode;
            ForeignKey inverseForeignKey = joinTableAnn.inverseForeignKey();
            String foreignKeyName = inverseForeignKey.name();
            String foreignKeyDefinition = inverseForeignKey.foreignKeyDefinition();
            Object[] inverseJoinColumns = joinTableAnn.inverseJoinColumns();
            if (!ArrayHelper.isEmpty(inverseJoinColumns)) {
                Object joinColumnAnn = inverseJoinColumns[0];
                if (foreignKeyName.isEmpty()) {
                    ForeignKey inverseJoinColumnForeignKey = joinColumnAnn.foreignKey();
                    foreignKeyName = inverseJoinColumnForeignKey.name();
                    foreignKeyDefinition = inverseJoinColumnForeignKey.foreignKeyDefinition();
                }
            }
            if ((constraintMode = inverseForeignKey.value()) == ConstraintMode.NO_CONSTRAINT || constraintMode == ConstraintMode.PROVIDER_DEFAULT && this.buildingContext.getBuildingOptions().isNoConstraintByDefault()) {
                element.disableForeignKey();
            } else {
                element.setForeignKeyName(StringHelper.nullIfEmpty(foreignKeyName));
                element.setForeignKeyDefinition(StringHelper.nullIfEmpty(foreignKeyDefinition));
            }
        }
        return element;
    }

    private void handleManyToAny() {
        PropertyInferredData inferredData = new PropertyInferredData(null, (TypeVariableScope)this.declaringClass, this.property, "unsupported", this.buildingContext);
        MemberDetails prop = inferredData.getAttributeMember();
        jakarta.persistence.Column discriminatorColumnAnn = (jakarta.persistence.Column)prop.getDirectAnnotationUsage(jakarta.persistence.Column.class);
        Formula discriminatorFormulaAnn = DialectOverridesAnnotationHelper.getOverridableAnnotation((AnnotationTarget)prop, Formula.class, this.buildingContext);
        this.inverseJoinColumns.setTable(this.collection.getCollectionTable());
        ManyToAny anyAnn = (ManyToAny)this.property.getDirectAnnotationUsage(ManyToAny.class);
        Any any = BinderHelper.buildAnyValue(discriminatorColumnAnn, discriminatorFormulaAnn, this.inverseJoinColumns, inferredData, this.onDeleteAction, anyAnn.fetch() == FetchType.LAZY, Nullability.NO_CONSTRAINT, this.propertyHolder, new EntityBinder(this.buildingContext), true, this.buildingContext);
        this.collection.setElement(any);
    }

    private PropertyData getSpecialMembers(TypeDetails elementClass) {
        if (this.isMap()) {
            if (this.isHibernateExtensionMapping()) {
                return new PropertyPreloadedData(AccessType.PROPERTY, "element", elementClass);
            }
            return new PropertyPreloadedData(AccessType.PROPERTY, "value", elementClass);
        }
        if (this.isHibernateExtensionMapping()) {
            return new PropertyPreloadedData(AccessType.PROPERTY, "element", elementClass);
        }
        return new PropertyPreloadedData(AccessType.PROPERTY, "collection&&element", elementClass);
    }

    private void handleOwnedManyToMany(PersistentClass collectionEntity, boolean isCollectionOfEntities) {
        InFlightMetadataCollector collector = this.buildingContext.getMetadataCollector();
        PersistentClass owner = this.collection.getOwner();
        this.joinColumns.setMappedBy(owner.getEntityName(), collector.getLogicalTableName(owner.getTable()), collector.getFromMappedBy(owner.getEntityName(), this.joinColumns.getPropertyName()));
        if (StringHelper.isEmpty(this.tableBinder.getName())) {
            this.tableBinder.setDefaultName(owner.getClassName(), owner.getEntityName(), owner.getJpaEntityName(), collector.getLogicalTableName(owner.getTable()), collectionEntity != null ? collectionEntity.getClassName() : null, collectionEntity != null ? collectionEntity.getEntityName() : null, collectionEntity != null ? collectionEntity.getJpaEntityName() : null, collectionEntity != null ? collector.getLogicalTableName(collectionEntity.getTable()) : null, this.joinColumns.getPropertyName());
        }
        this.tableBinder.setJPA2ElementCollection(!isCollectionOfEntities && this.property.hasDirectAnnotationUsage(ElementCollection.class));
        Table collectionTable = this.tableBinder.bind();
        this.collection.setCollectionTable(collectionTable);
        this.handleCheckConstraints(collectionTable);
        this.processSoftDeletes();
    }

    private void handleCheckConstraints(Table collectionTable) {
        this.property.forEachAnnotationUsage(Check.class, this.sourceModelContext(), usage -> CollectionBinder.addCheckToCollection(collectionTable, usage));
        this.property.forEachAnnotationUsage(JoinTable.class, this.sourceModelContext(), usage -> {
            TableBinder.addTableCheck(collectionTable, usage.check());
            TableBinder.addTableComment(collectionTable, usage.comment());
            TableBinder.addTableOptions(collectionTable, usage.options());
        });
    }

    private static void addCheckToCollection(Table collectionTable, Check check) {
        String name = check.name();
        String constraint = check.constraints();
        collectionTable.addCheck(name.isEmpty() ? new CheckConstraint(constraint) : new CheckConstraint(name, constraint));
    }

    private void processSoftDeletes() {
        assert (this.collection.getCollectionTable() != null);
        SoftDelete softDelete = CollectionBinder.extractSoftDelete(this.property, this.propertyHolder, this.buildingContext);
        if (softDelete == null) {
            return;
        }
        SoftDeleteHelper.bindSoftDeleteIndicator(softDelete, this.collection, this.collection.getCollectionTable(), this.buildingContext);
    }

    private static SoftDelete extractSoftDelete(MemberDetails property, PropertyHolder propertyHolder, MetadataBuildingContext context) {
        SoftDelete fromProperty = (SoftDelete)property.getDirectAnnotationUsage(SoftDelete.class);
        if (fromProperty != null) {
            return fromProperty;
        }
        return BinderHelper.extractFromPackage(SoftDelete.class, property.getDeclaringType(), context);
    }

    private void handleUnownedManyToMany(TypeDetails elementType, PersistentClass collectionEntity, boolean isCollectionOfEntities) {
        Property otherSideProperty;
        if (!isCollectionOfEntities) {
            throw new AnnotationException("Association '" + this.safeCollectionRole() + "'" + CollectionBinder.targetEntityMessage(elementType));
        }
        this.joinColumns.setManyToManyOwnerSideEntityName(collectionEntity.getEntityName());
        try {
            otherSideProperty = collectionEntity.getRecursiveProperty(this.mappedBy);
        }
        catch (MappingException e) {
            throw new AnnotationException("Association '" + this.safeCollectionRole() + "is 'mappedBy' a property named '" + this.mappedBy + "' which does not exist in the target entity '" + elementType.getName() + "'");
        }
        Value otherSidePropertyValue = otherSideProperty.getValue();
        Table table = otherSidePropertyValue instanceof org.hibernate.mapping.Collection ? ((org.hibernate.mapping.Collection)otherSidePropertyValue).getCollectionTable() : otherSidePropertyValue.getTable();
        this.collection.setCollectionTable(table);
        this.processSoftDeletes();
        if (this.property.hasDirectAnnotationUsage(Checks.class) || this.property.hasDirectAnnotationUsage(Check.class)) {
            throw new AnnotationException("Association '" + this.safeCollectionRole() + " is an unowned collection and may not be annotated '@Check'");
        }
    }

    private void detectManyToManyProblems(TypeDetails elementType, boolean isCollectionOfEntities, boolean isManyToAny) {
        if (!isCollectionOfEntities) {
            if (this.property.hasDirectAnnotationUsage(ManyToMany.class) || this.property.hasDirectAnnotationUsage(jakarta.persistence.OneToMany.class)) {
                throw new AnnotationException("Association '" + this.safeCollectionRole() + "'" + CollectionBinder.targetEntityMessage(elementType));
            }
            if (isManyToAny) {
                if (this.propertyHolder.getJoinTable(this.property) == null) {
                    throw new AnnotationException("Association '" + this.safeCollectionRole() + "' is a '@ManyToAny' and must specify a '@JoinTable'");
                }
            } else {
                JoinTable joinTableAnn = this.propertyHolder.getJoinTable(this.property);
                if (joinTableAnn != null && !ArrayHelper.isEmpty(joinTableAnn.inverseJoinColumns())) {
                    throw new AnnotationException("Association '" + this.safeCollectionRole() + " has a '@JoinTable' with 'inverseJoinColumns' and" + CollectionBinder.targetEntityMessage(elementType));
                }
            }
        }
    }

    static String targetEntityMessage(TypeDetails elementType) {
        String problem = elementType.determineRawClass().hasDirectAnnotationUsage(Entity.class) ? " which does not belong to the same persistence unit" : " which is not an '@Entity' type";
        return " targets the type '" + elementType.getName() + "'" + problem;
    }

    private Class<? extends org.hibernate.metamodel.spi.EmbeddableInstantiator> resolveCustomInstantiator(MemberDetails property, TypeDetails propertyClass, MetadataBuildingContext context) {
        EmbeddableInstantiator propertyAnnotation = (EmbeddableInstantiator)property.getDirectAnnotationUsage(EmbeddableInstantiator.class);
        if (propertyAnnotation != null) {
            return propertyAnnotation.value();
        }
        ClassDetails rawPropertyClassDetails = propertyClass.determineRawClass();
        EmbeddableInstantiator classAnnotation = (EmbeddableInstantiator)rawPropertyClassDetails.getDirectAnnotationUsage(EmbeddableInstantiator.class);
        if (classAnnotation != null) {
            return classAnnotation.value();
        }
        Class embeddableClass = rawPropertyClassDetails.toJavaClass();
        if (embeddableClass != null) {
            return context.getMetadataCollector().findRegisteredEmbeddableInstantiator(embeddableClass);
        }
        return null;
    }

    private static Class<? extends CompositeUserType<?>> resolveCompositeUserType(MemberDetails property, ClassDetails returnedClass, MetadataBuildingContext context) {
        CompositeType compositeType = (CompositeType)property.getDirectAnnotationUsage(CompositeType.class);
        if (compositeType != null) {
            return compositeType.value();
        }
        if (returnedClass != null) {
            Class embeddableClass = returnedClass.toJavaClass();
            return embeddableClass == null ? null : context.getMetadataCollector().findRegisteredCompositeUserType(embeddableClass);
        }
        return null;
    }

    private String extractHqlOrderBy(jakarta.persistence.OrderBy jpaOrderBy) {
        if (jpaOrderBy != null) {
            return jpaOrderBy.value();
        }
        return null;
    }

    private static void checkFilterConditions(org.hibernate.mapping.Collection collection) {
        if (!(collection.getFilters().isEmpty() && !StringHelper.isNotEmpty(collection.getWhere()) || collection.getFetchMode() != FetchMode.JOIN || collection.getElement() instanceof SimpleValue || collection.getElement().getFetchMode() == FetchMode.JOIN)) {
            throw new MappingException("@ManyToMany or @ElementCollection defining filter or where without join fetching not valid within collection using join fetching[" + collection.getRole() + "]");
        }
    }

    private static void checkConsistentColumnMutability(org.hibernate.mapping.Collection collection) {
        CollectionBinder.checkConsistentColumnMutability(collection.getRole(), collection.getKey());
        CollectionBinder.checkConsistentColumnMutability(collection.getRole(), collection.getElement());
    }

    private static void checkConsistentColumnMutability(String collectionRole, Value value) {
        Boolean readOnly = null;
        for (int i = 0; i < value.getColumnSpan(); ++i) {
            boolean insertable = value.isColumnInsertable(i);
            if (insertable != value.isColumnUpdateable(i)) {
                throw new AnnotationException("Join column '" + value.getColumns().get(i).getName() + "' on collection property '" + collectionRole + "' must be defined with the same insertable and updatable attributes");
            }
            if (readOnly == null) {
                readOnly = insertable;
                continue;
            }
            if (readOnly == insertable || value.getColumns().get(i).isFormula()) continue;
            throw new AnnotationException("All join columns on collection '" + collectionRole + "' should have the same insertable and updatable setting");
        }
    }

    private void bindCollectionSecondPass(PersistentClass targetEntity, AnnotatedJoinColumns joinColumns) {
        if (!this.isUnownedCollection()) {
            BinderHelper.createSyntheticPropertyReference(joinColumns, this.collection.getOwner(), this.collection.getOwner(), this.collection, this.propertyName, false, this.buildingContext);
        }
        if (this.property.hasDirectAnnotationUsage(ElementCollection.class)) {
            joinColumns.setElementCollection(true);
        }
        DependantValue key = this.buildCollectionKey(joinColumns, this.onDeleteAction);
        TableBinder.bindForeignKey(this.collection.getOwner(), targetEntity, joinColumns, key, false, this.buildingContext);
        key.sortProperties();
    }

    public void setOnDeleteActionAction(OnDeleteAction onDeleteAction) {
        this.onDeleteAction = onDeleteAction;
    }

    String safeCollectionRole() {
        return this.propertyHolder != null ? this.propertyHolder.getEntityName() + "." + this.propertyName : "";
    }

    public void bindManyToManyInverseForeignKey(PersistentClass targetEntity, AnnotatedJoinColumns joinColumns, SimpleValue value, boolean unique) {
        if (joinColumns.hasMappedBy()) {
            this.bindUnownedManyToManyInverseForeignKey(targetEntity, joinColumns, value);
        } else {
            this.bindOwnedManyToManyForeignKeyMappedBy(targetEntity, joinColumns, value, unique);
        }
    }

    private void bindOwnedManyToManyForeignKeyMappedBy(PersistentClass targetEntity, AnnotatedJoinColumns joinColumns, SimpleValue value, boolean unique) {
        BinderHelper.createSyntheticPropertyReference(joinColumns, targetEntity, this.collection.getOwner(), value, this.propertyName, true, this.buildingContext);
        if (this.notFoundAction == NotFoundAction.IGNORE) {
            value.disableForeignKey();
        }
        TableBinder.bindForeignKey(targetEntity, this.collection.getOwner(), joinColumns, value, unique, this.buildingContext);
    }

    private void bindUnownedManyToManyInverseForeignKey(PersistentClass targetEntity, AnnotatedJoinColumns joinColumns, SimpleValue value) {
        Property property = targetEntity.getRecursiveProperty(this.mappedBy);
        List<Selectable> mappedByColumns = CollectionBinder.mappedByColumns(targetEntity, property);
        AnnotatedJoinColumn firstColumn = joinColumns.getJoinColumns().get(0);
        for (Selectable selectable : mappedByColumns) {
            firstColumn.linkValueUsingAColumnCopy((Column)selectable, value);
        }
        String referencedPropertyName = this.buildingContext.getMetadataCollector().getPropertyReferencedAssociation(targetEntity.getEntityName(), this.mappedBy);
        if (referencedPropertyName != null) {
            ((ManyToOne)value).setReferencedPropertyName(referencedPropertyName);
            this.buildingContext.getMetadataCollector().addUniquePropertyReference(targetEntity.getEntityName(), referencedPropertyName);
        }
        ((ManyToOne)value).setReferenceToPrimaryKey(referencedPropertyName == null);
        value.createForeignKey();
    }

    private static List<Selectable> mappedByColumns(PersistentClass referencedEntity, Property property) {
        if (property.getValue() instanceof org.hibernate.mapping.Collection) {
            return ((org.hibernate.mapping.Collection)property.getValue()).getKey().getSelectables();
        }
        Value key = null;
        for (Join join : referencedEntity.getJoins()) {
            if (!join.containsProperty(property)) continue;
            key = join.getKey();
            break;
        }
        if (key == null) {
            key = property.getPersistentClass().getIdentifier();
        }
        return key.getSelectables();
    }

    public void setFkJoinColumns(AnnotatedJoinColumns annotatedJoinColumns) {
        this.foreignJoinColumns = annotatedJoinColumns;
    }

    public void setExplicitAssociationTable(boolean isExplicitAssociationTable) {
        this.isExplicitAssociationTable = isExplicitAssociationTable;
    }

    public void setElementColumns(AnnotatedColumns elementColumns) {
        this.elementColumns = elementColumns;
    }

    public void setEmbedded(boolean annotationPresent) {
        this.isEmbedded = annotationPresent;
    }

    public void setProperty(MemberDetails property) {
        this.property = property;
    }

    public NotFoundAction getNotFoundAction() {
        return this.notFoundAction;
    }

    public void setNotFoundAction(NotFoundAction notFoundAction) {
        this.notFoundAction = notFoundAction;
    }

    public void setMapKeyColumns(AnnotatedColumns mapKeyColumns) {
        this.mapKeyColumns = mapKeyColumns;
    }

    public void setMapKeyManyToManyColumns(AnnotatedJoinColumns mapJoinColumns) {
        this.mapKeyManyToManyColumns = mapJoinColumns;
    }

    public void setLocalGenerators(Map<String, IdentifierGeneratorDefinition> localGenerators) {
        this.localGenerators = localGenerators;
    }

    private void logOneToManySecondPass() {
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Binding a OneToMany: %s through a foreign key", this.safeCollectionRole());
        }
    }

    private void logManyToManySecondPass(boolean isOneToMany, boolean isCollectionOfEntities, boolean isManyToAny) {
        if (LOG.isDebugEnabled()) {
            if (isCollectionOfEntities && isOneToMany) {
                LOG.debugf("Binding a OneToMany: %s through an association table", this.safeCollectionRole());
            } else if (isCollectionOfEntities) {
                LOG.debugf("Binding a ManyToMany: %s", this.safeCollectionRole());
            } else if (isManyToAny) {
                LOG.debugf("Binding a ManyToAny: %s", this.safeCollectionRole());
            } else {
                LOG.debugf("Binding a collection of element: %s", this.safeCollectionRole());
            }
        }
    }
}

