/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import jakarta.persistence.Access;
import jakarta.persistence.AssociationOverride;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.Cacheable;
import jakarta.persistence.ConstraintMode;
import jakarta.persistence.DiscriminatorColumn;
import jakarta.persistence.DiscriminatorValue;
import jakarta.persistence.Entity;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.IdClass;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.NamedEntityGraph;
import jakarta.persistence.PrimaryKeyJoinColumn;
import jakarta.persistence.PrimaryKeyJoinColumns;
import jakarta.persistence.SecondaryTable;
import jakarta.persistence.SecondaryTables;
import jakarta.persistence.SharedCacheMode;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.MappingException;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.CacheLayout;
import org.hibernate.annotations.Check;
import org.hibernate.annotations.Checks;
import org.hibernate.annotations.ConcreteProxy;
import org.hibernate.annotations.DiscriminatorFormula;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Filter;
import org.hibernate.annotations.Filters;
import org.hibernate.annotations.HQLSelect;
import org.hibernate.annotations.Immutable;
import org.hibernate.annotations.Mutability;
import org.hibernate.annotations.NaturalIdCache;
import org.hibernate.annotations.OnDelete;
import org.hibernate.annotations.OptimisticLockType;
import org.hibernate.annotations.OptimisticLocking;
import org.hibernate.annotations.QueryCacheLayout;
import org.hibernate.annotations.RowId;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.SQLDeleteAll;
import org.hibernate.annotations.SQLInsert;
import org.hibernate.annotations.SQLRestriction;
import org.hibernate.annotations.SQLSelect;
import org.hibernate.annotations.SQLUpdate;
import org.hibernate.annotations.SecondaryRow;
import org.hibernate.annotations.SecondaryRows;
import org.hibernate.annotations.SoftDelete;
import org.hibernate.annotations.Subselect;
import org.hibernate.annotations.Synchronize;
import org.hibernate.annotations.TypeBinderType;
import org.hibernate.annotations.View;
import org.hibernate.binder.TypeBinder;
import org.hibernate.boot.model.IdentifierGeneratorDefinition;
import org.hibernate.boot.model.NamedEntityGraphDefinition;
import org.hibernate.boot.model.internal.AnnotatedClassType;
import org.hibernate.boot.model.internal.AnnotatedColumns;
import org.hibernate.boot.model.internal.AnnotatedDiscriminatorColumn;
import org.hibernate.boot.model.internal.AnnotatedJoinColumn;
import org.hibernate.boot.model.internal.AnnotatedJoinColumns;
import org.hibernate.boot.model.internal.BinderHelper;
import org.hibernate.boot.model.internal.CreateKeySecondPass;
import org.hibernate.boot.model.internal.DialectOverridesAnnotationHelper;
import org.hibernate.boot.model.internal.EmbeddableBinder;
import org.hibernate.boot.model.internal.IndexBinder;
import org.hibernate.boot.model.internal.InheritanceState;
import org.hibernate.boot.model.internal.JoinedSubclassFkSecondPass;
import org.hibernate.boot.model.internal.Nullability;
import org.hibernate.boot.model.internal.NullableDiscriminatorColumnSecondPass;
import org.hibernate.boot.model.internal.PropertyBinder;
import org.hibernate.boot.model.internal.PropertyContainer;
import org.hibernate.boot.model.internal.PropertyHolder;
import org.hibernate.boot.model.internal.PropertyHolderBuilder;
import org.hibernate.boot.model.internal.PropertyPreloadedData;
import org.hibernate.boot.model.internal.QueryBinder;
import org.hibernate.boot.model.internal.SecondaryTableFromAnnotationSecondPass;
import org.hibernate.boot.model.internal.SecondaryTableSecondPass;
import org.hibernate.boot.model.internal.SoftDeleteHelper;
import org.hibernate.boot.model.internal.TableBinder;
import org.hibernate.boot.model.naming.EntityNaming;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.naming.ImplicitEntityNameSource;
import org.hibernate.boot.model.naming.NamingStrategyHelper;
import org.hibernate.boot.model.relational.QualifiedTableName;
import org.hibernate.boot.models.HibernateAnnotations;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.annotations.internal.CacheAnnotation;
import org.hibernate.boot.models.annotations.spi.CustomSqlDetails;
import org.hibernate.boot.models.annotations.spi.DialectOverrider;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.boot.spi.AccessType;
import org.hibernate.boot.spi.InFlightMetadataCollector;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.PropertyData;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.OptimisticLockStyle;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.spi.ExecuteUpdateResultCheckStyle;
import org.hibernate.engine.spi.FilterDefinition;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.jdbc.Expectation;
import org.hibernate.jpa.event.internal.CallbackDefinitionResolver;
import org.hibernate.jpa.event.spi.CallbackType;
import org.hibernate.mapping.BasicValue;
import org.hibernate.mapping.CheckConstraint;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.DependantValue;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.JoinedSubclass;
import org.hibernate.mapping.MappedSuperclass;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.SingleTableSubclass;
import org.hibernate.mapping.Subclass;
import org.hibernate.mapping.TableOwner;
import org.hibernate.mapping.UnionSubclass;
import org.hibernate.mapping.Value;
import org.hibernate.models.internal.ClassTypeDetailsImpl;
import org.hibernate.models.spi.AnnotationTarget;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.MemberDetails;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.hibernate.models.spi.TypeDetails;
import org.hibernate.models.spi.TypeVariableScope;
import org.jboss.logging.Logger;

public class EntityBinder {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)EntityBinder.class.getName());
    private static final String NATURAL_ID_CACHE_SUFFIX = "##NaturalId";
    private MetadataBuildingContext context;
    private String name;
    private ClassDetails annotatedClass;
    private PersistentClass persistentClass;
    private boolean lazy;
    private ClassDetails proxyClass;
    private String where;
    private final Map<String, Join> secondaryTables = new HashMap<String, Join>();
    private final Map<String, Object> secondaryTableJoins = new HashMap<String, Object>();
    private final Map<String, Join> secondaryTablesFromAnnotation = new HashMap<String, Join>();
    private final Map<String, Object> secondaryTableFromAnnotationJoins = new HashMap<String, Object>();
    private final List<Filter> filters = new ArrayList<Filter>();
    private boolean ignoreIdAnnotations;
    private AccessType propertyAccessType = AccessType.DEFAULT;
    private boolean wrapIdsInEmbeddedComponents;
    private String subselect;
    private boolean isCached;
    private String cacheConcurrentStrategy;
    private String cacheRegion;
    private boolean cacheLazyProperty;
    private String naturalIdCacheRegion;
    private CacheLayout queryCacheLayout;

    private SourceModelBuildingContext getSourceModelContext() {
        return this.context.getMetadataCollector().getSourceModelBuildingContext();
    }

    public static void bindEntityClass(ClassDetails clazzToProcess, Map<ClassDetails, InheritanceState> inheritanceStates, Map<String, IdentifierGeneratorDefinition> generators, MetadataBuildingContext context) {
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Binding entity from annotated class: %s", clazzToProcess.getName());
        }
        InheritanceState inheritanceState = inheritanceStates.get(clazzToProcess);
        PersistentClass superEntity = EntityBinder.getSuperEntity(clazzToProcess, inheritanceStates, context, inheritanceState);
        PersistentClass persistentClass = EntityBinder.makePersistentClass(inheritanceState, superEntity, context);
        EntityBinder.checkOverrides(clazzToProcess, superEntity, context.getMetadataCollector().getSourceModelBuildingContext());
        EntityBinder entityBinder = new EntityBinder(clazzToProcess, persistentClass, context);
        entityBinder.bindEntity();
        entityBinder.bindSubselect();
        entityBinder.bindTables(inheritanceState, superEntity);
        entityBinder.bindCustomSql();
        entityBinder.bindSynchronize();
        entityBinder.bindFilters();
        entityBinder.handleCheckConstraints();
        PropertyHolder holder = PropertyHolderBuilder.buildPropertyHolder(clazzToProcess, persistentClass, entityBinder, context, inheritanceStates);
        entityBinder.handleInheritance(inheritanceState, superEntity, holder);
        entityBinder.handleIdentifier(holder, inheritanceStates, generators, inheritanceState);
        InFlightMetadataCollector collector = context.getMetadataCollector();
        if (persistentClass instanceof RootClass) {
            collector.addSecondPass(new CreateKeySecondPass((RootClass)persistentClass));
            EntityBinder.bindSoftDelete(clazzToProcess, (RootClass)persistentClass, inheritanceState, context);
        }
        if (persistentClass instanceof Subclass) {
            assert (superEntity != null);
            superEntity.addSubclass((Subclass)persistentClass);
        }
        collector.addEntityBinding(persistentClass);
        collector.addSecondPass(new SecondaryTableFromAnnotationSecondPass(entityBinder, holder));
        collector.addSecondPass(new SecondaryTableSecondPass(entityBinder, holder));
        entityBinder.processComplementaryTableDefinitions();
        EntityBinder.bindCallbacks(clazzToProcess, persistentClass, context);
        entityBinder.callTypeBinders(persistentClass);
    }

    private void bindTables(InheritanceState inheritanceState, PersistentClass superEntity) {
        this.handleClassTable(inheritanceState, superEntity);
        this.handleSecondaryTables();
    }

    private static void checkOverrides(ClassDetails clazzToProcess, PersistentClass superEntity, SourceModelBuildingContext sourceModelContext) {
        if (superEntity != null) {
            clazzToProcess.forEachAnnotationUsage(AttributeOverride.class, sourceModelContext, usage -> EntityBinder.checkOverride(superEntity, usage.name(), clazzToProcess, AttributeOverride.class));
            clazzToProcess.forEachAnnotationUsage(AssociationOverride.class, sourceModelContext, usage -> EntityBinder.checkOverride(superEntity, usage.name(), clazzToProcess, AttributeOverride.class));
        }
    }

    private static void checkOverride(PersistentClass superEntity, String name, ClassDetails clazzToProcess, Class<?> overrideClass) {
        if (superEntity.hasProperty(StringHelper.root(name))) {
            throw new AnnotationException("Property '" + name + "' is inherited from entity '" + superEntity.getEntityName() + "' and may not be overridden using '@" + overrideClass.getSimpleName() + "' in entity subclass '" + clazzToProcess.getName() + "'");
        }
    }

    private static void bindSoftDelete(ClassDetails classDetails, RootClass rootClass, InheritanceState inheritanceState, MetadataBuildingContext context) {
        SoftDelete softDelete = EntityBinder.extractSoftDelete(classDetails, inheritanceState, context);
        if (softDelete != null) {
            SoftDeleteHelper.bindSoftDeleteIndicator(softDelete, rootClass, rootClass.getRootTable(), context);
        }
    }

    private static SoftDelete extractSoftDelete(ClassDetails classDetails, InheritanceState inheritanceState, MetadataBuildingContext context) {
        SourceModelBuildingContext sourceModelContext = context.getMetadataCollector().getSourceModelBuildingContext();
        SoftDelete fromClass = (SoftDelete)classDetails.getAnnotationUsage(SoftDelete.class, sourceModelContext);
        if (fromClass != null) {
            return fromClass;
        }
        for (ClassDetails classToCheck = classDetails.getSuperClass(); classToCheck != null; classToCheck = classToCheck.getSuperClass()) {
            SoftDelete fromSuper = (SoftDelete)classToCheck.getAnnotationUsage(SoftDelete.class, sourceModelContext);
            if (fromSuper == null || !classToCheck.hasAnnotationUsage(jakarta.persistence.MappedSuperclass.class, sourceModelContext)) continue;
            return fromSuper;
        }
        return BinderHelper.extractFromPackage(SoftDelete.class, classDetails, context);
    }

    private void handleCheckConstraints() {
        if (this.annotatedClass.hasAnnotationUsage(Checks.class, this.getSourceModelContext())) {
            Checks explicitUsage = (Checks)this.annotatedClass.getAnnotationUsage(Checks.class, this.getSourceModelContext());
            for (Check check : explicitUsage.value()) {
                this.addCheckToEntity(check);
            }
        } else {
            Check check = DialectOverridesAnnotationHelper.getOverridableAnnotation((AnnotationTarget)this.annotatedClass, Check.class, this.context);
            if (check != null) {
                this.addCheckToEntity(check);
            }
        }
    }

    private void addCheckToEntity(Check check) {
        String name = check.name();
        String constraint = check.constraints();
        this.persistentClass.addCheckConstraint(name.isEmpty() ? new CheckConstraint(constraint) : new CheckConstraint(name, constraint));
    }

    private void callTypeBinders(PersistentClass persistentClass) {
        List metaAnnotatedList = this.annotatedClass.getMetaAnnotated(TypeBinderType.class, this.getSourceModelContext());
        for (Annotation metaAnnotated : metaAnnotatedList) {
            this.applyTypeBinder(metaAnnotated, persistentClass);
        }
    }

    private void applyTypeBinder(Annotation containingAnnotation, PersistentClass persistentClass) {
        Class<TypeBinder<?>> binderClass = containingAnnotation.annotationType().getAnnotation(TypeBinderType.class).binder();
        try {
            TypeBinder<?> binder = binderClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            binder.bind(containingAnnotation, this.context, persistentClass);
        }
        catch (Exception e) {
            throw new AnnotationException("error processing @TypeBinderType annotation '" + containingAnnotation + "'", e);
        }
    }

    private void handleIdentifier(PropertyHolder propertyHolder, Map<ClassDetails, InheritanceState> inheritanceStates, Map<String, IdentifierGeneratorDefinition> generators, InheritanceState inheritanceState) {
        InheritanceState.ElementsToProcess elementsToProcess = inheritanceState.postProcess(this.persistentClass, this);
        Set<String> idPropertiesIfIdClass = this.handleIdClass(this.persistentClass, inheritanceState, this.context, propertyHolder, elementsToProcess, inheritanceStates);
        this.processIdPropertiesIfNotAlready(this.persistentClass, inheritanceState, this.context, propertyHolder, generators, idPropertiesIfIdClass, elementsToProcess, inheritanceStates);
    }

    private void processComplementaryTableDefinitions() {
        Table jpaTableUsage = (Table)this.annotatedClass.getAnnotationUsage(Table.class, this.getSourceModelContext());
        if (jpaTableUsage != null) {
            org.hibernate.mapping.Table table = this.persistentClass.getTable();
            TableBinder.addJpaIndexes(table, jpaTableUsage.indexes(), this.context);
            TableBinder.addTableCheck(table, jpaTableUsage.check());
            TableBinder.addTableComment(table, jpaTableUsage.comment());
            TableBinder.addTableOptions(table, jpaTableUsage.options());
        }
        InFlightMetadataCollector.EntityTableXref entityTableXref = this.context.getMetadataCollector().getEntityTableXref(this.persistentClass.getEntityName());
        this.annotatedClass.forEachAnnotationUsage(SecondaryTable.class, this.getSourceModelContext(), usage -> {
            Identifier secondaryTableLogicalName = Identifier.toIdentifier(usage.name());
            org.hibernate.mapping.Table table = entityTableXref.resolveTable(secondaryTableLogicalName);
            assert (table != null);
            TableBinder.addJpaIndexes(table, usage.indexes(), this.context);
        });
    }

    private Set<String> handleIdClass(PersistentClass persistentClass, InheritanceState inheritanceState, MetadataBuildingContext context, PropertyHolder propertyHolder, InheritanceState.ElementsToProcess elementsToProcess, Map<ClassDetails, InheritanceState> inheritanceStates) {
        HashSet<String> idPropertiesIfIdClass = new HashSet<String>();
        boolean isIdClass = this.mapAsIdClass(inheritanceStates, inheritanceState, persistentClass, propertyHolder, elementsToProcess, idPropertiesIfIdClass, context);
        if (!isIdClass) {
            this.setWrapIdsInEmbeddedComponents(elementsToProcess.getIdPropertyCount() > 1);
        }
        return idPropertiesIfIdClass;
    }

    private boolean mapAsIdClass(Map<ClassDetails, InheritanceState> inheritanceStates, InheritanceState inheritanceState, PersistentClass persistentClass, PropertyHolder propertyHolder, InheritanceState.ElementsToProcess elementsToProcess, Set<String> idPropertiesIfIdClass, MetadataBuildingContext context) {
        ClassDetails classWithIdClass = inheritanceState.getClassWithIdClass(false);
        if (classWithIdClass != null) {
            AccessType propertyAccessor;
            PropertyPreloadedData baseInferredData;
            IdClass idClassAnn = (IdClass)classWithIdClass.getDirectAnnotationUsage(IdClass.class);
            Class idClassValue = idClassAnn.value();
            ClassDetails compositeClass = context.getMetadataCollector().getSourceModelBuildingContext().getClassDetailsRegistry().resolveClassDetails(idClassValue.getName());
            ClassTypeDetailsImpl compositeType = new ClassTypeDetailsImpl(compositeClass, TypeDetails.Kind.CLASS);
            ClassTypeDetailsImpl classWithIdType = new ClassTypeDetailsImpl(classWithIdClass, TypeDetails.Kind.CLASS);
            AccessType accessType = this.getPropertyAccessType();
            PropertyPreloadedData inferredData = new PropertyPreloadedData(accessType, "id", (TypeDetails)compositeType);
            boolean isFakeIdClass = EntityBinder.isIdClassPkOfTheAssociatedEntity(elementsToProcess, compositeClass, inferredData, baseInferredData = new PropertyPreloadedData(accessType, "id", (TypeDetails)classWithIdType), propertyAccessor = this.getPropertyAccessor((AnnotationTarget)compositeClass), inheritanceStates, context);
            if (isFakeIdClass) {
                return false;
            }
            boolean ignoreIdAnnotations = this.isIgnoreIdAnnotations();
            this.setIgnoreIdAnnotations(true);
            Component idClassComponent = this.bindIdClass(inferredData, baseInferredData, propertyHolder, propertyAccessor, context, inheritanceStates);
            Component mapper = this.createMapperProperty(inheritanceStates, persistentClass, propertyHolder, context, classWithIdClass, (TypeDetails)compositeType, baseInferredData, propertyAccessor, true);
            if (idClassComponent.isSimpleRecord()) {
                mapper.setSimpleRecord(true);
            }
            this.setIgnoreIdAnnotations(ignoreIdAnnotations);
            for (Property property : mapper.getProperties()) {
                idPropertiesIfIdClass.add(property.getName());
            }
            return true;
        }
        return false;
    }

    private Component createMapperProperty(Map<ClassDetails, InheritanceState> inheritanceStates, PersistentClass persistentClass, PropertyHolder propertyHolder, MetadataBuildingContext context, ClassDetails classWithIdClass, TypeDetails compositeClass, PropertyData baseInferredData, AccessType propertyAccessor, boolean isIdClass) {
        Component mapper = this.createMapper(inheritanceStates, persistentClass, propertyHolder, context, classWithIdClass, compositeClass, baseInferredData, propertyAccessor, isIdClass);
        Property mapperProperty = new Property();
        mapperProperty.setName("_identifierMapper");
        mapperProperty.setUpdateable(false);
        mapperProperty.setInsertable(false);
        mapperProperty.setPropertyAccessorName("embedded");
        mapperProperty.setValue(mapper);
        persistentClass.addProperty(mapperProperty);
        return mapper;
    }

    private Component createMapper(Map<ClassDetails, InheritanceState> inheritanceStates, PersistentClass persistentClass, PropertyHolder propertyHolder, MetadataBuildingContext context, ClassDetails classWithIdClass, TypeDetails compositeClass, PropertyData baseInferredData, AccessType propertyAccessor, boolean isIdClass) {
        Component mapper = EmbeddableBinder.fillEmbeddable(propertyHolder, new PropertyPreloadedData(propertyAccessor, "_identifierMapper", compositeClass), baseInferredData, propertyAccessor, this.annotatedClass, false, this, true, true, false, null, null, null, context, inheritanceStates, isIdClass);
        persistentClass.setIdentifierMapper(mapper);
        MappedSuperclass superclass = BinderHelper.getMappedSuperclassOrNull(classWithIdClass, inheritanceStates, context);
        if (superclass != null) {
            superclass.setDeclaredIdentifierMapper(mapper);
        } else {
            persistentClass.setDeclaredIdentifierMapper(mapper);
        }
        return mapper;
    }

    private static PropertyData getUniqueIdPropertyFromBaseClass(PropertyData inferredData, PropertyData baseInferredData, AccessType propertyAccessor, MetadataBuildingContext context) {
        ArrayList<PropertyData> baseClassElements = new ArrayList<PropertyData>();
        PropertyContainer propContainer = new PropertyContainer(baseInferredData.getClassOrElementType().determineRawClass(), (TypeVariableScope)inferredData.getPropertyType(), propertyAccessor);
        PropertyBinder.addElementsOfClass(baseClassElements, propContainer, context);
        return (PropertyData)baseClassElements.get(0);
    }

    private static boolean isIdClassPkOfTheAssociatedEntity(InheritanceState.ElementsToProcess elementsToProcess, ClassDetails compositeClass, PropertyData inferredData, PropertyData baseInferredData, AccessType propertyAccessor, Map<ClassDetails, InheritanceState> inheritanceStates, MetadataBuildingContext context) {
        if (elementsToProcess.getIdPropertyCount() == 1) {
            PropertyData idPropertyOnBaseClass = EntityBinder.getUniqueIdPropertyFromBaseClass(inferredData, baseInferredData, propertyAccessor, context);
            InheritanceState state = inheritanceStates.get(idPropertyOnBaseClass.getClassOrElementType().determineRawClass());
            if (state == null) {
                return false;
            }
            ClassDetails associatedClassWithIdClass = state.getClassWithIdClass(true);
            if (associatedClassWithIdClass == null) {
                return BinderHelper.hasToOneAnnotation((AnnotationTarget)idPropertyOnBaseClass.getAttributeMember());
            }
            SourceModelBuildingContext sourceModelContext = context.getMetadataCollector().getSourceModelBuildingContext();
            IdClass idClass = (IdClass)associatedClassWithIdClass.getAnnotationUsage(IdClass.class, sourceModelContext);
            return compositeClass.getName().equals(idClass.value().getName());
        }
        return false;
    }

    private Component bindIdClass(PropertyData inferredData, PropertyData baseInferredData, PropertyHolder propertyHolder, AccessType propertyAccessor, MetadataBuildingContext buildingContext, Map<ClassDetails, InheritanceState> inheritanceStates) {
        propertyHolder.setInIdClass(true);
        PersistentClass persistentClass = propertyHolder.getPersistentClass();
        if (!(persistentClass instanceof RootClass)) {
            throw new AnnotationException("Entity '" + persistentClass.getEntityName() + "' is a subclass in an entity inheritance hierarchy and may not redefine the identifier of the root entity");
        }
        RootClass rootClass = (RootClass)persistentClass;
        Component id = EmbeddableBinder.fillEmbeddable(propertyHolder, inferredData, baseInferredData, propertyAccessor, this.annotatedClass, false, this, true, false, false, null, null, null, buildingContext, inheritanceStates, true);
        id.setKey(true);
        if (rootClass.getIdentifier() != null) {
            throw new AssertionFailure("Entity '" + persistentClass.getEntityName() + "' has an '@IdClass' and may not have an identifier property");
        }
        if (id.getPropertySpan() == 0) {
            throw new AnnotationException("Class '" + id.getComponentClassName() + " is the '@IdClass' for the entity '" + persistentClass.getEntityName() + "' but has no persistent properties");
        }
        rootClass.setIdentifier(id);
        rootClass.setEmbeddedIdentifier(inferredData.getPropertyType() == null);
        propertyHolder.setInIdClass(null);
        return id;
    }

    private void handleSecondaryTables() {
        this.annotatedClass.forEachRepeatedAnnotationUsages(JpaAnnotations.SECONDARY_TABLE, this.getSourceModelContext(), usage -> this.addSecondaryTable((SecondaryTable)usage, null, false));
    }

    private void handleClassTable(InheritanceState inheritanceState, PersistentClass superEntity) {
        UniqueConstraint[] uniqueConstraints;
        String catalog;
        String schema;
        String table;
        Table tableAnnotation = (Table)this.annotatedClass.getAnnotationUsage(Table.class, this.getSourceModelContext());
        if (tableAnnotation != null) {
            table = tableAnnotation.name();
            schema = tableAnnotation.schema();
            catalog = tableAnnotation.catalog();
            uniqueConstraints = tableAnnotation.uniqueConstraints();
        } else {
            schema = "";
            table = "";
            catalog = "";
            uniqueConstraints = new UniqueConstraint[]{};
        }
        if (inheritanceState.hasTable()) {
            this.createTable(inheritanceState, superEntity, schema, table, catalog, uniqueConstraints);
        } else {
            if (tableAnnotation != null) {
                throw new AnnotationException("Entity '" + this.annotatedClass.getName() + "' is a subclass in a 'SINGLE_TABLE' hierarchy and may not be annotated '@Table' (the root class declares the table mapping for the hierarchy)");
            }
            this.bindTableForDiscriminatedSubclass(superEntity.getEntityName());
        }
    }

    private void createTable(InheritanceState inheritanceState, PersistentClass superEntity, String schema, String table, String catalog, UniqueConstraint[] uniqueConstraints) {
        RowId rowId = (RowId)this.annotatedClass.getAnnotationUsage(RowId.class, this.getSourceModelContext());
        View view = (View)this.annotatedClass.getAnnotationUsage(View.class, this.getSourceModelContext());
        this.bindTable(schema, catalog, table, uniqueConstraints, rowId == null ? null : rowId.value(), view == null ? null : view.query(), inheritanceState.hasDenormalizedTable() ? this.context.getMetadataCollector().getEntityTableXref(superEntity.getEntityName()) : null);
    }

    private void handleInheritance(InheritanceState inheritanceState, PersistentClass superEntity, PropertyHolder propertyHolder) {
        boolean isJoinedSubclass = switch (inheritanceState.getType()) {
            case InheritanceType.JOINED -> {
                this.joinedInheritance(inheritanceState, superEntity, propertyHolder);
                yield inheritanceState.hasParents();
            }
            case InheritanceType.SINGLE_TABLE -> {
                this.singleTableInheritance(inheritanceState, propertyHolder);
                yield false;
            }
            case InheritanceType.TABLE_PER_CLASS -> false;
            default -> throw new AssertionFailure("Unrecognized InheritanceType");
        };
        this.bindDiscriminatorValue();
        if (!isJoinedSubclass) {
            this.checkNoJoinColumns(this.annotatedClass);
            this.checkNoOnDelete(this.annotatedClass);
        }
    }

    private void singleTableInheritance(InheritanceState inheritanceState, PropertyHolder holder) {
        AnnotatedDiscriminatorColumn discriminatorColumn = this.processSingleTableDiscriminatorProperties(inheritanceState);
        if (!inheritanceState.hasParents()) {
            RootClass rootClass = (RootClass)this.persistentClass;
            if (inheritanceState.hasSiblings() || discriminatorColumn != null && !discriminatorColumn.isImplicit()) {
                this.bindDiscriminatorColumnToRootPersistentClass(rootClass, discriminatorColumn, holder);
                if (this.context.getBuildingOptions().shouldImplicitlyForceDiscriminatorInSelect()) {
                    rootClass.setForceDiscriminator(true);
                }
            }
        }
    }

    private void joinedInheritance(InheritanceState state, PersistentClass superEntity, PropertyHolder holder) {
        if (state.hasParents()) {
            AnnotatedJoinColumns joinColumns = EntityBinder.subclassJoinColumns(this.annotatedClass, superEntity, this.context);
            JoinedSubclass jsc = (JoinedSubclass)this.persistentClass;
            DependantValue key = new DependantValue(this.context, jsc.getTable(), jsc.getIdentifier());
            jsc.setKey(key);
            this.handleForeignKeys(this.annotatedClass, this.context, key);
            OnDelete onDelete = (OnDelete)this.annotatedClass.getAnnotationUsage(OnDelete.class, this.getSourceModelContext());
            key.setOnDeleteAction(onDelete == null ? null : onDelete.action());
            this.context.getMetadataCollector().addSecondPass(new JoinedSubclassFkSecondPass(jsc, joinColumns, key, this.context));
            this.context.getMetadataCollector().addSecondPass(new CreateKeySecondPass(jsc));
        }
        AnnotatedDiscriminatorColumn discriminatorColumn = this.processJoinedDiscriminatorProperties(state);
        if (!state.hasParents()) {
            RootClass rootClass = (RootClass)this.persistentClass;
            if (discriminatorColumn != null && (state.hasSiblings() || !discriminatorColumn.isImplicit())) {
                this.bindDiscriminatorColumnToRootPersistentClass(rootClass, discriminatorColumn, holder);
                if (this.context.getBuildingOptions().shouldImplicitlyForceDiscriminatorInSelect()) {
                    rootClass.setForceDiscriminator(true);
                }
            }
        }
    }

    private void checkNoJoinColumns(ClassDetails annotatedClass) {
        if (annotatedClass.hasAnnotationUsage(PrimaryKeyJoinColumns.class, this.getSourceModelContext()) || annotatedClass.hasAnnotationUsage(PrimaryKeyJoinColumn.class, this.getSourceModelContext())) {
            throw new AnnotationException("Entity class '" + annotatedClass.getName() + "' may not specify a '@PrimaryKeyJoinColumn'");
        }
    }

    private void checkNoOnDelete(ClassDetails annotatedClass) {
        if (annotatedClass.hasAnnotationUsage(PrimaryKeyJoinColumns.class, this.getSourceModelContext()) || annotatedClass.hasAnnotationUsage(PrimaryKeyJoinColumn.class, this.getSourceModelContext())) {
            throw new AnnotationException("Entity class '" + annotatedClass.getName() + "' may not be annotated '@OnDelete'");
        }
    }

    private void handleForeignKeys(ClassDetails clazzToProcess, MetadataBuildingContext context, DependantValue key) {
        PrimaryKeyJoinColumn pkJoinColumn = (PrimaryKeyJoinColumn)clazzToProcess.getDirectAnnotationUsage(PrimaryKeyJoinColumn.class);
        PrimaryKeyJoinColumns pkJoinColumns = (PrimaryKeyJoinColumns)clazzToProcess.getDirectAnnotationUsage(PrimaryKeyJoinColumns.class);
        boolean noConstraintByDefault = context.getBuildingOptions().isNoConstraintByDefault();
        if (pkJoinColumn != null && BinderHelper.noConstraint(pkJoinColumn.foreignKey(), noConstraintByDefault) || pkJoinColumns != null && BinderHelper.noConstraint(pkJoinColumns.foreignKey(), noConstraintByDefault)) {
            key.disableForeignKey();
        } else {
            ForeignKey foreignKey = (ForeignKey)clazzToProcess.getDirectAnnotationUsage(ForeignKey.class);
            if (BinderHelper.noConstraint(foreignKey, noConstraintByDefault)) {
                key.disableForeignKey();
            } else if (foreignKey != null) {
                key.setForeignKeyName(StringHelper.nullIfEmpty(foreignKey.name()));
                key.setForeignKeyDefinition(StringHelper.nullIfEmpty(foreignKey.foreignKeyDefinition()));
            } else if (noConstraintByDefault) {
                key.disableForeignKey();
            } else if (pkJoinColumns != null) {
                ForeignKey nestedFk = pkJoinColumns.foreignKey();
                key.setForeignKeyName(StringHelper.nullIfEmpty(nestedFk.name()));
                key.setForeignKeyDefinition(StringHelper.nullIfEmpty(nestedFk.foreignKeyDefinition()));
            } else if (pkJoinColumn != null) {
                ForeignKey nestedFk = pkJoinColumn.foreignKey();
                key.setForeignKeyName(StringHelper.nullIfEmpty(nestedFk.name()));
                key.setForeignKeyDefinition(StringHelper.nullIfEmpty(nestedFk.foreignKeyDefinition()));
            }
        }
    }

    private void bindDiscriminatorColumnToRootPersistentClass(RootClass rootClass, AnnotatedDiscriminatorColumn discriminatorColumn, PropertyHolder holder) {
        if (rootClass.getDiscriminator() == null) {
            if (discriminatorColumn == null) {
                throw new AssertionFailure("discriminator column should have been built");
            }
            AnnotatedColumns columns = new AnnotatedColumns();
            columns.setPropertyHolder(holder);
            columns.setBuildingContext(this.context);
            columns.setJoins(this.secondaryTables);
            discriminatorColumn.setParent(columns);
            BasicValue discriminatorColumnBinding = new BasicValue(this.context, rootClass.getTable());
            rootClass.setDiscriminator(discriminatorColumnBinding);
            discriminatorColumn.linkWithValue(discriminatorColumnBinding);
            discriminatorColumnBinding.setTypeName(discriminatorColumn.getDiscriminatorTypeName());
            rootClass.setPolymorphic(true);
            String rootEntityName = rootClass.getEntityName();
            LOG.tracev("Setting discriminator for entity {0}", rootEntityName);
            this.context.getMetadataCollector().addSecondPass(new NullableDiscriminatorColumnSecondPass(rootEntityName));
        }
    }

    private AnnotatedDiscriminatorColumn processSingleTableDiscriminatorProperties(InheritanceState inheritanceState) {
        DiscriminatorColumn discriminatorColumn = (DiscriminatorColumn)this.annotatedClass.getAnnotationUsage(DiscriminatorColumn.class, this.getSourceModelContext());
        DiscriminatorFormula discriminatorFormula = DialectOverridesAnnotationHelper.getOverridableAnnotation((AnnotationTarget)this.annotatedClass, DiscriminatorFormula.class, this.context);
        if (!inheritanceState.hasParents() || this.annotatedClass.hasAnnotationUsage(Inheritance.class, this.getSourceModelContext())) {
            return AnnotatedDiscriminatorColumn.buildDiscriminatorColumn(discriminatorColumn, discriminatorFormula, null, "DTYPE", this.context);
        }
        if (discriminatorColumn != null) {
            throw new AnnotationException("Entity class '" + this.annotatedClass.getName() + "' is annotated '@DiscriminatorColumn' but it is not the root of the entity inheritance hierarchy");
        }
        if (discriminatorFormula != null) {
            throw new AnnotationException("Entity class '" + this.annotatedClass.getName() + "' is annotated '@DiscriminatorFormula' but it is not the root of the entity inheritance hierarchy");
        }
        return null;
    }

    private AnnotatedDiscriminatorColumn processJoinedDiscriminatorProperties(InheritanceState inheritanceState) {
        if (this.annotatedClass.hasAnnotationUsage(DiscriminatorFormula.class, this.getSourceModelContext())) {
            throw new AnnotationException("Entity class '" + this.annotatedClass.getName() + "' has 'JOINED' inheritance and is annotated '@DiscriminatorFormula'");
        }
        DiscriminatorColumn discriminatorColumn = (DiscriminatorColumn)this.annotatedClass.getAnnotationUsage(DiscriminatorColumn.class, this.getSourceModelContext());
        if (!inheritanceState.hasParents() || this.annotatedClass.hasAnnotationUsage(Inheritance.class, this.getSourceModelContext())) {
            return this.useDiscriminatorColumnForJoined(discriminatorColumn) ? AnnotatedDiscriminatorColumn.buildDiscriminatorColumn(discriminatorColumn, null, null, "DTYPE", this.context) : null;
        }
        if (discriminatorColumn != null) {
            throw new AnnotationException("Entity class '" + this.annotatedClass.getName() + "' is annotated '@DiscriminatorColumn' but it is not the root of the entity inheritance hierarchy");
        }
        return null;
    }

    private boolean useDiscriminatorColumnForJoined(DiscriminatorColumn discriminatorColumn) {
        if (discriminatorColumn != null) {
            boolean ignore = this.context.getBuildingOptions().ignoreExplicitDiscriminatorsForJoinedInheritance();
            if (ignore) {
                LOG.debugf("Ignoring explicit @DiscriminatorColumn annotation on: %s", this.annotatedClass.getName());
            }
            return !ignore;
        }
        boolean createImplicit = this.context.getBuildingOptions().createImplicitDiscriminatorsForJoinedInheritance();
        if (createImplicit) {
            LOG.debugf("Inferring implicit @DiscriminatorColumn using defaults for: %s", this.annotatedClass.getName());
        }
        return createImplicit;
    }

    private void processIdPropertiesIfNotAlready(PersistentClass persistentClass, InheritanceState inheritanceState, MetadataBuildingContext context, PropertyHolder propertyHolder, Map<String, IdentifierGeneratorDefinition> generators, Set<String> idPropertiesIfIdClass, InheritanceState.ElementsToProcess elementsToProcess, Map<ClassDetails, InheritanceState> inheritanceStates) {
        HashSet<String> missingIdProperties = new HashSet<String>(idPropertiesIfIdClass);
        HashSet<String> missingEntityProperties = new HashSet<String>();
        for (PropertyData propertyAnnotatedElement : elementsToProcess.getElements()) {
            String propertyName = propertyAnnotatedElement.getPropertyName();
            if (!idPropertiesIfIdClass.contains(propertyName)) {
                boolean subclassAndSingleTableStrategy;
                MemberDetails property = propertyAnnotatedElement.getAttributeMember();
                boolean hasIdAnnotation = PropertyBinder.hasIdAnnotation(property);
                if (!idPropertiesIfIdClass.isEmpty() && !this.isIgnoreIdAnnotations() && hasIdAnnotation) {
                    missingEntityProperties.add(propertyName);
                    continue;
                }
                boolean bl = subclassAndSingleTableStrategy = inheritanceState.getType() == InheritanceType.SINGLE_TABLE && inheritanceState.hasParents();
                if (!hasIdAnnotation && property.hasAnnotationUsage(GeneratedValue.class, this.getSourceModelContext())) {
                    throw new AnnotationException("Property '" + BinderHelper.getPath(propertyHolder, propertyAnnotatedElement) + "' is annotated @GeneratedValue but is not part of an identifier");
                }
                PropertyBinder.processElementAnnotations(propertyHolder, subclassAndSingleTableStrategy ? Nullability.FORCED_NULL : Nullability.NO_CONSTRAINT, propertyAnnotatedElement, generators, this, false, false, false, context, inheritanceStates);
                continue;
            }
            missingIdProperties.remove(propertyName);
        }
        if (!missingIdProperties.isEmpty()) {
            throw new AnnotationException("Entity '" + persistentClass.getEntityName() + "' has an '@IdClass' with properties " + EntityBinder.getMissingPropertiesString(missingIdProperties) + " which do not match properties of the entity class");
        }
        if (!missingEntityProperties.isEmpty()) {
            throw new AnnotationException("Entity '" + persistentClass.getEntityName() + "' has '@Id' annotated properties " + EntityBinder.getMissingPropertiesString(missingEntityProperties) + " which do not match properties of the specified '@IdClass'");
        }
    }

    private static String getMissingPropertiesString(Set<String> propertyNames) {
        StringBuilder sb = new StringBuilder();
        for (String property : propertyNames) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("'").append(property).append("'");
        }
        return sb.toString();
    }

    private static PersistentClass makePersistentClass(InheritanceState inheritanceState, PersistentClass superEntity, MetadataBuildingContext metadataBuildingContext) {
        if (!inheritanceState.hasParents()) {
            return new RootClass(metadataBuildingContext);
        }
        switch (inheritanceState.getType()) {
            case SINGLE_TABLE: {
                return new SingleTableSubclass(superEntity, metadataBuildingContext);
            }
            case JOINED: {
                return new JoinedSubclass(superEntity, metadataBuildingContext);
            }
            case TABLE_PER_CLASS: {
                return new UnionSubclass(superEntity, metadataBuildingContext);
            }
        }
        throw new AssertionFailure("Unknown inheritance type: " + inheritanceState.getType());
    }

    private static AnnotatedJoinColumns subclassJoinColumns(ClassDetails clazzToProcess, PersistentClass superEntity, MetadataBuildingContext context) {
        AnnotatedJoinColumns joinColumns = new AnnotatedJoinColumns();
        joinColumns.setBuildingContext(context);
        SourceModelBuildingContext sourceModelContext = context.getMetadataCollector().getSourceModelBuildingContext();
        PrimaryKeyJoinColumns primaryKeyJoinColumns = (PrimaryKeyJoinColumns)clazzToProcess.getAnnotationUsage(PrimaryKeyJoinColumns.class, sourceModelContext);
        if (primaryKeyJoinColumns != null) {
            Object[] columns = primaryKeyJoinColumns.value();
            if (!ArrayHelper.isEmpty(columns)) {
                for (Object column : columns) {
                    AnnotatedJoinColumn.buildInheritanceJoinColumn((PrimaryKeyJoinColumn)column, null, superEntity.getIdentifier(), joinColumns, context);
                }
            } else {
                PrimaryKeyJoinColumn columnAnnotation = (PrimaryKeyJoinColumn)clazzToProcess.getAnnotationUsage(PrimaryKeyJoinColumn.class, sourceModelContext);
                AnnotatedJoinColumn.buildInheritanceJoinColumn(columnAnnotation, null, superEntity.getIdentifier(), joinColumns, context);
            }
        } else {
            AnnotatedJoinColumn.buildInheritanceJoinColumn((PrimaryKeyJoinColumn)clazzToProcess.getAnnotationUsage(PrimaryKeyJoinColumn.class, sourceModelContext), null, superEntity.getIdentifier(), joinColumns, context);
        }
        LOG.trace("Subclass joined column(s) created");
        return joinColumns;
    }

    private static PersistentClass getSuperEntity(ClassDetails clazzToProcess, Map<ClassDetails, InheritanceState> inheritanceStates, MetadataBuildingContext context, InheritanceState inheritanceState) {
        InheritanceState superState = InheritanceState.getInheritanceStateOfSuperEntity(clazzToProcess, inheritanceStates);
        if (superState == null) {
            return null;
        }
        PersistentClass superEntity = context.getMetadataCollector().getEntityBinding(superState.getClassDetails().getName());
        if (superEntity == null && inheritanceState.hasParents()) {
            throw new AssertionFailure("Subclass has to be bound after its parent class: " + superState.getClassDetails().getName());
        }
        return superEntity;
    }

    private static void bindCallbacks(ClassDetails entityClass, PersistentClass persistentClass, MetadataBuildingContext context) {
        for (CallbackType callbackType : CallbackType.values()) {
            persistentClass.addCallbackDefinitions(CallbackDefinitionResolver.resolveEntityCallbacks(context, entityClass, callbackType));
        }
        context.getMetadataCollector().addSecondPass(persistentClasses -> {
            for (Property property : persistentClass.getDeclaredProperties()) {
                if (!property.isComposite()) continue;
                try {
                    Class<?> mappedClass = persistentClass.getMappedClass();
                    for (CallbackType type : CallbackType.values()) {
                        property.addCallbackDefinitions(CallbackDefinitionResolver.resolveEmbeddableCallbacks(context, mappedClass, property, type));
                    }
                }
                catch (ClassLoadingException classLoadingException) {
                }
            }
        });
    }

    public boolean wrapIdsInEmbeddedComponents() {
        return this.wrapIdsInEmbeddedComponents;
    }

    public EntityBinder(MetadataBuildingContext context) {
        this.context = context;
    }

    public EntityBinder(ClassDetails annotatedClass, PersistentClass persistentClass, MetadataBuildingContext context) {
        this.context = context;
        this.persistentClass = persistentClass;
        this.annotatedClass = annotatedClass;
    }

    public boolean isPropertyDefinedInSuperHierarchy(String name) {
        return this.persistentClass != null && this.persistentClass.isPropertyDefinedInSuperHierarchy(name);
    }

    private void bindRowManagement() {
        DynamicInsert dynamicInsertAnn = (DynamicInsert)this.annotatedClass.getAnnotationUsage(DynamicInsert.class, this.getSourceModelContext());
        this.persistentClass.setDynamicInsert(dynamicInsertAnn != null);
        DynamicUpdate dynamicUpdateAnn = (DynamicUpdate)this.annotatedClass.getAnnotationUsage(DynamicUpdate.class, this.getSourceModelContext());
        this.persistentClass.setDynamicUpdate(dynamicUpdateAnn != null);
        if (this.persistentClass.useDynamicInsert() && this.annotatedClass.hasAnnotationUsage(SQLInsert.class, this.getSourceModelContext())) {
            throw new AnnotationException("Entity '" + this.name + "' is annotated both '@DynamicInsert' and '@SQLInsert'");
        }
        if (this.persistentClass.useDynamicUpdate() && this.annotatedClass.hasAnnotationUsage(SQLUpdate.class, this.getSourceModelContext())) {
            throw new AnnotationException("Entity '" + this.name + "' is annotated both '@DynamicUpdate' and '@SQLUpdate'");
        }
    }

    private void bindOptimisticLocking() {
        OptimisticLocking optimisticLockingAnn = (OptimisticLocking)this.annotatedClass.getAnnotationUsage(OptimisticLocking.class, this.getSourceModelContext());
        this.persistentClass.setOptimisticLockStyle(OptimisticLockStyle.fromLockType(optimisticLockingAnn == null ? OptimisticLockType.VERSION : optimisticLockingAnn.type()));
    }

    private void bindEntityAnnotation() {
        Entity entity = (Entity)this.annotatedClass.getAnnotationUsage(Entity.class, this.getSourceModelContext());
        if (entity == null) {
            throw new AssertionFailure("@Entity should never be missing");
        }
        String entityName = entity.name();
        this.name = entityName.isEmpty() ? StringHelper.unqualify(this.annotatedClass.getName()) : entityName;
    }

    public boolean isRootEntity() {
        return this.persistentClass instanceof RootClass;
    }

    public void bindEntity() {
        this.bindEntityAnnotation();
        this.bindRowManagement();
        this.bindOptimisticLocking();
        this.bindProxy();
        this.bindConcreteProxy();
        this.bindWhere();
        this.bindCache();
        this.bindNaturalIdCache();
        this.bindFiltersInHierarchy();
        this.persistentClass.setAbstract(this.annotatedClass.isAbstract());
        this.persistentClass.setClassName(this.annotatedClass.getClassName());
        this.persistentClass.setJpaEntityName(this.name);
        this.persistentClass.setEntityName(this.annotatedClass.getName());
        this.persistentClass.setCached(this.isCached);
        this.persistentClass.setLazy(this.lazy);
        this.persistentClass.setQueryCacheLayout(this.queryCacheLayout);
        if (this.proxyClass != null && this.proxyClass != ClassDetails.VOID_CLASS_DETAILS) {
            this.persistentClass.setProxyInterfaceName(this.proxyClass.getName());
        }
        if (this.persistentClass instanceof RootClass) {
            this.bindRootEntity();
        } else if (!this.isMutable()) {
            throw new AnnotationException("Entity class '" + this.annotatedClass.getName() + "' is annotated '@Immutable' but it is a subclass in an entity inheritance hierarchy (only root classes may declare mutability)");
        }
        this.ensureNoMutabilityPlan();
        this.registerImportName();
        this.processNamedEntityGraphs();
    }

    private void ensureNoMutabilityPlan() {
        if (this.annotatedClass.hasAnnotationUsage(Mutability.class, this.getSourceModelContext())) {
            throw new MappingException("@Mutability is not allowed on entity");
        }
    }

    private boolean isMutable() {
        return !this.annotatedClass.hasAnnotationUsage(Immutable.class, this.getSourceModelContext());
    }

    private void registerImportName() {
        LOG.debugf("Import with entity name %s", this.name);
        try {
            this.context.getMetadataCollector().addImport(this.name, this.persistentClass.getEntityName());
            String entityName = this.persistentClass.getEntityName();
            if (!entityName.equals(this.name)) {
                this.context.getMetadataCollector().addImport(entityName, entityName);
            }
        }
        catch (MappingException me) {
            throw new AnnotationException("Use of the same entity name twice: " + this.name, (Throwable)((Object)me));
        }
    }

    private void bindRootEntity() {
        RootClass rootClass = (RootClass)this.persistentClass;
        rootClass.setMutable(this.isMutable());
        if (StringHelper.isNotEmpty(this.where)) {
            rootClass.setWhere(this.where);
        }
        if (this.cacheConcurrentStrategy != null) {
            rootClass.setCacheConcurrencyStrategy(this.cacheConcurrentStrategy);
            rootClass.setCacheRegionName(this.cacheRegion);
            rootClass.setLazyPropertiesCacheable(this.cacheLazyProperty);
        }
        rootClass.setNaturalIdCacheRegionName(this.naturalIdCacheRegion);
    }

    private void bindCustomSql() {
        HQLSelect hqlSelect;
        SQLDeleteAll sqlDeleteAll;
        SQLDelete sqlDelete;
        SQLUpdate sqlUpdate;
        String primaryTableName = this.persistentClass.getTable().getName();
        SQLInsert sqlInsert = this.resolveCustomSqlAnnotation(this.annotatedClass, SQLInsert.class, primaryTableName);
        if (sqlInsert == null) {
            sqlInsert = this.resolveCustomSqlAnnotation(this.annotatedClass, SQLInsert.class, "");
        }
        if (sqlInsert != null) {
            this.persistentClass.setCustomSQLInsert(sqlInsert.sql().trim(), sqlInsert.callable(), ExecuteUpdateResultCheckStyle.fromResultCheckStyle(sqlInsert.check()));
            Class<? extends Expectation> expectationClass = sqlInsert.verify();
            if (expectationClass != Expectation.class) {
                this.persistentClass.setInsertExpectation(ReflectHelper.getDefaultSupplier(expectationClass));
            }
        }
        if ((sqlUpdate = this.resolveCustomSqlAnnotation(this.annotatedClass, SQLUpdate.class, primaryTableName)) == null) {
            sqlUpdate = this.resolveCustomSqlAnnotation(this.annotatedClass, SQLUpdate.class, "");
        }
        if (sqlUpdate != null) {
            this.persistentClass.setCustomSQLUpdate(sqlUpdate.sql().trim(), sqlUpdate.callable(), ExecuteUpdateResultCheckStyle.fromResultCheckStyle(sqlUpdate.check()));
            Class<? extends Expectation> expectationClass = sqlUpdate.verify();
            if (expectationClass != Expectation.class) {
                this.persistentClass.setUpdateExpectation(ReflectHelper.getDefaultSupplier(expectationClass));
            }
        }
        if ((sqlDelete = this.resolveCustomSqlAnnotation(this.annotatedClass, SQLDelete.class, primaryTableName)) == null) {
            sqlDelete = this.resolveCustomSqlAnnotation(this.annotatedClass, SQLDelete.class, "");
        }
        if (sqlDelete != null) {
            this.persistentClass.setCustomSQLDelete(sqlDelete.sql().trim(), sqlDelete.callable(), ExecuteUpdateResultCheckStyle.fromResultCheckStyle(sqlDelete.check()));
            Class<? extends Expectation> expectationClass = sqlDelete.verify();
            if (expectationClass != Expectation.class) {
                this.persistentClass.setDeleteExpectation(ReflectHelper.getDefaultSupplier(expectationClass));
            }
        }
        if ((sqlDeleteAll = this.resolveCustomSqlAnnotation(this.annotatedClass, SQLDeleteAll.class, "")) != null) {
            throw new AnnotationException("@SQLDeleteAll does not apply to entities: " + this.persistentClass.getEntityName());
        }
        SQLSelect sqlSelect = DialectOverridesAnnotationHelper.getOverridableAnnotation((AnnotationTarget)this.annotatedClass, SQLSelect.class, this.context);
        if (sqlSelect != null) {
            String loaderName = this.persistentClass.getEntityName() + "$SQLSelect";
            this.persistentClass.setLoaderName(loaderName);
            QueryBinder.bindNativeQuery(loaderName, sqlSelect, this.annotatedClass, this.context);
        }
        if ((hqlSelect = (HQLSelect)this.annotatedClass.getAnnotationUsage(HQLSelect.class, this.getSourceModelContext())) != null) {
            String loaderName = this.persistentClass.getEntityName() + "$HQLSelect";
            this.persistentClass.setLoaderName(loaderName);
            QueryBinder.bindQuery(loaderName, hqlSelect, this.context);
        }
    }

    private void bindSubselect() {
        Subselect subselect = (Subselect)this.annotatedClass.getAnnotationUsage(Subselect.class, this.getSourceModelContext());
        if (subselect != null) {
            this.subselect = subselect.value();
        }
    }

    private <A extends Annotation> A resolveCustomSqlAnnotation(ClassDetails annotatedClass, Class<A> annotationType, String tableName) {
        Class overrideAnnotation = DialectOverridesAnnotationHelper.getOverrideAnnotation(annotationType);
        Object[] dialectOverrides = annotatedClass.getRepeatedAnnotationUsages(overrideAnnotation, this.getSourceModelContext());
        if (CollectionHelper.isNotEmpty(dialectOverrides)) {
            Dialect dialect = this.context.getMetadataCollector().getDatabase().getDialect();
            for (int i = 0; i < dialectOverrides.length; ++i) {
                DialectOverrider dialectOverride = (DialectOverrider)dialectOverrides[i];
                if (!dialectOverride.matches(dialect)) continue;
                Object override = dialectOverride.override();
                if (StringHelper.isEmpty(tableName) && StringHelper.isEmpty(((CustomSqlDetails)override).table())) {
                    return (A)override;
                }
                if (!StringHelper.isNotEmpty(tableName) || !tableName.equals(((CustomSqlDetails)override).table())) continue;
                return (A)override;
            }
        }
        return (A)annotatedClass.getNamedAnnotationUsage(annotationType, tableName, "table", this.getSourceModelContext());
    }

    private void bindFilters() {
        for (Filter filter : this.filters) {
            String filterName = filter.name();
            String condition = filter.condition();
            if (condition.isEmpty()) {
                condition = this.getDefaultFilterCondition(filterName);
            }
            this.persistentClass.addFilter(filterName, condition, filter.deduceAliasInjectionPoints(), BinderHelper.toAliasTableMap(filter.aliases()), BinderHelper.toAliasEntityMap(filter.aliases()));
        }
    }

    private String getDefaultFilterCondition(String filterName) {
        FilterDefinition definition = this.context.getMetadataCollector().getFilterDefinition(filterName);
        if (definition == null) {
            throw new AnnotationException("Entity '" + this.name + "' has a '@Filter' for an undefined filter named '" + filterName + "'");
        }
        String condition = definition.getDefaultFilterCondition();
        if (StringHelper.isEmpty(condition)) {
            throw new AnnotationException("Entity '" + this.name + "' has a '@Filter' with no 'condition' and no default condition was given by the '@FilterDef' named '" + filterName + "'");
        }
        return condition;
    }

    private void bindSynchronize() {
        String[] tableNames;
        Synchronize synchronize = (Synchronize)this.annotatedClass.getAnnotationUsage(Synchronize.class, this.getSourceModelContext());
        if (synchronize == null) {
            return;
        }
        JdbcEnvironment jdbcEnvironment = this.context.getMetadataCollector().getDatabase().getJdbcEnvironment();
        boolean logical = synchronize.logical();
        for (String tableName : tableNames = synchronize.value()) {
            String physicalName = logical ? this.toPhysicalName(jdbcEnvironment, tableName) : tableName;
            this.persistentClass.addSynchronizedTable(physicalName);
        }
    }

    private String toPhysicalName(JdbcEnvironment jdbcEnvironment, String logicalName) {
        Identifier identifier = jdbcEnvironment.getIdentifierHelper().toIdentifier(logicalName);
        return this.context.getBuildingOptions().getPhysicalNamingStrategy().toPhysicalTableName(identifier, jdbcEnvironment).render(jdbcEnvironment.getDialect());
    }

    public PersistentClass getPersistentClass() {
        return this.persistentClass;
    }

    private void processNamedEntityGraphs() {
        this.annotatedClass.forEachAnnotationUsage(NamedEntityGraph.class, this.getSourceModelContext(), this::processNamedEntityGraph);
    }

    private void processNamedEntityGraph(NamedEntityGraph annotation) {
        if (annotation == null) {
            return;
        }
        this.context.getMetadataCollector().addNamedEntityGraph(new NamedEntityGraphDefinition(annotation, this.name, this.persistentClass.getEntityName()));
    }

    public void bindDiscriminatorValue() {
        String discriminatorValue;
        DiscriminatorValue discriminatorValueAnn = (DiscriminatorValue)this.annotatedClass.getAnnotationUsage(DiscriminatorValue.class, this.getSourceModelContext());
        String string = discriminatorValue = discriminatorValueAnn != null ? discriminatorValueAnn.value() : null;
        if (StringHelper.isEmpty(discriminatorValue)) {
            Value discriminator = this.persistentClass.getDiscriminator();
            if (discriminator == null) {
                this.persistentClass.setDiscriminatorValue(this.name);
            } else {
                if ("character".equals(discriminator.getType().getName())) {
                    throw new AnnotationException("Entity '" + this.name + "' has a discriminator of character type and must specify its '@DiscriminatorValue'");
                }
                if ("integer".equals(discriminator.getType().getName())) {
                    this.persistentClass.setDiscriminatorValue(String.valueOf(this.name.hashCode()));
                } else {
                    this.persistentClass.setDiscriminatorValue(this.name);
                }
            }
        } else {
            this.persistentClass.setDiscriminatorValue(discriminatorValue);
        }
    }

    public void bindProxy() {
        this.lazy = true;
        this.proxyClass = this.annotatedClass;
    }

    public void bindConcreteProxy() {
        ConcreteProxy annotationUsage = (ConcreteProxy)this.annotatedClass.getAnnotationUsage(ConcreteProxy.class, this.getSourceModelContext());
        if (annotationUsage != null) {
            if (this.persistentClass.getSuperclass() != null) {
                throw new AnnotationException("Entity class '" + this.persistentClass.getClassName() + "' is annotated '@ConcreteProxy' but it is not the root of the entity inheritance hierarchy");
            }
            this.persistentClass.getRootClass().setConcreteProxy(true);
        }
    }

    public void bindWhere() {
        SQLRestriction restriction = DialectOverridesAnnotationHelper.getOverridableAnnotation((AnnotationTarget)this.annotatedClass, SQLRestriction.class, this.context);
        if (restriction != null) {
            this.where = restriction.value();
        }
    }

    public void setWrapIdsInEmbeddedComponents(boolean wrapIdsInEmbeddedComponents) {
        this.wrapIdsInEmbeddedComponents = wrapIdsInEmbeddedComponents;
    }

    private void bindNaturalIdCache() {
        Cache explicitCacheAnn;
        this.naturalIdCacheRegion = null;
        NaturalIdCache naturalIdCacheAnn = (NaturalIdCache)this.annotatedClass.getAnnotationUsage(NaturalIdCache.class, this.getSourceModelContext());
        if (naturalIdCacheAnn == null) {
            return;
        }
        String region = naturalIdCacheAnn.region();
        this.naturalIdCacheRegion = region.isEmpty() ? ((explicitCacheAnn = (Cache)this.annotatedClass.getAnnotationUsage(Cache.class, this.getSourceModelContext())) != null && StringHelper.isNotEmpty(explicitCacheAnn.region()) ? explicitCacheAnn.region() + NATURAL_ID_CACHE_SUFFIX : this.annotatedClass.getName() + NATURAL_ID_CACHE_SUFFIX) : naturalIdCacheAnn.region();
    }

    private void bindCache() {
        this.isCached = false;
        this.cacheConcurrentStrategy = null;
        this.cacheRegion = null;
        this.cacheLazyProperty = true;
        this.queryCacheLayout = null;
        SharedCacheMode sharedCacheMode = this.context.getBuildingOptions().getSharedCacheMode();
        if (this.persistentClass instanceof RootClass) {
            this.bindRootClassCache(sharedCacheMode, this.context);
        } else {
            this.bindSubclassCache(sharedCacheMode);
        }
    }

    private void bindSubclassCache(SharedCacheMode sharedCacheMode) {
        if (this.annotatedClass.hasAnnotationUsage(Cache.class, this.getSourceModelContext())) {
            String className = this.persistentClass.getClassName() == null ? this.annotatedClass.getName() : this.persistentClass.getClassName();
            throw new AnnotationException("Entity class '" + className + "' is annotated '@Cache' but it is a subclass in an entity inheritance hierarchy (only root classes may define second-level caching semantics)");
        }
        Cacheable cacheable = (Cacheable)this.annotatedClass.getAnnotationUsage(Cacheable.class, this.getSourceModelContext());
        this.isCached = cacheable == null && this.persistentClass.getSuperclass() != null ? this.persistentClass.getSuperclass().isCached() : EntityBinder.isCacheable(sharedCacheMode, cacheable);
    }

    private void bindRootClassCache(SharedCacheMode sharedCacheMode, MetadataBuildingContext context) {
        Cache effectiveCache;
        Cache cache = (Cache)this.annotatedClass.getAnnotationUsage(Cache.class, this.getSourceModelContext());
        Cacheable cacheable = (Cacheable)this.annotatedClass.getAnnotationUsage(Cacheable.class, this.getSourceModelContext());
        if (cache != null) {
            this.isCached = true;
            effectiveCache = cache;
        } else {
            effectiveCache = EntityBinder.buildCacheMock(this.annotatedClass, context);
            this.isCached = EntityBinder.isCacheable(sharedCacheMode, cacheable);
        }
        this.cacheConcurrentStrategy = EntityBinder.resolveCacheConcurrencyStrategy(effectiveCache.usage());
        this.cacheRegion = effectiveCache.region();
        this.cacheLazyProperty = EntityBinder.isCacheLazy(effectiveCache, this.annotatedClass);
        QueryCacheLayout queryCache = (QueryCacheLayout)this.annotatedClass.getAnnotationUsage(QueryCacheLayout.class, this.getSourceModelContext());
        this.queryCacheLayout = queryCache == null ? null : queryCache.layout();
    }

    private static boolean isCacheLazy(Cache effectiveCache, ClassDetails annotatedClass) {
        if (!effectiveCache.includeLazy()) {
            return false;
        }
        return switch (effectiveCache.include().toLowerCase(Locale.ROOT)) {
            case "all" -> true;
            case "non-lazy" -> false;
            default -> throw new AnnotationException("Class '" + annotatedClass.getName() + "' has a '@Cache' with undefined option 'include=\"" + effectiveCache.include() + "\"'");
        };
    }

    private static boolean isCacheable(SharedCacheMode sharedCacheMode, Cacheable explicitCacheableAnn) {
        return switch (sharedCacheMode) {
            case SharedCacheMode.ALL -> true;
            case SharedCacheMode.ENABLE_SELECTIVE, SharedCacheMode.UNSPECIFIED -> {
                if (explicitCacheableAnn != null && explicitCacheableAnn.value()) {
                    yield true;
                }
                yield false;
            }
            case SharedCacheMode.DISABLE_SELECTIVE -> {
                if (explicitCacheableAnn == null || explicitCacheableAnn.value()) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    private static String resolveCacheConcurrencyStrategy(CacheConcurrencyStrategy strategy) {
        org.hibernate.cache.spi.access.AccessType accessType = strategy.toAccessType();
        return accessType == null ? null : accessType.getExternalName();
    }

    private static Cache buildCacheMock(ClassDetails classDetails, MetadataBuildingContext context) {
        CacheAnnotation cacheUsage = (CacheAnnotation)HibernateAnnotations.CACHE.createUsage(context.getMetadataCollector().getSourceModelBuildingContext());
        cacheUsage.region(classDetails.getName());
        cacheUsage.usage(EntityBinder.determineCacheConcurrencyStrategy(context));
        return cacheUsage;
    }

    private static CacheConcurrencyStrategy determineCacheConcurrencyStrategy(MetadataBuildingContext context) {
        return CacheConcurrencyStrategy.fromAccessType(context.getBuildingOptions().getImplicitCacheAccessType());
    }

    public void bindTableForDiscriminatedSubclass(String entityName) {
        if (!(this.persistentClass instanceof SingleTableSubclass)) {
            throw new AssertionFailure("Was expecting a discriminated subclass [" + SingleTableSubclass.class.getName() + "] but found [" + this.persistentClass.getClass().getName() + "] for entity [" + this.persistentClass.getEntityName() + "]");
        }
        InFlightMetadataCollector collector = this.context.getMetadataCollector();
        InFlightMetadataCollector.EntityTableXref superTableXref = collector.getEntityTableXref(entityName);
        org.hibernate.mapping.Table primaryTable = superTableXref.getPrimaryTable();
        collector.addEntityTableXref(this.persistentClass.getEntityName(), collector.getDatabase().toIdentifier(collector.getLogicalTableName(primaryTable)), primaryTable, superTableXref);
    }

    public void bindTable(String schema, String catalog, String tableName, UniqueConstraint[] uniqueConstraints, String rowId, String viewQuery, InFlightMetadataCollector.EntityTableXref denormalizedSuperTableXref) {
        String entityName = this.persistentClass.getEntityName();
        EntityTableNamingStrategyHelper namingStrategyHelper = new EntityTableNamingStrategyHelper(this.persistentClass.getClassName(), entityName, this.name);
        Identifier logicalName = StringHelper.isNotEmpty(tableName) ? namingStrategyHelper.handleExplicitName(tableName, this.context) : namingStrategyHelper.determineImplicitName(this.context);
        org.hibernate.mapping.Table table = TableBinder.buildAndFillTable(schema, catalog, logicalName, this.persistentClass.isAbstract(), uniqueConstraints, this.context, this.subselect, denormalizedSuperTableXref);
        table.setRowId(rowId);
        table.setViewQuery(viewQuery);
        this.context.getMetadataCollector().addEntityTableXref(entityName, logicalName, table, denormalizedSuperTableXref);
        if (!(this.persistentClass instanceof TableOwner)) {
            throw new AssertionFailure("binding a table for a subclass");
        }
        LOG.debugf("Bind entity %s on table %s", entityName, table.getName());
        ((TableOwner)((Object)this.persistentClass)).setTable(table);
    }

    public void finalSecondaryTableBinding(PropertyHolder propertyHolder) {
        Iterator<Object> joinColumns = this.secondaryTableJoins.values().iterator();
        for (Map.Entry<String, Join> entrySet : this.secondaryTables.entrySet()) {
            if (this.secondaryTablesFromAnnotation.containsKey(entrySet.getKey())) continue;
            this.createPrimaryColumnsToSecondaryTable(joinColumns.next(), propertyHolder, entrySet.getValue());
        }
    }

    public void finalSecondaryTableFromAnnotationBinding(PropertyHolder propertyHolder) {
        Iterator<Object> joinColumns = this.secondaryTableFromAnnotationJoins.values().iterator();
        for (Map.Entry<String, Join> entrySet : this.secondaryTables.entrySet()) {
            if (!this.secondaryTablesFromAnnotation.containsKey(entrySet.getKey())) continue;
            this.createPrimaryColumnsToSecondaryTable(joinColumns.next(), propertyHolder, entrySet.getValue());
        }
    }

    private void createPrimaryColumnsToSecondaryTable(Object incoming, PropertyHolder propertyHolder, Join join) {
        AnnotatedJoinColumns annotatedJoinColumns;
        Object[] joinColumnSource = (Annotation[])incoming;
        if (CollectionHelper.isEmpty(joinColumnSource)) {
            annotatedJoinColumns = this.createDefaultJoinColumn(propertyHolder);
        } else {
            JoinColumn[] joinColumns;
            PrimaryKeyJoinColumn[] pkJoinColumns;
            Object first = joinColumnSource[0];
            if (first instanceof PrimaryKeyJoinColumn) {
                pkJoinColumns = (PrimaryKeyJoinColumn[])joinColumnSource;
                joinColumns = null;
            } else if (first instanceof JoinColumn) {
                pkJoinColumns = null;
                joinColumns = (JoinColumn[])joinColumnSource;
            } else {
                throw new IllegalArgumentException("Expecting list of AnnotationUsages for either @JoinColumn or @PrimaryKeyJoinColumn, but got as list of AnnotationUsages for @" + first.annotationType().getName());
            }
            annotatedJoinColumns = this.createJoinColumns(propertyHolder, pkJoinColumns, joinColumns);
        }
        for (AnnotatedJoinColumn joinColumn : annotatedJoinColumns.getJoinColumns()) {
            joinColumn.forceNotNull();
        }
        this.bindJoinToPersistentClass(join, annotatedJoinColumns, this.context);
    }

    private AnnotatedJoinColumns createDefaultJoinColumn(PropertyHolder propertyHolder) {
        AnnotatedJoinColumns joinColumns = new AnnotatedJoinColumns();
        joinColumns.setBuildingContext(this.context);
        joinColumns.setJoins(this.secondaryTables);
        joinColumns.setPropertyHolder(propertyHolder);
        AnnotatedJoinColumn.buildInheritanceJoinColumn(null, null, this.persistentClass.getIdentifier(), joinColumns, this.context);
        return joinColumns;
    }

    private AnnotatedJoinColumns createJoinColumns(PropertyHolder propertyHolder, PrimaryKeyJoinColumn[] primaryKeyJoinColumns, JoinColumn[] joinColumns) {
        int joinColumnCount;
        int n = joinColumnCount = primaryKeyJoinColumns != null ? primaryKeyJoinColumns.length : joinColumns.length;
        if (joinColumnCount == 0) {
            return this.createDefaultJoinColumn(propertyHolder);
        }
        AnnotatedJoinColumns columns = new AnnotatedJoinColumns();
        columns.setBuildingContext(this.context);
        columns.setJoins(this.secondaryTables);
        columns.setPropertyHolder(propertyHolder);
        for (int colIndex = 0; colIndex < joinColumnCount; ++colIndex) {
            PrimaryKeyJoinColumn primaryKeyJoinColumn = primaryKeyJoinColumns != null ? primaryKeyJoinColumns[colIndex] : null;
            JoinColumn joinColumn = joinColumns != null ? joinColumns[colIndex] : null;
            AnnotatedJoinColumn.buildInheritanceJoinColumn(primaryKeyJoinColumn, joinColumn, this.persistentClass.getIdentifier(), columns, this.context);
        }
        return columns;
    }

    private void bindJoinToPersistentClass(Join join, AnnotatedJoinColumns joinColumns, MetadataBuildingContext context) {
        DependantValue key = new DependantValue(context, join.getTable(), this.persistentClass.getIdentifier());
        join.setKey(key);
        this.setForeignKeyNameIfDefined(join);
        key.setOnDeleteAction(null);
        TableBinder.bindForeignKey(this.persistentClass, null, joinColumns, key, false, context);
        key.sortProperties();
        join.createPrimaryKey();
        join.createForeignKey();
        this.persistentClass.addJoin(join);
    }

    private void setForeignKeyNameIfDefined(Join join) {
        SimpleValue key = (SimpleValue)join.getKey();
        SecondaryTable jpaSecondaryTable = this.findMatchingSecondaryTable(join);
        if (jpaSecondaryTable != null) {
            boolean noConstraintByDefault = this.context.getBuildingOptions().isNoConstraintByDefault();
            if (jpaSecondaryTable.foreignKey().value() == ConstraintMode.NO_CONSTRAINT || jpaSecondaryTable.foreignKey().value() == ConstraintMode.PROVIDER_DEFAULT && noConstraintByDefault) {
                key.disableForeignKey();
            } else {
                key.setForeignKeyName(StringHelper.nullIfEmpty(jpaSecondaryTable.foreignKey().name()));
                key.setForeignKeyDefinition(StringHelper.nullIfEmpty(jpaSecondaryTable.foreignKey().foreignKeyDefinition()));
            }
        }
    }

    private SecondaryTable findMatchingSecondaryTable(Join join) {
        String nameToMatch = join.getTable().getQuotedName();
        SecondaryTable secondaryTable = (SecondaryTable)this.annotatedClass.getDirectAnnotationUsage(SecondaryTable.class);
        if (secondaryTable != null && nameToMatch.equals(secondaryTable.name())) {
            return secondaryTable;
        }
        SecondaryTables secondaryTables = (SecondaryTables)this.annotatedClass.getDirectAnnotationUsage(SecondaryTables.class);
        if (secondaryTables != null) {
            SecondaryTable[] nestedSecondaryTableList;
            for (SecondaryTable nestedSecondaryTable : nestedSecondaryTableList = secondaryTables.value()) {
                if (nestedSecondaryTable == null || !nameToMatch.equals(nestedSecondaryTable.name())) continue;
                return nestedSecondaryTable;
            }
        }
        return null;
    }

    private SecondaryRow findMatchingSecondaryRowAnnotation(String tableName) {
        SecondaryRow row = (SecondaryRow)this.annotatedClass.getDirectAnnotationUsage(SecondaryRow.class);
        if (row != null && (row.table().isEmpty() || tableName.equals(row.table()))) {
            return row;
        }
        SecondaryRows tables = (SecondaryRows)this.annotatedClass.getDirectAnnotationUsage(SecondaryRows.class);
        if (tables != null) {
            SecondaryRow[] rowList;
            for (SecondaryRow current : rowList = tables.value()) {
                if (!tableName.equals(current.table())) continue;
                return current;
            }
        }
        return null;
    }

    public Join addJoinTable(JoinTable joinTable, PropertyHolder holder, boolean noDelayInPkColumnCreation) {
        Join join = this.addJoin(holder, noDelayInPkColumnCreation, false, joinTable.name(), joinTable.schema(), joinTable.catalog(), joinTable.joinColumns(), joinTable.uniqueConstraints());
        org.hibernate.mapping.Table table = join.getTable();
        TableBinder.addTableCheck(table, joinTable.check());
        TableBinder.addTableComment(table, joinTable.comment());
        TableBinder.addTableOptions(table, joinTable.options());
        return join;
    }

    public Join addSecondaryTable(SecondaryTable secondaryTable, PropertyHolder holder, boolean noDelayInPkColumnCreation) {
        Join join = this.addJoin(holder, noDelayInPkColumnCreation, true, secondaryTable.name(), secondaryTable.schema(), secondaryTable.catalog(), secondaryTable.pkJoinColumns(), secondaryTable.uniqueConstraints());
        org.hibernate.mapping.Table table = join.getTable();
        new IndexBinder(this.context).bindIndexes(table, secondaryTable.indexes());
        TableBinder.addTableCheck(table, secondaryTable.check());
        TableBinder.addTableComment(table, secondaryTable.comment());
        TableBinder.addTableOptions(table, secondaryTable.options());
        return join;
    }

    private Join addJoin(PropertyHolder propertyHolder, boolean noDelayInPkColumnCreation, boolean secondaryTable, String name, String schema, String catalog, Object joinColumns, UniqueConstraint[] uniqueConstraints) {
        QualifiedTableName logicalName = this.logicalTableName(name, schema, catalog);
        return this.createJoin(propertyHolder, noDelayInPkColumnCreation, secondaryTable, joinColumns, logicalName, TableBinder.buildAndFillTable(schema, catalog, logicalName.getTableName(), false, uniqueConstraints, this.context));
    }

    private QualifiedTableName logicalTableName(String name, String schema, String catalog) {
        return new QualifiedTableName(Identifier.toIdentifier(catalog), Identifier.toIdentifier(schema), this.context.getMetadataCollector().getDatabase().getJdbcEnvironment().getIdentifierHelper().toIdentifier(name));
    }

    Join createJoin(PropertyHolder propertyHolder, boolean noDelayInPkColumnCreation, boolean secondaryTable, Object joinColumns, QualifiedTableName logicalName, org.hibernate.mapping.Table table) {
        Join join = new Join();
        this.persistentClass.addJoin(join);
        String entityName = this.persistentClass.getEntityName();
        InFlightMetadataCollector.EntityTableXref tableXref = this.context.getMetadataCollector().getEntityTableXref(entityName);
        assert (tableXref != null) : "Could not locate EntityTableXref for entity [" + entityName + "]";
        tableXref.addSecondaryTable(logicalName, join);
        join.setTable(table);
        LOG.debugf("Adding secondary table to entity %s -> %s", entityName, join.getTable().getName());
        this.handleSecondaryRowManagement(join);
        this.processSecondaryTableCustomSql(join);
        if (noDelayInPkColumnCreation) {
            this.createPrimaryColumnsToSecondaryTable(joinColumns, propertyHolder, join);
        } else {
            String quotedName = table.getQuotedName();
            if (secondaryTable) {
                this.secondaryTablesFromAnnotation.put(quotedName, join);
                this.secondaryTableFromAnnotationJoins.put(quotedName, joinColumns);
            } else {
                this.secondaryTableJoins.put(quotedName, joinColumns);
            }
            this.secondaryTables.put(quotedName, join);
        }
        return join;
    }

    private void handleSecondaryRowManagement(Join join) {
        String tableName = join.getTable().getQuotedName();
        SecondaryRow matchingRow = this.findMatchingSecondaryRowAnnotation(tableName);
        if (matchingRow != null) {
            join.setInverse(!matchingRow.owned());
            join.setOptional(matchingRow.optional());
        } else {
            join.setInverse(false);
            join.setOptional(true);
        }
    }

    private void processSecondaryTableCustomSql(Join join) {
        SQLDelete sqlDelete;
        SQLUpdate sqlUpdate;
        String tableName = join.getTable().getQuotedName();
        SQLInsert sqlInsert = this.resolveCustomSqlAnnotation(this.annotatedClass, SQLInsert.class, tableName);
        if (sqlInsert != null) {
            join.setCustomSQLInsert(sqlInsert.sql().trim(), sqlInsert.callable(), ExecuteUpdateResultCheckStyle.fromResultCheckStyle(sqlInsert.check()));
            Class<? extends Expectation> expectationClass = sqlInsert.verify();
            if (expectationClass != Expectation.class) {
                join.setInsertExpectation(ReflectHelper.getDefaultSupplier(expectationClass));
            }
        }
        if ((sqlUpdate = this.resolveCustomSqlAnnotation(this.annotatedClass, SQLUpdate.class, tableName)) != null) {
            join.setCustomSQLUpdate(sqlUpdate.sql().trim(), sqlUpdate.callable(), ExecuteUpdateResultCheckStyle.fromResultCheckStyle(sqlUpdate.check()));
            Class<? extends Expectation> expectationClass = sqlUpdate.verify();
            if (expectationClass != Expectation.class) {
                join.setUpdateExpectation(ReflectHelper.getDefaultSupplier(expectationClass));
            }
        }
        if ((sqlDelete = this.resolveCustomSqlAnnotation(this.annotatedClass, SQLDelete.class, tableName)) != null) {
            join.setCustomSQLDelete(sqlDelete.sql().trim(), sqlDelete.callable(), ExecuteUpdateResultCheckStyle.fromResultCheckStyle(sqlDelete.check()));
            Class<? extends Expectation> expectationClass = sqlDelete.verify();
            if (expectationClass != Expectation.class) {
                join.setDeleteExpectation(ReflectHelper.getDefaultSupplier(expectationClass));
            }
        }
    }

    public Map<String, Join> getSecondaryTables() {
        return this.secondaryTables;
    }

    public static String getCacheConcurrencyStrategy(CacheConcurrencyStrategy strategy) {
        org.hibernate.cache.spi.access.AccessType accessType = strategy.toAccessType();
        return accessType == null ? null : accessType.getExternalName();
    }

    public void addFilter(Filter filter) {
        this.filters.add(filter);
    }

    public boolean isIgnoreIdAnnotations() {
        return this.ignoreIdAnnotations;
    }

    public void setIgnoreIdAnnotations(boolean ignoreIdAnnotations) {
        this.ignoreIdAnnotations = ignoreIdAnnotations;
    }

    public AccessType getPropertyAccessType() {
        return this.propertyAccessType;
    }

    public void setPropertyAccessType(AccessType propertyAccessType) {
        this.propertyAccessType = this.getExplicitAccessType((AnnotationTarget)this.annotatedClass);
        if (this.propertyAccessType == null) {
            this.propertyAccessType = propertyAccessType;
        }
    }

    public AccessType getPropertyAccessor(AnnotationTarget element) {
        AccessType accessType = this.getExplicitAccessType(element);
        return accessType == null ? this.propertyAccessType : accessType;
    }

    public AccessType getExplicitAccessType(AnnotationTarget element) {
        Access access;
        AccessType accessType = null;
        if (element != null && (access = (Access)element.getAnnotationUsage(Access.class, this.getSourceModelContext())) != null) {
            accessType = AccessType.getAccessStrategy(access.value());
        }
        return accessType;
    }

    public void bindFiltersInHierarchy() {
        AnnotatedClassType classType;
        this.bindFilters((AnnotationTarget)this.annotatedClass);
        for (ClassDetails classToProcess = this.annotatedClass.getSuperClass(); classToProcess != null && (classType = this.context.getMetadataCollector().getClassType(classToProcess)) == AnnotatedClassType.MAPPED_SUPERCLASS; classToProcess = classToProcess.getSuperClass()) {
            this.bindFilters((AnnotationTarget)classToProcess);
        }
    }

    private void bindFilters(AnnotationTarget element) {
        Filter filter;
        Filters filters = DialectOverridesAnnotationHelper.getOverridableAnnotation(element, Filters.class, this.context);
        if (filters != null) {
            for (Filter filter2 : filters.value()) {
                this.addFilter(filter2);
            }
        }
        if ((filter = (Filter)element.getDirectAnnotationUsage(Filter.class)) != null) {
            this.addFilter(filter);
        }
    }

    private static class EntityTableNamingStrategyHelper
    implements NamingStrategyHelper {
        private final String className;
        private final String entityName;
        private final String jpaEntityName;

        private EntityTableNamingStrategyHelper(String className, String entityName, String jpaEntityName) {
            this.className = className;
            this.entityName = entityName;
            this.jpaEntityName = jpaEntityName;
        }

        @Override
        public Identifier determineImplicitName(final MetadataBuildingContext buildingContext) {
            return buildingContext.getBuildingOptions().getImplicitNamingStrategy().determinePrimaryTableName(new ImplicitEntityNameSource(){
                private final EntityNaming entityNaming = new EntityNaming(){

                    @Override
                    public String getClassName() {
                        return className;
                    }

                    @Override
                    public String getEntityName() {
                        return entityName;
                    }

                    @Override
                    public String getJpaEntityName() {
                        return jpaEntityName;
                    }
                };

                @Override
                public EntityNaming getEntityNaming() {
                    return this.entityNaming;
                }

                @Override
                public MetadataBuildingContext getBuildingContext() {
                    return buildingContext;
                }
            });
        }

        @Override
        public Identifier handleExplicitName(String explicitName, MetadataBuildingContext buildingContext) {
            return EntityTableNamingStrategyHelper.jdbcEnvironment(buildingContext).getIdentifierHelper().toIdentifier(explicitName);
        }

        @Override
        public Identifier toPhysicalName(Identifier logicalName, MetadataBuildingContext buildingContext) {
            return buildingContext.getBuildingOptions().getPhysicalNamingStrategy().toPhysicalTableName(logicalName, EntityTableNamingStrategyHelper.jdbcEnvironment(buildingContext));
        }

        private static JdbcEnvironment jdbcEnvironment(MetadataBuildingContext buildingContext) {
            return buildingContext.getMetadataCollector().getDatabase().getJdbcEnvironment();
        }
    }
}

