/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import jakarta.persistence.CacheRetrieveMode;
import jakarta.persistence.CacheStoreMode;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.NamedStoredProcedureQuery;
import jakarta.persistence.ParameterMode;
import jakarta.persistence.QueryHint;
import jakarta.persistence.SqlResultSetMapping;
import jakarta.persistence.StoredProcedureParameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.function.Supplier;
import org.hibernate.AnnotationException;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.annotations.FlushModeType;
import org.hibernate.annotations.HQLSelect;
import org.hibernate.annotations.NamedNativeQuery;
import org.hibernate.annotations.SQLSelect;
import org.hibernate.boot.internal.NamedHqlQueryDefinitionImpl;
import org.hibernate.boot.internal.NamedProcedureCallDefinitionImpl;
import org.hibernate.boot.model.internal.QueryHintDefinition;
import org.hibernate.boot.model.internal.ResultSetMappingSecondPass;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.annotations.internal.NamedStoredProcedureQueryJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.QueryHintJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.StoredProcedureParameterJpaAnnotation;
import org.hibernate.boot.query.NamedHqlQueryDefinition;
import org.hibernate.boot.query.NamedNativeQueryDefinition;
import org.hibernate.boot.query.NamedProcedureCallDefinition;
import org.hibernate.boot.query.SqlResultSetMappingDescriptor;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.log.DeprecationLogger;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.models.internal.util.StringHelper;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.hibernate.query.sql.internal.ParameterParser;
import org.hibernate.query.sql.spi.ParameterRecognizer;
import org.hibernate.type.BasicType;
import org.jboss.logging.Logger;

public abstract class QueryBinder {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)QueryBinder.class.getName());

    public static void bindQuery(NamedQuery namedQuery, MetadataBuildingContext context, boolean isDefault) {
        if (namedQuery == null) {
            return;
        }
        String queryName = namedQuery.name();
        String queryString = namedQuery.query();
        if (queryName.isEmpty()) {
            throw new AnnotationException("Class or package level '@NamedQuery' annotation must specify a 'name'");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Binding named query: %s => %s", queryName, queryString);
        }
        QueryHintDefinition hints = new QueryHintDefinition(queryName, namedQuery.hints());
        NamedHqlQueryDefinitionImpl queryMapping = ((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)new NamedHqlQueryDefinition.Builder(queryName).setHqlString(queryString).setResultClass(namedQuery.resultClass())).setCacheable(hints.getCacheability())).setCacheMode(hints.getCacheMode())).setCacheRegion(hints.getString("org.hibernate.cacheRegion"))).setTimeout(hints.getTimeout())).setFetchSize(hints.getInteger("org.hibernate.fetchSize"))).setFlushMode(hints.getFlushMode())).setReadOnly(hints.getBooleanWrapper("org.hibernate.readOnly"))).setLockOptions(hints.determineLockOptions(namedQuery))).setComment(hints.getString("org.hibernate.comment"))).build();
        if (isDefault) {
            context.getMetadataCollector().addDefaultQuery(queryMapping);
        } else {
            context.getMetadataCollector().addNamedQuery(queryMapping);
        }
    }

    private static Class<Object> loadClass(ClassDetails classDetails, MetadataBuildingContext context) {
        return ClassDetails.VOID_CLASS_DETAILS == classDetails ? null : context.getBootstrapContext().getServiceRegistry().requireService(ClassLoaderService.class).classForName(classDetails.getName());
    }

    public static void bindNativeQuery(jakarta.persistence.NamedNativeQuery namedNativeQuery, MetadataBuildingContext context, boolean isDefault) {
        if (namedNativeQuery == null) {
            return;
        }
        String registrationName = namedNativeQuery.name();
        String queryString = namedNativeQuery.query();
        if (registrationName.isEmpty()) {
            throw new AnnotationException("Class or package level '@NamedNativeQuery' annotation must specify a 'name'");
        }
        QueryHintDefinition hints = new QueryHintDefinition(registrationName, namedNativeQuery.hints());
        String resultSetMappingName = namedNativeQuery.resultSetMapping();
        Class resultClassDetails = namedNativeQuery.resultClass();
        Class resultClass = Void.TYPE == resultClassDetails ? null : resultClassDetails;
        NamedNativeQueryDefinition.Builder builder = (NamedNativeQueryDefinition.Builder)((NamedNativeQueryDefinition.Builder)((NamedNativeQueryDefinition.Builder)((NamedNativeQueryDefinition.Builder)((NamedNativeQueryDefinition.Builder)((NamedNativeQueryDefinition.Builder)((NamedNativeQueryDefinition.Builder)((NamedNativeQueryDefinition.Builder)((NamedNativeQueryDefinition.Builder)((NamedNativeQueryDefinition.Builder)new NamedNativeQueryDefinition.Builder(registrationName).setSqlString(queryString).setResultClass(resultClass)).setResultSetMappingName(resultSetMappingName).setQuerySpaces(null).setCacheable(hints.getCacheability())).setCacheMode(hints.getCacheMode())).setCacheRegion(hints.getString("org.hibernate.cacheRegion"))).setTimeout(hints.getTimeout())).setFetchSize(hints.getInteger("org.hibernate.fetchSize"))).setFlushMode(hints.getFlushMode())).setReadOnly(hints.getBooleanWrapper("org.hibernate.readOnly"))).setComment(hints.getString("org.hibernate.comment"))).addHints(hints.getHintsMap());
        NamedNativeQueryDefinition queryDefinition = builder.build();
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Binding named native query: %s => %s", queryDefinition.getRegistrationName(), queryDefinition.getSqlQueryString());
        }
        if (isDefault) {
            context.getMetadataCollector().addDefaultNamedNativeQuery(queryDefinition);
        } else {
            context.getMetadataCollector().addNamedNativeQuery(queryDefinition);
        }
    }

    public static void bindNativeQuery(String name, SQLSelect sqlSelect, ClassDetails annotatedClass, MetadataBuildingContext context) {
        SqlResultSetMapping resultSetMapping;
        NamedNativeQueryDefinition.Builder builder = ((NamedNativeQueryDefinition.Builder)new NamedNativeQueryDefinition.Builder(name).setFlushMode(FlushMode.MANUAL)).setSqlString(sqlSelect.sql()).setQuerySpaces(CollectionHelper.setOf(sqlSelect.querySpaces()));
        if (annotatedClass != null) {
            builder.setResultClass(context.getBootstrapContext().getServiceRegistry().requireService(ClassLoaderService.class).classForName(annotatedClass.getClassName()));
        }
        if (!(ArrayHelper.isEmpty((resultSetMapping = sqlSelect.resultSetMapping()).columns()) && ArrayHelper.isEmpty(resultSetMapping.entities()) && ArrayHelper.isEmpty(resultSetMapping.classes()))) {
            context.getMetadataCollector().addResultSetMapping(SqlResultSetMappingDescriptor.from(resultSetMapping, name));
            builder.setResultSetMappingName(name);
        }
        context.getMetadataCollector().addNamedNativeQuery(builder.build());
    }

    public static void bindNativeQuery(NamedNativeQuery namedNativeQuery, MetadataBuildingContext context) {
        if (namedNativeQuery == null) {
            return;
        }
        String registrationName = namedNativeQuery.name();
        if (registrationName.isEmpty()) {
            throw new AnnotationException("Class or package level '@NamedNativeQuery' annotation must specify a 'name'");
        }
        String resultSetMappingName = namedNativeQuery.resultSetMapping();
        Class<?> resultClassDetails = namedNativeQuery.resultClass();
        Class<?> resultClass = resultClassDetails == Void.TYPE ? null : resultClassDetails;
        Integer timeout = namedNativeQuery.timeout();
        Integer fetchSize = namedNativeQuery.fetchSize();
        String[] querySpacesList = namedNativeQuery.querySpaces();
        HashSet<String> querySpaces = new HashSet<String>(CollectionHelper.determineProperSizing(querySpacesList.length));
        Collections.addAll(querySpaces, querySpacesList);
        NamedNativeQueryDefinition.Builder builder = (NamedNativeQueryDefinition.Builder)((NamedNativeQueryDefinition.Builder)((NamedNativeQueryDefinition.Builder)((NamedNativeQueryDefinition.Builder)((NamedNativeQueryDefinition.Builder)((NamedNativeQueryDefinition.Builder)((NamedNativeQueryDefinition.Builder)((NamedNativeQueryDefinition.Builder)((NamedNativeQueryDefinition.Builder)new NamedNativeQueryDefinition.Builder(registrationName).setSqlString(namedNativeQuery.query()).setResultSetMappingName(resultSetMappingName).setResultClass(resultClass)).setCacheable(namedNativeQuery.cacheable())).setCacheRegion(org.hibernate.internal.util.StringHelper.nullIfEmpty(namedNativeQuery.cacheRegion()))).setCacheMode(QueryBinder.getCacheMode(namedNativeQuery.cacheRetrieveMode(), namedNativeQuery.cacheStoreMode()))).setTimeout(timeout < 0 ? null : timeout)).setFetchSize(fetchSize < 0 ? null : fetchSize)).setFlushMode(QueryBinder.getFlushMode(namedNativeQuery.flushMode()))).setReadOnly(namedNativeQuery.readOnly())).setQuerySpaces(querySpaces).setComment(org.hibernate.internal.util.StringHelper.nullIfEmpty(namedNativeQuery.comment()));
        if (Boolean.TRUE.booleanValue() == namedNativeQuery.callable()) {
            NamedProcedureCallDefinition definition = QueryBinder.createStoredProcedure(builder, context, () -> QueryBinder.illegalCallSyntax(namedNativeQuery));
            context.getMetadataCollector().addNamedProcedureCallDefinition(definition);
            DeprecationLogger.DEPRECATION_LOGGER.warn("Marking named native queries as callable is no longer supported; use '@jakarta.persistence.NamedStoredProcedureQuery' instead. Ignoring.");
        } else {
            NamedNativeQueryDefinition queryDefinition = builder.build();
            if (LOG.isDebugEnabled()) {
                LOG.debugf("Binding named native query: %s => %s", queryDefinition.getRegistrationName(), queryDefinition.getSqlQueryString());
            }
            context.getMetadataCollector().addNamedNativeQuery(queryDefinition);
        }
    }

    @Deprecated
    public static NamedProcedureCallDefinition createStoredProcedure(NamedNativeQueryDefinition.Builder<?> builder, MetadataBuildingContext context, Supplier<RuntimeException> exceptionProducer) {
        QueryHintJpaAnnotation hint;
        Class resultClass;
        String sqlString = builder.getSqlString().trim();
        if (!sqlString.startsWith("{") || !sqlString.endsWith("}")) {
            throw exceptionProducer.get();
        }
        JdbcCall jdbcCall = QueryBinder.parseJdbcCall(sqlString, exceptionProducer);
        SourceModelBuildingContext sourceModelBuildingContext = context.getMetadataCollector().getSourceModelBuildingContext();
        NamedStoredProcedureQueryJpaAnnotation nameStoredProcedureQueryAnn = (NamedStoredProcedureQueryJpaAnnotation)((Object)JpaAnnotations.NAMED_STORED_PROCEDURE_QUERY.createUsage(sourceModelBuildingContext));
        nameStoredProcedureQueryAnn.name(builder.getName());
        nameStoredProcedureQueryAnn.procedureName(jdbcCall.callableName);
        StoredProcedureParameter[] parameters = new StoredProcedureParameter[jdbcCall.parameters.size()];
        nameStoredProcedureQueryAnn.parameters(parameters);
        for (int i = 0; i < jdbcCall.parameters.size(); ++i) {
            ClassDetails classDetails;
            StoredProcedureParameterJpaAnnotation param = (StoredProcedureParameterJpaAnnotation)((Object)JpaAnnotations.STORED_PROCEDURE_PARAMETER.createUsage(sourceModelBuildingContext));
            parameters[i] = param;
            String paramName = jdbcCall.parameters.get(i);
            param.name(paramName);
            param.mode(ParameterMode.IN);
            String typeName = builder.getParameterTypes().get(paramName);
            if (StringHelper.isEmpty((String)typeName)) {
                classDetails = ClassDetails.VOID_CLASS_DETAILS;
            } else {
                BasicType registeredType = context.getBootstrapContext().getTypeConfiguration().getBasicTypeRegistry().getRegisteredType(typeName);
                classDetails = context.getMetadataCollector().getClassDetailsRegistry().getClassDetails(registeredType.getJavaType().getName());
            }
            param.type(classDetails.toJavaClass());
        }
        if (builder.getResultSetMappingName() != null) {
            nameStoredProcedureQueryAnn.resultSetMappings(new String[]{builder.getResultSetMappingName()});
        }
        if ((resultClass = builder.getResultClass()) != null) {
            nameStoredProcedureQueryAnn.resultClasses(new Class[]{builder.getResultClass()});
        }
        ArrayList<QueryHintJpaAnnotation> hints = new ArrayList<QueryHintJpaAnnotation>();
        if (builder.getQuerySpaces() != null) {
            hint = (QueryHintJpaAnnotation)((Object)JpaAnnotations.QUERY_HINT.createUsage(sourceModelBuildingContext));
            hint.name("org.hibernate.query.native.spaces");
            hint.value(String.join((CharSequence)" ", builder.getQuerySpaces()));
            hints.add(hint);
        }
        if (jdbcCall.resultParameter) {
            hint = (QueryHintJpaAnnotation)((Object)JpaAnnotations.QUERY_HINT.createUsage(sourceModelBuildingContext));
            hint.name("org.hibernate.callableFunction");
            hint.value("true");
            hints.add(hint);
        }
        nameStoredProcedureQueryAnn.hints((QueryHint[])hints.toArray(QueryHint[]::new));
        return new NamedProcedureCallDefinitionImpl(nameStoredProcedureQueryAnn);
    }

    public static void bindQuery(String name, HQLSelect hqlSelect, MetadataBuildingContext context) {
        NamedHqlQueryDefinitionImpl hqlQueryDefinition = ((NamedHqlQueryDefinition.Builder)new NamedHqlQueryDefinition.Builder(name).setFlushMode(FlushMode.MANUAL)).setHqlString(hqlSelect.query()).build();
        context.getMetadataCollector().addNamedQuery(hqlQueryDefinition);
    }

    public static void bindQuery(org.hibernate.annotations.NamedQuery namedQuery, MetadataBuildingContext context) {
        if (namedQuery == null) {
            return;
        }
        String registrationName = namedQuery.name();
        if (registrationName.isEmpty()) {
            throw new AnnotationException("Class or package level '@NamedQuery' annotation must specify a 'name'");
        }
        int timeout = namedQuery.timeout();
        int fetchSize = namedQuery.fetchSize();
        NamedHqlQueryDefinition.Builder builder = (NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)new NamedHqlQueryDefinition.Builder(registrationName).setHqlString(namedQuery.query()).setResultClass(namedQuery.resultClass())).setCacheable(namedQuery.cacheable())).setCacheRegion(org.hibernate.internal.util.StringHelper.nullIfEmpty(namedQuery.cacheRegion()))).setCacheMode(QueryBinder.getCacheMode(namedQuery.cacheRetrieveMode(), namedQuery.cacheStoreMode()))).setTimeout(timeout < 0 ? null : Integer.valueOf(timeout))).setFetchSize(fetchSize < 0 ? null : Integer.valueOf(fetchSize))).setFlushMode(QueryBinder.getFlushMode(namedQuery.flushMode()))).setReadOnly(namedQuery.readOnly())).setComment(org.hibernate.internal.util.StringHelper.nullIfEmpty(namedQuery.comment()));
        NamedHqlQueryDefinitionImpl hqlQueryDefinition = builder.build();
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Binding named query: %s => %s", hqlQueryDefinition.getRegistrationName(), hqlQueryDefinition.getHqlString());
        }
        context.getMetadataCollector().addNamedQuery(hqlQueryDefinition);
    }

    private static CacheMode getCacheMode(CacheRetrieveMode cacheRetrieveMode, CacheStoreMode cacheStoreMode) {
        CacheMode cacheMode = CacheMode.fromJpaModes(cacheRetrieveMode, cacheStoreMode);
        return cacheMode == null ? CacheMode.NORMAL : cacheMode;
    }

    private static FlushMode getFlushMode(FlushModeType flushModeType) {
        return switch (flushModeType) {
            default -> throw new IncompatibleClassChangeError();
            case FlushModeType.ALWAYS -> FlushMode.ALWAYS;
            case FlushModeType.AUTO -> FlushMode.AUTO;
            case FlushModeType.COMMIT -> FlushMode.COMMIT;
            case FlushModeType.MANUAL -> FlushMode.MANUAL;
            case FlushModeType.PERSISTENCE_CONTEXT -> null;
        };
    }

    public static void bindNamedStoredProcedureQuery(NamedStoredProcedureQuery namedStoredProcedureQuery, MetadataBuildingContext context, boolean isDefault) {
        if (namedStoredProcedureQuery != null) {
            if (namedStoredProcedureQuery.name().isEmpty()) {
                throw new AnnotationException("Class or package level '@NamedStoredProcedureQuery' annotation must specify a 'name'");
            }
            NamedProcedureCallDefinitionImpl definition = new NamedProcedureCallDefinitionImpl(namedStoredProcedureQuery);
            if (isDefault) {
                context.getMetadataCollector().addDefaultNamedProcedureCall(definition);
            } else {
                context.getMetadataCollector().addNamedProcedureCallDefinition(definition);
            }
            LOG.debugf("Bound named stored procedure query : %s => %s", definition.getRegistrationName(), definition.getProcedureName());
        }
    }

    public static void bindSqlResultSetMapping(SqlResultSetMapping resultSetMappingAnn, MetadataBuildingContext context, boolean isDefault) {
        context.getMetadataCollector().addSecondPass(new ResultSetMappingSecondPass(resultSetMappingAnn, context, isDefault));
    }

    private static JdbcCall parseJdbcCall(String sqlString, Supplier<RuntimeException> exceptionProducer) {
        String callableName = null;
        boolean resultParameter = false;
        int index = QueryBinder.skipWhitespace(sqlString, 1);
        if (sqlString.charAt(index) == '?') {
            resultParameter = true;
            ++index;
            if (sqlString.charAt(index = QueryBinder.skipWhitespace(sqlString, index)) != '=') {
                throw exceptionProducer.get();
            }
            ++index;
            index = QueryBinder.skipWhitespace(sqlString, index);
        }
        if (!sqlString.regionMatches(true, index, "call", 0, 4)) {
            throw exceptionProducer.get();
        }
        index += 4;
        int procedureStart = index = QueryBinder.skipWhitespace(sqlString, index);
        while (index < sqlString.length()) {
            char c = sqlString.charAt(index);
            if (c == '(' || Character.isWhitespace(c)) {
                callableName = sqlString.substring(procedureStart, index);
                break;
            }
            ++index;
        }
        index = QueryBinder.skipWhitespace(sqlString, index);
        final ArrayList<String> parameters = new ArrayList<String>();
        ParameterParser.parse(sqlString.substring(index, sqlString.length() - 1), new ParameterRecognizer(){

            @Override
            public void ordinalParameter(int sourcePosition) {
                parameters.add("");
            }

            @Override
            public void namedParameter(String name, int sourcePosition) {
                parameters.add(name);
            }

            @Override
            public void jpaPositionalParameter(int label, int sourcePosition) {
                parameters.add("");
            }

            @Override
            public void other(char character) {
            }
        });
        return new JdbcCall(callableName, resultParameter, parameters);
    }

    private static int skipWhitespace(String sqlString, int i) {
        while (i < sqlString.length() && Character.isWhitespace(sqlString.charAt(i))) {
            ++i;
        }
        return i;
    }

    private static AnnotationException illegalCallSyntax(NamedNativeQuery queryAnn) {
        return new AnnotationException("Callable 'NamedNativeQuery' named '" + queryAnn.name() + "' does not use the JDBC call syntax");
    }

    private static class JdbcCall {
        private final String callableName;
        private final boolean resultParameter;
        private final ArrayList<String> parameters;

        public JdbcCall(String callableName, boolean resultParameter, ArrayList<String> parameters) {
            this.callableName = callableName;
            this.resultParameter = resultParameter;
            this.parameters = parameters;
        }
    }
}

