/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.annotations.internal;

import jakarta.persistence.FetchType;
import java.lang.annotation.Annotation;
import org.hibernate.annotations.Any;
import org.hibernate.boot.models.HibernateAnnotations;
import org.hibernate.boot.models.annotations.spi.AttributeMarker;
import org.hibernate.boot.models.internal.OrmAnnotationHelper;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.jboss.jandex.AnnotationInstance;

public class AnyAnnotation
implements Any,
AttributeMarker,
AttributeMarker.Fetchable,
AttributeMarker.Optionalable {
    private FetchType fetch;
    private boolean optional;

    public AnyAnnotation(SourceModelBuildingContext modelContext) {
        this.fetch = FetchType.EAGER;
        this.optional = true;
    }

    public AnyAnnotation(Any annotation, SourceModelBuildingContext modelContext) {
        this.fetch = annotation.fetch();
        this.optional = annotation.optional();
    }

    public AnyAnnotation(AnnotationInstance annotation, SourceModelBuildingContext modelContext) {
        this.fetch = (FetchType)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.ANY, "fetch", modelContext);
        this.optional = (Boolean)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.ANY, "optional", modelContext);
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return Any.class;
    }

    @Override
    public FetchType fetch() {
        return this.fetch;
    }

    @Override
    public void fetch(FetchType value) {
        this.fetch = value;
    }

    @Override
    public boolean optional() {
        return this.optional;
    }

    @Override
    public void optional(boolean value) {
        this.optional = value;
    }
}

