/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.annotations.internal;

import jakarta.persistence.AssociationOverride;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import java.lang.annotation.Annotation;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.internal.OrmAnnotationHelper;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.jboss.jandex.AnnotationInstance;

public class AssociationOverrideJpaAnnotation
implements AssociationOverride {
    private String name;
    private JoinColumn[] joinColumns;
    private ForeignKey foreignKey;
    private JoinTable joinTable;

    public AssociationOverrideJpaAnnotation(SourceModelBuildingContext modelContext) {
        this.joinColumns = new JoinColumn[0];
        this.foreignKey = (ForeignKey)JpaAnnotations.FOREIGN_KEY.createUsage(modelContext);
        this.joinTable = (JoinTable)JpaAnnotations.JOIN_TABLE.createUsage(modelContext);
    }

    public AssociationOverrideJpaAnnotation(AssociationOverride annotation, SourceModelBuildingContext modelContext) {
        this.name = annotation.name();
        this.joinColumns = (JoinColumn[])OrmAnnotationHelper.extractJdkValue(annotation, JpaAnnotations.ASSOCIATION_OVERRIDE, "joinColumns", modelContext);
        this.foreignKey = (ForeignKey)OrmAnnotationHelper.extractJdkValue(annotation, JpaAnnotations.ASSOCIATION_OVERRIDE, "foreignKey", modelContext);
        this.joinTable = (JoinTable)OrmAnnotationHelper.extractJdkValue(annotation, JpaAnnotations.ASSOCIATION_OVERRIDE, "joinTable", modelContext);
    }

    public AssociationOverrideJpaAnnotation(AnnotationInstance annotation, SourceModelBuildingContext modelContext) {
        this.name = (String)OrmAnnotationHelper.extractJandexValue(annotation, JpaAnnotations.ASSOCIATION_OVERRIDE, "name", modelContext);
        this.joinColumns = (JoinColumn[])OrmAnnotationHelper.extractJandexValue(annotation, JpaAnnotations.ASSOCIATION_OVERRIDE, "joinColumns", modelContext);
        this.foreignKey = (ForeignKey)OrmAnnotationHelper.extractJandexValue(annotation, JpaAnnotations.ASSOCIATION_OVERRIDE, "foreignKey", modelContext);
        this.joinTable = (JoinTable)OrmAnnotationHelper.extractJandexValue(annotation, JpaAnnotations.ASSOCIATION_OVERRIDE, "joinTable", modelContext);
    }

    public Class<? extends Annotation> annotationType() {
        return AssociationOverride.class;
    }

    public String name() {
        return this.name;
    }

    public void name(String value) {
        this.name = value;
    }

    public JoinColumn[] joinColumns() {
        return this.joinColumns;
    }

    public void joinColumns(JoinColumn[] value) {
        this.joinColumns = value;
    }

    public ForeignKey foreignKey() {
        return this.foreignKey;
    }

    public void foreignKey(ForeignKey value) {
        this.foreignKey = value;
    }

    public JoinTable joinTable() {
        return this.joinTable;
    }

    public void joinTable(JoinTable value) {
        this.joinTable = value;
    }
}

