/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.annotations.internal;

import jakarta.persistence.CheckConstraint;
import java.lang.annotation.Annotation;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.internal.OrmAnnotationHelper;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.jboss.jandex.AnnotationInstance;

public class CheckConstraintJpaAnnotation
implements CheckConstraint {
    private String name;
    private String constraint;
    private String options;

    public CheckConstraintJpaAnnotation(SourceModelBuildingContext modelContext) {
        this.name = "";
        this.options = "";
    }

    public CheckConstraintJpaAnnotation(CheckConstraint annotation, SourceModelBuildingContext modelContext) {
        this.name = annotation.name();
        this.constraint = annotation.constraint();
        this.options = annotation.options();
    }

    public CheckConstraintJpaAnnotation(AnnotationInstance annotation, SourceModelBuildingContext modelContext) {
        this.name = (String)OrmAnnotationHelper.extractJandexValue(annotation, JpaAnnotations.CHECK_CONSTRAINT, "name", modelContext);
        this.constraint = (String)OrmAnnotationHelper.extractJandexValue(annotation, JpaAnnotations.CHECK_CONSTRAINT, "constraint", modelContext);
        this.options = (String)OrmAnnotationHelper.extractJandexValue(annotation, JpaAnnotations.CHECK_CONSTRAINT, "options", modelContext);
    }

    public Class<? extends Annotation> annotationType() {
        return CheckConstraint.class;
    }

    public String name() {
        return this.name;
    }

    public void name(String value) {
        this.name = value;
    }

    public String constraint() {
        return this.constraint;
    }

    public void constraint(String value) {
        this.constraint = value;
    }

    public String options() {
        return this.options;
    }

    public void options(String value) {
        this.options = value;
    }
}

