/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.annotations.internal;

import jakarta.persistence.DiscriminatorColumn;
import jakarta.persistence.DiscriminatorType;
import java.lang.annotation.Annotation;
import org.hibernate.boot.jaxb.mapping.spi.JaxbDiscriminatorColumnImpl;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.annotations.spi.ColumnDetails;
import org.hibernate.boot.models.internal.OrmAnnotationHelper;
import org.hibernate.boot.models.xml.spi.XmlDocumentContext;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.jboss.jandex.AnnotationInstance;

public class DiscriminatorColumnJpaAnnotation
implements DiscriminatorColumn,
ColumnDetails {
    private String name;
    private DiscriminatorType discriminatorType;
    private String columnDefinition;
    private String options;
    private int length;

    public DiscriminatorColumnJpaAnnotation(SourceModelBuildingContext modelContext) {
        this.name = "DTYPE";
        this.discriminatorType = DiscriminatorType.STRING;
        this.columnDefinition = "";
        this.options = "";
        this.length = 31;
    }

    public DiscriminatorColumnJpaAnnotation(DiscriminatorColumn annotation, SourceModelBuildingContext modelContext) {
        this.name = annotation.name();
        this.discriminatorType = annotation.discriminatorType();
        this.columnDefinition = annotation.columnDefinition();
        this.options = annotation.options();
        this.length = annotation.length();
    }

    public DiscriminatorColumnJpaAnnotation(AnnotationInstance annotation, SourceModelBuildingContext modelContext) {
        this.name = (String)OrmAnnotationHelper.extractJandexValue(annotation, JpaAnnotations.DISCRIMINATOR_COLUMN, "name", modelContext);
        this.discriminatorType = (DiscriminatorType)OrmAnnotationHelper.extractJandexValue(annotation, JpaAnnotations.DISCRIMINATOR_COLUMN, "discriminatorType", modelContext);
        this.columnDefinition = (String)OrmAnnotationHelper.extractJandexValue(annotation, JpaAnnotations.DISCRIMINATOR_COLUMN, "columnDefinition", modelContext);
        this.options = (String)OrmAnnotationHelper.extractJandexValue(annotation, JpaAnnotations.DISCRIMINATOR_COLUMN, "options", modelContext);
        this.length = (Integer)OrmAnnotationHelper.extractJandexValue(annotation, JpaAnnotations.DISCRIMINATOR_COLUMN, "length", modelContext);
    }

    public Class<? extends Annotation> annotationType() {
        return DiscriminatorColumn.class;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public void name(String value) {
        this.name = value;
    }

    public DiscriminatorType discriminatorType() {
        return this.discriminatorType;
    }

    public void discriminatorType(DiscriminatorType value) {
        this.discriminatorType = value;
    }

    public String columnDefinition() {
        return this.columnDefinition;
    }

    public void columnDefinition(String value) {
        this.columnDefinition = value;
    }

    public String options() {
        return this.options;
    }

    public void options(String value) {
        this.options = value;
    }

    public int length() {
        return this.length;
    }

    public void length(int value) {
        this.length = value;
    }

    public void apply(JaxbDiscriminatorColumnImpl jaxbColumn, XmlDocumentContext xmlDocumentContext) {
        if (StringHelper.isNotEmpty(jaxbColumn.getName())) {
            this.name(jaxbColumn.getName());
        }
        if (jaxbColumn.getDiscriminatorType() != null) {
            this.discriminatorType(jaxbColumn.getDiscriminatorType());
        }
        if (jaxbColumn.getLength() != null) {
            this.length(jaxbColumn.getLength());
        }
        if (StringHelper.isNotEmpty(jaxbColumn.getColumnDefinition())) {
            this.columnDefinition(jaxbColumn.getColumnDefinition());
        }
        if (StringHelper.isNotEmpty(jaxbColumn.getOptions())) {
            this.options(jaxbColumn.getOptions());
        }
    }
}

