/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.annotations.internal;

import java.lang.annotation.Annotation;
import org.hibernate.annotations.EmbeddableInstantiatorRegistration;
import org.hibernate.boot.models.HibernateAnnotations;
import org.hibernate.boot.models.internal.OrmAnnotationHelper;
import org.hibernate.metamodel.spi.EmbeddableInstantiator;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.jboss.jandex.AnnotationInstance;

public class EmbeddableInstantiatorRegistrationAnnotation
implements EmbeddableInstantiatorRegistration {
    private Class<?> embeddableClass;
    private Class<? extends EmbeddableInstantiator> instantiator;

    public EmbeddableInstantiatorRegistrationAnnotation(SourceModelBuildingContext modelContext) {
    }

    public EmbeddableInstantiatorRegistrationAnnotation(EmbeddableInstantiatorRegistration annotation, SourceModelBuildingContext modelContext) {
        this.embeddableClass = annotation.embeddableClass();
        this.instantiator = annotation.instantiator();
    }

    public EmbeddableInstantiatorRegistrationAnnotation(AnnotationInstance annotation, SourceModelBuildingContext modelContext) {
        this.embeddableClass = (Class)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.EMBEDDABLE_INSTANTIATOR_REGISTRATION, "embeddableClass", modelContext);
        this.instantiator = (Class)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.EMBEDDABLE_INSTANTIATOR_REGISTRATION, "instantiator", modelContext);
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return EmbeddableInstantiatorRegistration.class;
    }

    @Override
    public Class<?> embeddableClass() {
        return this.embeddableClass;
    }

    public void embeddableClass(Class<?> value) {
        this.embeddableClass = value;
    }

    @Override
    public Class<? extends EmbeddableInstantiator> instantiator() {
        return this.instantiator;
    }

    public void instantiator(Class<? extends EmbeddableInstantiator> value) {
        this.instantiator = value;
    }
}

