/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.annotations.internal;

import jakarta.persistence.EntityResult;
import jakarta.persistence.FieldResult;
import jakarta.persistence.LockModeType;
import java.lang.annotation.Annotation;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.internal.OrmAnnotationHelper;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.jboss.jandex.AnnotationInstance;

public class EntityResultJpaAnnotation
implements EntityResult {
    private Class<?> entityClass;
    private LockModeType lockMode;
    private FieldResult[] fields;
    private String discriminatorColumn;

    public EntityResultJpaAnnotation(SourceModelBuildingContext modelContext) {
        this.lockMode = LockModeType.OPTIMISTIC;
        this.fields = new FieldResult[0];
        this.discriminatorColumn = "";
    }

    public EntityResultJpaAnnotation(EntityResult annotation, SourceModelBuildingContext modelContext) {
        this.entityClass = annotation.entityClass();
        this.lockMode = annotation.lockMode();
        this.fields = annotation.fields();
        this.discriminatorColumn = annotation.discriminatorColumn();
    }

    public EntityResultJpaAnnotation(AnnotationInstance annotation, SourceModelBuildingContext modelContext) {
        this.entityClass = (Class)OrmAnnotationHelper.extractJandexValue(annotation, JpaAnnotations.ENTITY_RESULT, "entityClass", modelContext);
        this.lockMode = (LockModeType)OrmAnnotationHelper.extractJandexValue(annotation, JpaAnnotations.ENTITY_RESULT, "lockMode", modelContext);
        this.fields = (FieldResult[])OrmAnnotationHelper.extractJandexValue(annotation, JpaAnnotations.ENTITY_RESULT, "fields", modelContext);
        this.discriminatorColumn = (String)OrmAnnotationHelper.extractJandexValue(annotation, JpaAnnotations.ENTITY_RESULT, "discriminatorColumn", modelContext);
    }

    public Class<? extends Annotation> annotationType() {
        return EntityResult.class;
    }

    public Class<?> entityClass() {
        return this.entityClass;
    }

    public void entityClass(Class<?> value) {
        this.entityClass = value;
    }

    public LockModeType lockMode() {
        return this.lockMode;
    }

    public void lockMode(LockModeType value) {
        this.lockMode = value;
    }

    public FieldResult[] fields() {
        return this.fields;
    }

    public void fields(FieldResult[] value) {
        this.fields = value;
    }

    public String discriminatorColumn() {
        return this.discriminatorColumn;
    }

    public void discriminatorColumn(String value) {
        this.discriminatorColumn = value;
    }
}

