/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.annotations.internal;

import jakarta.persistence.FetchType;
import java.lang.annotation.Annotation;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.FetchProfileOverride;
import org.hibernate.boot.models.DialectOverrideAnnotations;
import org.hibernate.boot.models.internal.OrmAnnotationHelper;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.jboss.jandex.AnnotationInstance;

public class FetchProfileOverrideAnnotation
implements FetchProfileOverride {
    private FetchMode mode;
    private FetchType fetch;
    private String profile;

    public FetchProfileOverrideAnnotation(SourceModelBuildingContext modelContext) {
        this.mode = FetchMode.JOIN;
        this.fetch = FetchType.EAGER;
    }

    public FetchProfileOverrideAnnotation(FetchProfileOverride annotation, SourceModelBuildingContext modelContext) {
        this.mode = annotation.mode();
        this.fetch = annotation.fetch();
        this.profile = annotation.profile();
    }

    public FetchProfileOverrideAnnotation(AnnotationInstance annotation, SourceModelBuildingContext modelContext) {
        this.mode = (FetchMode)((Object)OrmAnnotationHelper.extractJandexValue(annotation, DialectOverrideAnnotations.FETCH_PROFILE_OVERRIDE, "mode", modelContext));
        this.fetch = (FetchType)OrmAnnotationHelper.extractJandexValue(annotation, DialectOverrideAnnotations.FETCH_PROFILE_OVERRIDE, "fetch", modelContext);
        this.profile = (String)OrmAnnotationHelper.extractJandexValue(annotation, DialectOverrideAnnotations.FETCH_PROFILE_OVERRIDE, "profile", modelContext);
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return FetchProfileOverride.class;
    }

    @Override
    public FetchMode mode() {
        return this.mode;
    }

    public void mode(FetchMode value) {
        this.mode = value;
    }

    @Override
    public FetchType fetch() {
        return this.fetch;
    }

    public void fetch(FetchType value) {
        this.fetch = value;
    }

    @Override
    public String profile() {
        return this.profile;
    }

    public void profile(String value) {
        this.profile = value;
    }
}

