/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.annotations.internal;

import java.lang.annotation.Annotation;
import org.hibernate.annotations.Filter;
import org.hibernate.annotations.SqlFragmentAlias;
import org.hibernate.boot.jaxb.mapping.spi.JaxbFilterImpl;
import org.hibernate.boot.models.HibernateAnnotations;
import org.hibernate.boot.models.annotations.spi.FilterDetails;
import org.hibernate.boot.models.internal.OrmAnnotationHelper;
import org.hibernate.boot.models.xml.internal.FilterProcessing;
import org.hibernate.boot.models.xml.spi.XmlDocumentContext;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.jboss.jandex.AnnotationInstance;

public class FilterAnnotation
implements Filter,
FilterDetails {
    private String name;
    private String condition;
    private boolean deduceAliasInjectionPoints;
    private SqlFragmentAlias[] aliases;

    public FilterAnnotation(SourceModelBuildingContext modelContext) {
        this.condition = "";
        this.deduceAliasInjectionPoints = true;
        this.aliases = new SqlFragmentAlias[0];
    }

    public FilterAnnotation(Filter annotation, SourceModelBuildingContext modelContext) {
        this.name = annotation.name();
        this.condition = annotation.condition();
        this.deduceAliasInjectionPoints = annotation.deduceAliasInjectionPoints();
        this.aliases = (SqlFragmentAlias[])OrmAnnotationHelper.extractJdkValue(annotation, HibernateAnnotations.FILTER, "aliases", modelContext);
    }

    public FilterAnnotation(AnnotationInstance annotation, SourceModelBuildingContext modelContext) {
        this.name = (String)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.FILTER, "name", modelContext);
        this.condition = (String)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.FILTER, "condition", modelContext);
        this.deduceAliasInjectionPoints = (Boolean)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.FILTER, "deduceAliasInjectionPoints", modelContext);
        this.aliases = (SqlFragmentAlias[])OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.FILTER, "aliases", modelContext);
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return Filter.class;
    }

    @Override
    public String name() {
        return this.name;
    }

    public void name(String value) {
        this.name = value;
    }

    @Override
    public String condition() {
        return this.condition;
    }

    public void condition(String value) {
        this.condition = value;
    }

    @Override
    public boolean deduceAliasInjectionPoints() {
        return this.deduceAliasInjectionPoints;
    }

    public void deduceAliasInjectionPoints(boolean value) {
        this.deduceAliasInjectionPoints = value;
    }

    @Override
    public SqlFragmentAlias[] aliases() {
        return this.aliases;
    }

    public void aliases(SqlFragmentAlias[] value) {
        this.aliases = value;
    }

    @Override
    public void apply(JaxbFilterImpl jaxbFilter, XmlDocumentContext xmlDocumentContext) {
        this.name(jaxbFilter.getName());
        if (StringHelper.isNotEmpty(jaxbFilter.getCondition())) {
            this.condition(jaxbFilter.getCondition());
        }
        if (jaxbFilter.isAutoAliasInjection() != null) {
            this.deduceAliasInjectionPoints(jaxbFilter.isAutoAliasInjection());
        }
        this.aliases(FilterProcessing.collectSqlFragmentAliases(jaxbFilter.getAliases(), xmlDocumentContext));
    }
}

