/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.annotations.internal;

import jakarta.persistence.ConstraintMode;
import jakarta.persistence.ForeignKey;
import java.lang.annotation.Annotation;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.internal.OrmAnnotationHelper;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.jboss.jandex.AnnotationInstance;

public class ForeignKeyJpaAnnotation
implements ForeignKey {
    private String name;
    private ConstraintMode value;
    private String foreignKeyDefinition;
    private String options;

    public ForeignKeyJpaAnnotation(SourceModelBuildingContext modelContext) {
        this.name = "";
        this.value = ConstraintMode.CONSTRAINT;
        this.foreignKeyDefinition = "";
        this.options = "";
    }

    public ForeignKeyJpaAnnotation(ForeignKey annotation, SourceModelBuildingContext modelContext) {
        this.name = annotation.name();
        this.value = annotation.value();
        this.foreignKeyDefinition = annotation.foreignKeyDefinition();
        this.options = annotation.options();
    }

    public ForeignKeyJpaAnnotation(AnnotationInstance annotation, SourceModelBuildingContext modelContext) {
        this.name = (String)OrmAnnotationHelper.extractJandexValue(annotation, JpaAnnotations.FOREIGN_KEY, "name", modelContext);
        this.value = (ConstraintMode)OrmAnnotationHelper.extractJandexValue(annotation, JpaAnnotations.FOREIGN_KEY, "value", modelContext);
        this.foreignKeyDefinition = (String)OrmAnnotationHelper.extractJandexValue(annotation, JpaAnnotations.FOREIGN_KEY, "foreignKeyDefinition", modelContext);
        this.options = (String)OrmAnnotationHelper.extractJandexValue(annotation, JpaAnnotations.FOREIGN_KEY, "options", modelContext);
    }

    public Class<? extends Annotation> annotationType() {
        return ForeignKey.class;
    }

    public String name() {
        return this.name;
    }

    public void name(String value) {
        this.name = value;
    }

    public ConstraintMode value() {
        return this.value;
    }

    public void value(ConstraintMode value) {
        this.value = value;
    }

    public String foreignKeyDefinition() {
        return this.foreignKeyDefinition;
    }

    public void foreignKeyDefinition(String value) {
        this.foreignKeyDefinition = value;
    }

    public String options() {
        return this.options;
    }

    public void options(String value) {
        this.options = value;
    }
}

