/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.annotations.internal;

import java.lang.annotation.Annotation;
import org.hibernate.annotations.Generated;
import org.hibernate.boot.models.HibernateAnnotations;
import org.hibernate.boot.models.internal.OrmAnnotationHelper;
import org.hibernate.generator.EventType;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.jboss.jandex.AnnotationInstance;

public class GeneratedAnnotation
implements Generated {
    private EventType[] event;
    private String sql;
    private boolean writable;

    public GeneratedAnnotation(SourceModelBuildingContext modelContext) {
        this.event = new EventType[]{EventType.INSERT};
        this.sql = "";
        this.writable = false;
    }

    public GeneratedAnnotation(Generated annotation, SourceModelBuildingContext modelContext) {
        this.event = annotation.event();
        this.sql = annotation.sql();
        this.writable = annotation.writable();
    }

    public GeneratedAnnotation(AnnotationInstance annotation, SourceModelBuildingContext modelContext) {
        this.event = (EventType[])OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.GENERATED, "event", modelContext);
        this.sql = (String)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.GENERATED, "sql", modelContext);
        this.writable = (Boolean)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.GENERATED, "writable", modelContext);
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return Generated.class;
    }

    @Override
    public EventType[] event() {
        return this.event;
    }

    public void event(EventType[] value) {
        this.event = value;
    }

    @Override
    public String sql() {
        return this.sql;
    }

    public void sql(String value) {
        this.sql = value;
    }

    @Override
    public boolean writable() {
        return this.writable;
    }

    public void writable(boolean value) {
        this.writable = value;
    }
}

