/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.annotations.internal;

import java.lang.annotation.Annotation;
import org.hibernate.annotations.JavaTypeRegistration;
import org.hibernate.boot.models.HibernateAnnotations;
import org.hibernate.boot.models.internal.OrmAnnotationHelper;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.hibernate.type.descriptor.java.BasicJavaType;
import org.jboss.jandex.AnnotationInstance;

public class JavaTypeRegistrationAnnotation
implements JavaTypeRegistration {
    private Class<?> javaType;
    private Class<? extends BasicJavaType<?>> descriptorClass;

    public JavaTypeRegistrationAnnotation(SourceModelBuildingContext modelContext) {
    }

    public JavaTypeRegistrationAnnotation(JavaTypeRegistration annotation, SourceModelBuildingContext modelContext) {
        this.javaType = annotation.javaType();
        this.descriptorClass = annotation.descriptorClass();
    }

    public JavaTypeRegistrationAnnotation(AnnotationInstance annotation, SourceModelBuildingContext modelContext) {
        this.javaType = (Class)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.JAVA_TYPE_REGISTRATION, "javaType", modelContext);
        this.descriptorClass = (Class)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.JAVA_TYPE_REGISTRATION, "descriptorClass", modelContext);
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return JavaTypeRegistration.class;
    }

    @Override
    public Class<?> javaType() {
        return this.javaType;
    }

    public void javaType(Class<?> value) {
        this.javaType = value;
    }

    @Override
    public Class<? extends BasicJavaType<?>> descriptorClass() {
        return this.descriptorClass;
    }

    public void descriptorClass(Class<? extends BasicJavaType<?>> value) {
        this.descriptorClass = value;
    }
}

