/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.annotations.internal;

import jakarta.persistence.FetchType;
import java.lang.annotation.Annotation;
import org.hibernate.annotations.ManyToAny;
import org.hibernate.boot.models.HibernateAnnotations;
import org.hibernate.boot.models.internal.OrmAnnotationHelper;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.jboss.jandex.AnnotationInstance;

public class ManyToAnyAnnotation
implements ManyToAny {
    private FetchType fetch;

    public ManyToAnyAnnotation(SourceModelBuildingContext modelContext) {
        this.fetch = FetchType.EAGER;
    }

    public ManyToAnyAnnotation(ManyToAny annotation, SourceModelBuildingContext modelContext) {
        this.fetch = annotation.fetch();
    }

    public ManyToAnyAnnotation(AnnotationInstance annotation, SourceModelBuildingContext modelContext) {
        this.fetch = (FetchType)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.MANY_TO_ANY, "fetch", modelContext);
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return ManyToAny.class;
    }

    @Override
    public FetchType fetch() {
        return this.fetch;
    }

    public void fetch(FetchType value) {
        this.fetch = value;
    }
}

