/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.annotations.internal;

import jakarta.persistence.NamedAttributeNode;
import jakarta.persistence.NamedEntityGraph;
import jakarta.persistence.NamedSubgraph;
import java.lang.annotation.Annotation;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.internal.OrmAnnotationHelper;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.jboss.jandex.AnnotationInstance;

public class NamedEntityGraphJpaAnnotation
implements NamedEntityGraph {
    private String name;
    private NamedAttributeNode[] attributeNodes;
    private boolean includeAllAttributes;
    private NamedSubgraph[] subgraphs;
    private NamedSubgraph[] subclassSubgraphs;

    public NamedEntityGraphJpaAnnotation(SourceModelBuildingContext modelContext) {
        this.name = "";
        this.attributeNodes = new NamedAttributeNode[0];
        this.includeAllAttributes = false;
        this.subgraphs = new NamedSubgraph[0];
        this.subclassSubgraphs = new NamedSubgraph[0];
    }

    public NamedEntityGraphJpaAnnotation(NamedEntityGraph annotation, SourceModelBuildingContext modelContext) {
        this.name = annotation.name();
        this.attributeNodes = (NamedAttributeNode[])OrmAnnotationHelper.extractJdkValue(annotation, JpaAnnotations.NAMED_ENTITY_GRAPH, "attributeNodes", modelContext);
        this.includeAllAttributes = annotation.includeAllAttributes();
        this.subgraphs = (NamedSubgraph[])OrmAnnotationHelper.extractJdkValue(annotation, JpaAnnotations.NAMED_ENTITY_GRAPH, "subgraphs", modelContext);
        this.subclassSubgraphs = (NamedSubgraph[])OrmAnnotationHelper.extractJdkValue(annotation, JpaAnnotations.NAMED_ENTITY_GRAPH, "subclassSubgraphs", modelContext);
    }

    public NamedEntityGraphJpaAnnotation(AnnotationInstance annotation, SourceModelBuildingContext modelContext) {
        this.name = (String)OrmAnnotationHelper.extractJandexValue(annotation, JpaAnnotations.NAMED_ENTITY_GRAPH, "name", modelContext);
        this.attributeNodes = (NamedAttributeNode[])OrmAnnotationHelper.extractJandexValue(annotation, JpaAnnotations.NAMED_ENTITY_GRAPH, "attributeNodes", modelContext);
        this.includeAllAttributes = (Boolean)OrmAnnotationHelper.extractJandexValue(annotation, JpaAnnotations.NAMED_ENTITY_GRAPH, "includeAllAttributes", modelContext);
        this.subgraphs = (NamedSubgraph[])OrmAnnotationHelper.extractJandexValue(annotation, JpaAnnotations.NAMED_ENTITY_GRAPH, "subgraphs", modelContext);
        this.subclassSubgraphs = (NamedSubgraph[])OrmAnnotationHelper.extractJandexValue(annotation, JpaAnnotations.NAMED_ENTITY_GRAPH, "subclassSubgraphs", modelContext);
    }

    public Class<? extends Annotation> annotationType() {
        return NamedEntityGraph.class;
    }

    public String name() {
        return this.name;
    }

    public void name(String value) {
        this.name = value;
    }

    public NamedAttributeNode[] attributeNodes() {
        return this.attributeNodes;
    }

    public void attributeNodes(NamedAttributeNode[] value) {
        this.attributeNodes = value;
    }

    public boolean includeAllAttributes() {
        return this.includeAllAttributes;
    }

    public void includeAllAttributes(boolean value) {
        this.includeAllAttributes = value;
    }

    public NamedSubgraph[] subgraphs() {
        return this.subgraphs;
    }

    public void subgraphs(NamedSubgraph[] value) {
        this.subgraphs = value;
    }

    public NamedSubgraph[] subclassSubgraphs() {
        return this.subclassSubgraphs;
    }

    public void subclassSubgraphs(NamedSubgraph[] value) {
        this.subclassSubgraphs = value;
    }
}

