/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.annotations.internal;

import java.lang.annotation.Annotation;
import org.hibernate.annotations.ResultCheckStyle;
import org.hibernate.annotations.SQLInsert;
import org.hibernate.boot.models.HibernateAnnotations;
import org.hibernate.boot.models.annotations.spi.CustomSqlDetails;
import org.hibernate.boot.models.internal.OrmAnnotationHelper;
import org.hibernate.jdbc.Expectation;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.jboss.jandex.AnnotationInstance;

public class SQLInsertAnnotation
implements SQLInsert,
CustomSqlDetails {
    private String sql;
    private boolean callable;
    private Class<? extends Expectation> verify;
    private ResultCheckStyle check;
    private String table;

    public SQLInsertAnnotation(SourceModelBuildingContext modelContext) {
        this.callable = false;
        this.verify = Expectation.class;
        this.check = ResultCheckStyle.NONE;
        this.table = "";
    }

    public SQLInsertAnnotation(SQLInsert annotation, SourceModelBuildingContext modelContext) {
        this.sql = annotation.sql();
        this.callable = annotation.callable();
        this.verify = annotation.verify();
        this.check = annotation.check();
        this.table = annotation.table();
    }

    public SQLInsertAnnotation(AnnotationInstance annotation, SourceModelBuildingContext modelContext) {
        this.sql = (String)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.SQL_INSERT, "sql", modelContext);
        this.callable = (Boolean)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.SQL_INSERT, "callable", modelContext);
        this.verify = (Class)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.SQL_INSERT, "verify", modelContext);
        this.check = (ResultCheckStyle)((Object)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.SQL_INSERT, "check", modelContext));
        this.table = (String)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.SQL_INSERT, "table", modelContext);
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return SQLInsert.class;
    }

    @Override
    public String sql() {
        return this.sql;
    }

    @Override
    public void sql(String value) {
        this.sql = value;
    }

    @Override
    public boolean callable() {
        return this.callable;
    }

    @Override
    public void callable(boolean value) {
        this.callable = value;
    }

    @Override
    public Class<? extends Expectation> verify() {
        return this.verify;
    }

    public void verify(Class<? extends Expectation> value) {
        this.verify = value;
    }

    @Override
    public ResultCheckStyle check() {
        return this.check;
    }

    @Override
    public void check(ResultCheckStyle value) {
        this.check = value;
    }

    @Override
    public String table() {
        return this.table;
    }

    @Override
    public void table(String value) {
        this.table = value;
    }
}

