/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.annotations.internal;

import jakarta.persistence.SqlResultSetMapping;
import java.lang.annotation.Annotation;
import org.hibernate.annotations.SQLSelect;
import org.hibernate.boot.models.HibernateAnnotations;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.internal.OrmAnnotationHelper;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.jboss.jandex.AnnotationInstance;

public class SQLSelectAnnotation
implements SQLSelect {
    private String sql;
    private SqlResultSetMapping resultSetMapping;
    private String[] querySpaces;

    public SQLSelectAnnotation(SourceModelBuildingContext modelContext) {
        this.resultSetMapping = (SqlResultSetMapping)JpaAnnotations.SQL_RESULT_SET_MAPPING.createUsage(modelContext);
        this.querySpaces = new String[0];
    }

    public SQLSelectAnnotation(SQLSelect annotation, SourceModelBuildingContext modelContext) {
        this.sql = annotation.sql();
        this.resultSetMapping = (SqlResultSetMapping)OrmAnnotationHelper.extractJdkValue(annotation, HibernateAnnotations.SQL_SELECT, "resultSetMapping", modelContext);
        this.querySpaces = annotation.querySpaces();
    }

    public SQLSelectAnnotation(AnnotationInstance annotation, SourceModelBuildingContext modelContext) {
        this.sql = (String)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.SQL_SELECT, "sql", modelContext);
        this.resultSetMapping = (SqlResultSetMapping)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.SQL_SELECT, "resultSetMapping", modelContext);
        this.querySpaces = (String[])OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.SQL_SELECT, "querySpaces", modelContext);
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return SQLSelect.class;
    }

    @Override
    public String sql() {
        return this.sql;
    }

    public void sql(String value) {
        this.sql = value;
    }

    @Override
    public SqlResultSetMapping resultSetMapping() {
        return this.resultSetMapping;
    }

    public void resultSetMapping(SqlResultSetMapping value) {
        this.resultSetMapping = value;
    }

    @Override
    public String[] querySpaces() {
        return this.querySpaces;
    }

    public void querySpaces(String[] value) {
        this.querySpaces = value;
    }
}

