/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.annotations.internal;

import jakarta.persistence.SequenceGenerator;
import java.lang.annotation.Annotation;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.internal.OrmAnnotationHelper;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.jboss.jandex.AnnotationInstance;

public class SequenceGeneratorJpaAnnotation
implements SequenceGenerator {
    private String name;
    private String sequenceName;
    private String catalog;
    private String schema;
    private int initialValue;
    private int allocationSize;
    private String options;

    public SequenceGeneratorJpaAnnotation(SourceModelBuildingContext modelContext) {
        this.name = "";
        this.sequenceName = "";
        this.catalog = "";
        this.schema = "";
        this.initialValue = 1;
        this.allocationSize = 50;
        this.options = "";
    }

    public SequenceGeneratorJpaAnnotation(SequenceGenerator annotation, SourceModelBuildingContext modelContext) {
        this.name = annotation.name();
        this.sequenceName = annotation.sequenceName();
        this.catalog = annotation.catalog();
        this.schema = annotation.schema();
        this.initialValue = annotation.initialValue();
        this.allocationSize = annotation.allocationSize();
        this.options = annotation.options();
    }

    public SequenceGeneratorJpaAnnotation(AnnotationInstance annotation, SourceModelBuildingContext modelContext) {
        this.name = (String)OrmAnnotationHelper.extractJandexValue(annotation, JpaAnnotations.SEQUENCE_GENERATOR, "name", modelContext);
        this.sequenceName = (String)OrmAnnotationHelper.extractJandexValue(annotation, JpaAnnotations.SEQUENCE_GENERATOR, "sequenceName", modelContext);
        this.catalog = (String)OrmAnnotationHelper.extractJandexValue(annotation, JpaAnnotations.SEQUENCE_GENERATOR, "catalog", modelContext);
        this.schema = (String)OrmAnnotationHelper.extractJandexValue(annotation, JpaAnnotations.SEQUENCE_GENERATOR, "schema", modelContext);
        this.initialValue = (Integer)OrmAnnotationHelper.extractJandexValue(annotation, JpaAnnotations.SEQUENCE_GENERATOR, "initialValue", modelContext);
        this.allocationSize = (Integer)OrmAnnotationHelper.extractJandexValue(annotation, JpaAnnotations.SEQUENCE_GENERATOR, "allocationSize", modelContext);
        this.options = (String)OrmAnnotationHelper.extractJandexValue(annotation, JpaAnnotations.SEQUENCE_GENERATOR, "options", modelContext);
    }

    public Class<? extends Annotation> annotationType() {
        return SequenceGenerator.class;
    }

    public String name() {
        return this.name;
    }

    public void name(String value) {
        this.name = value;
    }

    public String sequenceName() {
        return this.sequenceName;
    }

    public void sequenceName(String value) {
        this.sequenceName = value;
    }

    public String catalog() {
        return this.catalog;
    }

    public void catalog(String value) {
        this.catalog = value;
    }

    public String schema() {
        return this.schema;
    }

    public void schema(String value) {
        this.schema = value;
    }

    public int initialValue() {
        return this.initialValue;
    }

    public void initialValue(int value) {
        this.initialValue = value;
    }

    public int allocationSize() {
        return this.allocationSize;
    }

    public void allocationSize(int value) {
        this.allocationSize = value;
    }

    public String options() {
        return this.options;
    }

    public void options(String value) {
        this.options = value;
    }
}

