/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.annotations.internal;

import java.lang.annotation.Annotation;
import org.hibernate.annotations.SqlFragmentAlias;
import org.hibernate.boot.models.HibernateAnnotations;
import org.hibernate.boot.models.internal.OrmAnnotationHelper;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.jboss.jandex.AnnotationInstance;

public class SqlFragmentAliasAnnotation
implements SqlFragmentAlias {
    private String alias;
    private String table;
    private Class<?> entity;

    public SqlFragmentAliasAnnotation(SourceModelBuildingContext modelContext) {
        this.table = "";
        this.entity = Void.TYPE;
    }

    public SqlFragmentAliasAnnotation(SqlFragmentAlias annotation, SourceModelBuildingContext modelContext) {
        this.alias = annotation.alias();
        this.table = annotation.table();
        this.entity = annotation.entity();
    }

    public SqlFragmentAliasAnnotation(AnnotationInstance annotation, SourceModelBuildingContext modelContext) {
        this.alias = (String)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.SQL_FRAGMENT_ALIAS, "alias", modelContext);
        this.table = (String)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.SQL_FRAGMENT_ALIAS, "table", modelContext);
        this.entity = (Class)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.SQL_FRAGMENT_ALIAS, "entity", modelContext);
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return SqlFragmentAlias.class;
    }

    @Override
    public String alias() {
        return this.alias;
    }

    public void alias(String value) {
        this.alias = value;
    }

    @Override
    public String table() {
        return this.table;
    }

    public void table(String value) {
        this.table = value;
    }

    @Override
    public Class<?> entity() {
        return this.entity;
    }

    public void entity(Class<?> value) {
        this.entity = value;
    }
}

