/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.annotations.internal;

import java.lang.annotation.Annotation;
import org.hibernate.annotations.Struct;
import org.hibernate.boot.models.HibernateAnnotations;
import org.hibernate.boot.models.internal.OrmAnnotationHelper;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.jboss.jandex.AnnotationInstance;

public class StructAnnotation
implements Struct {
    private String name;
    private String catalog;
    private String schema;
    private String[] attributes;

    public StructAnnotation(SourceModelBuildingContext modelContext) {
        this.attributes = new String[0];
    }

    public StructAnnotation(Struct annotation, SourceModelBuildingContext modelContext) {
        this.name = annotation.name();
        this.catalog = annotation.catalog();
        this.schema = annotation.schema();
        this.attributes = annotation.attributes();
    }

    public StructAnnotation(AnnotationInstance annotation, SourceModelBuildingContext modelContext) {
        this.name = (String)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.STRUCT, "name", modelContext);
        this.catalog = (String)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.STRUCT, "catalog", modelContext);
        this.schema = (String)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.STRUCT, "schema", modelContext);
        this.attributes = (String[])OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.STRUCT, "attributes", modelContext);
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return Struct.class;
    }

    @Override
    public String name() {
        return this.name;
    }

    public void name(String value) {
        this.name = value;
    }

    @Override
    public String catalog() {
        return this.catalog;
    }

    public void catalog(String value) {
        this.catalog = value;
    }

    @Override
    public String schema() {
        return this.schema;
    }

    public void schema(String value) {
        this.schema = value;
    }

    @Override
    public String[] attributes() {
        return this.attributes;
    }

    public void attributes(String[] value) {
        this.attributes = value;
    }
}

