/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.annotations.internal;

import java.lang.annotation.Annotation;
import org.hibernate.annotations.TypeRegistration;
import org.hibernate.boot.models.HibernateAnnotations;
import org.hibernate.boot.models.internal.OrmAnnotationHelper;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.hibernate.usertype.UserType;
import org.jboss.jandex.AnnotationInstance;

public class TypeRegistrationAnnotation
implements TypeRegistration {
    private Class<?> basicClass;
    private Class<? extends UserType<?>> userType;

    public TypeRegistrationAnnotation(SourceModelBuildingContext modelContext) {
    }

    public TypeRegistrationAnnotation(TypeRegistration annotation, SourceModelBuildingContext modelContext) {
        this.basicClass = annotation.basicClass();
        this.userType = annotation.userType();
    }

    public TypeRegistrationAnnotation(AnnotationInstance annotation, SourceModelBuildingContext modelContext) {
        this.basicClass = (Class)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.TYPE_REGISTRATION, "basicClass", modelContext);
        this.userType = (Class)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.TYPE_REGISTRATION, "userType", modelContext);
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return TypeRegistration.class;
    }

    @Override
    public Class<?> basicClass() {
        return this.basicClass;
    }

    public void basicClass(Class<?> value) {
        this.basicClass = value;
    }

    @Override
    public Class<? extends UserType<?>> userType() {
        return this.userType;
    }

    public void userType(Class<? extends UserType<?>> value) {
        this.userType = value;
    }
}

